/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.actionplans.base.ActionPhaseWork;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ActionPhaseWorkList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int planWorkId = -1;
    private int actionPhaseId = -1;
    private boolean hasWork = false;
    private int global = -1;
    private boolean isCurrent = false;
    private boolean buildStepWork = false;
    private boolean buildLinkedObject = false;
    private boolean buildPhase = false;
    private ActionPlanWork planWork = null;
    private boolean buildCurrentStepsOnly = false;
    public static final String tableName = "action_phase_work";
    public static final String uniqueField = "phase_work_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public int getGlobal() {
        return this.global;
    }

    public void setGlobal(int tmp) {
        this.global = tmp;
    }

    public void setGlobal(String tmp) {
        this.global = Integer.parseInt(tmp);
    }

    public int getActionPhaseId() {
        return this.actionPhaseId;
    }

    public void setActionPhaseId(int tmp) {
        this.actionPhaseId = tmp;
    }

    public void setActionPhaseId(String tmp) {
        this.actionPhaseId = Integer.parseInt(tmp);
    }

    public boolean getBuildPhase() {
        return this.buildPhase;
    }

    public void setBuildPhase(boolean tmp) {
        this.buildPhase = tmp;
    }

    public void setBuildPhase(String tmp) {
        this.buildPhase = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getHasWork() {
        return this.hasWork;
    }

    public void setHasWork(boolean tmp) {
        this.hasWork = tmp;
    }

    public void setHasWork(String tmp) {
        this.hasWork = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildLinkedObject() {
        return this.buildLinkedObject;
    }

    public void setBuildLinkedObject(boolean tmp) {
        this.buildLinkedObject = tmp;
    }

    public void setBuildLinkedObject(String tmp) {
        this.buildLinkedObject = DatabaseUtils.parseBoolean(tmp);
    }

    public int getPlanWorkId() {
        return this.planWorkId;
    }

    public void setPlanWorkId(int tmp) {
        this.planWorkId = tmp;
    }

    public void setPlanWorkId(String tmp) {
        this.planWorkId = Integer.parseInt(tmp);
    }

    public boolean getBuildStepWork() {
        return this.buildStepWork;
    }

    public void setBuildStepWork(boolean tmp) {
        this.buildStepWork = tmp;
    }

    public void setBuildStepWork(String tmp) {
        this.buildStepWork = DatabaseUtils.parseBoolean(tmp);
    }

    public ActionPlanWork getPlanWork() {
        return this.planWork;
    }

    public void setPlanWork(ActionPlanWork tmp) {
        this.planWork = tmp;
    }

    public boolean getBuildCurrentStepsOnly() {
        return this.buildCurrentStepsOnly;
    }

    public void setBuildCurrentStepsOnly(boolean tmp) {
        this.buildCurrentStepsOnly = tmp;
    }

    public void setBuildCurrentStepsOnly(String tmp) {
        this.buildCurrentStepsOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getIsCurrent() {
        return this.isCurrent;
    }

    public void setIsCurrent(boolean tmp) {
        this.isCurrent = tmp;
    }

    public void setIsCurrent(String tmp) {
        this.isCurrent = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM action_phase_work apw LEFT JOIN action_phase ap ON (apw.action_phase_id = ap.phase_id) WHERE apw.phase_work_id > 0 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(ap.phase_name) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("ap.phase_name", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY " + DatabaseUtils.addQuotes(db, "level") + ", ap.phase_name ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append(" SELECT ");
        }
        sqlSelect.append("apw.*, ap.phase_name, ap.description, ap.parent_id, ap." + DatabaseUtils.addQuotes(db, "global") + " " + "FROM action_phase_work apw " + "LEFT JOIN action_phase ap ON (apw.action_phase_id = ap.phase_id) " + "WHERE apw.phase_work_id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ActionPhaseWork actionPhaseWork = new ActionPhaseWork(rs);
            this.add(actionPhaseWork);
        }
        rs.close();
        pst.close();
        if (this.buildStepWork || this.buildLinkedObject || this.buildPhase) {
            for (ActionPhaseWork actionPhaseWork : this) {
                actionPhaseWork.setPlanWork(this.getPlanWork());
                if (this.buildLinkedObject) {
                    actionPhaseWork.setBuildLinkedObject(this.buildLinkedObject);
                }
                if (this.buildCurrentStepsOnly) {
                    actionPhaseWork.buildCurrentSteps(db);
                } else if (this.buildStepWork) {
                    actionPhaseWork.buildStepWork(db);
                }
                if (!this.getBuildPhase()) continue;
                actionPhaseWork.setBuildPhase(this.getBuildPhase());
                actionPhaseWork.buildPhaseObject(db);
            }
        }
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.planWorkId > -1) {
            sqlFilter.append("AND apw.plan_work_id = ? ");
        }
        if (this.actionPhaseId > -1) {
            sqlFilter.append("AND apw.action_phase_id = ? ");
        }
        if (this.hasWork) {
            sqlFilter.append("AND apw.start_date IS NOT NULL ");
        }
        if (this.global != -1) {
            sqlFilter.append("AND ap." + DatabaseUtils.addQuotes(db, "global") + " = ? ");
        }
        if (this.isCurrent) {
            sqlFilter.append("AND apw.start_date IS NOT NULL AND apw.end_date IS NULL AND apw.status_id IS NULL ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.planWorkId > -1) {
            pst.setInt(++i, this.planWorkId);
        }
        if (this.actionPhaseId > -1) {
            pst.setInt(++i, this.actionPhaseId);
        }
        if (this.global != -1) {
            pst.setBoolean(++i, this.global == 1);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public ActionPhaseWork getRootPhase() {
        for (ActionPhaseWork phaseWork : this) {
            if (phaseWork.getParentId() != 0) continue;
            return phaseWork;
        }
        return null;
    }

    public void delete(Connection db) throws SQLException {
        for (ActionPhaseWork phaseWork : this) {
            phaseWork.setPlanWork(this.planWork);
            phaseWork.delete(db);
        }
    }

    public void setPhaseWorks(HashMap map) throws SQLException {
        for (ActionPhaseWork phaseWork : this) {
            if (map.get(new Integer(phaseWork.getId())) == null) continue;
            map.remove(new Integer(phaseWork.getId()));
        }
        Iterator<Object> i = map.keySet().iterator();
        while (i.hasNext()) {
            ActionPhaseWork phaseWork;
            phaseWork = (ActionPhaseWork)((Object)map.get(i.next()));
            this.add(phaseWork);
        }
    }

    public void reset(Connection db) throws SQLException {
        Object nullStr = null;
        PreparedStatement pst = db.prepareStatement("UPDATE action_phase_work SET start_date = ?, end_date = ?, status_id = ? WHERE phase_work_id = ? ");
        pst.setNull(1, 91);
        pst.setNull(2, 91);
        pst.setInt(3, -1);
        for (ActionPhaseWork phaseWork : this) {
            pst.setInt(4, phaseWork.getId());
            pst.executeUpdate();
        }
        pst.close();
    }

    public ActionPhaseWork getPhaseWorkById(int phaseWorkId) {
        ActionPhaseWork result = null;
        for (ActionPhaseWork phaseWork : this) {
            if (phaseWork.getId() != phaseWorkId) continue;
            result = phaseWork;
            break;
        }
        return result;
    }
}

