/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.actionplans.base.ActionPhase;
import org.aspcfs.modules.actionplans.base.ActionPhaseList;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkList;
import org.aspcfs.modules.actionplans.base.ActionStep;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftPlanMapList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryPlanMapList;
import org.aspcfs.utils.DatabaseUtils;

public class ActionPlan
extends GenericBean {
    public static final int ACCOUNTS = 42420034;
    public static final int TICKETS = 912051329;
    public static final int CONTACTS = 2;
    public static final int QUOTES = 912051328;
    public static final int PIPELINE = 3;
    public static final int PROJECTS = 912051330;
    public static final int COMMUNICATIONS = 912051331;
    public static final int ADMIN = 912051332;
    public static final int CONTACTS_CALLS = 912051333;
    public static final int CFSNOTE = 912051334;
    public static final int PIPELINE_CALLS = 912051335;
    public static final int PIPELINE_COMPONENT = 1011200517;
    public static final int MYHOMEPAGE = 912051336;
    public static final int ACTION_ITEM_WORK_NOTE_OBJECT = 831200519;
    public static final int ACTION_ITEM_WORK_SELECTION_OBJECT = 831200520;
    public static final int ACTION_ITEM_WORK_RELATIONSHIP_OBJECT = 110061020;
    protected int id = -1;
    protected String name = null;
    protected String description = null;
    protected boolean enabled = false;
    protected Timestamp approved = null;
    protected Timestamp archiveDate = null;
    private int catCode = 0;
    private int subCat1 = 0;
    private int subCat2 = 0;
    private int subCat3 = 0;
    private int linkObjectId = -1;
    protected int siteId = -1;
    protected Timestamp entered = null;
    protected int enteredBy = -1;
    protected Timestamp modified = null;
    protected int modifiedBy = -1;
    protected boolean buildPhases = false;
    protected boolean buildSteps = false;
    protected boolean justApproved = false;
    protected boolean justDisapproved = false;
    protected ActionPhaseList phases = new ActionPhaseList();
    protected ActionPlanWorkList planWorks = null;
    protected boolean buildRelatedRecords = false;
    protected int owner = -1;
    protected String siteName = null;

    public ActionPlan() {
    }

    public ActionPlan(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ActionPlan(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Action Plan ID");
        }
        StringBuffer sb = new StringBuffer(" SELECT ap.*, ls.description as site_name  FROM action_plan ap  LEFT JOIN action_plan_constants apc ON (ap.link_object_id = apc.map_id)  LEFT JOIN lookup_site_id ls ON (ap.site_id = ls.code)  WHERE ap.plan_id = ? ");
        PreparedStatement pst = db.prepareStatement(sb.toString());
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        if (this.buildPhases || this.buildSteps) {
            this.buildPhases(db);
        }
        if (this.buildRelatedRecords) {
            this.buildRelatedRecords(db, this.owner);
        }
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("plan_id"));
        this.name = rs.getString("plan_name");
        this.description = rs.getString("description");
        this.enabled = rs.getBoolean("enabled");
        this.approved = rs.getTimestamp("approved");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.archiveDate = rs.getTimestamp("archive_date");
        this.catCode = DatabaseUtils.getInt(rs, "cat_code", 0);
        this.subCat1 = DatabaseUtils.getInt(rs, "subcat_code1", 0);
        this.subCat2 = DatabaseUtils.getInt(rs, "subcat_code2", 0);
        this.subCat3 = DatabaseUtils.getInt(rs, "subcat_code3", 0);
        this.linkObjectId = DatabaseUtils.getInt(rs, "link_object_id");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
        this.siteName = rs.getString("site_name");
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "action_plan_plan_id_seq");
            sql.append("INSERT INTO action_plan (plan_name, description, enabled, cat_code, subcat_code1, subcat_code2, subcat_code3, link_object_id, site_id, ");
            if (this.id > -1) {
                sql.append("plan_id, ");
            }
            if (this.getJustApproved() || this.getApproved() != null) {
                sql.append("approved, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            sql.append("enteredby, ");
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("modifiedby )");
            sql.append(" VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.getApproved() != null) {
                sql.append("?, ");
            } else if (this.getJustApproved()) {
                sql.append(DatabaseUtils.getCurrentTimestamp(db) + ", ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("?, ");
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("? )");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setString(++i, this.getName());
            pst.setString(++i, this.getDescription());
            pst.setBoolean(++i, this.getEnabled());
            if (this.getCatCode() > 0) {
                pst.setInt(++i, this.getCatCode());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.getSubCat1() > 0) {
                pst.setInt(++i, this.getSubCat1());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.getSubCat2() > 0) {
                pst.setInt(++i, this.getSubCat2());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.getSubCat3() > 0) {
                pst.setInt(++i, this.getSubCat3());
            } else {
                pst.setNull(++i, 4);
            }
            DatabaseUtils.setInt(pst, ++i, this.getLinkObjectId());
            DatabaseUtils.setInt(pst, ++i, this.getSiteId());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.getApproved() != null) {
                DatabaseUtils.setTimestamp(pst, ++i, this.getApproved());
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.getEntered());
            }
            pst.setInt(++i, this.getEnteredBy());
            if (this.modified != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "action_plan_plan_id_seq", this.id);
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE action_plan  SET plan_name = ?,  description = ?,  cat_code = ?, subcat_code1 = ?, subcat_code2 = ?, subcat_code3 = ?,  link_object_id = ?, site_id = ?, ");
        if (this.getEnabled()) {
            sql.append(" enabled = ?, archive_date = null, ");
        } else if (this.archiveDate != null) {
            sql.append(" enabled = ?, archive_date = ?, ");
        } else {
            sql.append(" enabled = ?, archive_date = " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
        }
        if (this.getJustDisapproved()) {
            sql.append(" approved = null, ");
        } else if (this.getJustApproved()) {
            sql.append(" approved = " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
        } else if (this.getApproved() != null) {
            sql.append(" approved = ?, ");
        }
        sql.append(" modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + " modifiedby = ? " + " WHERE plan_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getName());
        pst.setString(++i, this.getDescription());
        if (this.getCatCode() > 0) {
            pst.setInt(++i, this.getCatCode());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getSubCat1() > 0) {
            pst.setInt(++i, this.getSubCat1());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getSubCat2() > 0) {
            pst.setInt(++i, this.getSubCat2());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getSubCat3() > 0) {
            pst.setInt(++i, this.getSubCat3());
        } else {
            pst.setNull(++i, 4);
        }
        DatabaseUtils.setInt(pst, ++i, this.getLinkObjectId());
        DatabaseUtils.setInt(pst, ++i, this.getSiteId());
        if (this.getEnabled()) {
            pst.setBoolean(++i, true);
        } else if (this.archiveDate != null) {
            pst.setBoolean(++i, false);
            pst.setTimestamp(++i, this.getArchiveDate());
        } else {
            pst.setBoolean(++i, false);
        }
        if (!this.getJustDisapproved() && !this.getJustApproved() && this.getApproved() != null) {
            DatabaseUtils.setTimestamp(pst, ++i, this.getApproved());
        }
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        this.buildPhases(db);
        this.phases.delete(db);
        if (this.linkObjectId == ActionPlan.getMapIdGivenConstantId(db, 912051329)) {
            TicketCategoryDraftPlanMapList draftTicketPlanMaps = new TicketCategoryDraftPlanMapList();
            draftTicketPlanMaps.setPlanId(this.getId());
            draftTicketPlanMaps.buildList(db);
            draftTicketPlanMaps.parsePlans(db, new HashMap());
            TicketCategoryPlanMapList ticketPlanMaps = new TicketCategoryPlanMapList();
            ticketPlanMaps.setPlanId(this.getId());
            ticketPlanMaps.buildList(db);
            ticketPlanMaps.delete(db);
        }
        PreparedStatement pst = db.prepareStatement("DELETE FROM action_plan WHERE plan_id = ? ");
        pst.setInt(1, this.getId());
        boolean result = pst.execute();
        pst.close();
        return result;
    }

    public int updatePhases(Connection db) throws SQLException {
        int result = -1;
        for (ActionPhase phase : this.phases) {
            result += phase.update(db);
        }
        return result;
    }

    public void buildPhases(Connection db) throws SQLException {
        this.phases = new ActionPhaseList();
        this.phases.setPlanId(this.getId());
        this.phases.setBuildSteps(this.getBuildSteps());
        this.phases.buildList(db);
        this.phases = this.phases.reorder();
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("archiveDate");
        thisList.add("entered");
        thisList.add("modified");
        return thisList;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        Dependency thisDependency;
        int recordCount;
        if (this.getId() == -1) {
            throw new SQLException("Plan ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int i = 0;
        try {
            i = 0;
            pst = db.prepareStatement(" SELECT count(*) as recordcount  FROM action_plan_work  WHERE action_plan_id = ?");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (recordCount = rs.getInt("recordcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("actionPlanRecords");
                thisDependency.setCount(recordCount);
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            i = 0;
            pst = db.prepareStatement(" SELECT count(*) as recordcount  FROM action_phase  WHERE plan_id = ?");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (recordCount = rs.getInt("recordcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("actionPhases");
                thisDependency.setCount(recordCount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public void buildRelatedRecords(Connection db, int owner) throws SQLException {
        this.planWorks = new ActionPlanWorkList();
        this.planWorks.setActionPlanId(this.getId());
        this.planWorks.setSiteId(this.getSiteId());
        this.planWorks.setIncludeAllSites(true);
        this.planWorks.setOwner(owner);
        this.planWorks.buildList(db);
    }

    public static int getMapIdGivenConstantId(Connection db, int constantId) throws SQLException {
        int mapId = -1;
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT map_id FROM action_plan_constants WHERE constant_id = ? ");
        pst.setInt(1, constantId);
        rs = pst.executeQuery();
        if (rs.next()) {
            mapId = rs.getInt("map_id");
        }
        rs.close();
        pst.close();
        return mapId;
    }

    public static String getDescriptionGivenConstantId(Connection db, int constantId) throws SQLException {
        String constantDescription = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT description FROM action_plan_constants WHERE constant_id = ? ");
        pst.setInt(1, constantId);
        rs = pst.executeQuery();
        if (rs.next()) {
            constantDescription = rs.getString("description");
        }
        rs.close();
        pst.close();
        return constantDescription;
    }

    public static HashMap buildConstants(Connection db) throws SQLException {
        HashMap<Integer, String> constants = new HashMap<Integer, String>();
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT constant_id, description FROM action_plan_constants ");
        rs = pst.executeQuery();
        while (rs.next()) {
            constants.put(new Integer(rs.getInt("constant_id")), rs.getString("description"));
        }
        rs.close();
        pst.close();
        return constants;
    }

    public static boolean insertConstant(Connection db, int constant, String description) throws SQLException {
        PreparedStatement pst = null;
        pst = db.prepareStatement("INSERT INTO action_plan_constants (constant_id,description) VALUES( ?, ?) ");
        pst.setInt(1, constant);
        pst.setString(2, description);
        pst.execute();
        pst.close();
        return true;
    }

    public ActionPhase getCurrentPhase() {
        for (ActionPhase thisPhase : this.phases) {
            if (thisPhase.getGlobal()) continue;
            for (ActionStep thisStep : thisPhase.getSteps()) {
                if (!thisStep.allowsUpdate()) continue;
                return thisPhase;
            }
        }
        return null;
    }

    public ActionStep getCurrentStep() {
        for (ActionPhase thisPhase : this.phases) {
            if (thisPhase.getGlobal()) continue;
            for (ActionStep thisStep : thisPhase.getSteps()) {
                if (!thisStep.allowsUpdate()) continue;
                return thisStep;
            }
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getApproved() {
        return this.approved;
    }

    public void setApproved(Timestamp tmp) {
        this.approved = tmp;
    }

    public void setApproved(String tmp) {
        this.approved = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public boolean getBuildPhases() {
        return this.buildPhases;
    }

    public void setBuildPhases(boolean tmp) {
        this.buildPhases = tmp;
    }

    public void setBuildPhases(String tmp) {
        this.buildPhases = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildSteps() {
        return this.buildSteps;
    }

    public void setBuildSteps(boolean tmp) {
        this.buildSteps = tmp;
    }

    public void setBuildSteps(String tmp) {
        this.buildSteps = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getJustApproved() {
        return this.justApproved;
    }

    public void setJustApproved(boolean tmp) {
        this.justApproved = tmp;
    }

    public void setJustApproved(String tmp) {
        this.justApproved = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getJustDisapproved() {
        return this.justDisapproved;
    }

    public void setJustDisapproved(boolean tmp) {
        this.justDisapproved = tmp;
    }

    public void setJustDisapproved(String tmp) {
        this.justDisapproved = DatabaseUtils.parseBoolean(tmp);
    }

    public ActionPhaseList getPhases() {
        return this.phases;
    }

    public void setPhases(ActionPhaseList tmp) {
        this.phases = tmp;
    }

    public Timestamp getArchiveDate() {
        return this.archiveDate;
    }

    public void setArchiveDate(Timestamp tmp) {
        this.archiveDate = tmp;
    }

    public void setArchiveDate(String tmp) {
        this.archiveDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public ActionPlanWorkList getPlanWorks() {
        return this.planWorks;
    }

    public void setPlanWorks(ActionPlanWorkList tmp) {
        this.planWorks = tmp;
    }

    public boolean getBuildRelatedRecords() {
        return this.buildRelatedRecords;
    }

    public void setBuildRelatedRecords(boolean tmp) {
        this.buildRelatedRecords = tmp;
    }

    public void setBuildRelatedRecords(String tmp) {
        this.buildRelatedRecords = DatabaseUtils.parseBoolean(tmp);
    }

    public int getOwner() {
        return this.owner;
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setOwner(String tmp) {
        this.owner = Integer.parseInt(tmp);
    }

    public int getCatCode() {
        return this.catCode;
    }

    public void setCatCode(int tmp) {
        this.catCode = tmp;
    }

    public void setCatCode(String tmp) {
        this.catCode = Integer.parseInt(tmp);
    }

    public int getSubCat1() {
        return this.subCat1;
    }

    public void setSubCat1(int tmp) {
        this.subCat1 = tmp;
    }

    public void setSubCat1(String tmp) {
        this.subCat1 = Integer.parseInt(tmp);
    }

    public int getSubCat2() {
        return this.subCat2;
    }

    public void setSubCat2(int tmp) {
        this.subCat2 = tmp;
    }

    public void setSubCat2(String tmp) {
        this.subCat2 = Integer.parseInt(tmp);
    }

    public int getSubCat3() {
        return this.subCat3;
    }

    public void setSubCat3(int tmp) {
        this.subCat3 = tmp;
    }

    public void setSubCat3(String tmp) {
        this.subCat3 = Integer.parseInt(tmp);
    }

    public int getLinkObjectId() {
        return this.linkObjectId;
    }

    public void setLinkObjectId(int tmp) {
        this.linkObjectId = tmp;
    }

    public void setLinkObjectId(String tmp) {
        this.linkObjectId = Integer.parseInt(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String tmp) {
        this.siteName = tmp;
    }

    public String getDisplayInPlanSteps() {
        String result = "";
        Iterator actionPlanPhases = this.phases.iterator();
        while (actionPlanPhases.hasNext()) {
            ActionPhase thisPhase = (ActionPhase)((Object)actionPlanPhases.next());
            Iterator steps = thisPhase.getSteps().iterator();
            while (steps.hasNext()) {
                ActionStep step = (ActionStep)((Object)steps.next());
                if (step == null || !step.getDisplayInPlanList()) continue;
                if (steps.hasNext()) {
                    result = result + step.getPlanListLabel() + "\n";
                    continue;
                }
                result = result + step.getPlanListLabel();
            }
            if (!actionPlanPhases.hasNext()) continue;
            result = result + "\n";
        }
        return result;
    }
}

