/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.aspcfs.modules.actionplans.base.ActionPlanCategory;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class ActionPlanCategoryList
extends Vector {
    HtmlSelect catListSelect = new HtmlSelect();
    private PagedListInfo pagedListInfo = null;
    private int parentCode = -1;
    private int catLevel = -1;
    private String HtmlJsEvent = "";
    private int enabledState = -1;
    private boolean includeDisabled = false;
    private int siteId = -1;
    private boolean exclusiveToSite = false;
    public static final String tableName = "action_plan_category";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        Iterator i = this.iterator();
        this.catListSelect.addAttribute(uniqueField, selectName);
        while (i.hasNext()) {
            ActionPlanCategory thisCat = (ActionPlanCategory)((Object)i.next());
            String elementText = thisCat.getDescription();
            if (thisCat.getEnabled()) {
                this.catListSelect.addItem(thisCat.getId(), elementText);
                continue;
            }
            if ((thisCat.getEnabled() || thisCat.getId() != defaultKey) && !this.includeDisabled) continue;
            if (this.catListSelect.getSelectSize() > 1) {
                HashMap<String, String> colorAttribute = new HashMap<String, String>();
                colorAttribute.put("style", "color: red");
                this.catListSelect.addItem(thisCat.getId(), elementText, colorAttribute);
                continue;
            }
            elementText = elementText + "*";
            this.catListSelect.addItem(thisCat.getId(), elementText);
        }
        if (!this.getHtmlJsEvent().equals("")) {
            this.catListSelect.setJsEvent(this.getHtmlJsEvent());
        }
        return this.catListSelect.getHtml(selectName, defaultKey);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM action_plan_category apc WHERE apc.id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND apc.id < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("apc.description", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY apc.description");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("apc.* FROM action_plan_category apc WHERE apc.id > -1 ");
        pst = db.prepareStatement(new String(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString()));
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ActionPlanCategory thisCat = new ActionPlanCategory(rs);
            this.addElement(thisCat);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enabledState != -1) {
            sqlFilter.append("AND apc.enabled = ? ");
        }
        if (this.parentCode != -1) {
            sqlFilter.append("AND apc.parent_cat_code = ? ");
        }
        if (this.catLevel != -1) {
            sqlFilter.append("AND apc.cat_level = ? ");
        }
        if (this.siteId > -1) {
            sqlFilter.append("AND (apc.site_id = ? ");
            if (!this.exclusiveToSite) {
                sqlFilter.append("OR apc.site_id IS NULL ");
            }
            sqlFilter.append(") ");
        } else {
            sqlFilter.append("AND apc.site_id IS NULL ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enabledState != -1) {
            pst.setBoolean(++i, this.enabledState == 1);
        }
        if (this.parentCode != -1) {
            pst.setInt(++i, this.parentCode);
        }
        if (this.catLevel != -1) {
            pst.setInt(++i, this.catLevel);
        }
        if (this.siteId > -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public HtmlSelect getHtmlSelect(int defaultKey) {
        HtmlSelect catListSelect = new HtmlSelect();
        for (ActionPlanCategory thisCat : this) {
            String elementText = thisCat.getDescription();
            if (thisCat.getEnabled()) {
                catListSelect.addItem(thisCat.getId(), elementText);
                continue;
            }
            if ((thisCat.getEnabled() || thisCat.getId() != defaultKey) && !this.includeDisabled) continue;
            if (catListSelect.getSelectSize() > 1) {
                HashMap<String, String> colorAttribute = new HashMap<String, String>();
                colorAttribute.put("style", "color: red");
                catListSelect.addItem(thisCat.getId(), elementText, colorAttribute, false);
                continue;
            }
            elementText = elementText + "*";
            catListSelect.addItem(thisCat.getId(), elementText);
        }
        return catListSelect;
    }

    public int getIdFromValue(String value) {
        for (ActionPlanCategory thisCategory : this) {
            if (!value.equals(thisCategory.getDescription())) continue;
            return thisCategory.getId();
        }
        return -1;
    }

    public HtmlSelect getCatListSelect() {
        return this.catListSelect;
    }

    public void setCatListSelect(HtmlSelect tmp) {
        this.catListSelect = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getParentCode() {
        return this.parentCode;
    }

    public void setParentCode(int tmp) {
        this.parentCode = tmp;
    }

    public void setParentCode(String tmp) {
        this.parentCode = Integer.parseInt(tmp);
    }

    public int getCatLevel() {
        return this.catLevel;
    }

    public void setCatLevel(int tmp) {
        this.catLevel = tmp;
    }

    public void setCatLevel(String tmp) {
        this.catLevel = Integer.parseInt(tmp);
    }

    public String getHtmlJsEvent() {
        return this.HtmlJsEvent;
    }

    public void setHtmlJsEvent(String tmp) {
        this.HtmlJsEvent = tmp;
    }

    public int getEnabledState() {
        return this.enabledState;
    }

    public void setEnabledState(int tmp) {
        this.enabledState = tmp;
    }

    public void setEnabledState(String tmp) {
        this.enabledState = Integer.parseInt(tmp);
    }

    public boolean getIncludeDisabled() {
        return this.includeDisabled;
    }

    public void setIncludeDisabled(boolean tmp) {
        this.includeDisabled = tmp;
    }

    public void setIncludeDisabled(String tmp) {
        this.includeDisabled = DatabaseUtils.parseBoolean(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }
}

