/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.io.File;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.XMLUtils;
import org.aspcfs.utils.web.RequestUtils;
import org.w3c.dom.Element;

public class ActionPlanEmail {
    private String subject = null;
    private String body = null;

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String tmp) {
        this.body = tmp;
    }

    public ActionPlanEmail(String templateFile, ActionPlanWork actionPlan, Contact assigned, Contact manager, String orgName, ActionContext context) throws Exception {
        File configFile = new File(templateFile);
        XMLUtils xml = new XMLUtils(configFile);
        Element mappings = xml.getFirstChild("mappings");
        Template messageSubject = new Template();
        messageSubject.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "actionplan.assign.email.subject")));
        messageSubject.addParseElement("\r\n", "");
        messageSubject.addParseElement("\r", "");
        messageSubject.addParseElement("\n", "");
        this.subject = messageSubject.getParsedText();
        Template messageBody = new Template();
        messageBody.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "actionplan.assign.email.body")));
        messageBody.addParseElement("${actionplan.name}", actionPlan.getPlanName());
        messageBody.addParseElement("${actionplan.manager}", manager.getNameFull());
        messageBody.addParseElement("${actionplan.assignedTo}", assigned.getNameFull());
        messageBody.addParseElement("${organization.name}", orgName);
        messageBody.addParseElement("${link}", RequestUtils.getLink(context, "MyActionPlans.do?command=Details&actionPlanId=" + actionPlan.getId()));
        this.body = messageBody.getParsedText();
    }

    public ActionPlanEmail(String templateFile, ActionPlanWork actionPlan, Contact previous, Contact assigned, Contact manager, String orgName, ActionContext context) throws Exception {
        File configFile = new File(templateFile);
        XMLUtils xml = new XMLUtils(configFile);
        Element mappings = xml.getFirstChild("mappings");
        Template messageSubject = new Template();
        messageSubject.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "actionplan.reassign.email.subject")));
        messageSubject.addParseElement("\r\n", "");
        messageSubject.addParseElement("\r", "");
        messageSubject.addParseElement("\n", "");
        this.subject = messageSubject.getParsedText();
        Template messageBody = new Template();
        messageBody.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "actionplan.reassign.email.body")));
        messageBody.addParseElement("${actionplan.name}", actionPlan.getPlanName());
        messageBody.addParseElement("${actionplan.manager}", manager.getNameFull());
        messageBody.addParseElement("${actionplan.assignedFrom}", previous.getNameFull());
        messageBody.addParseElement("${actionplan.assignedTo}", assigned.getNameFull());
        messageBody.addParseElement("${organization.name}", orgName);
        messageBody.addParseElement("${link}", RequestUtils.getLink(context, "MyActionPlans.do?command=Details&actionPlanId=" + actionPlan.getId()));
        this.body = messageBody.getParsedText();
    }

    public ActionPlanEmail(String templateFile, ActionPlanWork actionPlan, Contact next, String stepName, ActionContext context) throws Exception {
        File configFile = new File(templateFile);
        XMLUtils xml = new XMLUtils(configFile);
        Element mappings = xml.getFirstChild("mappings");
        Template messageSubject = new Template();
        messageSubject.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "actionstep.alert.email.subject")));
        messageSubject.addParseElement("\r\n", "");
        messageSubject.addParseElement("\r", "");
        messageSubject.addParseElement("\n", "");
        this.subject = messageSubject.getParsedText();
        Template messageBody = new Template();
        messageBody.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "actionstep.alert.email.body")));
        if (actionPlan.getOrganization() != null) {
            messageBody.addParseElement("${organization.name}", actionPlan.getOrganization().getName());
        }
        messageBody.addParseElement("${actionstep.description}", stepName);
        messageBody.addParseElement("${actionstep.owner}", next.getNameFull());
        messageBody.addParseElement("${link}", RequestUtils.getLink(context, "MyActionPlans.do?command=Details&actionPlanId=" + actionPlan.getId()));
        this.body = messageBody.getParsedText();
    }

    public ActionPlanEmail(String templateFile, ActionPlanWork actionPlan, Contact next, String stepName, ActionContext context, String link) throws Exception {
        File configFile = new File(templateFile);
        XMLUtils xml = new XMLUtils(configFile);
        Element mappings = xml.getFirstChild("mappings");
        Template messageSubject = new Template();
        messageSubject.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "actionstep.stepCompletion.alert.email.subject")));
        messageSubject.addParseElement("\r\n", "");
        messageSubject.addParseElement("\r", "");
        messageSubject.addParseElement("\n", "");
        this.subject = messageSubject.getParsedText();
        Template messageBody = new Template();
        messageBody.setText(XMLUtils.getNodeText(XMLUtils.getElement(mappings, "map", "id", "actionstep.stepCompletion.alert.email.body")));
        if (actionPlan.getOrganization() != null) {
            messageBody.addParseElement("${organization.name}", actionPlan.getOrganization().getName());
        }
        messageBody.addParseElement("${actionstep.description}", stepName);
        messageBody.addParseElement("${actionstep.owner}", next.getNameFull());
        messageBody.addParseElement("${link}", RequestUtils.getLink(context, link + actionPlan.getId()));
        this.body = messageBody.getParsedText();
    }
}

