/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actionplans.base.ActionPhase;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkList;
import org.aspcfs.modules.actionplans.base.ActionStep;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class ActionPlanList
extends ArrayList {
    public String tableName = "action_plan";
    public String uniqueField = "plan_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private int archived = -1;
    private int categoryId = -1;
    private int enabled = -1;
    private Timestamp archiveDate = null;
    private int archiveDateBefore = -1;
    private Timestamp approved = null;
    private int includeOnlyApproved = -1;
    private int approvedBefore = -1;
    private int catCode = 0;
    private int subCat1 = 0;
    private int subCat2 = 0;
    private int subCat3 = 0;
    private int linkCatCode = 0;
    private int linkSubCat1 = 0;
    private int linkSubCat2 = 0;
    private int linkSubCat3 = 0;
    private int linkObjectId = -1;
    private String nameTable = null;
    private int siteId = -1;
    private boolean buildPhases = false;
    private boolean buildSteps = false;
    private boolean buildRelatedRecords = false;
    private int owner = -1;
    private String jsEvent = null;
    private boolean displayNone = false;
    private boolean includeAllSites = false;
    private boolean exclusiveToSite = false;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setTableName(String tmp) {
        this.tableName = tmp;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getUniqueField() {
        return this.uniqueField;
    }

    public String getNameTable() {
        return this.nameTable;
    }

    public void setNameTable(String tmp) {
        this.nameTable = tmp;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM action_plan ap  LEFT JOIN action_plan_constants apc ON (ap.link_object_id = apc.map_id)  LEFT JOIN lookup_site_id ls ON (ap.site_id = ls.code)  WHERE ap.plan_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(ap.plan_name) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("ap.plan_name", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY ap.archive_date, ap.entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" ap.*, ls.description AS site_name  FROM action_plan ap  LEFT JOIN action_plan_constants apc ON (ap.link_object_id = apc.map_id)  LEFT JOIN lookup_site_id ls ON (ap.site_id = ls.code)  WHERE ap.plan_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ActionPlan thisPlan = new ActionPlan(rs);
            this.add(thisPlan);
        }
        rs.close();
        pst.close();
        if (this.buildPhases || this.buildSteps || this.buildRelatedRecords) {
            for (ActionPlan plan : this) {
                plan.setBuildPhases(this.buildPhases || this.buildSteps);
                plan.setBuildSteps(this.buildSteps);
                if (this.buildRelatedRecords) {
                    plan.buildRelatedRecords(db, this.owner);
                }
                if (!this.buildPhases && !this.buildSteps) continue;
                plan.buildPhases(db);
            }
        }
    }

    protected void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.id > -1) {
            sqlFilter.append("AND ap.plan_id = ? ");
        }
        if (this.archived == 1) {
            sqlFilter.append("AND ap.expiration_date IS NOT NULL ");
        } else if (this.archived == 0) {
            sqlFilter.append("AND ap.expiration_date IS NULL ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND ap.enabled = ? ");
        }
        if (this.archiveDate != null) {
            if (this.archiveDateBefore == -1) {
                sqlFilter.append("AND ap.archive_date = ? ");
            } else if (this.archiveDateBefore == 1) {
                sqlFilter.append("AND ap.archive_date < ? ");
            } else {
                sqlFilter.append("AND ap.archive_date > ? ");
            }
        }
        if (this.includeOnlyApproved == 1) {
            sqlFilter.append("AND ap.approved IS NOT NULL ");
        } else if (this.includeOnlyApproved == 0) {
            sqlFilter.append("AND ap.approved IS NULL ");
        }
        if (this.approved != null) {
            if (this.approvedBefore == -1) {
                sqlFilter.append("AND ap.approved = ? ");
            } else if (this.approvedBefore == 1) {
                sqlFilter.append("AND ap.approved < ? ");
            } else {
                sqlFilter.append("AND ap.approved > ? ");
            }
        }
        if (this.subCat3 != 0) {
            sqlFilter.append("AND subcat_code3 = ? ");
        } else if (this.subCat2 != 0) {
            sqlFilter.append("AND subcat_code2 = ? ");
        } else if (this.subCat1 != 0) {
            sqlFilter.append("AND subcat_code1 = ? ");
        } else if (this.catCode != 0) {
            sqlFilter.append("AND cat_code = ? ");
        }
        if (this.linkObjectId != -1) {
            sqlFilter.append("AND link_object_id = ? ");
        }
        if (this.nameTable != null && (this.linkSubCat3 != 0 || this.linkSubCat2 != 0 || this.linkSubCat1 != 0 || this.linkCatCode != 0)) {
            sqlFilter.append("AND ap.plan_id IN ( SELECT plan_id FROM " + this.nameTable + "_plan_map " + "WHERE category_id = ?) ");
        } else if (this.nameTable != null && this.displayNone) {
            sqlFilter.append("AND ap.plan_id = ? ");
        }
        if (!this.includeAllSites) {
            if (this.siteId > -1) {
                sqlFilter.append("AND (ap.site_id = ? ");
                if (!this.exclusiveToSite) {
                    sqlFilter.append("OR ap.site_id IS NULL ");
                }
                sqlFilter.append(") ");
            } else {
                sqlFilter.append("AND ap.site_id IS NULL ");
            }
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.enabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.enabled == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.archiveDate != null) {
            pst.setTimestamp(++i, this.getArchiveDate());
        }
        if (this.approved != null) {
            pst.setTimestamp(++i, this.getApproved());
        }
        if (this.subCat3 != 0) {
            pst.setInt(++i, this.getSubCat3());
        } else if (this.subCat2 != 0) {
            pst.setInt(++i, this.getSubCat2());
        } else if (this.subCat1 != 0) {
            pst.setInt(++i, this.getSubCat1());
        } else if (this.catCode != 0) {
            pst.setInt(++i, this.getCatCode());
        }
        if (this.linkObjectId != -1) {
            pst.setInt(++i, this.getLinkObjectId());
        }
        if (this.nameTable != null) {
            if (this.linkSubCat3 != 0) {
                pst.setInt(++i, this.linkSubCat3);
            } else if (this.linkSubCat2 != 0) {
                pst.setInt(++i, this.linkSubCat2);
            } else if (this.linkSubCat1 != 0) {
                pst.setInt(++i, this.linkSubCat1);
            } else if (this.linkCatCode != 0) {
                pst.setInt(++i, this.linkCatCode);
            } else if (this.displayNone) {
                DatabaseUtils.setInt(pst, ++i, -1);
            }
        }
        if (!this.includeAllSites && this.siteId > -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect actionPlanListSelect = new HtmlSelect();
        if (this.jsEvent != null) {
            actionPlanListSelect.setJsEvent(this.jsEvent);
        }
        for (ActionPlan thisPlan : this) {
            actionPlanListSelect.addItem(thisPlan.getId(), thisPlan.getName() + (thisPlan.getSiteId() > -1 ? thisPlan.getSiteName() : ""));
        }
        return actionPlanListSelect.getHtml(selectName, defaultKey);
    }

    public HtmlSelect getHtmlSelectObj() {
        HtmlSelect actionPlanListSelect = new HtmlSelect();
        if (this.jsEvent != null) {
            actionPlanListSelect.setJsEvent(this.jsEvent);
        }
        for (ActionPlan thisPlan : this) {
            actionPlanListSelect.addItem(thisPlan.getId(), thisPlan.getName() + (thisPlan.getSiteId() > -1 ? thisPlan.getSiteName() : ""));
        }
        return actionPlanListSelect;
    }

    public int getEnabledPlanId() {
        int result = -1;
        if (this.size() == 1) {
            return ((ActionPlan)((Object)this.get(0))).getId();
        }
        for (ActionPlan thisPlan : this) {
            if (!thisPlan.getEnabled()) continue;
            result = thisPlan.getId();
            break;
        }
        return result;
    }

    public String getEnabledPlanName() {
        String result = null;
        if (this.size() == 1) {
            return ((ActionPlan)((Object)this.get(0))).getName();
        }
        for (ActionPlan thisPlan : this) {
            if (!thisPlan.getEnabled()) continue;
            result = thisPlan.getName();
            break;
        }
        return result;
    }

    public ActionPlan getEnabledActionPlan() {
        ActionPlan result = null;
        if (this.size() == 1) {
            return (ActionPlan)((Object)this.get(0));
        }
        for (ActionPlan thisPlan : this) {
            if (!thisPlan.getEnabled()) continue;
            result = thisPlan;
            break;
        }
        return result;
    }

    public String getHtmlSelectGroup(SystemStatus thisSystem, String selectName, int defaultKey) {
        ArrayList<ActionPlan> archivedPlans = new ArrayList<ActionPlan>();
        ArrayList<ActionPlan> activePlans = new ArrayList<ActionPlan>();
        for (ActionPlan thisPlan : this) {
            if (thisPlan.getArchiveDate() == null) {
                activePlans.add(thisPlan);
                continue;
            }
            archivedPlans.add(thisPlan);
        }
        HtmlSelect actionPlanListSelect = new HtmlSelect();
        if (this.jsEvent != null) {
            actionPlanListSelect.setJsEvent(this.jsEvent);
        }
        int count = 0;
        actionPlanListSelect.addGroup(thisSystem.getLabel("actionPlan.activePlans", "Active Plans") + " (" + activePlans.size() + ")");
        for (ActionPlan thisPlan : activePlans) {
            actionPlanListSelect.addItem(thisPlan.getId(), ++count + ". " + thisPlan.getName());
        }
        count = 0;
        actionPlanListSelect.addGroup(thisSystem.getLabel("actionPlan.archivedPlans", "Archived Plans") + " (" + archivedPlans.size() + ")");
        for (ActionPlan thisPlan : archivedPlans) {
            actionPlanListSelect.addItem(thisPlan.getId(), ++count + ". " + thisPlan.getName());
        }
        return actionPlanListSelect.getHtml(selectName, defaultKey);
    }

    public ActionPlan getPlan() {
        for (ActionPlan thisPlan : this) {
            if (thisPlan.getArchiveDate() != null) continue;
            return thisPlan;
        }
        return this.size() > 0 ? (ActionPlan)((Object)this.get(0)) : new ActionPlan();
    }

    public void addAtleastOne(Connection db, ActionPlanWorkList workList) throws SQLException {
        if (workList == null || workList.size() == 0) {
            return;
        }
        Iterator iter = this.iterator();
        boolean included = false;
        HashMap workMap = workList.getPlanIdHashMap();
        while (iter.hasNext()) {
            ActionPlan plan = (ActionPlan)((Object)iter.next());
            if (workMap.get(String.valueOf(plan.getId())) == null) continue;
            included = true;
            break;
        }
        if (!included) {
            ActionPlanWork work = (ActionPlanWork)((Object)workList.get(0));
            ActionPlan plan = new ActionPlan(db, work.getActionPlanId());
            this.add(plan);
        }
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public boolean getBuildPhases() {
        return this.buildPhases;
    }

    public void setBuildPhases(boolean tmp) {
        this.buildPhases = tmp;
    }

    public void setBuildPhases(String tmp) {
        this.buildPhases = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildSteps() {
        return this.buildSteps;
    }

    public void setBuildSteps(boolean tmp) {
        this.buildSteps = tmp;
    }

    public void setBuildSteps(String tmp) {
        this.buildSteps = DatabaseUtils.parseBoolean(tmp);
    }

    public int getArchived() {
        return this.archived;
    }

    public void setArchived(int tmp) {
        this.archived = tmp;
    }

    public void setArchived(String tmp) {
        this.archived = Integer.parseInt(tmp);
    }

    public Timestamp getApproved() {
        return this.approved;
    }

    public void setApproved(Timestamp tmp) {
        this.approved = tmp;
    }

    public void setApproved(String tmp) {
        this.approved = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getIncludeOnlyApproved() {
        return this.includeOnlyApproved;
    }

    public void setIncludeOnlyApproved(int tmp) {
        this.includeOnlyApproved = tmp;
    }

    public void setIncludeOnlyApproved(String tmp) {
        this.includeOnlyApproved = Integer.parseInt(tmp);
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public Timestamp getArchiveDate() {
        return this.archiveDate;
    }

    public void setArchiveDate(Timestamp tmp) {
        this.archiveDate = tmp;
    }

    public void setArchiveDate(String tmp) {
        this.archiveDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getArchiveDateBefore() {
        return this.archiveDateBefore;
    }

    public void setArchiveDateBefore(int tmp) {
        this.archiveDateBefore = tmp;
    }

    public void setArchiveDateBefore(String tmp) {
        this.archiveDateBefore = Integer.parseInt(tmp);
    }

    public int getApprovedBefore() {
        return this.approvedBefore;
    }

    public void setApprovedBefore(int tmp) {
        this.approvedBefore = tmp;
    }

    public void setApprovedBefore(String tmp) {
        this.approvedBefore = Integer.parseInt(tmp);
    }

    public boolean getBuildRelatedRecords() {
        return this.buildRelatedRecords;
    }

    public void setBuildRelatedRecords(boolean tmp) {
        this.buildRelatedRecords = tmp;
    }

    public void setBuildRelatedRecords(String tmp) {
        this.buildRelatedRecords = DatabaseUtils.parseBoolean(tmp);
    }

    public int getOwner() {
        return this.owner;
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setOwner(String tmp) {
        this.owner = Integer.parseInt(tmp);
    }

    public int getCatCode() {
        return this.catCode;
    }

    public void setCatCode(int tmp) {
        this.catCode = tmp;
    }

    public void setCatCode(String tmp) {
        this.catCode = Integer.parseInt(tmp);
    }

    public int getSubCat1() {
        return this.subCat1;
    }

    public void setSubCat1(int tmp) {
        this.subCat1 = tmp;
    }

    public void setSubCat1(String tmp) {
        this.subCat1 = Integer.parseInt(tmp);
    }

    public int getSubCat2() {
        return this.subCat2;
    }

    public void setSubCat2(int tmp) {
        this.subCat2 = tmp;
    }

    public void setSubCat2(String tmp) {
        this.subCat2 = Integer.parseInt(tmp);
    }

    public int getSubCat3() {
        return this.subCat3;
    }

    public void setSubCat3(int tmp) {
        this.subCat3 = tmp;
    }

    public void setSubCat3(String tmp) {
        this.subCat3 = Integer.parseInt(tmp);
    }

    public void setLevel0(String tmp) {
        this.catCode = Integer.parseInt(tmp);
    }

    public void setLevel1(String tmp) {
        this.subCat1 = Integer.parseInt(tmp);
    }

    public void setLevel2(String tmp) {
        this.subCat2 = Integer.parseInt(tmp);
    }

    public void setLevel3(String tmp) {
        this.subCat3 = Integer.parseInt(tmp);
    }

    public int getLevel0() {
        return this.catCode;
    }

    public int getLevel1() {
        return this.subCat1;
    }

    public int getLevel2() {
        return this.subCat2;
    }

    public int getLevel3() {
        return this.subCat3;
    }

    public int getLinkObjectId() {
        return this.linkObjectId;
    }

    public void setLinkObjectId(int tmp) {
        this.linkObjectId = tmp;
    }

    public void setLinkObjectId(String tmp) {
        this.linkObjectId = Integer.parseInt(tmp);
    }

    public int getLinkCatCode() {
        return this.linkCatCode;
    }

    public void setLinkCatCode(int tmp) {
        this.linkCatCode = tmp;
    }

    public void setLinkCatCode(String tmp) {
        this.linkCatCode = Integer.parseInt(tmp);
    }

    public int getLinkSubCat1() {
        return this.linkSubCat1;
    }

    public void setLinkSubCat1(int tmp) {
        this.linkSubCat1 = tmp;
    }

    public void setLinkSubCat1(String tmp) {
        this.linkSubCat1 = Integer.parseInt(tmp);
    }

    public int getLinkSubCat2() {
        return this.linkSubCat2;
    }

    public void setLinkSubCat2(int tmp) {
        this.linkSubCat2 = tmp;
    }

    public void setLinkSubCat2(String tmp) {
        this.linkSubCat2 = Integer.parseInt(tmp);
    }

    public int getLinkSubCat3() {
        return this.linkSubCat3;
    }

    public void setLinkSubCat3(int tmp) {
        this.linkSubCat3 = tmp;
    }

    public void setLinkSubCat3(String tmp) {
        this.linkSubCat3 = Integer.parseInt(tmp);
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public boolean getDisplayNone() {
        return this.displayNone;
    }

    public void setDisplayNone(boolean tmp) {
        this.displayNone = tmp;
    }

    public void setDisplayNone(String tmp) {
        this.displayNone = DatabaseUtils.parseBoolean(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public boolean getIncludeAllSites() {
        return this.includeAllSites;
    }

    public void setIncludeAllSites(boolean tmp) {
        this.includeAllSites = tmp;
    }

    public void setIncludeAllSites(String tmp) {
        this.includeAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }

    public int getDisplayInPlanStepsCount() {
        int result = 0;
        for (ActionPlan actionPlan : this) {
            for (ActionPhase thisPhase : actionPlan.getPhases()) {
                for (ActionStep step : thisPhase.getSteps()) {
                    if (step == null || !step.getDisplayInPlanList()) continue;
                    ++result;
                }
            }
        }
        return result;
    }
}

