/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actionplans.base.ActionItemWork;
import org.aspcfs.modules.actionplans.base.ActionItemWorkList;
import org.aspcfs.modules.actionplans.base.ActionPhase;
import org.aspcfs.modules.actionplans.base.ActionPhaseWork;
import org.aspcfs.modules.actionplans.base.ActionPhaseWorkList;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanEmail;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkNoteList;
import org.aspcfs.modules.actionplans.base.ActionStep;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.web.HtmlSelect;

public class ActionPlanWork
extends GenericBean {
    public static final int INCOMPLETE = -1;
    public static final int UNDEFINED = 0;
    public static final int SKIPPED = 1;
    public static final int COMPLETED = 2;
    private int id = -1;
    private int actionPlanId = -1;
    private int managerId = -1;
    private int assignedTo = -1;
    private int linkModuleId = -1;
    private int linkItemId = -1;
    private String linkItemName = null;
    private boolean enabled = true;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private int currentPhaseId = -1;
    private String planName = null;
    private String planDescription = null;
    private int planSiteId = -1;
    private boolean buildPhaseWork = false;
    private boolean buildStepWork = false;
    private boolean buildLinkedObject = false;
    private int buildGlobalPhases = -1;
    private ActionPhaseWorkList phaseWorkList = null;
    private Contact contact = null;
    private Organization organization = null;
    private Ticket ticket = null;
    private boolean buildCurrentPhaseWork = false;
    private boolean buildCurrentStepWork = false;

    public int getBuildGlobalPhases() {
        return this.buildGlobalPhases;
    }

    public void setBuildGlobalPhases(int tmp) {
        this.buildGlobalPhases = tmp;
    }

    public void setBuildGlobalPhases(String tmp) {
        this.buildGlobalPhases = Integer.parseInt(tmp);
    }

    public int getPlanSiteId() {
        return this.planSiteId;
    }

    public void setPlanSiteId(int tmp) {
        this.planSiteId = tmp;
    }

    public void setPlanSiteId(String tmp) {
        this.planSiteId = Integer.parseInt(tmp);
    }

    public int getCurrentPhaseId() {
        return this.currentPhaseId;
    }

    public void setCurrentPhaseId(int tmp) {
        this.currentPhaseId = tmp;
    }

    public void setCurrentPhaseId(String tmp) {
        this.currentPhaseId = Integer.parseInt(tmp);
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization tmp) {
        this.organization = tmp;
    }

    public boolean getBuildLinkedObject() {
        return this.buildLinkedObject;
    }

    public void setBuildLinkedObject(boolean tmp) {
        this.buildLinkedObject = tmp;
    }

    public void setBuildLinkedObject(String tmp) {
        this.buildLinkedObject = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact tmp) {
        this.contact = tmp;
    }

    public ActionPhaseWorkList getPhaseWorkList() {
        return this.phaseWorkList;
    }

    public void setPhaseWorkList(ActionPhaseWorkList tmp) {
        this.phaseWorkList = tmp;
    }

    public boolean getBuildPhaseWork() {
        return this.buildPhaseWork;
    }

    public void setBuildPhaseWork(boolean tmp) {
        this.buildPhaseWork = tmp;
    }

    public void setBuildPhaseWork(String tmp) {
        this.buildPhaseWork = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildStepWork() {
        return this.buildStepWork;
    }

    public void setBuildStepWork(boolean tmp) {
        this.buildStepWork = tmp;
    }

    public void setBuildStepWork(String tmp) {
        this.buildStepWork = DatabaseUtils.parseBoolean(tmp);
    }

    public String getPlanName() {
        return this.planName;
    }

    public void setPlanName(String tmp) {
        this.planName = tmp;
    }

    public String getPlanDescription() {
        return this.planDescription;
    }

    public void setPlanDescription(String tmp) {
        this.planDescription = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getActionPlanId() {
        return this.actionPlanId;
    }

    public void setActionPlanId(int tmp) {
        this.actionPlanId = tmp;
    }

    public void setActionPlanId(String tmp) {
        this.actionPlanId = Integer.parseInt(tmp);
    }

    public int getManagerId() {
        return this.managerId;
    }

    public void setManagerId(int tmp) {
        this.managerId = tmp;
    }

    public void setManagerId(String tmp) {
        this.managerId = Integer.parseInt(tmp);
    }

    public int getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(int tmp) {
        this.assignedTo = tmp;
    }

    public void setAssignedTo(String tmp) {
        this.assignedTo = Integer.parseInt(tmp);
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public String getLinkItemName() {
        return this.linkItemName;
    }

    public void setLinkItemName(String tmp) {
        this.linkItemName = tmp;
    }

    public void setLinkItemId(String tmp) {
        this.linkItemId = Integer.parseInt(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket tmp) {
        this.ticket = tmp;
    }

    public boolean getBuildCurrentPhaseWork() {
        return this.buildCurrentPhaseWork;
    }

    public void setBuildCurrentPhaseWork(boolean tmp) {
        this.buildCurrentPhaseWork = tmp;
    }

    public void setBuildCurrentPhaseWork(String tmp) {
        this.buildCurrentPhaseWork = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildCurrentStepWork() {
        return this.buildCurrentStepWork;
    }

    public void setBuildCurrentStepWork(boolean tmp) {
        this.buildCurrentStepWork = tmp;
    }

    public void setBuildCurrentStepWork(String tmp) {
        this.buildCurrentStepWork = DatabaseUtils.parseBoolean(tmp);
    }

    public int getDaysActive() {
        if (this.entered != null) {
            float ageCheck = (System.currentTimeMillis() - this.entered.getTime()) / 3600000L;
            int totalHours = Math.round(ageCheck);
            return Math.round(totalHours / 24);
        }
        return 0;
    }

    public ActionPlanWork() {
    }

    public ActionPlanWork(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ActionPlanWork(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Action Plan Work ID");
        }
        PreparedStatement pst = db.prepareStatement("SELECT apw.*, ap.plan_name, ap.description, ap.site_id, c.namefirst, c.namelast FROM action_plan_work apw LEFT JOIN action_plan ap ON (apw.action_plan_id = ap.plan_id) LEFT JOIN contact c ON (apw.assignedTo = c.user_id) WHERE apw.plan_work_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.buildLinkedObject) {
            this.buildLinkedObject(db);
        }
        if (this.buildPhaseWork) {
            this.buildPhaseWork(db);
        }
        if (this.buildCurrentPhaseWork) {
            this.buildCurrentPhaseWork(db);
        }
        if (this.getId() == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    public void buildPhaseWork(Connection db) throws SQLException {
        if (this.phaseWorkList == null) {
            this.phaseWorkList = new ActionPhaseWorkList();
        }
        this.phaseWorkList.setPlanWorkId(this.id);
        this.phaseWorkList.setBuildStepWork(this.buildStepWork);
        this.phaseWorkList.setGlobal(this.buildGlobalPhases);
        this.phaseWorkList.setBuildPhase(true);
        this.phaseWorkList.setPlanWork(this);
        this.phaseWorkList.setBuildLinkedObject(this.buildLinkedObject);
        this.phaseWorkList.buildList(db);
    }

    public void buildCurrentPhaseWork(Connection db) throws SQLException {
        if (this.phaseWorkList == null) {
            this.phaseWorkList = new ActionPhaseWorkList();
        }
        this.phaseWorkList.setPlanWorkId(this.id);
        this.phaseWorkList.setBuildCurrentStepsOnly(this.buildCurrentStepWork);
        this.phaseWorkList.setHasWork(true);
        this.phaseWorkList.setGlobal(this.buildGlobalPhases);
        this.phaseWorkList.setBuildPhase(true);
        this.phaseWorkList.setPlanWork(this);
        this.phaseWorkList.setBuildLinkedObject(this.buildLinkedObject);
        this.phaseWorkList.buildList(db);
    }

    public void buildLinkedObject(Connection db) throws SQLException {
        if (this.linkModuleId == ActionPlan.getMapIdGivenConstantId(db, 2)) {
            if (this.contact == null || this.contact.getId() == -1) {
                this.contact = new Contact(db, this.linkItemId);
                this.linkItemName = this.contact.getNameFirstLast();
            }
        } else if (this.linkModuleId == ActionPlan.getMapIdGivenConstantId(db, 42420034)) {
            if (this.organization == null || this.organization.getOrgId() == -1) {
                this.organization = new Organization(db, this.linkItemId);
                this.linkItemName = this.organization.getName();
            }
        } else if (this.linkModuleId == ActionPlan.getMapIdGivenConstantId(db, 912051329) && (this.ticket == null || this.ticket.getId() == -1)) {
            this.ticket = new Ticket(db, this.linkItemId);
            if (this.organization == null || this.organization.getOrgId() == -1) {
                this.organization = new Organization(db, this.ticket.getOrgId());
                this.linkItemName = this.organization.getName();
            }
            if (this.contact == null || this.contact.getId() == -1) {
                this.contact = new Contact(db, this.ticket.getContactId());
                this.linkItemName = this.contact.getNameFirstLast();
            }
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("plan_work_id");
        this.actionPlanId = DatabaseUtils.getInt(rs, "action_plan_id");
        this.managerId = DatabaseUtils.getInt(rs, "manager");
        this.assignedTo = DatabaseUtils.getInt(rs, "assignedTo");
        this.linkModuleId = DatabaseUtils.getInt(rs, "link_module_id");
        this.linkItemId = DatabaseUtils.getInt(rs, "link_item_id");
        this.enabled = rs.getBoolean("enabled");
        this.currentPhaseId = DatabaseUtils.getInt(rs, "current_phase");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = DatabaseUtils.getInt(rs, "enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = DatabaseUtils.getInt(rs, "modifiedby");
        this.planName = rs.getString("plan_name");
        this.planDescription = rs.getString("description");
        this.planSiteId = DatabaseUtils.getInt(rs, "site_id");
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "action_plan_work_plan_work_id_seq");
        sql.append("INSERT INTO action_plan_work (" + (this.id > -1 ? "plan_work_id, " : "") + "action_plan_id, manager, assignedTo, enabled, link_module_id, link_item_id, current_phase, ");
        if (this.entered != null) {
            sql.append("entered, ");
        }
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("enteredby, modifiedby ) ");
        sql.append("VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ");
        if (this.entered != null) {
            sql.append("?, ");
        }
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("?, ? ) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.getActionPlanId());
        DatabaseUtils.setInt(pst, ++i, this.getManagerId());
        pst.setInt(++i, this.getAssignedTo());
        pst.setBoolean(++i, this.getEnabled());
        DatabaseUtils.setInt(pst, ++i, this.getLinkModuleId());
        DatabaseUtils.setInt(pst, ++i, this.getLinkItemId());
        DatabaseUtils.setInt(pst, ++i, this.currentPhaseId);
        if (this.entered != null) {
            pst.setTimestamp(++i, this.entered);
        }
        if (this.modified != null) {
            pst.setTimestamp(++i, this.modified);
        }
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "action_plan_work_plan_work_id_seq", this.id);
        return true;
    }

    public boolean insert(Connection db, ActionPlan actionPlan) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            ActionPhase currentPhase;
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            if (actionPlan.getPhases().size() > 0 && (currentPhase = actionPlan.getCurrentPhase()) != null) {
                this.setCurrentPhaseId(currentPhase.getId());
            }
            this.setPlanName(actionPlan.getName());
            this.insert(db);
            for (ActionPhase actionPhase : actionPlan.getPhases()) {
                ActionPhaseWork phaseWork = new ActionPhaseWork();
                phaseWork.setPlanWorkId(this.getId());
                phaseWork.setActionPhaseId(actionPhase.getId());
                phaseWork.setAssignedTo(this.getAssignedTo());
                phaseWork.setManagerId(this.getManagerId());
                phaseWork.setEnteredBy(this.getEnteredBy());
                phaseWork.setModifiedBy(this.getModifiedBy());
                if (actionPhase.beforeCurrent(actionPlan)) {
                    phaseWork.setStatusId(2);
                }
                phaseWork.insert(db, actionPlan, actionPhase);
            }
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException("ActionPlanWork: " + e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public void update(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE action_plan_work ");
        sql.append("SET manager = ?, assignedTo = ?, current_phase = ?, ");
        sql.append("enabled = ?, modifiedby = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + " ");
        sql.append("WHERE plan_work_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.managerId);
        pst.setInt(++i, this.assignedTo);
        DatabaseUtils.setInt(pst, ++i, this.currentPhaseId);
        pst.setBoolean(++i, this.enabled);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.id);
        pst.executeUpdate();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            ActionPlanWorkNoteList notes = new ActionPlanWorkNoteList();
            notes.setPlanWorkId(this.id);
            notes.buildList(db);
            notes.delete(db);
            ActionPhaseWorkList phases = new ActionPhaseWorkList();
            phases.setPlanWorkId(this.id);
            phases.buildList(db);
            this.setBuildLinkedObject(true);
            this.buildLinkedObject(db);
            phases.setPlanWork(this);
            phases.delete(db);
            PreparedStatement pst = db.prepareStatement("DELETE FROM action_plan_work WHERE plan_work_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public void updateRating(Connection db, int rating) throws SQLException {
        if (this.linkModuleId == ActionPlan.getMapIdGivenConstantId(db, 42420034)) {
            if (this.organization != null) {
                this.organization.setRating(rating);
                this.organization.update(db);
            }
        } else if (this.linkModuleId != ActionPlan.getMapIdGivenConstantId(db, 2) && this.linkModuleId == ActionPlan.getMapIdGivenConstantId(db, 912051329) && this.organization != null) {
            this.organization.setRating(rating);
            this.organization.update(db);
        }
    }

    public boolean reassign(Connection db, int userId) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            ActionItemWorkList steps = this.getSteps();
            for (ActionItemWork itemWork : steps) {
                if (itemWork.getOwnerId() != this.getAssignedTo() || itemWork.getPermissionType() == 0) continue;
                itemWork.setOwnerId(userId);
                itemWork.reassign(db);
            }
            this.setAssignedTo(userId);
            this.update(db);
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public boolean restart(Connection db) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            ActionItemWorkList steps;
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            ActionPhaseWorkList phases = new ActionPhaseWorkList();
            phases.setPlanWorkId(this.getId());
            phases.setBuildStepWork(true);
            phases.setBuildPhase(true);
            phases.setHasWork(true);
            phases.buildList(db);
            phases.reset(db);
            for (ActionPhaseWork phaseWork : phases) {
                steps = phaseWork.getItemWorkList();
                if (steps == null) continue;
                steps.reset(db);
            }
            if (phases.size() > 0) {
                ActionPhaseWork currentPhase = (ActionPhaseWork)((Object)phases.get(0));
                currentPhase.setStartDate(new Timestamp(new Date().getTime()));
                currentPhase.setEndDate((Timestamp)null);
                currentPhase.setStatusId(-1);
                currentPhase.update(db);
                currentPhase.buildPhaseObject(db);
                steps = currentPhase.getItemWorkList();
                if (steps != null && steps.size() > 0) {
                    String nullStr = null;
                    if (currentPhase.getPhase().getRandom()) {
                        for (ActionItemWork currentStep : steps) {
                            currentStep.setStartDate(new Timestamp(new Date().getTime()));
                            currentStep.setStatusId(-1);
                            currentStep.setEndDate(nullStr);
                            currentStep.update(db);
                        }
                    } else {
                        ActionItemWork currentStep = (ActionItemWork)((Object)steps.get(0));
                        currentStep.setStartDate(new Timestamp(new Date().getTime()));
                        currentStep.setStatusId(-1);
                        currentStep.setEndDate(nullStr);
                        currentStep.update(db);
                    }
                }
                this.setCurrentPhaseId(currentPhase.getActionPhaseId());
            }
            this.update(db);
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public ActionPhaseWork getCurrentPhase() {
        if (this.phaseWorkList != null) {
            ActionPhaseWork topPhase = this.phaseWorkList.getRootPhase();
            if (topPhase != null && topPhase.isCurrent()) {
                return topPhase;
            }
            for (ActionPhaseWork phaseWork : this.phaseWorkList) {
                if (!phaseWork.isCurrent()) continue;
                return phaseWork;
            }
        }
        return null;
    }

    public ActionItemWork getCurrentStep() {
        ActionPhaseWork currentPhase = this.getCurrentPhase();
        if (currentPhase != null) {
            return currentPhase.getCurrentStep();
        }
        return null;
    }

    public boolean requiresAction(int userId) {
        ActionItemWorkList pendingSteps = this.getPendingSteps();
        for (ActionItemWork pendingStep : pendingSteps) {
            if (pendingStep.getOwnerId() != userId) continue;
            return true;
        }
        return false;
    }

    public static HtmlSelect getStatusSelect(String selectName, int defaultKey) {
        HtmlSelect statusSelect = new HtmlSelect();
        statusSelect.setSelectName(selectName);
        statusSelect.addItem(2, "Completed");
        statusSelect.addItem(1, "Skipped");
        statusSelect.setDefaultKey(defaultKey);
        statusSelect.build();
        return statusSelect;
    }

    public static ActionPlanWork getActionPlanWork(Connection db, int linkModuleId, int linkItemId) throws SQLException {
        ActionPlanWork actionPlanWork = new ActionPlanWork();
        PreparedStatement pst = db.prepareStatement("SELECT plan_work_id FROM action_plan_work WHERE link_module_id = ? AND link_item_id = ? ");
        DatabaseUtils.setInt(pst, 1, linkModuleId);
        DatabaseUtils.setInt(pst, 2, linkItemId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            actionPlanWork = new ActionPlanWork(db, rs.getInt("plan_work_id"));
        }
        rs.close();
        pst.close();
        return actionPlanWork;
    }

    public String getDisplayInPlanSteps() {
        String steps = "";
        for (ActionPhaseWork thisPhase : this.phaseWorkList) {
            Iterator items = thisPhase.getItemWorkList().iterator();
            while (items.hasNext()) {
                ActionItemWork thisItem = (ActionItemWork)((Object)items.next());
                ActionStep step = thisItem.getStep();
                if (step == null || !step.getDisplayInPlanList()) continue;
                if (items.hasNext()) {
                    steps = steps + step.getPlanListLabel() + ",";
                    continue;
                }
                steps = steps + step.getPlanListLabel();
            }
        }
        return steps;
    }

    public ActionItemWorkList getSteps() {
        ActionItemWorkList steps = new ActionItemWorkList();
        for (ActionPhaseWork thisPhase : this.phaseWorkList) {
            for (ActionItemWork thisItem : thisPhase.getItemWorkList()) {
                steps.add(thisItem);
            }
        }
        return steps;
    }

    public ActionItemWorkList getPendingSteps() {
        ActionItemWorkList steps = new ActionItemWorkList();
        for (ActionPhaseWork thisPhase : this.phaseWorkList) {
            for (ActionItemWork thisItem : thisPhase.getItemWorkList()) {
                if (thisItem.hasStatus()) continue;
                steps.add(thisItem);
            }
        }
        return steps;
    }

    public void buildStepLinks() {
        Iterator steps1 = this.getSteps().iterator();
        Iterator steps2 = this.getSteps().iterator();
        if (steps2.hasNext()) {
            steps2.next();
        }
        while (steps1.hasNext()) {
            ActionItemWork thisStep = (ActionItemWork)((Object)steps1.next());
            if (!steps2.hasNext()) continue;
            ActionItemWork nextStep = (ActionItemWork)((Object)steps2.next());
            thisStep.setNextStep(nextStep);
            thisStep.setHasNext(true);
        }
    }

    public static HashMap buildUserPhaseMap(Connection db, int actionPlanId) throws SQLException {
        if (actionPlanId == -1) {
            throw new SQLException("Action Plan ID not specified");
        }
        int userId = -1;
        HashMap userPhase = new HashMap();
        HashMap<Integer, Integer> phaseMap = new HashMap<Integer, Integer>();
        PreparedStatement pst = db.prepareStatement("SELECT assignedTo, current_phase, count(assignedTo) AS assigned_count FROM action_plan_work WHERE action_plan_id = ? GROUP BY assignedTo, current_phase ORDER BY assignedTo, current_phase ");
        pst.setInt(1, actionPlanId);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            int phaseId;
            if (userId == -1) {
                phaseId = DatabaseUtils.getInt(rs, "current_phase");
                if (phaseId != -1) {
                    phaseMap.put(new Integer(phaseId), new Integer(rs.getInt("assigned_count")));
                }
            } else {
                if (userId != rs.getInt("assignedTo")) {
                    userPhase.put(new Integer(userId), new HashMap(phaseMap));
                    phaseMap = new HashMap();
                }
                if ((phaseId = DatabaseUtils.getInt(rs, "current_phase")) != -1) {
                    phaseMap.put(new Integer(phaseId), new Integer(rs.getInt("assigned_count")));
                }
            }
            userId = rs.getInt("assignedTo");
        }
        rs.close();
        pst.close();
        if (userId != -1) {
            userPhase.put(new Integer(userId), new HashMap(phaseMap));
        }
        return userPhase;
    }

    public static void adjustPhaseCount(HashMap userPhase, ArrayList childList, int user) {
        if (userPhase != null) {
            HashMap<Integer, Integer> userPhases = (HashMap<Integer, Integer>)userPhase.get(new Integer(user));
            for (User child : childList) {
                ActionPlanWork.adjustPhaseCount(userPhase, new ArrayList(child.getShortChildList()), child.getId());
                HashMap childPhases = (HashMap)userPhase.get(new Integer(child.getId()));
                if (childPhases == null) continue;
                Iterator p = childPhases.keySet().iterator();
                if (userPhases == null) {
                    userPhases = new HashMap<Integer, Integer>();
                    userPhase.put(new Integer(user), userPhases);
                }
                while (p.hasNext()) {
                    Integer phase = (Integer)p.next();
                    Integer userCount = (Integer)userPhases.get(phase);
                    Integer childCount = (Integer)childPhases.get(phase);
                    if (childCount == null) continue;
                    if (userCount != null) {
                        userPhases.put(phase, new Integer(userCount + childCount));
                        continue;
                    }
                    userPhases.put(phase, childCount);
                }
            }
        }
    }

    public boolean sendEmail(ActionContext context, Contact assigned, Contact manager, String orgName, String template) throws Exception {
        return this.sendEmail(context, assigned, manager, null, orgName, template);
    }

    public boolean sendEmail(ActionContext context, Contact assigned, Contact manager, Contact previous, String orgName, String template) throws Exception {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        ActionPlanEmail planEmail = null;
        planEmail = previous != null && previous.getId() > -1 ? new ActionPlanEmail(template, this, previous, assigned, manager, orgName, context) : new ActionPlanEmail(template, this, assigned, manager, orgName, context);
        SMTPMessage mail = new SMTPMessage();
        mail.setHost(prefs.get("MAILSERVER"));
        mail.setFrom(prefs.get("EMAILADDRESS"));
        mail.addReplyTo(prefs.get("EMAILADDRESS"));
        mail.setType("text/html");
        mail.setSubject(planEmail.getSubject());
        mail.setBody(planEmail.getBody());
        if (assigned.getPrimaryEmailAddress() != null && !"".equals(assigned.getPrimaryEmailAddress())) {
            mail.addTo(assigned.getPrimaryEmailAddress());
        }
        if (manager.getPrimaryEmailAddress() != null && !"".equals(manager.getPrimaryEmailAddress())) {
            mail.addTo(manager.getPrimaryEmailAddress());
        }
        if (previous != null && previous.getId() > -1 && previous.getPrimaryEmailAddress() != null && !"".equals(previous.getPrimaryEmailAddress())) {
            mail.addTo(previous.getPrimaryEmailAddress());
        }
        if (mail.send() == 2) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ActionPlanWork -> Send error: " + mail.getErrorMsg() + "\n");
            }
        } else if (System.getProperty("DEBUG") != null) {
            System.out.println("ActionPlanWork -> Sending message...");
        }
        return true;
    }

    public boolean isCompleted() {
        boolean completed = true;
        Iterator phases = this.phaseWorkList.iterator();
        if (phases != null) {
            while (phases.hasNext()) {
                ActionPhaseWork thisPhase = (ActionPhaseWork)((Object)phases.next());
                if (thisPhase == null) continue;
                for (ActionItemWork itemWork : thisPhase.getItemWorkList()) {
                    if (itemWork == null || itemWork.isComplete()) continue;
                    completed = false;
                }
            }
        }
        return completed;
    }
}

