/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.modules.actionplans.base.ActionItemWork;
import org.aspcfs.modules.actionplans.base.ActionPhaseWork;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.modules.actionplans.base.ActionStep;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ActionPlanWorkList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int linkModuleId = -1;
    private int linkItemId = -1;
    private int owner = -1;
    private int manager = -1;
    private int currentStepOwner = -1;
    private int viewpoint = -1;
    private int actionPlanId = -1;
    private int enabled = -1;
    private int hasCurrentPhase = -1;
    private String ownerRange = null;
    private int opportunityId = -1;
    private int userGroupId = -1;
    private int siteId = -1;
    private boolean exclusiveToSite = false;
    private boolean includeAllSites = false;
    private boolean buildPhaseWork = false;
    private boolean buildStepWork = false;
    private boolean buildLinkedObject = false;
    private boolean allMyPlans = false;
    private boolean isTicket = false;
    private boolean buildCurrentPhaseOnly = false;
    private boolean buildCurrentStepOnly = false;
    public static final String tableName = "action_plan_work";
    public static final String uniqueField = "plan_work_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public int getUserGroupId() {
        return this.userGroupId;
    }

    public void setUserGroupId(int tmp) {
        this.userGroupId = tmp;
    }

    public void setUserGroupId(String tmp) {
        this.userGroupId = Integer.parseInt(tmp);
    }

    public boolean getAllMyPlans() {
        return this.allMyPlans;
    }

    public void setAllMyPlans(boolean tmp) {
        this.allMyPlans = tmp;
    }

    public void setAllMyPlans(String tmp) {
        this.allMyPlans = DatabaseUtils.parseBoolean(tmp);
    }

    public int getOpportunityId() {
        return this.opportunityId;
    }

    public void setOpportunityId(int tmp) {
        this.opportunityId = tmp;
    }

    public void setOpportunityId(String tmp) {
        this.opportunityId = Integer.parseInt(tmp);
    }

    public String getOwnerRange() {
        return this.ownerRange;
    }

    public void setOwnerRange(String tmp) {
        this.ownerRange = tmp;
    }

    public int getHasCurrentPhase() {
        return this.hasCurrentPhase;
    }

    public void setHasCurrentPhase(int tmp) {
        this.hasCurrentPhase = tmp;
    }

    public void setHasCurrentPhase(String tmp) {
        this.hasCurrentPhase = Integer.parseInt(tmp);
    }

    public int getCurrentStepOwner() {
        return this.currentStepOwner;
    }

    public void setCurrentStepOwner(int tmp) {
        this.currentStepOwner = tmp;
    }

    public void setCurrentStepOwner(String tmp) {
        this.currentStepOwner = Integer.parseInt(tmp);
    }

    public int getViewpoint() {
        return this.viewpoint;
    }

    public void setViewpoint(int viewpoint) {
        this.viewpoint = viewpoint;
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setLinkItemId(String tmp) {
        this.linkItemId = Integer.parseInt(tmp);
    }

    public int getManager() {
        return this.manager;
    }

    public void setManager(int tmp) {
        this.manager = tmp;
    }

    public void setManager(String tmp) {
        this.manager = Integer.parseInt(tmp);
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public boolean getBuildLinkedObject() {
        return this.buildLinkedObject;
    }

    public void setBuildLinkedObject(boolean tmp) {
        this.buildLinkedObject = tmp;
    }

    public void setBuildLinkedObject(String tmp) {
        this.buildLinkedObject = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildPhaseWork() {
        return this.buildPhaseWork;
    }

    public void setBuildPhaseWork(boolean tmp) {
        this.buildPhaseWork = tmp;
    }

    public void setBuildPhaseWork(String tmp) {
        this.buildPhaseWork = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildStepWork() {
        return this.buildStepWork;
    }

    public void setBuildStepWork(boolean tmp) {
        this.buildStepWork = tmp;
    }

    public void setBuildStepWork(String tmp) {
        this.buildStepWork = DatabaseUtils.parseBoolean(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public int getOwner() {
        return this.owner;
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setOwner(String tmp) {
        this.owner = Integer.parseInt(tmp);
    }

    public int getActionPlanId() {
        return this.actionPlanId;
    }

    public void setActionPlanId(int tmp) {
        this.actionPlanId = tmp;
    }

    public void setActionPlanId(String tmp) {
        this.actionPlanId = Integer.parseInt(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getIncludeAllSites() {
        return this.includeAllSites;
    }

    public void setIncludeAllSites(boolean tmp) {
        this.includeAllSites = tmp;
    }

    public void setIncludeAllSites(String tmp) {
        this.includeAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildCurrentPhaseOnly() {
        return this.buildCurrentPhaseOnly;
    }

    public void setBuildCurrentPhaseOnly(boolean tmp) {
        this.buildCurrentPhaseOnly = tmp;
    }

    public void setBuildCurrentPhaseOnly(String tmp) {
        this.buildCurrentPhaseOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildCurrentStepOnly() {
        return this.buildCurrentStepOnly;
    }

    public void setBuildCurrentStepOnly(boolean tmp) {
        this.buildCurrentStepOnly = tmp;
    }

    public void setBuildCurrentStepOnly(String tmp) {
        this.buildCurrentStepOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        this.isTicket = this.linkModuleId == ActionPlan.getMapIdGivenConstantId(db, 912051329);
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM action_plan_work apw LEFT JOIN action_plan ap ON (apw.action_plan_id = ap.plan_id) LEFT JOIN contact c ON (apw.assignedTo = c.user_id) WHERE apw.plan_work_id > 0 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(ap.plan_name) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("c.namefirst, c.namelast, apw.entered", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY c.namefirst, c.namelast, apw.entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append(" SELECT ");
        }
        sqlSelect.append("apw.*, ap.plan_name, ap.description, ap.site_id, c.namefirst, c.namelast FROM action_plan_work apw LEFT JOIN action_plan ap ON (apw.action_plan_id = ap.plan_id) LEFT JOIN contact c ON (apw.assignedTo = c.user_id) WHERE apw.plan_work_id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ActionPlanWork actionPlanWork = new ActionPlanWork(rs);
            this.add(actionPlanWork);
        }
        rs.close();
        pst.close();
        for (ActionPlanWork actionPlanWork : this) {
            if (this.buildPhaseWork) {
                actionPlanWork.setBuildStepWork(this.buildStepWork);
                actionPlanWork.setBuildLinkedObject(this.buildLinkedObject);
                actionPlanWork.buildPhaseWork(db);
            }
            if (this.buildCurrentPhaseOnly) {
                actionPlanWork.setBuildCurrentStepWork(this.buildCurrentStepOnly);
                actionPlanWork.buildCurrentPhaseWork(db);
            }
            if (!this.buildLinkedObject) continue;
            actionPlanWork.buildLinkedObject(db);
        }
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.linkModuleId > -1) {
            sqlFilter.append("AND apw.link_module_id = ? ");
        }
        if (this.linkItemId > -1) {
            sqlFilter.append("AND apw.link_item_id = ? ");
        }
        if (!this.allMyPlans) {
            if (this.owner > -1) {
                sqlFilter.append("AND apw.assignedTo = ? ");
            }
            if (this.manager > -1) {
                sqlFilter.append("AND apw.manager = ? ");
            }
            if (this.viewpoint > -1) {
                sqlFilter.append("AND (apw.assignedTo = ? OR apw.manager = ?) ");
            }
            if (this.currentStepOwner > -1) {
                sqlFilter.append("AND apw.plan_work_id IN (SELECT aphw.plan_work_id FROM action_phase_work aphw  WHERE aphw.phase_work_id IN (SELECT phase_work_id FROM action_item_work aiw  WHERE aiw.start_date IS NOT NULL  AND aiw.end_date IS NULL  AND (aiw.owner = ? ");
                if (this.isTicket) {
                    sqlFilter.append(" OR aiw.action_step_id IN (SELECT s.step_id FROM action_step s  WHERE (s.permission_type = ?  AND apw.link_module_id = ?  AND apw.link_item_id IN (SELECT t.ticketid FROM ticket t  WHERE t.user_group_id IN (SELECT group_id FROM user_group_map WHERE user_id = ? )))) ");
                }
                sqlFilter.append(" OR aiw.action_step_id IN (SELECT s.step_id FROM action_step s  WHERE (s.permission_type = ? AND s.role_id IN (SELECT role_id FROM " + DatabaseUtils.addQuotes(db, "access") + " WHERE user_id = ? ))) " + " OR aiw.action_step_id IN (SELECT s.step_id FROM action_step s " + " WHERE s.permission_type = ? AND s.department_id IN (SELECT department FROM contact WHERE user_id = ? )) " + " OR aiw.action_step_id IN (SELECT s.step_id FROM action_step s " + " WHERE s.permission_type = ? AND s.group_id IN (SELECT group_id from user_group_map WHERE user_id = ? )) " + " )) " + "AND aphw.start_date IS NOT NULL AND aphw.end_date IS NULL AND aphw.status_id IS NULL ) ");
            }
        } else {
            if (this.owner > -1 || this.manager > -1 || this.currentStepOwner > -1) {
                sqlFilter.append("AND ( ");
            }
            if (this.owner > -1) {
                sqlFilter.append(" apw.assignedTo = ? ");
            }
            if (this.manager > -1) {
                sqlFilter.append((this.owner > -1 ? "OR " : "") + " apw.manager = ? ");
            }
            if (this.currentStepOwner > -1) {
                sqlFilter.append((this.owner > -1 || this.manager > -1 ? "OR " : "") + " apw.plan_work_id IN (SELECT aphw.plan_work_id FROM action_phase_work aphw " + " WHERE aphw.phase_work_id IN (SELECT phase_work_id FROM action_item_work aiw " + " WHERE aiw.start_date IS NOT NULL " + " AND aiw.end_date IS NULL " + " AND (aiw.owner = ? ");
                if (this.isTicket) {
                    sqlFilter.append(" OR aiw.action_step_id IN (SELECT s.step_id FROM action_step s  WHERE (s.permission_type = ?  AND apw.link_module_id = ?  AND apw.link_item_id IN (SELECT t.ticketid FROM ticket t  WHERE t.user_group_id IN (SELECT group_id FROM user_group_map WHERE user_id = ? )))) ");
                }
                sqlFilter.append(" OR aiw.action_step_id IN (SELECT s.step_id FROM action_step s  WHERE (s.permission_type = ? AND s.role_id IN (SELECT role_id FROM " + DatabaseUtils.addQuotes(db, "access") + " WHERE user_id = ? ))) " + " OR aiw.action_step_id IN (SELECT s.step_id FROM action_step s " + " WHERE s.permission_type = ? AND s.department_id IN (SELECT department FROM contact WHERE user_id = ? )) " + " OR aiw.action_step_id IN (SELECT s.step_id FROM action_step s " + " WHERE s.permission_type = ? AND s.group_id IN (SELECT group_id from user_group_map WHERE user_id = ? )) " + " )) " + "AND aphw.start_date IS NOT NULL AND aphw.end_date IS NULL AND aphw.status_id IS NULL ) ");
            }
            if (this.owner > -1 || this.manager > -1 || this.currentStepOwner > -1) {
                sqlFilter.append(") ");
            }
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND apw.enabled = ? ");
        }
        if (this.hasCurrentPhase != -1) {
            if (this.hasCurrentPhase == 1) {
                sqlFilter.append("AND apw.current_phase IS NOT NULL ");
            } else if (this.hasCurrentPhase == 0) {
                sqlFilter.append("AND apw.current_phase IS NULL ");
            }
        }
        if (this.actionPlanId != -1) {
            sqlFilter.append("AND apw.action_plan_id = ? ");
        }
        if (this.ownerRange != null && !"".equals(this.ownerRange.trim())) {
            sqlFilter.append("AND apw.assignedto IN (" + this.ownerRange + ") ");
        }
        if (this.opportunityId > -1) {
            sqlFilter.append("AND apw.plan_work_id IN (SELECT plan_work_id FROM action_phase_work  WHERE phase_work_id IN (SELECT phase_work_id FROM action_item_work  WHERE link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = 1011200517) AND link_item_id IN (SELECT id FROM opportunity_component WHERE opp_id = ? ))) ");
        }
        if (!this.includeAllSites) {
            if (this.siteId > -1) {
                sqlFilter.append("AND (ap.site_id = ? ");
                if (!this.exclusiveToSite) {
                    sqlFilter.append("OR ap.site_id IS NULL ");
                }
                sqlFilter.append(") ");
            } else {
                sqlFilter.append("AND ap.site_id IS NULL ");
            }
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.linkModuleId > -1) {
            pst.setInt(++i, this.linkModuleId);
        }
        if (this.linkItemId > -1) {
            pst.setInt(++i, this.linkItemId);
        }
        if (this.owner > -1) {
            pst.setInt(++i, this.owner);
        }
        if (this.manager > -1) {
            pst.setInt(++i, this.manager);
        }
        if (!this.allMyPlans && this.viewpoint > -1) {
            pst.setInt(++i, this.viewpoint);
            pst.setInt(++i, this.viewpoint);
        }
        if (this.currentStepOwner > -1) {
            pst.setInt(++i, this.currentStepOwner);
            if (this.isTicket) {
                pst.setInt(++i, 7);
                pst.setInt(++i, this.linkModuleId);
                pst.setInt(++i, this.currentStepOwner);
            }
            pst.setInt(++i, 2);
            pst.setInt(++i, this.currentStepOwner);
            pst.setInt(++i, 3);
            pst.setInt(++i, this.currentStepOwner);
            pst.setInt(++i, 8);
            pst.setInt(++i, this.currentStepOwner);
        }
        if (this.enabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.enabled == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.actionPlanId != -1) {
            pst.setInt(++i, this.actionPlanId);
        }
        if (this.opportunityId > -1) {
            pst.setInt(++i, this.opportunityId);
        }
        if (!this.includeAllSites && this.siteId > -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public int getEnabledItem() {
        int result = -1;
        for (ActionPlanWork work : this) {
            if (!work.getEnabled()) continue;
            result = work.getId();
            break;
        }
        return result;
    }

    public void delete(Connection db) throws SQLException {
        for (ActionPlanWork thisWork : this) {
            thisWork.delete(db);
        }
    }

    public void enable(Connection db, boolean enable) throws SQLException {
        for (ActionPlanWork thisWork : this) {
            thisWork.setEnabled(enable);
            thisWork.update(db);
        }
    }

    public static int retrieveRecordCount(Connection db, int linkModuleId, int linkItemId) throws SQLException {
        int count = 0;
        PreparedStatement pst = db.prepareStatement("SELECT COUNT(plan_work_id) as itemcount FROM action_plan_work apw WHERE apw.plan_work_id > 0 AND apw.link_module_id = ? AND apw.link_item_id = ? ");
        pst.setInt(1, linkModuleId);
        pst.setInt(2, linkItemId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            count = rs.getInt("itemcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public ActionPlanWork getLatestPlan() {
        ActionPlanWork result = null;
        for (ActionPlanWork work : this) {
            if (result != null && work.getEntered().after(result.getEntered())) {
                result = work;
                continue;
            }
            result = work;
        }
        return result;
    }

    public int getDisplayInPlanStepsCount() {
        int result = 0;
        for (ActionPlanWork work : this) {
            for (ActionPhaseWork thisPhase : work.getPhaseWorkList()) {
                for (ActionItemWork thisItem : thisPhase.getItemWorkList()) {
                    ActionStep step = thisItem.getStep();
                    if (step == null || !step.getDisplayInPlanList()) continue;
                    ++result;
                }
            }
        }
        return result;
    }

    public HashMap getPlanIdHashMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (ActionPlanWork work : this) {
            String workPlanId = String.valueOf(work.getActionPlanId());
            result.put(workPlanId, workPlanId);
        }
        return result;
    }
}

