/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.actionplans.base.ActionItemWorkList;
import org.aspcfs.modules.actionplans.base.ActionPhase;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionStepList;
import org.aspcfs.modules.actionplans.base.ActionStepLookupList;
import org.aspcfs.modules.actionplans.base.ActionStepMap;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.LookupElement;
import org.aspcfs.utils.web.LookupList;

public class ActionStep
extends GenericBean {
    public static final int USER_DELEGATED = -1;
    public static final int MANAGER = 0;
    public static final int ASSIGNED_USER = 1;
    public static final int ROLE = 2;
    public static final int DEPARTMENT = 3;
    public static final int UP_USER_HIERARCHY = 4;
    public static final int WITHIN_USER_HIERARCHY = 5;
    public static final int ASSIGNED_USER_AND_MANAGER = 6;
    public static final int USER_GROUP = 7;
    public static final int SPECIFIC_USER_GROUP = 8;
    public static final int ATTACH_NOTHING = -1;
    public static final int ATTACH_OPPORTUNITY = 110061030;
    public static final int ATTACH_DOCUMENT = 110061031;
    public static final int ATTACH_ACTIVITY = 110061032;
    public static final int ATTACH_FOLDER = 110061033;
    public static final int UPDATE_RATING = 110061034;
    public static final int ATTACH_NOTE_SINGLE = 110061035;
    public static final int ATTACH_NOTE_MULTIPLE = 110061036;
    public static final int ATTACH_LOOKUPLIST_MULTIPLE = 110061037;
    public static final int VIEW_ACCOUNT = 110061038;
    public static final int ATTACH_ACCOUNT_CONTACT = 110061039;
    public static final int ATTACH_RELATIONSHIP = 110061040;
    public static final int ADD_RECIPIENT = 302061653;
    protected int id = -1;
    protected int parentId = -1;
    protected int phaseId = -1;
    protected String description = null;
    protected int actionId = -1;
    protected int durationTypeId = -1;
    protected int estimatedDuration = -1;
    protected int customFieldCategoryId = -1;
    protected int customFieldId = -1;
    protected int permissionType = 1;
    protected int roleId = -1;
    protected int departmentId = -1;
    protected boolean enabled = false;
    protected Timestamp entered = null;
    protected boolean allowSkipToHere = false;
    protected boolean actionRequired = false;
    protected String label = null;
    protected int userGroupId = -1;
    protected String targetRelationship = null;
    protected boolean allowUpdate = true;
    protected int campaignId = -1;
    protected boolean allowDuplicateRecipient = false;
    protected ArrayList accountTypes = null;
    protected String durationTypeIdString = null;
    protected ActionStepList stepList = new ActionStepList();
    protected boolean buildCompleteStepList = false;
    protected boolean buildRelatedRecords = false;
    protected ActionItemWorkList actionItems = null;
    protected ActionStepLookupList lookupList = null;
    protected String userGroupName = null;
    protected boolean displayInPlanList = false;
    protected String planListLabel = null;

    public ActionStep() {
    }

    public ActionStep(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ActionStep(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Action Plan ID");
        }
        StringBuffer sb = new StringBuffer(" SELECT astp.*,  ldt.description AS duration, ug.group_name as groupname  FROM action_step astp  LEFT JOIN lookup_duration_type ldt ON (astp.duration_type_id = ldt.code)  LEFT JOIN custom_field_category cfc ON (astp.category_id = cfc.category_id)  LEFT JOIN custom_field_info cfi ON (astp.field_id = cfi.field_id)  LEFT JOIN " + DatabaseUtils.addQuotes(db, "role") + " r ON (astp.role_id = r.role_id) " + " LEFT JOIN lookup_department dpt ON (astp.department_id = dpt.code) " + " LEFT JOIN user_group ug ON (astp.group_id = ug.group_id) " + " WHERE astp.step_id = ? ");
        PreparedStatement pst = db.prepareStatement(sb.toString());
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        if (this.getBuildRelatedRecords()) {
            this.buildRelatedRecords(db);
        }
        this.buildAccountTypes(db);
    }

    public void buildRelatedRecords(Connection db) throws SQLException {
        this.actionItems = new ActionItemWorkList();
        this.actionItems.setActionStepId(this.getId());
        this.actionItems.buildList(db);
    }

    private void buildAccountTypes(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Action Step ID not specified");
        }
        this.accountTypes = new ArrayList();
        PreparedStatement pst = db.prepareStatement("SELECT type_id FROM action_step_account_types WHERE step_id = ? ");
        pst.setInt(1, this.getId());
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            String type = String.valueOf(rs.getInt("type_id"));
            this.accountTypes.add(type);
        }
        rs.close();
        pst.close();
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("step_id"));
        this.parentId = DatabaseUtils.getInt(rs, "parent_id", 0);
        this.phaseId = DatabaseUtils.getInt(rs, "phase_id");
        this.description = rs.getString("description");
        this.actionId = DatabaseUtils.getInt(rs, "action_id");
        this.durationTypeId = DatabaseUtils.getInt(rs, "duration_type_id");
        this.estimatedDuration = DatabaseUtils.getInt(rs, "estimated_duration");
        this.customFieldCategoryId = DatabaseUtils.getInt(rs, "category_id");
        this.customFieldId = DatabaseUtils.getInt(rs, "field_id");
        this.permissionType = DatabaseUtils.getInt(rs, "permission_type");
        this.roleId = DatabaseUtils.getInt(rs, "role_id");
        this.departmentId = DatabaseUtils.getInt(rs, "department_id");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.allowSkipToHere = rs.getBoolean("allow_skip_to_here");
        this.actionRequired = rs.getBoolean("action_required");
        this.label = rs.getString("label");
        this.userGroupId = DatabaseUtils.getInt(rs, "group_id");
        this.targetRelationship = rs.getString("target_relationship");
        this.allowUpdate = rs.getBoolean("allow_update");
        this.campaignId = DatabaseUtils.getInt(rs, "campaign_id");
        this.allowDuplicateRecipient = rs.getBoolean("allow_duplicate_recipient");
        this.durationTypeIdString = rs.getString("duration");
        this.userGroupName = rs.getString("groupname");
        this.displayInPlanList = rs.getBoolean("display_in_plan_list");
        this.planListLabel = rs.getString("plan_list_label");
    }

    public void setAccountTypes(String[] params) {
        this.accountTypes = params != null ? new ArrayList<String>(Arrays.asList(params)) : new ArrayList();
    }

    public boolean insert(Connection db) throws SQLException {
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "action_step_step_id_seq");
            sql.append("INSERT INTO action_step (phase_id, description,  duration_type_id, estimated_duration, ");
            if (this.parentId > -1) {
                sql.append("parent_id, ");
            }
            if (this.actionId > -1) {
                sql.append("action_id, ");
            }
            if (this.customFieldCategoryId > -1) {
                sql.append("category_id, ");
            }
            if (this.customFieldId > -1) {
                sql.append("field_id, ");
            }
            if (this.id > -1) {
                sql.append("step_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            sql.append("enabled, permission_type, role_id, department_id,  allow_skip_to_here, action_required, label, group_id, target_relationship, allow_update, campaign_id,  allow_duplicate_recipient, display_in_plan_list, plan_list_label)");
            sql.append(" VALUES (?, ?, ?, ?, ");
            if (this.parentId > -1) {
                sql.append("?, ");
            }
            if (this.actionId > -1) {
                sql.append("?, ");
            }
            if (this.customFieldCategoryId > -1) {
                sql.append("?, ");
            }
            if (this.customFieldId > -1) {
                sql.append("?, ");
            }
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.getPhaseId());
            pst.setString(++i, this.getDescription());
            DatabaseUtils.setInt(pst, ++i, this.getDurationTypeId());
            DatabaseUtils.setInt(pst, ++i, this.getEstimatedDuration());
            if (this.parentId > -1) {
                DatabaseUtils.setInt(pst, ++i, this.getParentId());
            }
            if (this.actionId > -1) {
                DatabaseUtils.setInt(pst, ++i, this.getActionId());
            }
            if (this.customFieldCategoryId > -1) {
                DatabaseUtils.setInt(pst, ++i, this.getCustomFieldCategoryId());
            }
            if (this.customFieldId > -1) {
                DatabaseUtils.setInt(pst, ++i, this.getCustomFieldId());
            }
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.getEntered());
            }
            pst.setBoolean(++i, this.getEnabled());
            DatabaseUtils.setInt(pst, ++i, this.getPermissionType());
            DatabaseUtils.setInt(pst, ++i, this.getRoleId());
            DatabaseUtils.setInt(pst, ++i, this.getDepartmentId());
            pst.setBoolean(++i, this.allowSkipToHere);
            pst.setBoolean(++i, this.actionRequired);
            pst.setString(++i, this.label);
            DatabaseUtils.setInt(pst, ++i, this.getUserGroupId());
            pst.setString(++i, this.getTargetRelationship());
            pst.setBoolean(++i, this.getAllowUpdate());
            DatabaseUtils.setInt(pst, ++i, this.getCampaignId());
            pst.setBoolean(++i, this.getAllowDuplicateRecipient());
            pst.setBoolean(++i, this.displayInPlanList);
            pst.setString(++i, this.planListLabel);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "action_step_step_id_seq", this.id);
            this.processAccountTypes(db);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            if (this.getActionId() != 110061040) {
                this.targetRelationship = null;
                this.accountTypes.clear();
            }
            PreparedStatement pst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE action_step  SET parent_id = ?,  phase_id = ?,  description = ?,  action_id = ?,  duration_type_id = ?,  estimated_duration = ?,  category_id = ?,  field_id = ?,  permission_type = ?,  role_id = ?,  department_id = ?,  group_id = ?,  target_relationship = ?,  enabled = ?,  allow_skip_to_here = ?,  action_required = ?,  label = ?,  allow_update = ?,  campaign_id = ?,  allow_duplicate_recipient = ?,  display_in_plan_list = ?,  plan_list_label = ?  WHERE step_id = ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.getParentId() == 0 ? -1 : this.getParentId());
            DatabaseUtils.setInt(pst, ++i, this.getPhaseId());
            pst.setString(++i, this.getDescription());
            DatabaseUtils.setInt(pst, ++i, this.getActionId());
            DatabaseUtils.setInt(pst, ++i, this.getDurationTypeId());
            DatabaseUtils.setInt(pst, ++i, this.getEstimatedDuration());
            DatabaseUtils.setInt(pst, ++i, this.getCustomFieldCategoryId());
            DatabaseUtils.setInt(pst, ++i, this.getCustomFieldId());
            DatabaseUtils.setInt(pst, ++i, this.getPermissionType());
            DatabaseUtils.setInt(pst, ++i, this.getRoleId());
            DatabaseUtils.setInt(pst, ++i, this.getDepartmentId());
            DatabaseUtils.setInt(pst, ++i, this.getUserGroupId());
            pst.setString(++i, this.getTargetRelationship());
            pst.setBoolean(++i, this.getEnabled());
            pst.setBoolean(++i, this.allowSkipToHere);
            pst.setBoolean(++i, this.actionRequired);
            pst.setString(++i, this.label);
            pst.setBoolean(++i, this.allowUpdate);
            DatabaseUtils.setInt(pst, ++i, this.getCampaignId());
            pst.setBoolean(++i, this.getAllowDuplicateRecipient());
            pst.setBoolean(++i, this.displayInPlanList);
            pst.setString(++i, this.planListLabel);
            DatabaseUtils.setInt(pst, ++i, this.getId());
            resultCount = pst.executeUpdate();
            pst.close();
            this.processAccountTypes(db);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public void processAccountTypes(Connection db) throws SQLException {
        if (this.accountTypes != null) {
            this.resetAccountTypes(db);
            for (int k = 0; k < this.accountTypes.size(); ++k) {
                String val = (String)this.accountTypes.get(k);
                if (val == null || val.equals("")) continue;
                int typeId = Integer.parseInt((String)this.accountTypes.get(k));
                this.insertAccountType(db, typeId);
            }
        }
    }

    public boolean resetAccountTypes(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Action Step ID not specified");
        }
        int i = 0;
        PreparedStatement pst = db.prepareStatement("DELETE FROM action_step_account_types WHERE step_id = ? ");
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public boolean insertAccountType(Connection db, int typeId) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Action Step ID not specified");
        }
        int i = 0;
        PreparedStatement pst = db.prepareStatement("INSERT INTO action_step_account_types (step_id, type_id) VALUES (?, ?) ");
        pst.setInt(++i, this.getId());
        pst.setInt(++i, typeId);
        pst.execute();
        pst.close();
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        this.queryRecord(db, this.getId());
        int childStepId = ActionStep.getStepIdGivenParentId(db, this.getId());
        ActionStep childStep = null;
        if (childStepId != -1) {
            childStep = new ActionStep();
            childStep.setBuildRelatedRecords(true);
            childStep.queryRecord(db, childStepId);
        }
        if (childStep != null) {
            if (this.getParentId() != -1 && this.getParentId() != 0) {
                childStep.setParentId(this.getParentId());
            } else {
                childStep.setParentId(-1);
            }
            childStep.update(db);
        }
        PreparedStatement pst = db.prepareStatement("DELETE FROM action_step_lookup WHERE step_id = ? ");
        pst.setInt(1, this.getId());
        boolean result = pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM action_step_account_types WHERE step_id = ? ");
        pst.setInt(1, this.getId());
        result = pst.execute();
        pst.close();
        pst = db.prepareStatement("DELETE FROM action_step WHERE step_id = ? ");
        pst.setInt(1, this.getId());
        result = pst.execute();
        pst.close();
        return result;
    }

    public static String getActionString(int actionId) {
        switch (actionId) {
            case 110061039: {
                return "actionPlan.attachAccountContact.text";
            }
            case 110061032: {
                return "actionPlan.attachActivity.text";
            }
            case 110061031: {
                return "actionPlan.attachDocument.text";
            }
            case 110061030: {
                return "actionPlan.attachOpportunity.text";
            }
            case 110061033: {
                return "actionPlan.attachFolder.text";
            }
            case -1: {
                return "actionPlan.noAdditionalActionRequired.text";
            }
            case 110061034: {
                return "actionPlan.updateRating.text";
            }
            case 110061035: {
                return "actionPlan.attachNoteSingle.text";
            }
            case 110061036: {
                return "actionPlan.attachNoteMultiple.text";
            }
            case 110061037: {
                return "actionPlan.attachLookupListMultiple.text";
            }
            case 110061038: {
                return "actionPlan.viewAccount.text";
            }
            case 110061040: {
                return "actionPlan.attachRelationship.text";
            }
            case 302061653: {
                return "admin.actionPlan.addRecipient.text";
            }
        }
        return "actionPlan.noAdditionalActionRequired.text";
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("entered");
        return thisList;
    }

    public void buildStepList(Connection db) throws SQLException {
        this.stepList = new ActionStepList();
        this.stepList.setParentId(this.getId());
        this.stepList.setBuildCompleteStepList(this.getBuildCompleteStepList());
        this.stepList.buildList(db);
    }

    public boolean setAfterStepId(Connection db, String previousStepIdString, boolean addingStep) throws SQLException {
        int nextStepId = -1;
        if (previousStepIdString == null || "".equals(previousStepIdString) || "-1".equals(previousStepIdString)) {
            return true;
        }
        ActionStep previousStep = new ActionStep(db, Integer.parseInt(previousStepIdString));
        ActionStep nextStep = null;
        nextStepId = ActionStep.getStepIdGivenParentId(db, previousStep.getId());
        if (nextStepId != -1) {
            nextStep = new ActionStep(db, nextStepId);
        }
        if (!addingStep) {
            if (this.getParentId() == 0 || this.getParentId() == -1) {
                previousStep.setParentId(-1);
            } else {
                previousStep.setParentId(this.getParentId());
            }
            previousStep.update(db);
        }
        if (nextStepId != -1) {
            nextStep.setParentId(this.getId());
            nextStep.update(db);
        }
        this.setParentId(previousStep.getId());
        this.update(db);
        return true;
    }

    public boolean setBeforeStepId(Connection db, String nextStepIdString, boolean addingStep) throws SQLException {
        boolean result = false;
        int earlierNextStepId = -1;
        if (nextStepIdString == null || "".equals(nextStepIdString) || "-1".equals(nextStepIdString)) {
            return true;
        }
        int nextStepId = Integer.parseInt(nextStepIdString);
        ActionStep earlierNextStep = null;
        ActionStep nextStep = new ActionStep(db, nextStepId);
        if (!addingStep && (earlierNextStepId = ActionStep.getStepIdGivenParentId(db, this.getId())) != -1) {
            earlierNextStep = new ActionStep(db, earlierNextStepId);
        }
        if (nextStep.getParentId() == 0 || nextStep.getParentId() == -1) {
            this.setParentId(-1);
        } else {
            this.setParentId(nextStep.getParentId());
        }
        int resultCount = this.update(db);
        nextStep.setParentId(this.getId());
        nextStep.update(db);
        if (earlierNextStep != null) {
            earlierNextStep.setParentId(nextStep.getId());
            earlierNextStep.update(db);
        }
        return true;
    }

    public static int getStepIdGivenParentId(Connection db, int parentId) throws SQLException {
        int result = -1;
        PreparedStatement pst = db.prepareStatement("SELECT step_id FROM action_step WHERE parent_id = ?");
        pst.setInt(1, parentId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            result = DatabaseUtils.getInt(rs, "step_id");
        }
        rs.close();
        pst.close();
        return result;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Step ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        try {
            int recordCount;
            int i = 0;
            PreparedStatement pst = db.prepareStatement(" SELECT count(*) as recordcount  FROM action_item_work  WHERE action_step_id = ?");
            pst.setInt(++i, this.getId());
            ResultSet rs = pst.executeQuery();
            if (rs.next() && (recordCount = rs.getInt("recordcount")) != 0) {
                Dependency thisDependency = new Dependency();
                thisDependency.setName("actionStepRecords");
                thisDependency.setCount(recordCount);
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public LookupList getMappedActionLookupList(Connection db, int constantId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        LookupList thisLookupList = new LookupList();
        pst = db.prepareStatement("SELECT lsa.* FROM lookup_step_action lsa LEFT JOIN step_action_map map ON (lsa.code = map.action_id ) WHERE map.constant_id = ? ");
        pst.setInt(1, constantId);
        rs = pst.executeQuery();
        while (rs.next()) {
            LookupElement thisElement = new LookupElement(rs);
            thisLookupList.add(thisElement);
        }
        rs.close();
        pst.close();
        return thisLookupList;
    }

    public static HashMap getRequiredActionMappings(Connection db, int constantId) throws SQLException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT action_constant_id, map_id FROM step_action_map WHERE constant_id = ? ");
        pst.setInt(1, constantId);
        rs = pst.executeQuery();
        while (rs.next()) {
            map.put(new Integer(rs.getInt("action_constant_id")), new Integer(rs.getInt("map_id")));
        }
        rs.close();
        pst.close();
        return map;
    }

    public static boolean parseRequiredActionMappings(ActionContext context, Connection db, LookupList stepActions, int constantId) throws SQLException {
        HashMap map = ActionStep.getRequiredActionMappings(db, constantId);
        PreparedStatement pst = null;
        for (LookupElement element : stepActions) {
            String currentId = context.getRequest().getParameter("element" + element.getId());
            if (currentId == null || "".equals(currentId)) continue;
            if (map.get(new Integer(currentId)) != null) {
                map.remove(new Integer(currentId));
                continue;
            }
            ActionStepMap actionStepMap = new ActionStepMap();
            actionStepMap.setConstantId(constantId);
            actionStepMap.setActionConstantId(element.getId());
            actionStepMap.insert(db);
        }
        for (Integer actionId : map.keySet()) {
            pst = db.prepareStatement("DELETE FROM step_action_map WHERE map_id = ? ");
            pst.setInt(1, (Integer)map.get(actionId));
            pst.execute();
            pst.close();
        }
        return true;
    }

    public static boolean parseRequiredActionMappings(Connection db, HashMap mappedList, LookupList stepActions, int constantId) throws SQLException {
        HashMap map = ActionStep.getRequiredActionMappings(db, constantId);
        PreparedStatement pst = null;
        for (LookupElement element : stepActions) {
            Integer currentId = (Integer)mappedList.get(new Integer(element.getId()));
            if (currentId == null) continue;
            if (map.get(currentId) != null) {
                map.remove(currentId);
                continue;
            }
            ActionStepMap actionStepMap = new ActionStepMap();
            actionStepMap.setConstantId(constantId);
            actionStepMap.setActionConstantId(element.getId());
            actionStepMap.insert(db);
        }
        for (Integer actionId : map.keySet()) {
            pst = db.prepareStatement("DELETE FROM step_action_map WHERE map_id = ? ");
            pst.setInt(1, (Integer)map.get(actionId));
            pst.execute();
            pst.close();
        }
        return true;
    }

    public static LookupList parseRequiredActionLookupList(Connection db, LookupList list, int constantId) throws SQLException {
        LookupList newList = new LookupList();
        newList.setJsEvent("onChange=\"updateActionId();\"");
        HashMap map = ActionStep.getRequiredActionMappings(db, constantId);
        for (LookupElement element : list) {
            if (map.get(new Integer(element.getCode())) == null) continue;
            newList.addItem(element.getId(), element.getDescription());
        }
        return newList;
    }

    public static LookupList getStepActionsLookup(Connection db) throws SQLException {
        LookupList thisList = new LookupList();
        PreparedStatement pst = db.prepareStatement("SELECT constant_id, description FROM lookup_step_actions ");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            thisList.addItem(rs.getInt("constant_id"), rs.getString("description"));
        }
        rs.close();
        pst.close();
        return thisList;
    }

    public boolean allowsUpdate() {
        return this.allowUpdate;
    }

    public boolean isCurrent(ActionPlan actionPlan) {
        ActionStep currentStep = actionPlan.getCurrentStep();
        if (currentStep != null) {
            return currentStep.getId() == this.getId();
        }
        return false;
    }

    public boolean beforeCurrent(ActionPlan actionPlan) {
        boolean before = false;
        block0: for (ActionPhase thisPhase : actionPlan.getPhases()) {
            ActionStep thisStep;
            Iterator j = thisPhase.getSteps().iterator();
            while (j.hasNext() && !(thisStep = (ActionStep)((Object)j.next())).isCurrent(actionPlan)) {
                if (thisStep.getId() != this.getId()) continue;
                before = true;
                continue block0;
            }
        }
        return before;
    }

    public void checkRemoveStepAttachments(Connection db, ActionStep oldStep) throws SQLException {
        if (this.getActionId() != oldStep.getActionId()) {
            ActionItemWorkList workList = new ActionItemWorkList();
            workList.setActionStepId(this.getId());
            workList.buildList(db);
            workList.resetAttachment(db);
        }
    }

    public boolean getActionRequired() {
        return this.actionRequired;
    }

    public void setActionRequired(boolean tmp) {
        this.actionRequired = tmp;
    }

    public void setActionRequired(String tmp) {
        this.actionRequired = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getDisplayInPlanList() {
        return this.displayInPlanList;
    }

    public void setDisplayInPlanList(boolean tmp) {
        this.displayInPlanList = tmp;
    }

    public void setDisplayInPlanList(String tmp) {
        this.displayInPlanList = DatabaseUtils.parseBoolean(tmp);
    }

    public String getPlanListLabel() {
        return this.planListLabel;
    }

    public void setPlanListLabel(String tmp) {
        this.planListLabel = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public ArrayList getAccountTypes() {
        return this.accountTypes;
    }

    public void setAccountTypes(ArrayList tmp) {
        this.accountTypes = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public int getPhaseId() {
        return this.phaseId;
    }

    public void setPhaseId(int tmp) {
        this.phaseId = tmp;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String tmp) {
        this.label = tmp;
    }

    public void setPhaseId(String tmp) {
        this.phaseId = Integer.parseInt(tmp);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public int getActionId() {
        return this.actionId;
    }

    public void setActionId(int tmp) {
        this.actionId = tmp;
    }

    public void setActionId(String tmp) {
        this.actionId = Integer.parseInt(tmp);
    }

    public int getDurationTypeId() {
        return this.durationTypeId;
    }

    public void setDurationTypeId(int tmp) {
        this.durationTypeId = tmp;
    }

    public void setDurationTypeId(String tmp) {
        this.durationTypeId = Integer.parseInt(tmp);
    }

    public int getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public void setEstimatedDuration(int tmp) {
        this.estimatedDuration = tmp;
    }

    public void setEstimatedDuration(String tmp) {
        this.estimatedDuration = Integer.parseInt(tmp);
    }

    public int getCustomFieldCategoryId() {
        return this.customFieldCategoryId;
    }

    public void setCustomFieldCategoryId(int tmp) {
        this.customFieldCategoryId = tmp;
    }

    public void setCustomFieldCategoryId(String tmp) {
        this.customFieldCategoryId = Integer.parseInt(tmp);
    }

    public int getCustomFieldId() {
        return this.customFieldId;
    }

    public void setCustomFieldId(int tmp) {
        this.customFieldId = tmp;
    }

    public void setCustomFieldId(String tmp) {
        this.customFieldId = Integer.parseInt(tmp);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public String getDurationTypeIdString() {
        return this.durationTypeIdString;
    }

    public void setDurationTypeIdString(String tmp) {
        this.durationTypeIdString = tmp;
    }

    public int getPermissionType() {
        return this.permissionType;
    }

    public void setPermissionType(int tmp) {
        this.permissionType = tmp;
    }

    public void setPermissionType(String tmp) {
        this.permissionType = Integer.parseInt(tmp);
    }

    public int getRoleId() {
        return this.roleId;
    }

    public void setRoleId(int tmp) {
        this.roleId = tmp;
    }

    public void setRoleId(String tmp) {
        this.roleId = Integer.parseInt(tmp);
    }

    public int getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(int tmp) {
        this.departmentId = tmp;
    }

    public void setDepartmentId(String tmp) {
        this.departmentId = Integer.parseInt(tmp);
    }

    public ActionStepList getStepList() {
        return this.stepList;
    }

    public void setStepList(ActionStepList tmp) {
        this.stepList = tmp;
    }

    public boolean getBuildCompleteStepList() {
        return this.buildCompleteStepList;
    }

    public void setBuildCompleteStepList(boolean tmp) {
        this.buildCompleteStepList = tmp;
    }

    public void setBuildCompleteStepList(String tmp) {
        this.buildCompleteStepList = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getAllowSkipToHere() {
        return this.allowSkipToHere;
    }

    public void setAllowSkipToHere(boolean tmp) {
        this.allowSkipToHere = tmp;
    }

    public void setAllowSkipToHere(String tmp) {
        this.allowSkipToHere = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildRelatedRecords() {
        return this.buildRelatedRecords;
    }

    public void setBuildRelatedRecords(boolean tmp) {
        this.buildRelatedRecords = tmp;
    }

    public void setBuildRelatedRecords(String tmp) {
        this.buildRelatedRecords = DatabaseUtils.parseBoolean(tmp);
    }

    public ActionItemWorkList getActionItems() {
        return this.actionItems;
    }

    public void setActionItems(ActionItemWorkList tmp) {
        this.actionItems = tmp;
    }

    public ActionStepLookupList getLookupList() {
        return this.lookupList;
    }

    public void setLookupList(ActionStepLookupList tmp) {
        this.lookupList = tmp;
    }

    public int getUserGroupId() {
        return this.userGroupId;
    }

    public void setUserGroupId(int tmp) {
        this.userGroupId = tmp;
    }

    public void setUserGroupId(String tmp) {
        this.userGroupId = Integer.parseInt(tmp);
    }

    public String getUserGroupName() {
        return this.userGroupName;
    }

    public void setUserGroupName(String tmp) {
        this.userGroupName = tmp;
    }

    public String getTargetRelationship() {
        return this.targetRelationship;
    }

    public void setTargetRelationship(String tmp) {
        this.targetRelationship = tmp;
    }

    public boolean getAllowUpdate() {
        return this.allowUpdate;
    }

    public void setAllowUpdate(boolean tmp) {
        this.allowUpdate = tmp;
    }

    public void setAllowUpdate(String tmp) {
        this.allowUpdate = DatabaseUtils.parseBoolean(tmp);
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(int tmp) {
        this.campaignId = tmp;
    }

    public void setCampaignId(String tmp) {
        this.campaignId = Integer.parseInt(tmp);
    }

    public boolean getAllowDuplicateRecipient() {
        return this.allowDuplicateRecipient;
    }

    public void setAllowDuplicateRecipient(boolean tmp) {
        this.allowDuplicateRecipient = tmp;
    }

    public void setAllowDuplicateRecipient(String tmp) {
        this.allowDuplicateRecipient = DatabaseUtils.parseBoolean(tmp);
    }
}

