/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.actionplans.base.ActionItemWorkList;
import org.aspcfs.modules.actionplans.base.ActionStep;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ActionStepList
extends ArrayList {
    public static final String tableName = "action_step";
    public static final String uniqueField = "step_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int parentId = -1;
    private int phaseId = -1;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private int categoryId = -1;
    private int campaignId = -1;
    private boolean buildCompleteStepList = false;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM action_step astp  LEFT JOIN lookup_duration_type ldt ON (astp.duration_type_id = ldt.code)  LEFT JOIN custom_field_category cfc ON (astp.category_id = cfc.category_id)  LEFT JOIN custom_field_info cfi ON (astp.field_id = cfi.field_id)  LEFT JOIN " + DatabaseUtils.addQuotes(db, "role") + " r ON (astp.role_id = r.role_id) " + " LEFT JOIN lookup_department dpt ON (astp.department_id = dpt.code) " + " WHERE astp.step_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("astp.entered", null);
            boolean flag = true;
            sqlOrder.append("ORDER BY astp.entered" + (this.pagedListInfo.getSortOrder() != null ? " DESC " : " "));
        } else {
            sqlOrder.append("ORDER BY astp.entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" astp.*,  ldt.description AS duration, ug.group_name as groupname  FROM action_step astp  LEFT JOIN lookup_duration_type ldt ON (astp.duration_type_id = ldt.code)  LEFT JOIN custom_field_category cfc ON (astp.category_id = cfc.category_id)  LEFT JOIN custom_field_info cfi ON (astp.field_id = cfi.field_id)  LEFT JOIN " + DatabaseUtils.addQuotes(db, "role") + " r ON (astp.role_id = r.role_id) " + " LEFT JOIN lookup_department dpt ON (astp.department_id = dpt.code) " + " LEFT JOIN user_group ug ON (astp.group_id = ug.group_id) " + " WHERE astp.step_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ActionStep thisPlan = new ActionStep(rs);
            this.add(thisPlan);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.id > -1) {
            sqlFilter.append("AND astp.step_id = ? ");
        }
        if (this.parentId == 0) {
            sqlFilter.append("AND astp.parent_id IS NULL ");
        } else if (this.parentId > -1) {
            sqlFilter.append("AND astp.parent_id = ? ");
        }
        if (this.phaseId > -1) {
            sqlFilter.append("AND astp.phase_id = ? ");
        }
        if (this.categoryId > -1) {
            sqlFilter.append("AND cfc.category_id = ? ");
        }
        if (this.campaignId > -1) {
            sqlFilter.append("AND astp.campaign_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.parentId > 0) {
            DatabaseUtils.setInt(pst, ++i, this.parentId);
        }
        if (this.phaseId > -1) {
            pst.setInt(++i, this.phaseId);
        }
        if (this.categoryId > -1) {
            pst.setInt(++i, this.categoryId);
        }
        if (this.campaignId > -1) {
            pst.setInt(++i, this.campaignId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean result = false;
        for (ActionStep step : this) {
            result = step.delete(db) && result;
        }
        return result;
    }

    public int getLastStepId() {
        int result = -1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ActionStep step = (ActionStep)((Object)iterator.next());
            if (iterator.hasNext()) continue;
            result = step.getId();
        }
        return result;
    }

    public boolean hasUserGroupStep() {
        for (ActionStep step : this) {
            if (step.getPermissionType() != 7) continue;
            return true;
        }
        return false;
    }

    public void resetFolderInformation(Connection db) throws SQLException {
        for (ActionStep step : this) {
            step.queryRecord(db, step.getId());
            ActionItemWorkList workList = new ActionItemWorkList();
            workList.setActionStepId(step.getId());
            workList.buildList(db);
            workList.resetAttachment(db);
            step.setCustomFieldCategoryId(-1);
            step.update(db);
        }
    }

    public void resetCampaignInformation(Connection db) throws SQLException {
        for (ActionStep step : this) {
            step.queryRecord(db, step.getId());
            ActionItemWorkList workList = new ActionItemWorkList();
            workList.setActionStepId(step.getId());
            workList.buildList(db);
            workList.resetAttachment(db);
            step.setCampaignId(-1);
            step.setActionId(-1);
            step.setAllowDuplicateRecipient(false);
            step.update(db);
        }
    }

    public ActionStepList reorder() {
        HashMap positionMap = this.getStepIdsAsHashMap();
        HashMap steps = this.getStepsByParentAsHashMap();
        ActionStepList reorderedList = new ActionStepList();
        reorderedList.setPhaseId(this.getPhaseId());
        String tempStepId = "0";
        for (int i = 0; i < this.size(); ++i) {
            ActionStep thisStep = (ActionStep)((Object)steps.get(tempStepId));
            if (thisStep == null) continue;
            tempStepId = (String)positionMap.get(tempStepId);
            reorderedList.add(thisStep);
        }
        return reorderedList;
    }

    public String printArray(ArrayList list) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            str.append("\nActionStepList:: list[" + i + "] = " + list.get(i));
        }
        return str.toString();
    }

    public HashMap getStepIdsAsHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ActionStep step : this) {
            map.put(String.valueOf(step.getParentId()), String.valueOf(step.getId()));
        }
        return map;
    }

    public HashMap getStepsByParentAsHashMap() {
        HashMap<String, ActionStep> map = new HashMap<String, ActionStep>();
        for (ActionStep step : this) {
            map.put(String.valueOf(step.getParentId()), step);
        }
        return map;
    }

    public HashMap getStepsAsHashMap() {
        HashMap<String, ActionStep> map = new HashMap<String, ActionStep>();
        for (ActionStep step : this) {
            map.put(String.valueOf(step.getId()), step);
        }
        return map;
    }

    public HashMap getStepParentsAsHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iter = this.iterator();
        int i = 1;
        while (iter.hasNext()) {
            ActionStep step = (ActionStep)((Object)iter.next());
            map.put(String.valueOf(step.getId()), String.valueOf(i));
            ++i;
        }
        return map;
    }

    public ActionStep getStepById(int id) {
        ActionStep result = null;
        for (ActionStep step : this) {
            if (step.getId() != id) continue;
            result = step;
            break;
        }
        return result;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public int getPhaseId() {
        return this.phaseId;
    }

    public void setPhaseId(int tmp) {
        this.phaseId = tmp;
    }

    public void setPhaseId(String tmp) {
        this.phaseId = Integer.parseInt(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public boolean getBuildCompleteStepList() {
        return this.buildCompleteStepList;
    }

    public void setBuildCompleteStepList(boolean tmp) {
        this.buildCompleteStepList = tmp;
    }

    public void setBuildCompleteStepList(String tmp) {
        this.buildCompleteStepList = DatabaseUtils.parseBoolean(tmp);
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(int tmp) {
        this.campaignId = tmp;
    }

    public void setCampaignId(String tmp) {
        this.campaignId = Integer.parseInt(tmp);
    }
}

