/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class ActionStepLookup
extends GenericBean {
    private int id = -1;
    private int stepId = -1;
    private String description = null;
    private boolean defaultItem = false;
    private int level = 0;
    private boolean enabled = true;

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getStepId() {
        return this.stepId;
    }

    public void setStepId(int tmp) {
        this.stepId = tmp;
    }

    public void setStepId(String tmp) {
        this.stepId = Integer.parseInt(tmp);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public boolean getDefaultItem() {
        return this.defaultItem;
    }

    public void setDefaultItem(boolean tmp) {
        this.defaultItem = tmp;
    }

    public void setDefaultItem(String tmp) {
        this.defaultItem = DatabaseUtils.parseBoolean(tmp);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public ActionStepLookup() {
    }

    public ActionStepLookup(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ActionStepLookup(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Step Lookup ID specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT asl.* FROM action_step_lookup asl WHERE asl.code = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("code");
        this.stepId = rs.getInt("step_id");
        this.description = rs.getString("description");
        this.defaultItem = rs.getBoolean("default_item");
        this.level = rs.getInt("level");
        this.enabled = rs.getBoolean("enabled");
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "action_step_lookup_code_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO action_step_lookup (" + (this.id > -1 ? "code, " : "") + "step_id, description, default_item, " + DatabaseUtils.addQuotes(db, "level") + ", enabled) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.stepId);
        pst.setString(++i, this.description);
        pst.setBoolean(++i, this.defaultItem);
        pst.setInt(++i, this.level);
        pst.setBoolean(++i, this.enabled);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "action_step_lookup_code_seq", this.id);
        return true;
    }
}

