/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class ActionStepMap {
    private int mapId = -1;
    private int constantId = -1;
    private int actionConstantId = -1;

    public int getMapId() {
        return this.mapId;
    }

    public void setMapId(int mapId) {
        this.mapId = mapId;
    }

    public int getConstantId() {
        return this.constantId;
    }

    public void setConstantId(int constantId) {
        this.constantId = constantId;
    }

    public int getActionConstantId() {
        return this.actionConstantId;
    }

    public void setActionConstantId(int actionConstantId) {
        this.actionConstantId = actionConstantId;
    }

    public void insert(Connection db) throws SQLException {
        this.mapId = DatabaseUtils.getNextSeq(db, "step_action_map_map_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO step_action_map (" + (this.mapId > -1 ? "map_id, " : "") + "constant_id, action_constant_id) " + "VALUES (" + (this.mapId > -1 ? "?, " : "") + "?, ?) ");
        int i = 0;
        if (this.mapId > -1) {
            pst.setInt(++i, this.mapId);
        }
        pst.setInt(++i, this.constantId);
        pst.setInt(++i, this.actionConstantId);
        pst.execute();
        pst.close();
        this.mapId = DatabaseUtils.getCurrVal(db, "step_action_map_map_id_seq", this.mapId);
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM step_action_map WHERE constant_id = ? AND action_constant_id = ? ");
        pst.setInt(1, this.constantId);
        pst.setInt(2, this.actionConstantId);
        pst.execute();
        pst.close();
    }

    public static int retrieveActionPlanMapIdFromConstantId(Connection db, int constantId) throws SQLException {
        int mapId = -1;
        PreparedStatement pst = db.prepareStatement("SELECT map_id FROM action_plan_constants WHERE constant_id = ? ");
        pst.setInt(1, constantId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            mapId = rs.getInt("map_id");
        }
        rs.close();
        pst.close();
        return mapId;
    }
}

