/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.utils.DatabaseUtils;

public class PlanEditor
extends GenericBean {
    protected int id = -1;
    private int moduleId = -1;
    private int categoryId = -1;
    private int constantId = -1;
    private int level = -1;
    private String description = null;
    private Timestamp entered = null;
    private SystemStatus systemStatus = null;

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public PlanEditor() {
    }

    public PlanEditor(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public PlanEditor(Connection db, int constantId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT apel.* FROM action_plan_editor_lookup apel LEFT JOIN action_plan_constants apc ON (apel.constant_id = apc.map_id) WHERE apc.constant_id = ? ");
        pst.setInt(1, constantId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.moduleId = rs.getInt("module_id");
        this.constantId = rs.getInt("constant_id");
        this.level = rs.getInt("level");
        this.description = rs.getString("description");
        this.entered = rs.getTimestamp("entered");
        this.categoryId = rs.getInt("category_id");
    }

    public void insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "action_plan_editor_loo_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO action_plan_editor_lookup (" + (this.id > -1 ? "id, " : "") + "module_id, constant_id, " + DatabaseUtils.addQuotes(db, "level") + ", description, category_id) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.moduleId);
        pst.setInt(++i, this.constantId);
        pst.setInt(++i, this.level);
        pst.setString(++i, this.description);
        pst.setInt(++i, this.categoryId);
        pst.executeUpdate();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "action_plan_editor_loo_id_seq", this.id);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(int tmp) {
        this.moduleId = tmp;
    }

    public void setModuleId(String tmp) {
        this.moduleId = Integer.parseInt(tmp);
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public int getConstantId() {
        return this.constantId;
    }

    public void setConstantId(int tmp) {
        this.constantId = tmp;
    }

    public void setConstantId(String tmp) {
        this.constantId = Integer.parseInt(tmp);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public void setSystemStatus(SystemStatus tmp) {
        this.systemStatus = tmp;
    }
}

