/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.components;

import java.sql.Connection;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actionplans.base.ActionItemWork;
import org.aspcfs.modules.actionplans.base.ActionPhaseWork;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.troubletickets.base.Ticket;

public class LoadStepDetails
extends ObjectHookComponent
implements ComponentInterface {
    public static final String ORGANIZATION = "stepOrganization";
    public static final String CONTACT = "stepContact";
    public static final String TICKET = "stepTicket";
    public static final String ENTERED_BY_CONTACT = "stepEnteredByContact";
    public static final String MODIFIED_BY_CONTACT = "stepModifiedByContact";
    public static final String ASSIGNED_TO_CONTACT = "stepAssignedToContact";
    public static final String GROUP_USERS = "stepGroupUsers";
    public static final String STEP_DESCRIPTION = "stepDescription";
    public static final String STEP = "step";
    public static final String URL = "actionPlanURL";
    public static final String linkedOBJECT = "linkedObject";
    public static final String linkedTICKETObjectNAME = "linkedTicketObjectName";
    public static final String linkedACCOUNTObjectNAME = "linkedAccountObjectName";

    public String getDescription() {
        return "Load all Action Step information for use in other steps";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        boolean result = false;
        ActionItemWork thisWork = (ActionItemWork)((Object)context.getThisObject());
        ActionItemWork previousWork = (ActionItemWork)((Object)context.getPreviousObject());
        ActionPhaseWork phaseWork = new ActionPhaseWork();
        ActionPlanWork planWork = new ActionPlanWork();
        ActionPlan plan = new ActionPlan();
        Connection db = null;
        try {
            Contact contact;
            User user;
            ActionPlan linkedObject;
            ActionPlan url;
            db = LoadStepDetails.getConnection(context);
            phaseWork.setBuildPhase(true);
            phaseWork.queryRecord(db, thisWork.getPhaseWorkId());
            planWork.setBuildPhaseWork(true);
            planWork.setBuildLinkedObject(true);
            planWork.queryRecord(db, phaseWork.getPlanWorkId());
            plan.queryRecord(db, planWork.getActionPlanId());
            thisWork.setPlanWork(planWork);
            context.setThisObject((Object)thisWork);
            if (planWork.getLinkModuleId() == ActionPlan.getMapIdGivenConstantId(db, 42420034)) {
                url = new ActionPlan();
                url.setName("AccountActionPlans.do?command=Details&orgId=" + planWork.getOrganization().getOrgId() + "&actionPlanId=" + planWork.getId());
                url.setDescription((String)context.getAttribute("SERVERURL"));
                linkedObject = new ActionPlan();
                linkedObject.setName(context.getParameter(linkedACCOUNTObjectNAME));
                linkedObject.setDescription(planWork.getOrganization().getName());
                context.setAttribute(linkedOBJECT, (Object)linkedObject);
                context.setAttribute(URL, (Object)url);
            } else if (planWork.getLinkModuleId() == ActionPlan.getMapIdGivenConstantId(db, 912051329)) {
                url = new ActionPlan();
                url.setDescription((String)context.getAttribute("SERVERURL"));
                url.setName("TroubleTicketActionPlans.do?command=Details&ticketId=" + planWork.getTicket().getId() + "&actionPlanId=" + planWork.getId());
                linkedObject = new ActionPlan();
                linkedObject.setName(context.getParameter(linkedTICKETObjectNAME));
                linkedObject.setDescription(planWork.getTicket().getPaddedId());
                context.setAttribute(linkedOBJECT, (Object)linkedObject);
                context.setAttribute(URL, (Object)url);
            }
            if (planWork.getOrganization() != null) {
                context.setAttribute(ORGANIZATION, (Object)planWork.getOrganization());
            } else {
                context.setAttribute(ORGANIZATION, (Object)new Organization());
            }
            if (planWork.getTicket() != null) {
                context.setAttribute(TICKET, (Object)planWork.getTicket());
            } else {
                context.setAttribute(TICKET, (Object)new Ticket());
            }
            if (planWork.getContact() != null) {
                context.setAttribute(CONTACT, (Object)planWork.getContact());
            } else {
                context.setAttribute(CONTACT, (Object)new Contact());
            }
            if (thisWork.getOwnerId() > 0) {
                user = new User();
                user.setBuildContact(true);
                user.buildRecord(db, thisWork.getOwnerId());
                context.setAttribute(ASSIGNED_TO_CONTACT, (Object)user.getContact());
            }
            if (thisWork.getModifiedBy() > 0) {
                user = new User(db, thisWork.getModifiedBy());
                contact = new Contact(db, user.getContactId());
                context.setAttribute(MODIFIED_BY_CONTACT, (Object)contact);
            }
            if (thisWork.getEnteredBy() > 0) {
                user = null;
                user = previousWork != null ? new User(db, previousWork.getEnteredBy()) : new User(db, thisWork.getEnteredBy());
                contact = new Contact(db, user.getContactId());
                context.setAttribute(ENTERED_BY_CONTACT, (Object)contact);
            }
            thisWork.buildStep(db);
            context.setAttribute(STEP_DESCRIPTION, thisWork.getStep().getDescription());
            context.setAttribute(STEP, (Object)thisWork.getStep());
            result = true;
        }
        catch (Exception e) {
        }
        finally {
            LoadStepDetails.freeConnection(context, db);
        }
        return result;
    }
}

