/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.FilterList;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class AccountSelector
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListAccounts(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        boolean listDone = false;
        String listType = context.getRequest().getParameter("listType");
        SystemStatus thisSystem = this.getSystemStatus(context);
        OrganizationList acctList = null;
        OrganizationList finalAccounts = null;
        ArrayList<String> selectedList = (ArrayList<String>)context.getSession().getAttribute("SelectedAccounts");
        if (selectedList == null || "true".equals(context.getRequest().getParameter("reset"))) {
            selectedList = new ArrayList<String>();
        }
        if (context.getRequest().getParameter("previousSelection") != null) {
            StringTokenizer st = new StringTokenizer(context.getRequest().getParameter("previousSelection"), "|");
            while (st.hasMoreTokens()) {
                selectedList.add(String.valueOf(st.nextToken()));
            }
        }
        try {
            String tmpOrgId;
            int acctId;
            db = this.getConnection(context);
            int rowCount = 1;
            acctList = new OrganizationList();
            if ("list".equals(listType)) {
                while (context.getRequest().getParameter("hiddenAccountId" + rowCount) != null) {
                    acctId = Integer.parseInt(context.getRequest().getParameter("hiddenAccountId" + rowCount));
                    if (context.getRequest().getParameter("account" + rowCount) != null) {
                        if (!selectedList.contains(String.valueOf(acctId))) {
                            selectedList.add(String.valueOf(acctId));
                        }
                    } else {
                        selectedList.remove(String.valueOf(acctId));
                    }
                    ++rowCount;
                }
            }
            if ("true".equals(context.getRequest().getParameter("finalsubmit"))) {
                if ("single".equals(listType)) {
                    rowCount = Integer.parseInt(context.getRequest().getParameter("rowcount"));
                    acctId = Integer.parseInt(context.getRequest().getParameter("hiddenAccountId" + rowCount));
                    selectedList.clear();
                    selectedList.add(String.valueOf(acctId));
                }
                listDone = true;
                if (finalAccounts == null) {
                    finalAccounts = new OrganizationList();
                }
                for (int i = 0; i < selectedList.size(); ++i) {
                    int orgId = Integer.parseInt((String)selectedList.get(i));
                    finalAccounts.add(new Organization(db, orgId));
                }
            }
            LookupList typeSelect = new LookupList(db, "lookup_account_types");
            typeSelect.addItem(0, thisSystem.getLabel("accounts.allTypes"));
            context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
            LookupList siteIdList = new LookupList(db, "lookup_site_id");
            siteIdList.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("siteIdList", (Object)siteIdList);
            this.setParameters(acctList, context);
            UserBean thisUserBean = (UserBean)((Object)context.getSession().getAttribute("User"));
            User thisUser = thisUserBean.getUserRecord();
            acctList.setOrgSiteId(thisUser.getSiteId());
            String siteId = context.getRequest().getParameter("siteId");
            if (!(siteId != null && !"".equals(siteId) || (tmpOrgId = context.getRequest().getParameter("siteIdOrg")) == null || "".equals(tmpOrgId) || "-1".equals(tmpOrgId))) {
                Organization org = new Organization(db, Integer.parseInt(tmpOrgId));
                siteId = String.valueOf(org.getSiteId());
            }
            String thisSiteIdOnly = context.getRequest().getParameter("thisSiteIdOnly");
            if (siteId != null && !"".equals(siteId.trim())) {
                int siteIdToFetch = Integer.parseInt(siteId);
                acctList.setOrgSiteId(siteIdToFetch);
                if (siteIdToFetch == -1 && "true".equals(thisSiteIdOnly)) {
                    acctList.setIncludeOrganizationWithoutSite(true);
                }
            }
            acctList.buildList(db);
            context.getRequest().setAttribute("siteId", (Object)siteId);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("AccountList", (Object)acctList);
            context.getSession().setAttribute("SelectedAccounts", selectedList);
            if (listDone) {
                context.getRequest().setAttribute("FinalAccounts", finalAccounts);
            }
            return "ListAccountsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    private void setParameters(OrganizationList acctList, ActionContext context) {
        PagedListInfo acctListInfo;
        SystemStatus thisSystem = this.getSystemStatus(context);
        String acctNameLabel = thisSystem.getLabel("organization.name");
        String acctNumberLabel = thisSystem.getLabel("organization.accountNumber");
        String acctName = context.getRequest().getParameter("acctName");
        String acctNumber = context.getRequest().getParameter("acctNumber");
        if (acctName != null && !acctNameLabel.equals(acctName) && !"".equals(acctName.trim())) {
            acctList.setName("%" + acctName + "%");
        }
        if (acctNumber != null && !acctNumberLabel.equals(acctNumber) && !"".equals(acctNumber.trim())) {
            acctList.setAccountNumber("%" + acctNumber + "%");
        }
        boolean showMyCompany = "true".equals(context.getRequest().getParameter("showMyCompany"));
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("AccountListInfo");
        }
        if (!(acctListInfo = this.getPagedListInfo(context, "AccountListInfo")).hasListFilters()) {
            acctListInfo.addFilter(1, "0");
        }
        FilterList filters = new FilterList();
        filters.setSource(1);
        filters.build(thisSystem, context.getRequest());
        context.getRequest().setAttribute("Filters", (Object)filters);
        String filterString = context.getRequest().getParameter("filters");
        if (filterString != null && !"".equals(filterString)) {
            context.getRequest().setAttribute("filterString", (Object)filterString);
        }
        String firstFilter = filters.getFirstFilter(acctListInfo.getListView());
        acctList.setPagedListInfo(acctListInfo);
        acctList.setMinerOnly(false);
        acctList.setTypeId(acctListInfo.getFilterKey("listFilter1"));
        acctList.setShowMyCompany(showMyCompany);
        if ("my".equals(firstFilter)) {
            acctList.setOwnerId(this.getUserId(context));
        } else if ("disabled".equals(firstFilter)) {
            acctList.setIncludeEnabled(0);
        }
    }
}

