/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.assets.base.Asset;
import org.aspcfs.modules.assets.base.AssetList;
import org.aspcfs.modules.base.CategoryList;
import org.aspcfs.modules.base.FilterList;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class AssetSelector
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListAssets(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        boolean listDone = false;
        String listType = context.getRequest().getParameter("listType");
        AssetList assetList = null;
        AssetList finalAssets = null;
        ArrayList<String> selectedList = (ArrayList<String>)context.getSession().getAttribute("SelectedAssets");
        int tmpContractId = -1;
        SystemStatus systemStatus = this.getSystemStatus(context);
        if (selectedList == null || "true".equals(context.getRequest().getParameter("reset"))) {
            selectedList = new ArrayList<String>();
        }
        if (context.getRequest().getParameter("previousSelection") != null) {
            StringTokenizer st = new StringTokenizer(context.getRequest().getParameter("previousSelection"), "|");
            while (st.hasMoreTokens()) {
                selectedList.add(String.valueOf(st.nextToken()));
            }
        }
        try {
            int assetId;
            db = this.getConnection(context);
            int rowCount = 1;
            assetList = new AssetList();
            if ("list".equals(listType)) {
                while (context.getRequest().getParameter("hiddenAssetId" + rowCount) != null) {
                    assetId = Integer.parseInt(context.getRequest().getParameter("hiddenAssetId" + rowCount));
                    if (context.getRequest().getParameter("asset" + rowCount) != null) {
                        if (!selectedList.contains(String.valueOf(assetId))) {
                            selectedList.add(String.valueOf(assetId));
                        }
                    } else {
                        selectedList.remove(String.valueOf(assetId));
                    }
                    ++rowCount;
                }
            }
            if ("true".equals(context.getRequest().getParameter("finalsubmit"))) {
                if ("single".equals(listType)) {
                    rowCount = Integer.parseInt(context.getRequest().getParameter("rowcount"));
                    assetId = Integer.parseInt(context.getRequest().getParameter("hiddenAssetId" + rowCount));
                    selectedList.clear();
                    selectedList.add(String.valueOf(assetId));
                }
                listDone = true;
                if (finalAssets == null) {
                    finalAssets = new AssetList();
                }
                for (int i = 0; i < selectedList.size(); ++i) {
                    String assetId2 = (String)selectedList.get(i);
                    Asset thisAsset = new Asset(db, assetId2);
                    finalAssets.add(thisAsset);
                }
            }
            LookupList assetStatusList = new LookupList(db, "lookup_asset_status");
            assetStatusList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("assetStatusList", (Object)assetStatusList);
            LookupList assetManufacturerList = new LookupList(db, "lookup_asset_manufacturer");
            assetManufacturerList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("assetManufacturerList", (Object)assetManufacturerList);
            String orgIdString = context.getRequest().getParameter("orgId");
            Organization organization = new Organization(db, Integer.parseInt(orgIdString));
            this.buildCategories(context, db, null, organization.getSiteId());
            try {
                tmpContractId = Integer.parseInt(context.getRequest().getParameter("contractId"));
            }
            catch (Exception e) {
                tmpContractId = -1;
            }
            assetList.setServiceContractId(tmpContractId);
            this.setParameters(assetList, context);
            assetList.setOrgId(orgIdString);
            assetList.buildList(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("assetList", (Object)assetList);
            context.getSession().setAttribute("selectedAssets", selectedList);
            if (listDone) {
                context.getRequest().setAttribute("finalAssets", finalAssets);
            }
            return "ListAssetsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    private void setParameters(AssetList assetList, ActionContext context) {
        PagedListInfo assetListInfo;
        SystemStatus thisSystem = this.getSystemStatus(context);
        String serialNumberLabel = thisSystem.getLabel("accounts.accountasset_include.SerialNumber");
        String contractNumberLabel = thisSystem.getLabel("accounts.accountasset_include.ServiceContractNumber");
        String serialNumber = context.getRequest().getParameter("serialNumber");
        String contractNumber = context.getRequest().getParameter("contractNumber");
        if (serialNumber != null && !serialNumberLabel.equals(serialNumber) && !"".equals(serialNumber.trim())) {
            assetList.setSerialNumber("%" + serialNumber + "%");
        }
        if (contractNumber != null && !contractNumberLabel.equals(contractNumber) && !"".equals(contractNumber.trim())) {
            assetList.setServiceContractNumber("%" + contractNumber + "%");
            assetList.setServiceContractId(-1);
        }
        if (!(assetListInfo = this.getPagedListInfo(context, "AssetListInfo")).hasListFilters()) {
            assetListInfo.addFilter(1, "0");
        }
        FilterList filters = new FilterList();
        filters.setSource(209041110);
        filters.build(thisSystem, context.getRequest());
        context.getRequest().setAttribute("Filters", (Object)filters);
        String firstFilter = filters.getFirstFilter(assetListInfo.getListView());
        if ("allassets".equals(firstFilter)) {
            assetList.setAllAssets(true);
        } else {
            assetList.setAllAssets(false);
        }
        String orgId = context.getRequest().getParameter("orgId");
        assetListInfo.setLink("AssetSelector.do?command=ListAssets&orgId=" + orgId);
        assetList.setPagedListInfo(assetListInfo);
        assetList.setOrgId(Integer.parseInt(orgId));
        context.getRequest().setAttribute("orgId", (Object)orgId);
    }

    public void buildCategories(ActionContext context, Connection db, Asset thisAsset, int siteId) throws SQLException {
        SystemStatus thisSystem = this.getSystemStatus(context);
        CategoryList categoryList1 = new CategoryList("asset_category");
        categoryList1.setCatLevel(0);
        categoryList1.setParentCode(0);
        categoryList1.setSiteId(siteId);
        categoryList1.buildList(db);
        categoryList1.setHtmlJsEvent("onChange=\"javascript:updateCategoryList('1');\"");
        categoryList1.getCatListSelect().addItem(-1, thisSystem.getLabel("accounts.assets.category.undetermined"));
        context.getRequest().setAttribute("categoryList1", (Object)categoryList1);
        CategoryList categoryList2 = new CategoryList("asset_category");
        categoryList2.setCatLevel(1);
        categoryList2.setSiteId(siteId);
        if (thisAsset == null) {
            categoryList2.buildList(db);
        } else if (thisAsset.getLevel1() > -1) {
            categoryList2.setParentCode(thisAsset.getLevel1());
            categoryList2.buildList(db);
        }
        categoryList2.setHtmlJsEvent("onChange=\"javascript:updateCategoryList('2');\"");
        categoryList2.getCatListSelect().addItem(-1, thisSystem.getLabel("accounts.assets.category.undetermined"));
        context.getRequest().setAttribute("categoryList2", (Object)categoryList2);
        CategoryList categoryList3 = new CategoryList("asset_category");
        categoryList3.setCatLevel(2);
        categoryList3.setSiteId(siteId);
        if (thisAsset == null) {
            categoryList3.buildList(db);
        } else if (thisAsset.getLevel2() > -1) {
            categoryList3.setParentCode(thisAsset.getLevel2());
            categoryList3.buildList(db);
        }
        categoryList3.getCatListSelect().addItem(-1, thisSystem.getLabel("accounts.assets.category.undetermined"));
        context.getRequest().setAttribute("categoryList3", (Object)categoryList3);
    }
}

