/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actions;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.IndexEvent;
import com.zeroio.iteam.base.Project;
import com.zeroio.iteam.base.TeamMember;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.ObjectValidator;
import org.aspcfs.controller.RecentItem;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.controller.UserSession;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.admin.base.AccessType;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.beans.ModuleBean;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.modules.communications.base.CampaignUserGroupMapList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.documents.base.DocumentStore;
import org.aspcfs.modules.documents.base.DocumentStoreTeamMember;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.modules.website.base.Icelet;
import org.aspcfs.modules.website.base.IceletPropertyMap;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.UserUtils;
import org.aspcfs.utils.web.CustomForm;
import org.aspcfs.utils.web.CustomFormList;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.ViewpointInfo;
import org.quartz.Scheduler;

public class CFSModule {
    public static final String fs = System.getProperty("file.separator");
    public static final String NOT_UPDATED_MESSAGE = "<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.";

    public String executeCommandDefault(ActionContext context) {
        return "DefaultOK";
    }

    protected PagedListInfo getPagedListInfo(ActionContext context, String viewName) {
        return this.getPagedListInfo(context, viewName, true);
    }

    protected PagedListInfo getPagedListInfo(ActionContext context, String viewName, boolean setParams) {
        PagedListInfo tmpInfo = (PagedListInfo)context.getSession().getAttribute(viewName);
        if (tmpInfo == null || tmpInfo.getId() == null) {
            tmpInfo = new PagedListInfo();
            tmpInfo.setId(viewName);
            context.getSession().setAttribute(viewName, (Object)tmpInfo);
        }
        if (setParams) {
            tmpInfo.setParameters(context);
        }
        return tmpInfo;
    }

    protected PagedListInfo getPagedListInfo(ActionContext context, String viewName, int defaultItemsPerPage) {
        PagedListInfo tmpInfo = (PagedListInfo)context.getSession().getAttribute(viewName);
        if (tmpInfo == null) {
            tmpInfo = new PagedListInfo();
            tmpInfo.setId(viewName);
            tmpInfo.setItemsPerPage(defaultItemsPerPage);
            context.getSession().setAttribute(viewName, (Object)tmpInfo);
        }
        ActionContext actionContext = new ActionContext(context.getServlet(), null, null, context.getRequest(), context.getResponse());
        tmpInfo.setParameters(actionContext);
        return tmpInfo;
    }

    protected ViewpointInfo getViewpointInfo(ActionContext context, String viewName) {
        SystemStatus systemStatus = this.getSystemStatus(context);
        UserSession thisSession = systemStatus.getSessionManager().getUserSession(this.getActualUserId(context));
        ViewpointInfo tmpInfo = (ViewpointInfo)context.getSession().getAttribute(viewName);
        if (!thisSession.isViewpointsValid()) {
            tmpInfo = null;
        }
        if (tmpInfo == null) {
            tmpInfo = new ViewpointInfo();
            tmpInfo.setId(viewName);
            context.getSession().setAttribute(viewName, (Object)tmpInfo);
        }
        tmpInfo.setParameters(context);
        return tmpInfo;
    }

    protected PagedListInfo getPagedListInfo(ActionContext context, String viewName, String defaultColumn, String defaultOrder) {
        PagedListInfo tmpInfo = (PagedListInfo)context.getSession().getAttribute(viewName);
        if (tmpInfo == null) {
            tmpInfo = new PagedListInfo();
            tmpInfo.setId(viewName);
            tmpInfo.setColumnToSortBy(defaultColumn);
            tmpInfo.setSortOrder(defaultOrder);
            context.getSession().setAttribute(viewName, (Object)tmpInfo);
        }
        tmpInfo.setParameters(context);
        return tmpInfo;
    }

    protected Connection getConnection(ActionContext context) throws SQLException {
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        return this.getConnection(context, ce);
    }

    protected Connection getConnection(ActionContext context, ConnectionElement ce) throws SQLException {
        ConnectionPool sqlDriver = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool");
        return sqlDriver.getConnection(ce);
    }

    public int getUserId(ActionContext context) {
        return UserUtils.getUserId(context.getRequest());
    }

    protected int getActualUserId(ActionContext context) {
        return ((UserBean)((Object)context.getSession().getAttribute("User"))).getActualUserId();
    }

    protected String getUserRange(ActionContext context) {
        return UserUtils.getUserIdRange(context.getRequest());
    }

    public int getUserSiteId(ActionContext context) {
        return UserUtils.getUserSiteId(context.getRequest());
    }

    protected String getSiteUserRange(ActionContext context, int siteId) {
        return this.getSystemStatus(context).getSiteIdRange(siteId);
    }

    protected String getUserRange(ActionContext context, int userId) {
        User userRecord = this.getUser(context, userId);
        UserList shortChildList = userRecord.getShortChildList();
        UserList fullChildList = userRecord.getFullChildList(shortChildList, new UserList());
        return fullChildList.getUserListIds(userRecord.getId());
    }

    protected String getNameLast(ActionContext context) {
        return ((UserBean)((Object)context.getSession().getAttribute("User"))).getUserRecord().getContact().getNameLast();
    }

    protected String getNameFirst(ActionContext context) {
        return ((UserBean)((Object)context.getSession().getAttribute("User"))).getUserRecord().getContact().getNameFirst();
    }

    protected SystemStatus getSystemStatus(ActionContext context) {
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        return this.getSystemStatus(context, ce);
    }

    protected SystemStatus getSystemStatus(ActionContext context, ConnectionElement ce) {
        if (ce != null) {
            return (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CFSModule-> ** System status is null **");
        }
        return null;
    }

    public User getUser(ActionContext context, int userId) {
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
        return systemStatus.getUser(userId);
    }

    protected Hashtable getUserTable(ActionContext context) {
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
        return systemStatus.getUserList();
    }

    protected boolean hasPermission(ActionContext context, String permission) {
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        SystemStatus systemStatus = this.getSystemStatus(context);
        return systemStatus.hasPermission(thisUser.getUserId(), permission);
    }

    public static String includeFile(String sourceFile) {
        StringBuffer HTMLBuffer = new StringBuffer();
        try {
            int c;
            File inputFile = new File(sourceFile);
            FileReader in = new FileReader(inputFile);
            while ((c = in.read()) != -1) {
                HTMLBuffer.append((char)c);
            }
            in.close();
        }
        catch (IOException ex) {
            HTMLBuffer.append(ex.toString());
        }
        return HTMLBuffer.toString();
    }

    public static String getDbName(ActionContext context) {
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        if (ce != null) {
            return ce.getDbName();
        }
        return null;
    }

    public static String getDbName(ConnectionElement ce) {
        if (ce != null) {
            return ce.getDbName();
        }
        return null;
    }

    protected String getPath(ActionContext context) {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        return prefs.get("FILELIBRARY");
    }

    protected String getPath(ActionContext context, String moduleFolderName) {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        return prefs.get("FILELIBRARY") + (CFSModule.getDbName(context) == null ? "" : CFSModule.getDbName(context) + fs) + (moduleFolderName == null ? "" : moduleFolderName + fs);
    }

    protected String getPath(ActionContext context, ConnectionElement ce, String moduleFolderName) {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        return prefs.get("FILELIBRARY") + (CFSModule.getDbName(ce) == null ? "" : CFSModule.getDbName(ce) + fs) + moduleFolderName + fs;
    }

    public static String getDbNamePath(ActionContext context) {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        return prefs.get("FILELIBRARY") + CFSModule.getDbName(context) + fs;
    }

    public static String getDatePath(Date fileDate) {
        return DateUtils.getDatePath(fileDate);
    }

    public static String getDatePath(Timestamp fileDate) {
        return DateUtils.getDatePath(fileDate);
    }

    public static String getDatePath(String filenameDate) {
        if (filenameDate.length() > 7) {
            return filenameDate.substring(0, 4) + fs + filenameDate.substring(4, 8) + fs;
        }
        return null;
    }

    public TimeZone getUserTimeZone(ActionContext context) {
        TimeZone timeZone = Calendar.getInstance().getTimeZone();
        User thisUser = this.getUser(context, this.getUserId(context));
        String tZone = thisUser.getTimeZone();
        if (tZone != null && !"".equals(tZone)) {
            timeZone = TimeZone.getTimeZone(tZone);
        }
        return timeZone;
    }

    protected String getWebInfPath(ActionContext context, String moduleFolderName) {
        return context.getServletContext().getRealPath("/") + "WEB-INF" + fs + moduleFolderName + fs;
    }

    protected void deletePagedListInfo(ActionContext context, String viewName) {
        PagedListInfo tmpInfo = (PagedListInfo)context.getSession().getAttribute(viewName);
        if (tmpInfo != null) {
            context.getSession().removeAttribute(viewName);
        }
    }

    protected void freeConnection(ActionContext context, Connection db) {
        if (db != null) {
            ConnectionPool sqlDriver = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool");
            sqlDriver.free(db);
        }
        db = null;
    }

    protected void renewConnection(ActionContext context, Connection db) {
        if (db != null) {
            ConnectionPool sqlDriver = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool");
            sqlDriver.renew(db);
        }
    }

    protected void addModuleBean(ActionContext context, String submenuKey, String actionName) {
        ModuleBean thisModule = new ModuleBean();
        thisModule.setCurrentAction(actionName);
        thisModule.setSubmenuKey(context, submenuKey);
        context.getRequest().setAttribute("ModuleBean", (Object)thisModule);
    }

    protected void processErrors(ActionContext context, HashMap errors) {
        for (String errorKey : errors.keySet()) {
            String errorMsg = (String)errors.get(errorKey);
            context.getRequest().setAttribute(errorKey, (Object)errorMsg);
            if (System.getProperty("DEBUG") == null) continue;
            System.out.println(" Object Validation Error-> " + errorKey + "=" + errorMsg);
        }
        context.getRequest().setAttribute("errors", (Object)errors);
        if (errors.size() > 0 && context.getRequest().getAttribute("actionError") == null) {
            SystemStatus systemStatus = this.getSystemStatus(context);
            if (systemStatus != null) {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.genericActionError"));
            } else {
                ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
                if (prefs != null) {
                    context.getRequest().setAttribute("actionError", (Object)prefs.getLabel("object.validation.genericActionError", prefs.get("SYSTEM.LANGUAGE")));
                }
            }
        }
    }

    protected void processWarnings(ActionContext context, HashMap warnings) {
        for (String warningKey : warnings.keySet()) {
            String warningMsg = (String)warnings.get(warningKey);
            context.getRequest().setAttribute(warningKey, (Object)warningMsg);
            if (System.getProperty("DEBUG") == null) continue;
            System.out.println(" Object Validation Warning-> " + warningKey + "=" + warningMsg);
        }
        context.getRequest().setAttribute("warnings", (Object)warnings);
        if (warnings.size() > 0 && context.getRequest().getAttribute("actionWarning") == null) {
            SystemStatus systemStatus = this.getSystemStatus(context);
            if (systemStatus != null) {
                context.getRequest().setAttribute("actionWarning", (Object)systemStatus.getLabel("object.validation.actionWarning.warning"));
            } else {
                ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
                if (prefs != null) {
                    context.getRequest().setAttribute("actionWarning", (Object)prefs.getLabel("object.validation.actionWarning.warning", prefs.get("SYSTEM.LANGUAGE")));
                }
            }
        }
    }

    protected void updateSystemPermissionCheck(Connection db, ActionContext context) throws SQLException {
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
        systemStatus.updateRolePermissions(db);
    }

    protected void updateSystemHierarchyCheck(Connection db, ActionContext context) throws SQLException {
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
        systemStatus.updateHierarchy(db);
    }

    protected void invalidateUserData(ActionContext context, int userId) {
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
        systemStatus.getHierarchyList().getUser(userId).setIsValid(false, true);
        systemStatus.getHierarchyList().getUser(userId).setIsValidLead(false, true);
    }

    protected void invalidateUserRevenueData(ActionContext context, int userId) {
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
        systemStatus.getHierarchyList().getUser(userId).setRevenueIsValid(false, true);
    }

    protected void invalidateUserInMemory(int userId, ActionContext context) {
        UserList shortChildList = new UserList();
        UserList fullChildList = new UserList();
        SystemStatus thisStatus = this.getSystemStatus(context);
        UserList thisList = thisStatus.getHierarchyList();
        for (User thisUser : thisList) {
            shortChildList = thisUser.getShortChildList();
            fullChildList = thisUser.getFullChildList(shortChildList, new UserList());
            for (User indUser : fullChildList) {
                if (indUser.getId() != userId) continue;
                indUser.setIsValid(false, true);
                indUser.setIsValidLead(false, true);
                if (System.getProperty("DEBUG") == null) continue;
                System.out.println("CFSModule-> invalidateUserInMemory: " + indUser.getId());
            }
        }
    }

    protected void deleteRecentItems(ActionContext context, Iterator iterator) {
        while (iterator.hasNext()) {
            this.deleteRecentItem(context, iterator.next());
        }
    }

    protected void deleteRecentItem(ActionContext context, Object itemObject) {
        RecentItem thisItem;
        ArrayList recentItems = (ArrayList)context.getSession().getAttribute("RecentItems");
        if (recentItems == null) {
            recentItems = new ArrayList();
            context.getSession().setAttribute("RecentItems", recentItems);
        }
        if ((thisItem = this.getRecentItem(context, itemObject)) != null) {
            for (RecentItem existingItem : recentItems) {
                if (!existingItem.getUrl().equals(thisItem.getUrl())) continue;
                recentItems.remove(recentItems.indexOf(existingItem));
                break;
            }
        }
    }

    protected void addRecentItem(ActionContext context, Object itemObject) {
        RecentItem thisItem;
        ArrayList<RecentItem> recentItems = (ArrayList<RecentItem>)context.getSession().getAttribute("RecentItems");
        if (recentItems == null) {
            recentItems = new ArrayList<RecentItem>();
            context.getSession().setAttribute("RecentItems", recentItems);
        }
        if ((thisItem = this.getRecentItem(context, itemObject)) != null) {
            for (RecentItem existingItem : recentItems) {
                if (!existingItem.getUrl().equals(thisItem.getUrl())) continue;
                recentItems.remove(recentItems.indexOf(existingItem));
                break;
            }
            if (recentItems.size() > 0) {
                recentItems.add(0, thisItem);
            } else {
                recentItems.add(thisItem);
            }
            while (recentItems.size() > 10) {
                recentItems.remove(10);
            }
        }
    }

    public RecentItem getRecentItem(ActionContext context, Object itemObject) {
        RecentItem thisItem = null;
        if (itemObject instanceof Contact) {
            Contact thisContact = (Contact)((Object)itemObject);
            thisItem = thisContact.getEmployee() ? new RecentItem(3, thisContact.getNameFirstLast(), "CompanyDirectory.do?command=EmployeeDetails&empid=" + thisContact.getId()) : (thisContact.getOrgId() > 0 ? new RecentItem(2, thisContact.getNameFirstLast(), "Contacts.do?command=Details&id=" + thisContact.getId()) : new RecentItem(2, thisContact.getNameFirstLast(), "ExternalContacts.do?command=ContactDetails&id=" + thisContact.getId()));
        } else if (itemObject instanceof Organization) {
            Organization thisOrganization = (Organization)((Object)itemObject);
            thisItem = new RecentItem(1, thisOrganization.getName(), "Accounts.do?command=Details&orgId=" + thisOrganization.getOrgId());
        } else if (itemObject instanceof User) {
            User thisUser = (User)((Object)itemObject);
            thisItem = new RecentItem(8, thisUser.getContact().getNameFirstLast(), "Users.do?command=UserDetails&id=" + thisUser.getId());
        } else if (itemObject instanceof Ticket) {
            Ticket thisTicket = (Ticket)((Object)itemObject);
            thisItem = new RecentItem(7, thisTicket.getPaddedId(), "TroubleTickets.do?command=Details&id=" + thisTicket.getId());
        } else if (itemObject instanceof OpportunityHeader) {
            OpportunityHeader thisOpp = (OpportunityHeader)((Object)itemObject);
            if (thisOpp.getShortDescription() == null) {
                return null;
            }
            thisItem = new RecentItem(4, thisOpp.getShortDescription(), "Leads.do?command=DetailsOpp&headerId=" + thisOpp.getId() + "&reset=true");
        } else if (itemObject instanceof Project) {
            Project thisProject = (Project)itemObject;
            thisItem = new RecentItem(6, thisProject.getTitle(), "ProjectManagement.do?command=ProjectCenter&pid=" + thisProject.getId());
        } else if (itemObject instanceof Campaign) {
            Campaign thisCampaign = (Campaign)((Object)itemObject);
            thisItem = thisCampaign.getActive() ? new RecentItem(5, thisCampaign.getSubject(), "CampaignManager.do?command=Details&id=" + thisCampaign.getId() + "&reset=true") : new RecentItem(5, thisCampaign.getSubject(), "CampaignManager.do?command=ViewDetails&id=" + thisCampaign.getId() + "&reset=true");
        }
        return thisItem;
    }

    public static void saveTextFile(String text, String filename) throws IOException {
        File outputFile = new File(filename);
        FileWriter out = new FileWriter(outputFile);
        out.write(text);
        out.close();
    }

    public CustomForm getDynamicForm(ActionContext context, String formName) {
        CustomForm thisForm = new CustomForm();
        if (((CustomFormList)context.getServletContext().getAttribute("DynamicFormList")).containsKey(formName)) {
            thisForm = (CustomForm)((CustomForm)((CustomFormList)context.getServletContext().getAttribute("DynamicFormList")).get(formName)).clone();
        }
        return thisForm;
    }

    protected void processInsertHook(ActionContext context, Object object) {
        ConnectionPool sqlDriver = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool");
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        this.getSystemStatus(context).processHook(context, 1, null, object, sqlDriver, ce);
    }

    protected void processUpdateHook(ActionContext context, Object previousObject, Object object) {
        ConnectionPool sqlDriver = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool");
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        this.getSystemStatus(context).processHook(context, 2, previousObject, object, sqlDriver, ce);
    }

    protected void processDeleteHook(ActionContext context, Object previousObject) {
        ConnectionPool sqlDriver = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool");
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        this.getSystemStatus(context).processHook(context, 3, previousObject, null, sqlDriver, ce);
    }

    protected boolean hasAuthority(ActionContext context, int ownerId) {
        int userId = this.getUserId(context);
        if (userId == ownerId) {
            return true;
        }
        User userRecord = this.getUser(context, userId);
        User childRecord = userRecord.getChild(ownerId);
        return childRecord != null;
    }

    protected boolean hasCampaignUserGroupAccess(Connection db, int campaignId, int userId) throws SQLException {
        if (campaignId <= 0) {
            return false;
        }
        CampaignUserGroupMapList mapList = new CampaignUserGroupMapList();
        mapList.setCampaignId(campaignId);
        mapList.buildList(db);
        if (mapList.size() > 0) {
            User user = new User(db, userId);
            return mapList.checkUserAccess(db, userId, user.getSiteId());
        }
        return false;
    }

    protected boolean hasCampaignUserGroupAccess(ActionContext context, Connection db, Campaign campaign) throws SQLException {
        int userId = this.getUserId(context);
        int siteId = this.getUserSiteId(context);
        return campaign.getUserGroupMaps().checkUserAccess(db, userId, siteId);
    }

    public boolean hasViewpointAuthority(Connection db, ActionContext context, String permName, int owner, int vpUser) throws SQLException {
        if (this.hasAuthority(context, owner) || vpUser == owner) {
            return true;
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        UserSession thisSession = systemStatus.getSessionManager().getUserSession(this.getActualUserId(context));
        HashMap viewpoints = thisSession.getViewpoints(db, permName, this.getUserId(context));
        ArrayList vpUsers = null;
        if (viewpoints.get(permName) != null) {
            vpUsers = (ArrayList)viewpoints.get(permName);
            Iterator i = vpUsers.iterator();
            while (i.hasNext()) {
                User userRecord;
                User childRecord;
                int user = (Integer)i.next();
                if (vpUser != user || (childRecord = (userRecord = this.getUser(context, user)).getChild(owner)) == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAuthority(Connection db, ActionContext context, Object thisElt) throws SQLException {
        try {
            AccessTypeList accessList = this.getSystemStatus(context).getAccessTypeList(db, AccessType.getLinkModuleId(thisElt));
            Method method = thisElt.getClass().getMethod("getAccessTypeString", null);
            Object result = method.invoke(thisElt, (Object[])null);
            int accessType = Integer.parseInt((String)result);
            if (accessList.getCode(626030334) == accessType) {
                return true;
            }
            method = thisElt.getClass().getMethod("getOwnerString", null);
            result = method.invoke(thisElt, (Object[])null);
            int owner = Integer.parseInt((String)result);
            if (!this.hasAuthority(context, owner)) {
                return false;
            }
            if (accessList.getCode(626030333) == accessType && owner != this.getUserId(context)) {
                return false;
            }
        }
        catch (Exception e) {
            System.out.println("hasAuthority - > Error: " + e.getMessage());
        }
        return true;
    }

    public UserList addViewpoints(Connection db, ActionContext context, String permName) throws SQLException {
        UserList userList = new UserList();
        userList.add(this.getUser(context, this.getUserId(context)));
        SystemStatus systemStatus = this.getSystemStatus(context);
        UserSession thisSession = systemStatus.getSessionManager().getUserSession(this.getActualUserId(context));
        HashMap viewpoints = thisSession.getViewpoints(db, permName, this.getUserId(context));
        ArrayList vpUsers = null;
        if (viewpoints.get(permName) != null) {
            vpUsers = (ArrayList)viewpoints.get(permName);
            Iterator i = vpUsers.iterator();
            while (i.hasNext()) {
                int userId = (Integer)i.next();
                User thisUser = new User();
                thisUser.setBuildContact(true);
                thisUser.setBuildContactDetails(false);
                thisUser.buildRecord(db, userId);
                userList.add(thisUser);
            }
        }
        userList = UserList.sortEnabledUsers(userList, new UserList());
        context.getRequest().setAttribute("Viewpoints", (Object)userList);
        return userList;
    }

    public void invalidateViewpoints(ActionContext context) {
        SystemStatus systemStatus = this.getSystemStatus(context);
        UserSession thisSession = systemStatus.getSessionManager().getUserSession(this.getActualUserId(context));
        thisSession.invalidateViewpoints();
    }

    protected void updateUserContact(Connection db, ActionContext context, int id) throws SQLException {
        if (id > -1) {
            SystemStatus systemStatus = this.getSystemStatus(context);
            systemStatus.updateUserContact(db, id);
        }
    }

    protected static String getReturn(ActionContext context, String returnString) {
        boolean popup = "true".equals(context.getRequest().getParameter("popup"));
        if (popup) {
            returnString = returnString + "PopupOK";
            return returnString;
        }
        returnString = returnString + "OK";
        return returnString;
    }

    protected static String getPref(ActionContext context, String param) {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        if (prefs != null) {
            return prefs.get(param);
        }
        return null;
    }

    protected Icelet getIclet(ActionContext context, String param) {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        if (prefs != null) {
            return prefs.getIceletFromClass(this.getUserLanguage(context), param);
        }
        return null;
    }

    protected HashMap getAllIclets(ActionContext context) {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        if (prefs != null) {
            return prefs.getIcelets(this.getUserLanguage(context));
        }
        return null;
    }

    protected IceletPropertyMap getIcletPrefs(ActionContext context, String param) {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        if (prefs != null) {
            return prefs.getIceletPrefs(this.getUserLanguage(context), param);
        }
        return null;
    }

    protected String getSystemPref(ActionContext context, String configName, String param) {
        SystemStatus systemStatus = this.getSystemStatus(context);
        return systemStatus.getValue(configName, param);
    }

    protected static boolean isRecordAccessPermitted(ActionContext context, Connection db, int tmpOrgId) throws SQLException {
        if (CFSModule.isPortalUser(context)) {
            return tmpOrgId == CFSModule.getPortalUserPermittedOrgId(context);
        }
        if (UserUtils.getUserSiteId(context.getRequest()) != -1) {
            int orgSiteId = Organization.getOrganizationSiteId(db, tmpOrgId);
            return orgSiteId == UserUtils.getUserSiteId(context.getRequest());
        }
        return true;
    }

    protected static boolean isRecordAccessPermitted(ActionContext context, Object object) throws Exception {
        int tmpUserSiteId = UserUtils.getUserSiteId(context.getRequest());
        if (tmpUserSiteId != -1) {
            Method method = object.getClass().getMethod("getSiteId", null);
            Object result = method.invoke(object, (Object[])null);
            int tmpObjectSiteId = (Integer)result;
            return tmpObjectSiteId == tmpUserSiteId;
        }
        return true;
    }

    protected static boolean isSiteAccessPermitted(ActionContext context, String siteId) {
        int tmpUserSiteId = UserUtils.getUserSiteId(context.getRequest());
        return siteId == null || "".equals(siteId) || tmpUserSiteId == -1 || tmpUserSiteId == Integer.parseInt(siteId);
    }

    protected static boolean isPortalUser(ActionContext context) {
        return UserUtils.getUserRoleType(context.getRequest()) > 0;
    }

    protected static int getPortalUserPermittedOrgId(ActionContext context) {
        if (UserUtils.getUserRoleType(context.getRequest()) > 0) {
            return UserUtils.getUserOrganization(context.getRequest());
        }
        return -1;
    }

    protected int getUserLevel(ActionContext context, Connection db, int roleLevel) throws SQLException {
        SystemStatus thisSystem = this.getSystemStatus(context);
        LookupList roleList = thisSystem.getLookupList(db, "lookup_project_role");
        if (roleList != null) {
            return roleList.getIdFromLevel(roleLevel);
        }
        return -1;
    }

    protected int getDocumentStoreUserLevel(ActionContext context, Connection db, int roleLevel) throws SQLException {
        SystemStatus thisSystem = this.getSystemStatus(context);
        LookupList roleList = thisSystem.getLookupList(db, "lookup_document_store_role");
        if (roleList != null) {
            return roleList.getIdFromLevel(roleLevel);
        }
        return -1;
    }

    protected int getRoleId(ActionContext context, Connection db, int userlevel) throws SQLException {
        SystemStatus thisSystem = this.getSystemStatus(context);
        LookupList roleList = thisSystem.getLookupList(db, "lookup_project_role");
        if (roleList != null) {
            return roleList.getLevelFromId(userlevel);
        }
        return -1;
    }

    protected int getDocumentStoreRoleId(ActionContext context, Connection db, int userlevel) throws SQLException {
        SystemStatus thisSystem = this.getSystemStatus(context);
        LookupList roleList = thisSystem.getLookupList(db, "lookup_document_store_role");
        if (roleList != null) {
            return roleList.getLevelFromId(userlevel);
        }
        return -1;
    }

    protected boolean hasProjectAccess(ActionContext context, Connection db, Project thisProject, String permission) throws SQLException {
        TeamMember thisMember = (TeamMember)context.getRequest().getAttribute("currentMember");
        if (thisMember == null) {
            try {
                thisMember = new TeamMember(db, thisProject.getId(), this.getUserId(context));
            }
            catch (Exception notValid) {
                if (CFSModule.isPortalUser(context)) {
                    return false;
                }
                thisMember = new TeamMember();
                thisMember.setProjectId(thisProject.getId());
                thisMember.setUserLevel(this.getUserLevel(context, db, 100));
                thisMember.setRoleId(100);
            }
            context.getRequest().setAttribute("currentMember", (Object)thisMember);
        }
        if (thisMember.getRoleId() == 10) {
            return true;
        }
        int code = thisProject.getAccessUserLevel(permission);
        int roleId = this.getRoleId(context, db, code);
        if (code == -1 || roleId == -1) {
            return false;
        }
        return thisMember.getRoleId() <= roleId;
    }

    protected boolean hasDocumentStoreAccess(ActionContext context, Connection db, DocumentStore thisDocumentStore, String permission) throws SQLException {
        DocumentStoreTeamMember thisMember = (DocumentStoreTeamMember)context.getRequest().getAttribute("currentMember");
        if (thisMember == null) {
            int tmpUserId = this.getUserId(context);
            User tmpUser = this.getUser(context, tmpUserId);
            try {
                int tmpUserRoleId = tmpUser.getRoleId();
                Contact tmpContact = new Contact(db, tmpUser.getContactId());
                int tmpDepartmentId = tmpContact.getDepartment();
                thisMember = new DocumentStoreTeamMember(db, thisDocumentStore.getId(), tmpUserId, tmpUserRoleId, tmpDepartmentId, tmpUser.getSiteId());
            }
            catch (Exception notValid) {
                if (CFSModule.isPortalUser(context)) {
                    return false;
                }
                thisMember = new DocumentStoreTeamMember();
                thisMember.setDocumentStoreId(thisDocumentStore.getId());
                thisMember.setUserLevel(this.getDocumentStoreUserLevel(context, db, 5));
                thisMember.setRoleId(5);
                thisMember.setSiteId(tmpUser.getSiteId());
            }
            context.getRequest().setAttribute("currentMember", (Object)thisMember);
        }
        if (thisMember.getRoleId() == 1) {
            return true;
        }
        int code = thisDocumentStore.getAccessUserLevel(permission);
        int roleId = this.getDocumentStoreRoleId(context, db, code);
        if (code == -1 || roleId == -1) {
            return false;
        }
        return thisMember.getRoleId() <= roleId;
    }

    protected void updateProjectCache(ActionContext context, int id, String title) {
        if (title != null) {
            ((HashMap)this.getSystemStatus(context).getObject("200401202226")).put(new Integer(id), title);
        } else {
            ((HashMap)this.getSystemStatus(context).getObject("200401202226")).remove(new Integer(id));
        }
    }

    protected void updateDocumentStoreCache(ActionContext context, int id, String title) {
        if (title != null) {
            // empty if block
        }
    }

    protected boolean isPopup(ActionContext context) {
        return "true".equals(context.getRequest().getParameter("popup"));
    }

    protected synchronized Directory getDirectory(ActionContext context) throws IOException {
        File path = new File(CFSModule.getDbNamePath(context) + "index");
        boolean create = !path.exists();
        return this.getDirectory(path, create);
    }

    protected synchronized Directory getDirectory(ActionContext context, boolean create) throws IOException {
        File path = new File(CFSModule.getDbNamePath(context) + "index");
        return this.getDirectory(path, create);
    }

    protected synchronized Directory getDirectory(File path, boolean create) throws IOException {
        FSDirectory index = FSDirectory.getDirectory((File)path, (boolean)create);
        if (create) {
            IndexWriter writer = new IndexWriter((Directory)index, (Analyzer)new StandardAnalyzer(), true);
            writer.optimize();
            writer.close();
        }
        return index;
    }

    protected synchronized boolean addLogItem(ActionContext context, String type, Object item) throws IOException {
        if (item == null) {
            return false;
        }
        Scheduler scheduler = (Scheduler)context.getServletContext().getAttribute("Scheduler");
        try {
            ((Vector)scheduler.getContext().get((Object)type)).add(item);
            scheduler.triggerJob("logger", "DEFAULT");
        }
        catch (Exception e) {
            System.out.println("CFSModule-> Scheduler failed: " + e.getMessage());
        }
        return true;
    }

    protected synchronized boolean indexAddItem(ActionContext context, Object item) throws IOException {
        if (item == null) {
            return false;
        }
        Scheduler scheduler = (Scheduler)context.getServletContext().getAttribute("Scheduler");
        try {
            IndexEvent indexEvent = new IndexEvent(item, 1, CFSModule.getDbName(context) + fs);
            ((Vector)scheduler.getContext().get((Object)"IndexArray")).add(indexEvent);
            scheduler.triggerJob("indexer", "DEFAULT");
        }
        catch (Exception e) {
            System.out.println("CFSModule-> Scheduler failed: " + e.getMessage());
        }
        return true;
    }

    protected synchronized boolean indexDeleteItem(ActionContext context, Object item) throws IOException {
        if (item == null) {
            return false;
        }
        Scheduler scheduler = (Scheduler)context.getServletContext().getAttribute("Scheduler");
        try {
            IndexEvent indexEvent = new IndexEvent(item, 2, CFSModule.getDbName(context) + fs);
            ((Vector)scheduler.getContext().get((Object)"IndexArray")).add(indexEvent);
            scheduler.triggerJob("indexer", "DEFAULT");
        }
        catch (Exception e) {
            System.out.println("CFSModule-> Scheduler failed: " + e.getMessage());
        }
        return true;
    }

    public static String getCurrentDateAsString(ActionContext context) {
        String currentDateAsString = "";
        try {
            UserBean userBean = (UserBean)((Object)context.getSession().getAttribute("User"));
            User user = userBean.getUserRecord();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(TimeZone.getTimeZone(user.getTimeZone()));
            SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, user.getLocale());
            formatter.applyPattern(DateUtils.get4DigitYearDateFormat(formatter.toPattern()));
            currentDateAsString = formatter.format(calendar.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currentDateAsString;
    }

    protected boolean validateObject(ActionContext context, Connection db, Object object) throws Exception {
        ObjectValidator.validate(this.getSystemStatus(context), db, object);
        HashMap errors = (HashMap)ObjectUtils.getObject(object, "errors");
        HashMap warnings = (HashMap)ObjectUtils.getObject(object, "warnings");
        if (errors.size() > 0) {
            ObjectUtils.setParam(object, "onlyWarnings", false);
            this.processErrors(context, errors);
            return false;
        }
        if (warnings.size() > 0) {
            String showWarnings = ObjectUtils.getParam(object, "onlyWarnings");
            if (showWarnings != null && "true".equals(showWarnings)) {
                return true;
            }
            this.processWarnings(context, warnings);
            ObjectUtils.setParam(object, "onlyWarnings", true);
            return false;
        }
        return true;
    }

    protected boolean validateObject(ActionContext context, Connection db, Object object, HashMap map) throws Exception {
        ObjectValidator.validate(this.getSystemStatus(context), db, object, map);
        HashMap errors = (HashMap)ObjectUtils.getObject(object, "errors");
        HashMap warnings = (HashMap)ObjectUtils.getObject(object, "warnings");
        if (errors.size() > 0) {
            ObjectUtils.setParam(object, "onlyWarnings", false);
            this.processErrors(context, errors);
            return false;
        }
        if (warnings.size() > 0) {
            String showWarnings = ObjectUtils.getParam(object, "onlyWarnings");
            if (showWarnings != null && "true".equals(showWarnings)) {
                return true;
            }
            this.processWarnings(context, warnings);
            ObjectUtils.setParam(object, "onlyWarnings", true);
            return false;
        }
        return true;
    }

    protected Project loadProject(Connection db, int projectId, ActionContext context) throws SQLException {
        return new Project(db, projectId, this.getUserRange(context));
    }

    protected void executeJob(ActionContext context, String jobName) {
        Scheduler scheduler = (Scheduler)context.getServletContext().getAttribute("Scheduler");
        try {
            scheduler.triggerJob(jobName, "DEFAULT");
        }
        catch (Exception e) {
            System.out.println("CFSModule-> Scheduler failed: " + e.getMessage());
        }
    }

    protected String getUserLanguage(ActionContext context) {
        User thisUser = this.getUser(context, this.getUserId(context));
        return this.getUserLanguage(context, thisUser);
    }

    protected String getUserLanguage(ActionContext context, User thisUser) {
        Locale locale;
        if (thisUser != null && (locale = thisUser.getLocale()) != null) {
            return locale.getLanguage() + "_" + locale.getCountry();
        }
        return CFSModule.getPref(context, "SYSTEM.LANGUAGE");
    }
}

