/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.ProjectList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.FilterList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class ContactsList
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandContactList(ActionContext context) {
        Connection db = null;
        ContactList contactList = null;
        boolean listDone = false;
        String selectedIds = context.getRequest().getParameter("selectedIds");
        String listType = context.getRequest().getParameter("listType");
        String type = context.getRequest().getParameter("type");
        if (type != null && !"".equals(type) && !"null".equals(type)) {
            context.getRequest().setAttribute("type", (Object)type);
        }
        String displayType = context.getRequest().getParameter("displayType");
        HashMap<Integer, String> selectedList = new HashMap<Integer, String>();
        if (context.getRequest().getParameter("previousSelection") != null) {
            StringTokenizer st = new StringTokenizer(context.getRequest().getParameter("previousSelection"), "|");
            StringTokenizer st1 = new StringTokenizer(context.getRequest().getParameter("previousSelectionDisplay"), "|");
            while (st.hasMoreTokens()) {
                selectedList.put(new Integer(st.nextToken()), st1.nextToken());
            }
        } else {
            selectedList = (HashMap<Integer, String>)context.getSession().getAttribute("selectedContacts");
        }
        if ("true".equals(context.getRequest().getParameter("flushtemplist")) && context.getSession().getAttribute("finalContacts") != null && context.getRequest().getParameter("previousSelection") == null) {
            selectedList = (HashMap)((HashMap)context.getSession().getAttribute("finalContacts")).clone();
        }
        HashMap<Integer, String> finalContactList = (HashMap<Integer, String>)context.getSession().getAttribute("finalContacts");
        try {
            db = this.getConnection(context);
            SystemStatus thisSystem = this.getSystemStatus(context);
            if (context.getSession().getAttribute("DepartmentList") == null) {
                LookupList departmentList = new LookupList(db, "lookup_department");
                departmentList.addItem(-1, "--" + thisSystem.getLabel("contact.allDepartments") + "--");
                context.getSession().setAttribute("DepartmentList", (Object)departmentList);
            }
            if (context.getSession().getAttribute("ProjectListSelect") == null) {
                ProjectList projects = new ProjectList();
                projects.setUserRange(this.getUserRange(context));
                projects.setBuildAssignments(false);
                projects.setBuildIssues(false);
                projects.setGroupId(-1);
                projects.buildList(db);
                HtmlSelect htmlSelect = projects.getHtmlSelect();
                htmlSelect.addItem(-1, "--" + thisSystem.getLabel("contact.allProjects") + "--", 0);
                context.getSession().setAttribute("ProjectListSelect", (Object)htmlSelect);
            }
            contactList = new ContactList();
            int rowCount = 1;
            if (listType.equalsIgnoreCase("list")) {
                while (context.getRequest().getParameter("hiddencontactid" + rowCount) != null) {
                    int contactId = 0;
                    String emailAddress = "";
                    contactId = Integer.parseInt(context.getRequest().getParameter("hiddencontactid" + rowCount));
                    if (context.getRequest().getParameter("checkcontact" + rowCount) != null) {
                        if (context.getRequest().getParameter("contactemail" + rowCount) != null) {
                            if (context.getRequest().getParameter("campaign") == null) {
                                emailAddress = context.getRequest().getParameter("contactemail" + rowCount);
                            } else if (!context.getRequest().getParameter("campaign").equalsIgnoreCase("true")) {
                                emailAddress = context.getRequest().getParameter("contactemail" + rowCount);
                            }
                        }
                        if ((emailAddress.equals("") || "single".equals(listType) || "name".equals(displayType)) && context.getRequest().getParameter("hiddenname" + rowCount) != null) {
                            emailAddress = "P:" + context.getRequest().getParameter("hiddenname" + rowCount);
                        }
                        if (selectedList.get(new Integer(contactId)) == null) {
                            selectedList.put(new Integer(contactId), emailAddress);
                        } else {
                            selectedList.remove(new Integer(contactId));
                            selectedList.put(new Integer(contactId), emailAddress);
                        }
                    } else {
                        selectedList.remove(new Integer(contactId));
                    }
                    ++rowCount;
                }
            } else if (selectedIds != null && !"".equals(selectedIds)) {
                if (selectedList == null) {
                    selectedList = new HashMap<Integer, String>();
                }
                selectedList.clear();
                selectedList.put(new Integer(Integer.parseInt(selectedIds)), "");
            }
            if ("true".equals(context.getRequest().getParameter("finalsubmit"))) {
                if ("single".equals(listType)) {
                    rowCount = Integer.parseInt(context.getRequest().getParameter("rowcount"));
                    String emailAddress = context.getRequest().getParameter("hiddenname" + rowCount);
                    int contactId = Integer.parseInt(context.getRequest().getParameter("hiddencontactid" + rowCount));
                    selectedList.clear();
                    selectedList.put(new Integer(contactId), emailAddress);
                }
                listDone = true;
                finalContactList = selectedList;
            }
            this.setParameters(contactList, context, db);
            contactList.buildList(db);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("ContactList", (Object)contactList);
        if ("true".equals(context.getRequest().getParameter("campaign"))) {
            context.getRequest().setAttribute("Campaign", (Object)context.getRequest().getParameter("campaign"));
        }
        context.getSession().setAttribute("selectedContacts", selectedList);
        if (listDone) {
            context.getSession().setAttribute("finalContacts", finalContactList);
        }
        return "CFSContactListOK";
    }

    private void setParameters(ContactList contactList, ActionContext context, Connection db) throws Exception {
        String actionItemId;
        String source;
        String recipient;
        String tasks;
        String leads;
        PagedListInfo contactListInfo;
        SystemStatus thisSystem = this.getSystemStatus(context);
        String defaultFirstName = thisSystem.getLabel("accounts.accounts_add.FirstName");
        String defaultLastName = thisSystem.getLabel("accounts.accounts_add.LastName");
        String firstName = context.getRequest().getParameter("firstName");
        String lastName = context.getRequest().getParameter("lastName");
        if (firstName != null && !defaultFirstName.equals(firstName) && !"".equals(firstName.trim())) {
            contactList.setFirstName("%" + firstName + "%");
        }
        if (lastName != null && !defaultLastName.equals(lastName) && !"".equals(lastName.trim())) {
            contactList.setLastName("%" + lastName + "%");
        }
        if (context.getRequest().getParameter("reset") != null) {
            context.getSession().removeAttribute("ContactListInfo");
        }
        if (!(contactListInfo = this.getPagedListInfo(context, "ContactListInfo")).hasListFilters()) {
            contactListInfo.addFilter(1, "0");
        }
        if ((leads = context.getRequest().getParameter("leads")) != null && !"".equals(leads.trim())) {
            context.getRequest().setAttribute("leads", (Object)leads);
        }
        if ((tasks = context.getRequest().getParameter("tasks")) != null && !"".equals(tasks.trim())) {
            context.getRequest().setAttribute("tasks", (Object)tasks);
        }
        if ((recipient = context.getRequest().getParameter("recipient")) != null && !"".equals(recipient)) {
            context.getRequest().setAttribute("recipient", (Object)recipient);
        }
        String secondFilter = context.getRequest().getParameter("listFilter1");
        String usersOnly = context.getRequest().getParameter("usersOnly");
        String hierarchy = context.getRequest().getParameter("hierarchy");
        String nonUsersOnly = context.getRequest().getParameter("nonUsersOnly");
        String orgId = context.getRequest().getParameter("orgId");
        String siteIdUser = context.getRequest().getParameter("siteIdUser");
        String siteIdContact = context.getRequest().getParameter("siteIdContact");
        String siteIdOrg = context.getRequest().getParameter("siteIdOrg");
        String mySiteOnly = context.getRequest().getParameter("mySiteOnly");
        String departmentId = context.getRequest().getParameter("departmentId");
        String siteIdString = context.getRequest().getParameter("siteId");
        String ticketIdString = context.getRequest().getParameter("ticketId");
        String includeAllSites = context.getRequest().getParameter("includeAllSites");
        String allowDuplicateRecipient = context.getRequest().getParameter("allowDuplicateRecipient");
        if (allowDuplicateRecipient != null && !"".equals(allowDuplicateRecipient.trim())) {
            context.getRequest().setAttribute("allowDuplicateRecipient", (Object)allowDuplicateRecipient);
        }
        if ((source = context.getRequest().getParameter("hiddensource")) != null && !"".equals(source.trim())) {
            context.getRequest().setAttribute("hiddensource", (Object)source);
        }
        if ((actionItemId = context.getRequest().getParameter("actionItemId")) != null && !"".equals(actionItemId.trim())) {
            context.getRequest().setAttribute("actionItemId", (Object)actionItemId);
        }
        int siteId = this.getUserSiteId(context);
        if (siteIdString != null && !"".equals(siteIdString.trim())) {
            siteId = Integer.parseInt(siteIdString);
        }
        if (siteIdUser != null && !"".equals(siteIdUser.trim()) && !"-1".equals(siteIdUser.trim())) {
            User user = this.getUser(context, Integer.parseInt(siteIdUser.trim()));
            siteId = user.getSiteId();
        }
        if (siteIdContact != null && !"".equals(siteIdContact.trim()) && !"-1".equals(siteIdContact.trim())) {
            Contact contact = new Contact(db, Integer.parseInt(siteIdContact.trim()));
            siteId = contact.getSiteId();
        }
        if (siteIdOrg != null && !"".equals(siteIdOrg.trim()) && !"-1".equals(siteIdOrg.trim())) {
            Organization org = new Organization(db, Integer.parseInt(siteIdOrg));
            siteId = org.getSiteId();
        }
        if (!(ticketIdString == null || "".equals(ticketIdString) || "null".equals(ticketIdString) || "-1".equals(ticketIdString))) {
            Ticket ticket = new Ticket(db, Integer.parseInt(ticketIdString));
            siteId = ticket.getOrgSiteId();
        }
        if (!ContactsList.isSiteAccessPermitted(context, String.valueOf(siteId))) {
            throw new SQLException("PermissionError");
        }
        FilterList filters = new FilterList(thisSystem, context.getRequest());
        context.getRequest().setAttribute("Filters", (Object)filters);
        String firstFilter = filters.getFirstFilter(contactListInfo.getListView());
        if (firstFilter.equalsIgnoreCase("all")) {
            contactList.addIgnoreTypeId(1);
            contactList.addIgnoreTypeId(2);
            contactList.setAllContacts(true, this.getUserId(context), this.getUserRange(context));
            contactList.setSiteId(siteId);
        }
        if (firstFilter.equalsIgnoreCase("employees")) {
            contactList.setEmployeesOnly(1);
            if (secondFilter != null && !"".equals(secondFilter)) {
                contactList.setDepartmentId(Integer.parseInt(secondFilter));
            }
            contactList.setSiteId(siteId);
        }
        if (firstFilter.equalsIgnoreCase("mycontacts")) {
            contactList.addIgnoreTypeId(1);
            contactList.addIgnoreTypeId(2);
            contactList.setOwner(this.getUserId(context));
            contactList.setSiteId(siteId);
            contactList.setPersonalId(this.getUserId(context));
        }
        if (firstFilter.equalsIgnoreCase("accountcontacts")) {
            contactList.setWithAccountsOnly(true);
            contactList.setSiteId(siteId);
        }
        if (firstFilter.equalsIgnoreCase("myprojects")) {
            contactList.setWithProjectsOnly(true);
            if (secondFilter != null && !"".equals(secondFilter)) {
                contactList.setProjectId(Integer.parseInt(secondFilter));
            }
            contactList.setSiteId(siteId);
        }
        contactListInfo.setListView(firstFilter);
        contactList.setPagedListInfo(contactListInfo);
        contactList.setCheckUserAccess(true);
        contactList.setBuildDetails(true);
        contactListInfo.setSearchCriteria(contactList, context);
        contactList.setBuildTypes(true);
        if ("true".equals(usersOnly)) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ContactsList-> Only ROLETYPE_REGULAR is valid");
            }
            contactList.setIncludeEnabledUsersOnly(true);
            if (hierarchy != null && !"".equals(hierarchy)) {
                contactList.setHierarchialUsers(hierarchy);
            }
            contactList.setUserRoleType(0);
        }
        if ("true".equals(nonUsersOnly)) {
            contactList.setIncludeNonUsersOnly(true);
        }
        if (orgId != null && !"".equals(orgId.trim())) {
            contactList.setOrgId(Integer.parseInt(orgId));
        }
        if ("true".equals(usersOnly) && departmentId != null && !"".equals(departmentId.trim()) && !"null".equals(departmentId.trim())) {
            context.getRequest().setAttribute("departmentId", (Object)departmentId);
            contactList.setDepartmentId(Integer.parseInt(departmentId));
        }
        if ("true".equals(context.getRequest().getParameter("campaign")) && firstFilter.equalsIgnoreCase("accountcontacts")) {
            contactList.setSiteId(siteId);
        }
        if (mySiteOnly != null && "true".equals(mySiteOnly)) {
            contactList.setExclusiveToSite(true);
        }
        if (includeAllSites != null && "true".equals(includeAllSites.trim()) && siteId == -1) {
            contactList.setIncludeAllSites(true);
        }
        context.getRequest().setAttribute("includeAllSites", (Object)includeAllSites);
        context.getRequest().setAttribute("siteId", (Object)String.valueOf(siteId));
        context.getRequest().setAttribute("mySiteOnly", (Object)mySiteOnly);
    }
}

