/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.actions.ProjectManagementFileFolders;
import com.zeroio.iteam.base.FileFolderList;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.iteam.base.Project;
import com.zeroio.iteam.base.ProjectList;
import com.zeroio.webutils.FileDownload;
import java.io.File;
import java.net.SocketException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.documents.base.DocumentStore;
import org.aspcfs.modules.documents.base.DocumentStoreList;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.web.PagedListInfo;

public final class DocumentSelector
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        Exception errorMessage = null;
        String itemId = context.getRequest().getParameter("fid");
        String version = context.getRequest().getParameter("ver");
        String view = context.getRequest().getParameter("view");
        String moduleId = context.getRequest().getParameter("moduleId");
        String linkItemId = context.getRequest().getParameter("linkItemId");
        String fileDir = null;
        FileItem thisItem = null;
        Connection db = null;
        Contact thisContact = null;
        Organization thisOrg = null;
        DocumentStore thisDocumentStore = null;
        Project thisProject = null;
        try {
            db = this.getConnection(context);
            switch (Integer.parseInt(moduleId)) {
                case 2: {
                    if (!this.hasPermission(context, "accounts-accounts-contacts-documents-view") && !this.hasPermission(context, "contacts-external_contacts-documents-view")) {
                        String string = "PermissionError";
                        return string;
                    }
                    thisContact = new Contact(db, Integer.parseInt(linkItemId));
                    if (!DocumentSelector.isRecordAccessPermitted(context, db, thisContact.getId())) {
                        String string = "PermissionError";
                        return string;
                    }
                    fileDir = "contacts";
                    break;
                }
                case 1: {
                    if (!this.hasPermission(context, "accounts-accounts-documents-view")) {
                        String string = "PermissionError";
                        return string;
                    }
                    thisOrg = new Organization(db, Integer.parseInt(linkItemId));
                    if (!DocumentSelector.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                        String string = "PermissionError";
                        return string;
                    }
                    fileDir = "accounts";
                    break;
                }
                case 20041083: {
                    thisDocumentStore = new DocumentStore(db, Integer.parseInt(linkItemId));
                    thisDocumentStore.buildPermissionList(db);
                    context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
                    if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-download")) {
                        String string = "PermissionError";
                        return string;
                    }
                    fileDir = "documents";
                    break;
                }
                case 4: {
                    thisProject = this.loadProject(db, Integer.parseInt(linkItemId), context);
                    thisProject.buildPermissionList(db);
                    context.getRequest().setAttribute("Project", (Object)thisProject);
                    if (!this.hasProjectAccess(context, db, thisProject, "project-documents-files-download")) {
                        String string = "PermissionError";
                        return string;
                    }
                    fileDir = "projects";
                    break;
                }
                default: {
                    String string = "PermissionError";
                    return string;
                }
            }
            thisItem = new FileItem(db, Integer.parseInt(itemId), Integer.parseInt(linkItemId), Integer.parseInt(moduleId));
            if (version != null) {
                thisItem.buildVersionList(db);
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            if (version == null) {
                FileItem itemToDownload = thisItem;
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, fileDir) + DocumentSelector.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    if (view != null && "true".equals(view)) {
                        fileDownload.setFileTimestamp(thisItem.getModificationDate().getTime());
                        fileDownload.streamContent(context);
                    } else {
                        fileDownload.sendFile(context);
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                } else {
                    db = null;
                    System.err.println("MessagesAttachments-> Trying to send a file that does not exist");
                }
            } else {
                FileItemVersion itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, fileDir) + DocumentSelector.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    if (view != null && "true".equals(view)) {
                        fileDownload.setFileTimestamp(itemToDownload.getModificationDate().getTime());
                        fileDownload.streamContent(context);
                    } else {
                        fileDownload.sendFile(context);
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                } else {
                    db = null;
                    System.err.println("MessagesAttachments-> Trying to send a file that does not exist");
                }
            }
        }
        catch (SocketException se) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println(se.toString());
            }
        }
        catch (Exception e) {
            errorMessage = e;
            System.out.println(e.toString());
        }
        finally {
            if (db != null) {
                this.freeConnection(context, db);
            }
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListDocuments(ActionContext context) {
        String hiddenFileId;
        String previousSelection;
        String folderId;
        String linkItemId;
        String contactId;
        String orgId;
        Exception errorMessage = null;
        Connection db = null;
        boolean listDone = false;
        FileFolderList folders = null;
        FileItemList documents = null;
        FileItemList finalDocuments = null;
        String listType = context.getRequest().getParameter("listType");
        if (listType == null) {
            listType = (String)context.getRequest().getAttribute("listType");
        }
        if ((orgId = context.getRequest().getParameter("orgId")) == null) {
            orgId = (String)context.getRequest().getAttribute("orgId");
        }
        if ((contactId = context.getRequest().getParameter("contactId")) == null) {
            contactId = (String)context.getRequest().getAttribute("contactId");
        }
        SystemStatus thisSystem = this.getSystemStatus(context);
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "documentListInfo");
        String moduleId = context.getRequest().getParameter("moduleId");
        if (moduleId == null) {
            moduleId = (String)context.getRequest().getAttribute("moduleId");
        }
        if ((linkItemId = context.getRequest().getParameter("linkItemId")) == null) {
            linkItemId = (String)context.getRequest().getAttribute("linkItemId");
        }
        if (linkItemId == null) {
            linkItemId = Integer.parseInt(moduleId) == 1 && !"".equals(orgId) ? orgId : (Integer.parseInt(moduleId) == 2 && !"".equals(contactId) ? contactId : "-1");
        }
        if (linkItemId == null) {
            linkItemId = "-1";
        }
        if ((folderId = context.getRequest().getParameter("folderId")) == null) {
            folderId = (String)context.getRequest().getAttribute("folderId");
        }
        if ((previousSelection = context.getRequest().getParameter("previousSelection")) == null) {
            previousSelection = (String)context.getRequest().getAttribute("previousSelection");
        }
        if ((hiddenFileId = context.getRequest().getParameter("hiddenFileId")) == null) {
            hiddenFileId = (String)context.getRequest().getAttribute("hiddenFileId");
        }
        String displayFieldId = context.getRequest().getParameter("displayFieldId");
        if (previousSelection == null) {
            previousSelection = (String)context.getRequest().getAttribute("displayFieldId");
        }
        ArrayList<String> selectedList = new ArrayList<String>();
        if (!"true".equals(context.getRequest().getParameter("reset")) && previousSelection != null) {
            StringTokenizer st = new StringTokenizer(previousSelection, "|");
            while (st.hasMoreTokens()) {
                selectedList.add(String.valueOf(st.nextToken()));
            }
        }
        String pagedListLink = "";
        pagedListLink = "DocumentSelector.do?command=ListDocuments";
        if (moduleId != null) {
            pagedListLink = pagedListLink + "&moduleId=" + moduleId;
        }
        if (folderId != null) {
            pagedListLink = pagedListLink + "&folderId=" + folderId;
        }
        if (orgId != null) {
            pagedListLink = pagedListLink + "&orgId=" + orgId;
        }
        if (contactId != null) {
            pagedListLink = pagedListLink + "&contactId=" + contactId;
        }
        if (previousSelection != null) {
            pagedListLink = pagedListLink + "&previousSelection=" + previousSelection;
        }
        if (linkItemId != null) {
            pagedListLink = pagedListLink + "&linkItemId=" + linkItemId;
        }
        if (listType != null) {
            pagedListLink = pagedListLink + "&listType=" + listType;
        }
        if (hiddenFileId != null) {
            pagedListLink = pagedListLink + "&hiddenFileId=" + hiddenFileId;
        }
        if (displayFieldId != null) {
            pagedListLink = pagedListLink + "&displayFieldId=" + displayFieldId;
        }
        pagedListInfo.setLink(pagedListLink);
        pagedListInfo.setItemsPerPage(0);
        try {
            int fileId;
            db = this.getConnection(context);
            int rowCount = 1;
            if ("list".equals(listType)) {
                while (context.getRequest().getParameter("hiddenFileId" + rowCount) != null) {
                    fileId = Integer.parseInt(context.getRequest().getParameter("hiddenFileId" + rowCount));
                    if (context.getRequest().getParameter("file" + rowCount) != null) {
                        if (!selectedList.contains(String.valueOf(fileId))) {
                            selectedList.add(String.valueOf(fileId));
                        }
                    } else {
                        selectedList.remove(String.valueOf(fileId));
                    }
                    ++rowCount;
                }
            }
            if ("true".equals(context.getRequest().getParameter("finalsubmit"))) {
                if ("single".equals(listType)) {
                    rowCount = Integer.parseInt(context.getRequest().getParameter("rowcount"));
                    fileId = Integer.parseInt(context.getRequest().getParameter("hiddenFileId" + rowCount));
                    selectedList.clear();
                    selectedList.add(String.valueOf(fileId));
                }
                listDone = true;
                if (finalDocuments == null) {
                    finalDocuments = new FileItemList();
                }
                for (int i = 0; i < selectedList.size(); ++i) {
                    int fileId2 = Integer.parseInt((String)selectedList.get(i));
                    finalDocuments.add((Object)new FileItem(db, fileId2));
                }
            }
            if ("-1".equals(linkItemId) && Integer.parseInt(moduleId) == 20041083) {
                if (!this.hasPermission(context, "documents-view")) {
                    String i = "PermissionError";
                    return i;
                }
                DocumentStoreList documentStoreList = new DocumentStoreList();
                int tmpUserId = this.getUserId(context);
                User tmpUser = this.getUser(context, tmpUserId);
                int tmpUserRoleId = tmpUser.getRoleId();
                Contact tmpContact = new Contact(db, tmpUser.getContactId());
                int tmpDepartmentId = tmpContact.getDepartment();
                documentStoreList.setDocumentStoresForUser(this.getUserId(context));
                documentStoreList.setUserRole(tmpUserRoleId);
                documentStoreList.setDepartmentId(tmpDepartmentId);
                documentStoreList.setSiteId(tmpUser.getSiteId());
                documentStoreList.buildList(db);
                DocumentStoreList docStoreList = new DocumentStoreList();
                for (DocumentStore thisDocumentStore : documentStoreList) {
                    thisDocumentStore.buildPermissionList(db);
                    if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-download")) continue;
                    docStoreList.add(thisDocumentStore);
                }
                context.getRequest().setAttribute("documentStoreList", (Object)docStoreList);
            } else if ("-1".equals(linkItemId) && Integer.parseInt(moduleId) == 4) {
                if (!this.hasPermission(context, "projects-view")) {
                    String documentStoreList = "PermissionError";
                    return documentStoreList;
                }
                ProjectList projects = new ProjectList();
                projects.setGroupId(-1);
                projects.setIncludeGuestProjects(true);
                projects.setPortalState(0);
                projects.setBuildOverallProgress(true);
                projects.buildList(db);
                ProjectList projectList = new ProjectList();
                for (Project thisProject : projects) {
                    thisProject.buildPermissionList(db);
                    if (!this.hasProjectAccess(context, db, thisProject, "project-documents-files-download")) continue;
                    projectList.add((Object)thisProject);
                }
                context.getRequest().setAttribute("projectList", (Object)projectList);
            } else {
                Contact thisContact = null;
                Organization thisOrg = null;
                DocumentStore thisDocumentStore = null;
                Project thisProject = null;
                switch (Integer.parseInt(moduleId)) {
                    case 2: {
                        if (!this.hasPermission(context, "accounts-accounts-contacts-documents-view") && !this.hasPermission(context, "contacts-external_contacts-documents-view")) {
                            String string = "PermissionError";
                            return string;
                        }
                        thisContact = new Contact(db, Integer.parseInt(linkItemId));
                        if (DocumentSelector.isRecordAccessPermitted(context, db, thisContact.getId())) break;
                        String string = "PermissionError";
                        return string;
                    }
                    case 1: {
                        if (!this.hasPermission(context, "accounts-accounts-documents-view")) {
                            String string = "PermissionError";
                            return string;
                        }
                        thisOrg = new Organization(db, Integer.parseInt(linkItemId));
                        if (DocumentSelector.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) break;
                        String string = "PermissionError";
                        return string;
                    }
                    case 20041083: {
                        thisDocumentStore = new DocumentStore(db, Integer.parseInt(linkItemId));
                        thisDocumentStore.buildPermissionList(db);
                        context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
                        if (this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-download")) break;
                        String string = "PermissionError";
                        return string;
                    }
                    case 4: {
                        thisProject = this.loadProject(db, Integer.parseInt(linkItemId), context);
                        thisProject.buildPermissionList(db);
                        context.getRequest().setAttribute("Project", (Object)thisProject);
                        if (this.hasProjectAccess(context, db, thisProject, "project-documents-files-download")) break;
                        String string = "PermissionError";
                        return string;
                    }
                    default: {
                        String string = "PermissionError";
                        return string;
                    }
                }
                folders = new FileFolderList();
                if (folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId)) {
                    folders.setTopLevelOnly(true);
                } else {
                    folders.setParentId(Integer.parseInt(folderId));
                    ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
                }
                folders.setLinkModuleId(Integer.parseInt(moduleId));
                folders.setLinkItemId(Integer.parseInt(linkItemId));
                folders.setBuildItemCount(true);
                folders.setPagedListInfo(pagedListInfo);
                folders.buildList(db);
                documents = new FileItemList();
                if (folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId)) {
                    documents.setTopLevelOnly(true);
                } else {
                    documents.setFolderId(Integer.parseInt(folderId));
                }
                documents.setLinkModuleId(Integer.parseInt(moduleId));
                documents.setLinkItemId(Integer.parseInt(linkItemId));
                documents.setPagedListInfo(pagedListInfo);
                documents.buildList(db);
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ViewDocuments", "View Documents");
        if (errorMessage == null) {
            context.getRequest().setAttribute("fileItemList", documents);
            context.getRequest().setAttribute("orgId", (Object)orgId);
            context.getRequest().setAttribute("contactId", (Object)contactId);
            context.getRequest().setAttribute("fileFolderList", folders);
            context.getRequest().setAttribute("linkItemId", (Object)linkItemId);
            context.getRequest().setAttribute("selectedDocuments", selectedList);
            if (listDone) {
                context.getRequest().setAttribute("finalDocuments", (Object)finalDocuments);
            }
            return "ListDocumentsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeCommandUpload(ActionContext context) {
        Connection db = null;
        boolean isValid = false;
        boolean recordInserted = false;
        String filePath = null;
        Object path = null;
        try {
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest());
            db = this.getConnection(context);
            String subject = (String)parts.get("subject");
            String moduleId = (String)parts.get("moduleId");
            String linkItemId = (String)parts.get("linkItemId");
            String folderId = (String)parts.get("folderId");
            String orgId = (String)parts.get("orgId");
            String contactId = (String)parts.get("contactId");
            String selectedList = (String)parts.get("previousSelection");
            String fileDir = "";
            Contact thisContact = null;
            Organization thisOrg = null;
            DocumentStore thisDocumentStore = null;
            Project thisProject = null;
            switch (Integer.parseInt(moduleId)) {
                case 2: {
                    if (!this.hasPermission(context, "accounts-accounts-contacts-documents-add") && !this.hasPermission(context, "contacts-external_contacts-documents-add")) {
                        String string = "PermissionError";
                        this.freeConnection(context, db);
                        return string;
                    }
                    thisContact = new Contact(db, Integer.parseInt(linkItemId));
                    if (!DocumentSelector.isRecordAccessPermitted(context, db, thisContact.getId())) {
                        String string = "PermissionError";
                        this.freeConnection(context, db);
                        return string;
                    } else {
                        fileDir = "contacts";
                        break;
                    }
                }
                case 1: {
                    if (!this.hasPermission(context, "accounts-accounts-documents-add")) {
                        String string = "PermissionError";
                        this.freeConnection(context, db);
                        return string;
                    }
                    thisOrg = new Organization(db, Integer.parseInt(linkItemId));
                    if (!DocumentSelector.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                        String string = "PermissionError";
                        this.freeConnection(context, db);
                        return string;
                    } else {
                        fileDir = "accounts";
                        break;
                    }
                }
                case 20041083: {
                    thisDocumentStore = new DocumentStore(db, Integer.parseInt(linkItemId));
                    thisDocumentStore.buildPermissionList(db);
                    context.getRequest().setAttribute("documentStore", (Object)thisDocumentStore);
                    if (!this.hasDocumentStoreAccess(context, db, thisDocumentStore, "documentcenter-documents-files-upload")) {
                        String string = "PermissionError";
                        this.freeConnection(context, db);
                        return string;
                    } else {
                        fileDir = "documents";
                        break;
                    }
                }
                case 4: {
                    thisProject = this.loadProject(db, Integer.parseInt(linkItemId), context);
                    thisProject.buildPermissionList(db);
                    context.getRequest().setAttribute("Project", (Object)thisProject);
                    if (!this.hasProjectAccess(context, db, thisProject, "project-documents-files-upload")) {
                        String string = "PermissionError";
                        this.freeConnection(context, db);
                        return string;
                    } else {
                        fileDir = "projects";
                        break;
                    }
                }
                default: {
                    String string = "PermissionError";
                    this.freeConnection(context, db);
                    return string;
                }
            }
            if (parts.get("attachment") instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("attachment");
                FileItem thisItem = new FileItem();
                filePath = this.getPath(context, fileDir);
                thisItem.setLinkModuleId(moduleId);
                thisItem.setLinkItemId(linkItemId);
                filePath = filePath + DocumentSelector.getDatePath(new Date());
                File f = new File(filePath);
                f.mkdirs();
                String filenameToUse = DateUtils.getFilename();
                newFileInfo.setClientFileName(FileUtils.getFileName(newFileInfo.getClientFileName()));
                filenameToUse = filenameToUse + (newFileInfo.getVersion() == -1.0 ? "" : "^" + newFileInfo.getVersion()) + (newFileInfo.getExtensionId() == -1 ? "" : "-" + newFileInfo.getExtensionId());
                FileUtils.copyBytesToFile(newFileInfo.getFileContents(), new File(FileUtils.getFileName(filePath, filenameToUse)), true);
                File thisFile = new File(FileUtils.getFileName(filePath, filenameToUse));
                newFileInfo.setLocalFile(thisFile);
                newFileInfo.setSize((int)thisFile.length());
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                if (folderId != null) {
                    thisItem.setFolderId(Integer.parseInt(folderId));
                } else {
                    thisItem.setFolderId(-1);
                }
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(1.0);
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insert(db);
                    if (recordInserted) {
                        this.processInsertHook(context, thisItem);
                    }
                } else {
                    recordInserted = false;
                    HashMap<String, String> errors = new HashMap<String, String>();
                    SystemStatus systemStatus = this.getSystemStatus(context);
                    errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                    this.processErrors(context, errors);
                }
            }
            context.getRequest().setAttribute("moduleId", (Object)moduleId);
            context.getRequest().setAttribute("linkItemId", (Object)linkItemId);
            context.getRequest().setAttribute("orgId", (Object)orgId);
            context.getRequest().setAttribute("contactId", (Object)contactId);
            context.getRequest().setAttribute("previousSelection", (Object)selectedList);
            this.freeConnection(context, db);
            return this.executeCommandListDocuments(context);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }
}

