/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.Iterator;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.pipeline.base.OpportunityHeaderList;
import org.aspcfs.utils.web.PagedListInfo;

public final class OpportunitySelector
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        Connection db = null;
        OpportunityHeaderList oppList = null;
        try {
            db = this.getConnection(context);
            String orgId = context.getRequest().getParameter("orgId");
            String displayFieldId = context.getRequest().getParameter("displayFieldId");
            String hiddenFieldId = context.getRequest().getParameter("hiddenFieldId");
            PagedListInfo oppPagedInfo = this.getPagedListInfo(context, "opportunityListInfo");
            oppPagedInfo.setLink("OpportunitySelector.do?command=List&orgId=" + orgId + "&hiddenFieldId=" + hiddenFieldId + "&displayFieldId=" + displayFieldId);
            oppList = new OpportunityHeaderList();
            oppList.setPagedListInfo(oppPagedInfo);
            oppList.setOrgId(orgId);
            oppList.setControlledHierarchy(1, this.getUserRange(context));
            oppList.setQueryOpenOnly(true);
            oppList.setPagedListInfo(oppPagedInfo);
            oppList.buildList(db);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            Iterator iterator = oppList.iterator();
            while (iterator.hasNext()) {
                OpportunityHeader header = (OpportunityHeader)((Object)iterator.next());
                header.buildManagerOwnerIdRange(db, accessTypeList, this.getUserRange(context));
                if (this.checkAuthority(context, header.getManagerOwnerIdRange())) continue;
                iterator.remove();
            }
            Organization orgDetails = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
            context.getRequest().setAttribute("displayFieldId", (Object)displayFieldId);
            context.getRequest().setAttribute("hiddenFieldId", (Object)hiddenFieldId);
            context.getRequest().setAttribute("orgId", (Object)orgId);
            context.getRequest().setAttribute("oppList", (Object)oppList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListOK";
    }

    public boolean checkAuthority(ActionContext context, String owner) {
        SystemStatus systemStatus = this.getSystemStatus(context);
        int userId = this.getUserId(context);
        String[] owners = owner.split(",");
        for (int i = 0; i < owners.length; ++i) {
            String oneOwner = owners[i];
            if (userId == Integer.parseInt(oneOwner)) {
                return true;
            }
            User userRecord = systemStatus.getUser(userId);
            User childRecord = null;
            if (oneOwner != null && !"".equals(oneOwner.trim())) {
                childRecord = userRecord.getChild(Integer.parseInt(oneOwner));
            }
            if (childRecord == null) continue;
            return true;
        }
        return false;
    }
}

