/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItemVersionList;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessLogList;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.admin.base.PermissionCategoryList;
import org.aspcfs.modules.admin.base.UsageList;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.contacts.base.ContactType;
import org.aspcfs.modules.contacts.base.ContactTypeList;
import org.aspcfs.modules.system.base.DatabaseVersion;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.LookupElement;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.LookupListElement;
import org.aspcfs.utils.web.LookupListList;

public final class Admin
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        return this.executeCommandHome(context);
    }

    public String executeCommandHome(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Admin", "Admin");
        return "HomeOK";
    }

    public String executeCommandManage(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Configuration", "Management");
        return "ManagementOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUsage(ActionContext context) {
        if (!this.hasPermission(context, "admin-usage-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Configuration", "Usage");
        Connection db = null;
        ArrayList<String> usageList = new ArrayList<String>();
        ArrayList<String> usageList2 = new ArrayList<String>();
        String rangeSelect = context.getRequest().getParameter("rangeSelect");
        Timestamp dateStart = null;
        String dateStartParam = context.getRequest().getParameter("dateStart");
        if (dateStartParam != null && (dateStart = DatabaseUtils.parseDateToTimestamp(dateStartParam)) != null) {
            rangeSelect = "custom";
        }
        Timestamp dateEnd = null;
        String dateEndParam = context.getRequest().getParameter("dateEnd");
        if (dateEndParam != null && (dateEnd = DatabaseUtils.parseDateToTimestamp(dateEndParam)) != null) {
            rangeSelect = "custom";
        }
        context.getRequest().setAttribute("rangeSelect", (Object)rangeSelect);
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            Calendar cal = Calendar.getInstance();
            if (dateStart != null) {
                cal.setTimeInMillis(dateStart.getTime());
            }
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long startRange = cal.getTimeInMillis();
            context.getRequest().setAttribute("dateStart", (Object)new Timestamp(cal.getTimeInMillis()));
            if (dateStart != null && dateEnd != null && dateEnd.after(dateStart)) {
                cal.setTimeInMillis(dateEnd.getTime());
            }
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            long endRange = cal.getTimeInMillis();
            context.getRequest().setAttribute("dateEnd", (Object)new Timestamp(cal.getTimeInMillis()));
            NumberFormat nf = NumberFormat.getInstance();
            db = this.getConnection(context);
            UserList userList = new UserList();
            userList.setEnabled(1);
            userList.setRoleType(0);
            int userListCount = userList.queryRecordCount(db);
            if (systemStatus != null) {
                String logEntry = null;
                logEntry = userListCount == 1 ? systemStatus.getLabel("admin.usage.userEnabled.text") : systemStatus.getLabel("admin.usage.usersEnabled.text");
                if (logEntry != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("${number}", nf.format(userListCount));
                    usageList.add(this.getLabel(systemStatus, map, logEntry));
                } else {
                    usageList.add(nf.format(userListCount) + " enabled user" + StringUtils.addS(userListCount));
                }
            } else {
                usageList.add(nf.format(userListCount) + " enabled user" + StringUtils.addS(userListCount));
            }
            FileItemVersionList fileList = new FileItemVersionList();
            int fileCount = fileList.queryRecordCount(db);
            long fileSize = fileList.queryFileSize(db);
            if (systemStatus != null) {
                String logEntry = null;
                logEntry = fileCount == 1 ? systemStatus.getLabel("admin.usage.oneFileStoredDocumentLibraryWithSize.text") : systemStatus.getLabel("admin.usage.filesStoredDocumentLibraryWithSize.text");
                if (logEntry != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("${number}", nf.format(fileCount));
                    map.put("${size}", nf.format(fileSize));
                    usageList.add(this.getLabel(systemStatus, map, logEntry));
                } else {
                    usageList.add(nf.format(fileCount) + " file" + StringUtils.addS(fileCount) + " stored in document library using " + nf.format(fileSize) + " megabyte" + StringUtils.addS(fileSize) + " of storage");
                }
            } else {
                usageList.add(nf.format(fileCount) + " file" + StringUtils.addS(fileCount) + " stored in document library using " + nf.format(fileSize) + " megabyte" + StringUtils.addS(fileSize) + " of storage");
            }
            AccessLogList accessLog = new AccessLogList();
            accessLog.setEnteredRangeStart(new Timestamp(startRange));
            accessLog.setEnteredRangeEnd(new Timestamp(endRange));
            int logins = accessLog.queryRecordCount(db);
            if (systemStatus != null) {
                String logEntry = null;
                logEntry = logins == 1 ? systemStatus.getLabel("admin.usage.login.text") : systemStatus.getLabel("admin.usage.logins.text");
                if (logEntry != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("${number}", nf.format(logins));
                    usageList2.add(this.getLabel(systemStatus, map, logEntry));
                } else {
                    usageList2.add(nf.format(logins) + " login" + StringUtils.addS(logins));
                }
            } else {
                usageList2.add(nf.format(logins) + " login" + StringUtils.addS(logins));
            }
            UsageList usage = new UsageList();
            usage.setEnteredRangeStart(new Timestamp(startRange));
            usage.setEnteredRangeEnd(new Timestamp(endRange));
            usage.setAction(1);
            usage.buildUsage(db);
            long fileUploadCount = usage.getCount();
            long fileUploadSize = usage.getSize();
            if (systemStatus != null) {
                String logEntry = null;
                logEntry = fileUploadCount == 1L ? systemStatus.getLabel("admin.usage.fileUploadedBandwidth.text") : systemStatus.getLabel("admin.usage.filesUploadedBandwidth.text");
                if (logEntry != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("${number}", nf.format(fileUploadCount));
                    map.put("${size}", nf.format(fileUploadSize));
                    usageList2.add(this.getLabel(systemStatus, map, logEntry));
                } else {
                    usageList2.add(nf.format(fileUploadCount) + " file" + StringUtils.addS(fileUploadCount) + " uploaded, using " + nf.format(fileUploadSize) + " byte" + StringUtils.addS(fileUploadSize) + " of bandwidth");
                }
            } else {
                usageList2.add(nf.format(fileUploadCount) + " file" + StringUtils.addS(fileUploadCount) + " uploaded, using " + nf.format(fileUploadSize) + " byte" + StringUtils.addS(fileUploadSize) + " of bandwidth");
            }
            usage.setAction(2);
            usage.buildUsage(db);
            long fileDownloadCount = usage.getCount();
            long fileDownloadSize = usage.getSize();
            if (systemStatus != null) {
                String logEntry = null;
                logEntry = fileDownloadCount == 1L ? systemStatus.getLabel("admin.usage.fileDownloadedBandwidth.text") : systemStatus.getLabel("admin.usage.filesDownloadedBandwidth.text");
                if (logEntry != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("${number}", nf.format(fileDownloadCount));
                    map.put("${size}", nf.format(fileDownloadSize));
                    usageList2.add(this.getLabel(systemStatus, map, logEntry));
                } else {
                    usageList2.add(nf.format(fileDownloadCount) + " file" + StringUtils.addS(fileDownloadCount) + " downloaded, using " + nf.format(fileDownloadSize) + " byte" + StringUtils.addS(fileDownloadSize) + " of bandwidth");
                }
            } else {
                usageList2.add(nf.format(fileDownloadCount) + " file" + StringUtils.addS(fileDownloadCount) + " downloaded, using " + nf.format(fileDownloadSize) + " byte" + StringUtils.addS(fileDownloadSize) + " of bandwidth");
            }
            usage.setAction(3);
            usage.buildUsage(db);
            long emailRecipientCount = usage.getCount();
            long emailSize = usage.getSize();
            if (systemStatus != null) {
                String logEntry = null;
                logEntry = emailRecipientCount == 1L ? systemStatus.getLabel("admin.usage.communicationManagerOneEmail.text") : systemStatus.getLabel("admin.usage.communicationManagerEmails.text");
                if (logEntry != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("${number}", nf.format(emailRecipientCount));
                    map.put("${size}", nf.format(emailSize));
                    usageList2.add(this.getLabel(systemStatus, map, logEntry));
                } else {
                    usageList2.add(nf.format(emailRecipientCount) + " email" + StringUtils.addS(emailRecipientCount) + " sent, consisting of " + nf.format(emailSize) + " byte" + StringUtils.addS(emailSize));
                }
            } else {
                usageList2.add(nf.format(emailRecipientCount) + " email" + StringUtils.addS(emailRecipientCount) + " sent, consisting of " + nf.format(emailSize) + " byte" + StringUtils.addS(emailSize));
            }
            usage.setAction(4);
            usage.buildUsage(db);
            long faxRecipientCount = usage.getCount();
            long faxSize = usage.getSize();
            if (systemStatus != null) {
                String logEntry = null;
                logEntry = faxRecipientCount == 1L ? systemStatus.getLabel("admin.usage.oneFaxSent.text") : systemStatus.getLabel("admin.usage.faxsSent.text");
                if (logEntry != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("${number}", nf.format(faxRecipientCount));
                    map.put("${size}", nf.format(faxSize));
                    usageList2.add(this.getLabel(systemStatus, map, logEntry));
                } else {
                    usageList2.add(nf.format(faxRecipientCount) + " fax" + StringUtils.addES(faxRecipientCount) + " sent, consisting of  " + nf.format(faxSize) + " byte" + StringUtils.addS(faxSize));
                }
            } else {
                usageList2.add(nf.format(faxRecipientCount) + " fax" + StringUtils.addES(faxRecipientCount) + " sent, consisting of  " + nf.format(faxSize) + " byte" + StringUtils.addS(faxSize));
            }
            context.getRequest().setAttribute("usageList", usageList);
            context.getRequest().setAttribute("usageList2", usageList2);
            String appVersion = "Centric CRM 4.1.1 (2007-03-12)";
            context.getRequest().setAttribute("applicationVersion", (Object)appVersion);
            String dbVersion = DatabaseVersion.getLatestVersion(db);
            context.getRequest().setAttribute("databaseVersion", (Object)dbVersion);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "UsageOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfig(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        this.addModuleBean(context, "Configuration", "Configuration");
        Connection db = null;
        PermissionCategoryList thisPermCatList = new PermissionCategoryList();
        try {
            db = this.getConnection(context);
            thisPermCatList.setEnabledState(1);
            thisPermCatList.setCustomizableModulesOnly(true);
            thisPermCatList.buildList(db);
            context.getRequest().setAttribute("PermissionCategoryList", (Object)thisPermCatList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "ConfigurationOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfigDetails(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Configuration", "Configuration");
        Connection db = null;
        String moduleId = context.getRequest().getParameter("moduleId");
        try {
            db = this.getConnection(context);
            PermissionCategory permCat = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permCat);
            String string = "ConfigDetailsOK";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandEditLists(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-lists-view")) {
            return "PermissionError";
        }
        Connection db = null;
        PermissionCategory permCat = null;
        String moduleId = context.getRequest().getParameter("moduleId");
        try {
            db = this.getConnection(context);
            permCat = new PermissionCategory(db, Integer.parseInt(moduleId));
            this.buildFormElements(context, db);
            context.getRequest().setAttribute("PermissionCategory", (Object)permCat);
            this.addModuleBean(context, "Configuration", "Configuration");
            String string = "EditListsOK";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateList(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-lists-edit")) {
            return "PermissionError";
        }
        String tblName = context.getRequest().getParameter("tableName");
        if ("lookup_contact_types".equals(tblName)) {
            return this.executeCommandUpdateContactList(context);
        }
        String[] params = context.getRequest().getParameterValues("selectedList");
        String[] names = new String[params.length];
        int j = 0;
        StringTokenizer st = new StringTokenizer(context.getRequest().getParameter("selectNames"), "^");
        while (st.hasMoreTokens()) {
            names[j] = st.nextToken();
            ++j;
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            LookupList compareList = new LookupList(db, tblName);
            LookupList newList = new LookupList(params, names);
            for (LookupElement thisElement : compareList) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Here: " + thisElement.getCode() + " " + newList.getSelectedValue(thisElement.getCode()));
                }
                if (!newList.getSelectedValue(thisElement.getCode()).equals("") && newList.getSelectedValue(thisElement.getCode()) != null) continue;
                thisElement.disableElement(db, tblName);
            }
            for (LookupElement thisElement : newList) {
                if (thisElement.getCode() == 0) {
                    int thisCode = -1;
                    thisCode = thisElement.isDisabled(db, tblName);
                    if (thisCode != -1) {
                        thisElement.setCode(thisCode);
                        thisElement.enableElement(db, tblName);
                        thisElement.setNewOrder(db, tblName);
                        continue;
                    }
                    thisElement.insertElement(db, tblName);
                    continue;
                }
                thisElement.setNewOrder(db, tblName);
                if (thisElement.getDescription().equals(compareList.getValueFromId(thisElement.getCode()))) continue;
                thisElement.setNewDescription(db, tblName);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            systemStatus.removeLookup(tblName);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("moduleId", (Object)context.getRequest().getParameter("module"));
        this.addModuleBean(context, "Configuration", "Configuration");
        return this.executeCommandEditLists(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateContactList(ActionContext context) {
        Connection db = null;
        String category = context.getRequest().getParameter("category");
        String[] params = context.getRequest().getParameterValues("selectedList");
        String[] names = new String[params.length];
        int j = 0;
        StringTokenizer st = new StringTokenizer(context.getRequest().getParameter("selectNames"), "^");
        while (st.hasMoreTokens()) {
            names[j] = st.nextToken();
            ++j;
        }
        try {
            db = this.getConnection(context);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Admin -- > Updating Contact Types ");
            }
            ContactTypeList compareList = new ContactTypeList();
            compareList.setCategory(category);
            compareList.setIncludeDefinedByUser(this.getUserId(context));
            compareList.buildList(db);
            ContactTypeList newList = new ContactTypeList(params, names);
            for (ContactType thisType : compareList) {
                if (newList.getElement(thisType.getId()) != null) continue;
                thisType.setEnabled(db, false);
            }
            for (ContactType thisType : newList) {
                thisType.setCategory(category);
                if (thisType.getId() == 0) {
                    thisType.insert(db);
                    continue;
                }
                thisType.setNewOrder(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("moduleId", (Object)context.getRequest().getParameter("module"));
        this.addModuleBean(context, "Configuration", "Configuration");
        return this.executeCommandEditLists(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyList(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-lists-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int moduleId = -1;
        int lookupId = -1;
        LookupList selectedList = null;
        PermissionCategory permCat = null;
        try {
            db = this.getConnection(context);
            moduleId = Integer.parseInt(context.getRequest().getParameter("module"));
            lookupId = Integer.parseInt(context.getRequest().getParameter("sublist"));
            permCat = new PermissionCategory(db, moduleId);
            LookupListElement thisList = new LookupListElement(db, moduleId, lookupId);
            thisList.buildLookupList(this.getSystemStatus(context), db, this.getUserId(context));
            selectedList = thisList.getLookupList();
            switch (thisList.getCategoryId()) {
                case 2: {
                    if (lookupId != 1) break;
                    context.getRequest().setAttribute("category", (Object)String.valueOf(0));
                    break;
                }
                case 1: {
                    if (lookupId != 3) break;
                    context.getRequest().setAttribute("category", (Object)String.valueOf(1));
                    break;
                }
            }
            context.getRequest().setAttribute("moduleId", (Object)String.valueOf(moduleId));
            context.getRequest().setAttribute("SelectedList", (Object)selectedList);
            context.getRequest().setAttribute("SubTitle", (Object)thisList.getDescription());
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (selectedList != null) {
            selectedList.setSelectSize(8);
            selectedList.setMultiple(true);
        }
        this.addModuleBean(context, "Configuration", "Configuration");
        context.getRequest().setAttribute("PermissionCategory", (Object)permCat);
        return "ModifyListOK";
    }

    protected void buildFormElements(ActionContext context, Connection db) throws SQLException {
        int moduleId = Integer.parseInt(context.getRequest().getParameter("moduleId"));
        LookupListList thisList = new LookupListList();
        thisList.setUserId(this.getUserId(context));
        thisList.setModuleId(moduleId);
        thisList.buildList(this.getSystemStatus(context), db);
        if (!this.hasPermission(context, "accounts-accounts-revenue-view")) {
            thisList.removeList(1, 2);
        }
        context.getRequest().setAttribute("LookupLists", (Object)thisList);
    }

    public String getLabel(SystemStatus systemStatus, HashMap map, String input) {
        Template template = new Template(input);
        template.setParseElements(map);
        return template.getParsedText();
    }
}

