/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanCategoryList;
import org.aspcfs.modules.actionplans.base.ActionPlanList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.CategoryEditor;
import org.aspcfs.modules.admin.base.CategoryEditorList;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.CategoryList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraft;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftAssignment;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftPlanMapList;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class AdminCategories
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandShow(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Configuration", "View");
        String moduleId = context.getRequest().getParameter("moduleId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            PermissionCategory permCat = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permCat);
            CategoryEditorList editorList = new CategoryEditorList();
            editorList.setModuleId(moduleId);
            editorList.buildList(db);
            context.getRequest().setAttribute("editorList", (Object)editorList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AdminCategories.getReturn(context, "Show");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Configuration", "View");
        Connection db = null;
        String moduleId = context.getRequest().getParameter("moduleId");
        try {
            String siteId = context.getRequest().getParameter("siteId");
            if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("siteId", (Object)siteId);
            int constantId = Integer.parseInt(context.getRequest().getParameter("constantId"));
            User user = this.getUser(context, this.getUserId(context));
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList departmentList = new LookupList(db, "lookup_department");
            departmentList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            departmentList.setJsEvent("onChange=\"javascript:updateDepartment();\" id=\"departmentId\"");
            context.getRequest().setAttribute("departmentSelect", (Object)departmentList);
            LookupList siteid = new LookupList(db, "lookup_site_id");
            siteid.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteid);
            CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, constantId);
            if (siteId == null || "".equals(siteId)) {
                siteId = String.valueOf(user.getSiteId());
            }
            thisEditor.setSiteId(siteId);
            thisEditor.build(db);
            context.getRequest().setAttribute("categoryEditor", (Object)thisEditor);
            PermissionCategory permCat = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permCat);
            HashMap tmpList = null;
            if (context.getSession().getAttribute("selectedCategories" + constantId) != null || "true".equals(context.getRequest().getParameter("reset"))) {
                tmpList = (HashMap)context.getSession().getAttribute("selectedCategories" + constantId);
                HashMap categories = thisEditor.getCategoryList();
                for (int k = 1; k < thisEditor.getMaxLevels(); ++k) {
                    TicketCategoryDraftList subList = null;
                    if (tmpList.get(new Integer(k - 1)) != null) {
                        TicketCategoryDraft tmpCat = (TicketCategoryDraft)((Object)categories.get((Integer)tmpList.get(new Integer(k - 1))));
                        subList = tmpCat.getShortChildList();
                    } else {
                        subList = new TicketCategoryDraftList();
                    }
                    subList.setNoneLabel(systemStatus.getLabel("calendar.none.4dashes"));
                    subList.setHtmlJsEvent("onChange=\"javascript:loadCategories('" + k + "');\"");
                    context.getRequest().setAttribute("SubList" + k, (Object)subList);
                }
            } else {
                tmpList = new HashMap();
                context.getSession().setAttribute("selectedCategories" + constantId, (Object)tmpList);
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AdminCategories.getReturn(context, "View");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Configuration", "Modify Categories");
        String categoryId = context.getRequest().getParameter("categoryId");
        String siteId = context.getRequest().getParameter("siteId");
        if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
            return "PermissionError";
        }
        context.getRequest().setAttribute("siteId", (Object)siteId);
        TicketCategoryDraftList catList = new TicketCategoryDraftList();
        Connection db = null;
        try {
            int constantId = Integer.parseInt(context.getRequest().getParameter("constantId"));
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, constantId);
            thisEditor.setSiteId(siteId);
            thisEditor.build(db);
            if (!"-1".equals(categoryId)) {
                TicketCategoryDraft thisCategory = thisEditor.getCategory(Integer.parseInt(categoryId));
                catList = thisCategory.getShortChildList();
            } else {
                catList = thisEditor.getTopCategoryList();
            }
            catList.setNoneLabel(systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("categoryList", (Object)catList);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AdminCategories.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCategoryJSList(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        String moduleId = context.getRequest().getParameter("moduleId");
        String categoryId = context.getRequest().getParameter("categoryId");
        String siteId = context.getRequest().getParameter("siteId");
        if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
            return "PermissionError";
        }
        context.getRequest().setAttribute("siteId", (Object)siteId);
        Connection db = null;
        try {
            int constantId = Integer.parseInt(context.getRequest().getParameter("constantId"));
            db = this.getConnection(context);
            PermissionCategory permCat = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permCat);
            SystemStatus systemStatus = this.getSystemStatus(context);
            CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, constantId);
            thisEditor.setSiteId(siteId);
            thisEditor.build(db);
            context.getRequest().setAttribute("categoryEditor", (Object)thisEditor);
            String hierarchialUsers = this.getUserRange(context, this.getUserId(context));
            context.getRequest().setAttribute("hierarchialUsers", (Object)hierarchialUsers);
            TicketCategoryDraftList catList = null;
            TicketCategoryDraftAssignment assignment = new TicketCategoryDraftAssignment();
            if (Integer.parseInt(categoryId) > 0) {
                TicketCategoryDraft thisCategory = thisEditor.getCategory(Integer.parseInt(categoryId));
                assignment = new TicketCategoryDraftAssignment(db, thisCategory.getId(), null);
                if (assignment.getId() == -1) {
                    assignment.setCategoryId(thisCategory.getId());
                }
                catList = thisCategory.getShortChildList();
                context.getRequest().setAttribute("ParentCategory", (Object)thisCategory);
                assignment.buildPlanMapList(db);
            } else {
                catList = thisEditor.getTopCategoryList();
            }
            context.getRequest().setAttribute("draftAssignment", (Object)assignment);
            context.getRequest().setAttribute("categoryList", (Object)catList);
            context.getSession().removeAttribute("selectedCategories");
            if (Integer.parseInt(categoryId) != -1) {
                HashMap tmpList = thisEditor.getHierarchyAsList(Integer.parseInt(categoryId));
                context.getSession().setAttribute("selectedCategories", (Object)tmpList);
            }
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                e.printStackTrace();
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AdminCategories.getReturn(context, "CategoryJSList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Configuration", "Save Categories");
        String categories = context.getRequest().getParameter("categories");
        String parentCatId = context.getRequest().getParameter("parentCode");
        String siteId = context.getRequest().getParameter("siteId");
        if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
            return "PermissionError";
        }
        context.getRequest().setAttribute("siteId", (Object)siteId);
        Connection db = null;
        try {
            int constantId = Integer.parseInt(context.getRequest().getParameter("constantId"));
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, constantId);
            thisEditor.setSiteId(siteId);
            thisEditor.build(db);
            thisEditor.setSystemStatus(this.getSystemStatus(context));
            thisEditor.updateCategory(db, categories, Integer.parseInt(parentCatId));
            TicketCategoryDraftList catList = null;
            if (!"-1".equals(parentCatId)) {
                TicketCategoryDraft thisCategory = thisEditor.getCategory(Integer.parseInt(parentCatId));
                catList = thisCategory.getShortChildList();
            } else {
                catList = thisEditor.getTopCategoryList();
            }
            context.getRequest().setAttribute("categoryList", (Object)catList);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AdminCategories.getReturn(context, "Save");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmSave(ActionContext context) {
        Connection db;
        HtmlDialog htmlDialog;
        block8: {
            if (!this.hasPermission(context, "admin-view")) {
                return "PermissionError";
            }
            htmlDialog = new HtmlDialog();
            db = null;
            String categories = context.getRequest().getParameter("categories");
            String parentCatId = context.getRequest().getParameter("parentCode");
            String level = context.getRequest().getParameter("level");
            String siteId = context.getRequest().getParameter("siteId");
            if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
                return "PermissionError";
            }
            context.getRequest().setAttribute("siteId", (Object)siteId);
            try {
                int constantId = Integer.parseInt(context.getRequest().getParameter("constantId"));
                db = this.getConnection(context);
                categories = StringUtils.replacePattern(categories, "'", "\\\\'");
                SystemStatus systemStatus = this.getSystemStatus(context);
                CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, constantId);
                thisEditor.setSiteId(siteId);
                thisEditor.build(db);
                DependencyList dependencies = thisEditor.processDependencies(categories);
                htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
                if (dependencies.size() == 0) {
                    htmlDialog.setTitle(systemStatus.getLabel("admin.confirm.title"));
                    htmlDialog.setShowAndConfirm(false);
                    htmlDialog.setHeader(systemStatus.getLabel("admin.confirm.header"));
                    htmlDialog.setDeleteUrl("javascript:window.location.href='AdminCategories.do?command=Save&categories=' + escape('" + categories + "') + '&parentCode=" + parentCatId + "&level=" + level + "'");
                    break block8;
                }
                if (dependencies.canDelete()) {
                    htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                    htmlDialog.setHeader(systemStatus.getLabel("admin.confirm.categories.header"));
                    htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='AdminCategories.do?command=Save&categories=' + escape('" + categories + "') + '&parentCode=" + parentCatId + "&level=" + level + "'");
                    htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
                    break block8;
                }
                htmlDialog.setTitle(systemStatus.getLabel("admin.confirm.alert"));
                htmlDialog.setHeader(systemStatus.getLabel("admin.confirm.alert.message"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            }
            catch (Exception e) {
                String string;
                try {
                    context.getRequest().setAttribute("Error", (Object)e);
                    string = "SystemError";
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
                return string;
            }
        }
        this.freeConnection(context, db);
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return AdminCategories.getReturn(context, "ConfirmSave");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveDraft(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Configuration", "Save Draft");
        Connection db = null;
        String siteId = context.getRequest().getParameter("siteId");
        if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
            return "PermissionError";
        }
        context.getRequest().setAttribute("siteId", (Object)siteId);
        try {
            int constantId = Integer.parseInt(context.getRequest().getParameter("constantId"));
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            systemStatus.getCategoryEditor(db, constantId);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AdminCategories.getReturn(context, "SaveDraft");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReset(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
            return "PermissionError";
        }
        context.getRequest().setAttribute("siteId", (Object)siteId);
        this.addModuleBean(context, "Configuration", "Reset List");
        User user = this.getUser(context, this.getUserId(context));
        Connection db = null;
        try {
            int constantId = Integer.parseInt(context.getRequest().getParameter("constantId"));
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, constantId);
            if (siteId == null || "".equals(siteId.trim())) {
                siteId = String.valueOf(user.getSiteId());
            }
            thisEditor.setSiteId(siteId);
            thisEditor.build(db);
            thisEditor.reset(db);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        context.getSession().removeAttribute("selectedCategories");
        return AdminCategories.getReturn(context, "Reset");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandActivate(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
            return "PermissionError";
        }
        context.getRequest().setAttribute("siteId", (Object)siteId);
        this.addModuleBean(context, "Configuration", "Activate Categories");
        User user = this.getUser(context, this.getUserId(context));
        Connection db = null;
        try {
            int constantId = Integer.parseInt(context.getRequest().getParameter("constantId"));
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, constantId);
            if (siteId == null || "".equals(siteId.trim())) {
                siteId = String.valueOf(user.getSiteId());
            }
            thisEditor.setSiteId(siteId);
            thisEditor.build(db);
            thisEditor.activate(db);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AdminCategories.getReturn(context, "Activate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewActive(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        String siteId = context.getRequest().getParameter("siteId");
        if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
            return "PermissionError";
        }
        context.getRequest().setAttribute("siteId", (Object)siteId);
        this.addModuleBean(context, "Configuration", "Active Categories");
        Connection db = null;
        User user = this.getUser(context, this.getUserId(context));
        String moduleId = context.getRequest().getParameter("moduleId");
        try {
            int constantId = Integer.parseInt(context.getRequest().getParameter("constantId"));
            db = this.getConnection(context);
            PermissionCategory permCat = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permCat);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList siteid = new LookupList(db, "lookup_site_id");
            siteid.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteid);
            CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, constantId);
            if (siteId == null || "".equals(siteId.trim())) {
                siteId = String.valueOf(user.getSiteId());
            }
            thisEditor.setSiteId(siteId);
            thisEditor.build(db);
            context.getRequest().setAttribute("categoryEditor", (Object)thisEditor);
            HtmlSelect htmlSelect = new HtmlSelect();
            CategoryList categoryList = new CategoryList(thisEditor.getTableName());
            categoryList.setCatLevel(0);
            categoryList.setParentCode(0);
            categoryList.setSiteId(siteId);
            categoryList.setExclusiveToSite(true);
            categoryList.buildList(db);
            categoryList.setIncludeDisabled(true);
            htmlSelect = categoryList.getHtmlSelect(-1);
            if (htmlSelect.size() == 0) {
                htmlSelect.addItem(0, systemStatus.getLabel("calendar.none.4dashes", "---------None---------"));
            }
            context.getRequest().setAttribute("categoryList", (Object)htmlSelect);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AdminCategories.getReturn(context, "ViewActive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandActiveCatJSList(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        String parentCode = context.getRequest().getParameter("categoryId");
        String siteId = context.getRequest().getParameter("siteId");
        if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
            return "PermissionError";
        }
        context.getRequest().setAttribute("siteId", (Object)siteId);
        Connection db = null;
        try {
            int constantId = Integer.parseInt(context.getRequest().getParameter("constantId"));
            HtmlSelect htmlSelect = new HtmlSelect();
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, constantId);
            if (siteId == null || "".equals(siteId.trim())) {
                siteId = String.valueOf(this.getUser(context, this.getUserId(context)).getSiteId());
            }
            thisEditor.setSiteId(siteId);
            thisEditor.build(db);
            context.getRequest().setAttribute("categoryEditor", (Object)thisEditor);
            CategoryList catList = new CategoryList(thisEditor.getTableName());
            catList.setParentCode(Integer.parseInt(parentCode));
            catList.setSiteId(siteId);
            catList.setExclusiveToSite(true);
            catList.buildList(db);
            htmlSelect = catList.getHtmlSelect(-1);
            context.getRequest().setAttribute("categoryList", (Object)htmlSelect);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AdminCategories.getReturn(context, "ActiveCategoryJSList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddMapping(ActionContext context) {
        if (!this.hasPermission(context, "admin-actionplans-view")) {
            return "PermissionError";
        }
        CategoryEditor thisEditor = null;
        TicketCategoryDraftPlanMapList planList = new TicketCategoryDraftPlanMapList();
        Connection db = null;
        String siteId = context.getRequest().getParameter("siteId");
        if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
            return "PermissionError";
        }
        context.getRequest().setAttribute("siteId", (Object)siteId);
        String categoryId = context.getRequest().getParameter("categoryId");
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            int constantId = Integer.parseInt(context.getRequest().getParameter("constantId"));
            context.getRequest().setAttribute("constantId", (Object)String.valueOf(constantId));
            db = this.getConnection(context);
            if (categoryId != null && !"".equals(categoryId) && !"-1".equals(categoryId)) {
                context.getRequest().setAttribute("categoryId", (Object)categoryId);
            }
            thisEditor = systemStatus.getCategoryEditor(db, 907051127);
            context.getRequest().setAttribute("categoryEditor", (Object)thisEditor);
            planList.setCategoryId(categoryId);
            planList.setBuildPlan(true);
            planList.buildList(db);
            context.getRequest().setAttribute("categoryPlanMapList", (Object)planList);
        }
        catch (Exception e) {
            String string;
            try {
                e.printStackTrace();
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AdminCategories.getReturn(context, "AddMapping");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeCommandPopupSelector(ActionContext context) {
        ActionPlanList selectList;
        Connection db;
        block29: {
            Object thisTicketCategory;
            block28: {
                if (!this.hasPermission(context, "admin-actionplans-view")) {
                    return "PermissionError";
                }
                String siteId = context.getRequest().getParameter("siteId");
                if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
                    return "PermissionError";
                }
                String selectedSiteId = context.getRequest().getParameter("selectedSiteId");
                if (selectedSiteId == null || "".equals(selectedSiteId.trim())) {
                    selectedSiteId = siteId;
                }
                CategoryEditor thisCatEditor = null;
                Object thisEditor = null;
                User user = this.getUser(context, this.getUserId(context));
                SystemStatus systemStatus = this.getSystemStatus(context);
                String categoryId = context.getRequest().getParameter("categoryId");
                context.getRequest().setAttribute("categoryId", (Object)categoryId);
                String constantId = context.getRequest().getParameter("constantId");
                context.getRequest().setAttribute("constantId", (Object)constantId);
                TicketCategoryDraftPlanMapList planList = new TicketCategoryDraftPlanMapList();
                db = null;
                selectList = new ActionPlanList();
                if (siteId == null || "".equals(siteId.trim())) {
                    siteId = String.valueOf(user.getSiteId());
                }
                boolean listDone = false;
                PagedListInfo actionPlanSelectorInfo = this.getPagedListInfo(context, "actionPlanSelectorInfo");
                actionPlanSelectorInfo.setLink("AdminCategories.do?command=PopupSelector&categoryId=" + categoryId + "&constantId=" + constantId + "&selectedSiteId=" + (selectedSiteId != null ? selectedSiteId : ""));
                HashMap selectedList = new HashMap();
                try {
                    HashMap finalElementList = (HashMap)context.getSession().getAttribute("finalElements");
                    if (context.getRequest().getParameter("previousSelection") != null) {
                        int j = 0;
                        StringTokenizer st = new StringTokenizer(context.getRequest().getParameter("previousSelection"), "|");
                        while (st.hasMoreTokens()) {
                            String str = st.nextToken();
                            selectedList.put(new Integer(str), str);
                            ++j;
                        }
                    } else {
                        selectedList = (HashMap)context.getSession().getAttribute("selectedElements");
                    }
                    if (context.getRequest().getParameter("flushtemplist") != null && context.getRequest().getParameter("flushtemplist").equalsIgnoreCase("true") && context.getSession().getAttribute("finalElements") != null && context.getRequest().getParameter("previousSelection") == null) {
                        selectedList = (HashMap)((HashMap)context.getSession().getAttribute("finalElements")).clone();
                    }
                    int rowCount = 1;
                    while (context.getRequest().getParameter("hiddenelementid" + rowCount) != null) {
                        int elementId = 0;
                        String elementValue = "";
                        elementId = Integer.parseInt(context.getRequest().getParameter("hiddenelementid" + rowCount));
                        if (context.getRequest().getParameter("checkelement" + rowCount) != null) {
                            if (selectedList.get(new Integer(elementId)) == null) {
                                selectedList.put(new Integer(elementId), String.valueOf(elementId));
                            } else {
                                selectedList.remove(new Integer(elementId));
                                selectedList.put(new Integer(elementId), String.valueOf(elementId));
                            }
                        } else {
                            selectedList.remove(new Integer(elementId));
                        }
                        ++rowCount;
                    }
                    context.getSession().setAttribute("selectedElements", (Object)selectedList);
                    db = this.getConnection(context);
                    LookupList siteid = new LookupList(db, "lookup_site_id");
                    siteid.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
                    context.getRequest().setAttribute("SiteIdList", (Object)siteid);
                    if (categoryId != null && !"".equals(categoryId.trim())) {
                        thisCatEditor = systemStatus.getCategoryEditor(db, Integer.parseInt(constantId));
                        context.getRequest().setAttribute("thisCatEditor", (Object)thisCatEditor);
                        thisTicketCategory = thisCatEditor.getCategory(Integer.parseInt(categoryId));
                        context.getRequest().setAttribute("ticketCategoryDraft", thisTicketCategory);
                    }
                    if (context.getRequest().getParameter("finalsubmit") != null && context.getRequest().getParameter("finalsubmit").equalsIgnoreCase("true")) {
                        context.getSession().removeAttribute("selectedElements");
                        context.getSession().removeAttribute("finalElements");
                        thisTicketCategory = this.saveActionPlans(context, db, selectedList, categoryId, constantId);
                        context.getRequest().setAttribute("baseList", (Object)selectList);
                        break block28;
                    }
                    selectList.setPagedListInfo(actionPlanSelectorInfo);
                    actionPlanSelectorInfo.setSearchCriteria(selectList, context);
                    selectList.setLinkObjectId(ActionPlan.getMapIdGivenConstantId(db, 912051329));
                    if (selectedSiteId != null && !"".equals(selectedSiteId)) {
                        selectList.setSiteId(selectedSiteId);
                    } else if (actionPlanSelectorInfo.getSearchOptionValue("searchcodeSiteId") != null) {
                        selectedSiteId = actionPlanSelectorInfo.getSearchOptionValue("searchcodeSiteId");
                    }
                    selectList.setExclusiveToSite(true);
                    context.getRequest().setAttribute("selectedSiteId", (Object)selectedSiteId);
                    if (actionPlanSelectorInfo.getSearchOptionValue("searchcodeCatCode") == null || "".equals(actionPlanSelectorInfo.getSearchOptionValue("searchcodeCatCode")) || "0".equals(actionPlanSelectorInfo.getSearchOptionValue("searchcodeCatCode"))) {
                        selectList.setCatCode(0);
                        selectList.setSubCat1(0);
                        selectList.setSubCat2(0);
                        selectList.setSubCat3(0);
                    }
                    String refresh = context.getParameter("refresh");
                    ActionPlanCategoryList categoryList = new ActionPlanCategoryList();
                    categoryList.setCatLevel(0);
                    categoryList.setParentCode(0);
                    categoryList.setSiteId(selectedSiteId);
                    categoryList.setExclusiveToSite(true);
                    categoryList.setHtmlJsEvent("onChange=\"javascript:updateSubList1();\"");
                    categoryList.buildList(db);
                    categoryList.getCatListSelect().addItem(0, systemStatus.getLabel("accounts.assets.category.undetermined", "Undetermined"));
                    context.getRequest().setAttribute("CategoryList", (Object)categoryList);
                    ActionPlanCategoryList subList1 = new ActionPlanCategoryList();
                    subList1.setCatLevel(1);
                    subList1.setParentCode(selectList.getCatCode());
                    subList1.setSiteId(selectedSiteId);
                    subList1.setExclusiveToSite(true);
                    subList1.setHtmlJsEvent("onChange=\"javascript:updateSubList2();\"");
                    subList1.buildList(db);
                    subList1.getCatListSelect().addItem(0, systemStatus.getLabel("accounts.assets.category.undetermined", "Undetermined"));
                    context.getRequest().setAttribute("SubList1", (Object)subList1);
                    if (subList1.size() <= 1) {
                        selectList.setSubCat1(0);
                    }
                    ActionPlanCategoryList subList2 = new ActionPlanCategoryList();
                    subList2.setCatLevel(2);
                    subList2.setSiteId(selectedSiteId);
                    subList2.setExclusiveToSite(true);
                    subList2.setParentCode(selectList.getSubCat1());
                    subList2.getCatListSelect().setDefaultKey(selectList.getSubCat2());
                    subList2.setHtmlJsEvent("onChange=\"javascript:updateSubList3();\"");
                    subList2.buildList(db);
                    subList2.getCatListSelect().addItem(0, systemStatus.getLabel("accounts.assets.category.undetermined", "Undetermined"));
                    context.getRequest().setAttribute("SubList2", (Object)subList2);
                    if (subList2.size() <= 1) {
                        selectList.setSubCat2(0);
                    }
                    ActionPlanCategoryList subList3 = new ActionPlanCategoryList();
                    subList3.setCatLevel(3);
                    subList3.setParentCode(selectList.getSubCat2());
                    subList3.setSiteId(selectedSiteId);
                    subList3.setExclusiveToSite(true);
                    subList3.getCatListSelect().setDefaultKey(selectList.getSubCat3());
                    subList3.setHtmlJsEvent("onChange=\"javascript:updateSubList4();\"");
                    subList3.buildList(db);
                    subList3.getCatListSelect().addItem(0, systemStatus.getLabel("accounts.assets.category.undetermined", "Undetermined"));
                    context.getRequest().setAttribute("SubList3", (Object)subList3);
                    selectList.buildList(db);
                    planList.setCategoryId(categoryId);
                    planList.setBuildPlan(true);
                    planList.buildList(db);
                    context.getRequest().setAttribute("mappedActionPlanList", (Object)planList);
                    context.getRequest().setAttribute("siteId", (Object)siteId);
                    context.getRequest().setAttribute("baseList", (Object)selectList);
                    break block29;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    context.getRequest().setAttribute("Error", (Object)e);
                    String string = "SystemError";
                    return string;
                }
            }
            this.freeConnection(context, db);
            return thisTicketCategory;
        }
        this.freeConnection(context, db);
        return AdminCategories.getReturn(context, "AddPlanMap");
        finally {
            context.getRequest().setAttribute("baseList", (Object)selectList);
            this.freeConnection(context, db);
        }
    }

    public String saveActionPlans(ActionContext context, Connection db, HashMap finalSelections, String categoryId, String constantId) throws SQLException {
        try {
            TicketCategoryDraftPlanMapList mapList = new TicketCategoryDraftPlanMapList();
            mapList.setCategoryId(categoryId);
            mapList.buildList(db);
            mapList.parsePlans(db, finalSelections);
            TicketCategoryDraftPlanMapList planMapList = new TicketCategoryDraftPlanMapList();
            planMapList.setBuildPlan(true);
            planMapList.setCategoryId(categoryId);
            planMapList.buildList(db);
            context.getRequest().setAttribute("planMapList", (Object)planMapList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        return "SavePlanMapPopupOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveMapping(ActionContext context) {
        Connection db;
        block7: {
            String string;
            if (!this.hasPermission(context, "admin-actionplans-view")) {
                return "PermissionError";
            }
            String categoryId = context.getRequest().getParameter("selectedCategoryId");
            String planId = context.getRequest().getParameter("planId");
            String siteId = context.getRequest().getParameter("siteId");
            if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
                return "PermissionError";
            }
            context.getRequest().setAttribute("siteId", (Object)siteId);
            TicketCategoryDraftList catList = new TicketCategoryDraftList();
            db = null;
            try {
                int constantId = Integer.parseInt(context.getRequest().getParameter("constantId"));
                db = this.getConnection(context);
                SystemStatus systemStatus = this.getSystemStatus(context);
                CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, constantId);
                thisEditor.setSiteId(siteId);
                thisEditor.build(db);
                context.getRequest().setAttribute("categoryEditor", (Object)thisEditor);
                if (!"-1".equals(categoryId)) {
                    TicketCategoryDraft thisCategory = thisEditor.getCategory(Integer.parseInt(categoryId));
                    thisCategory.insertPlan(db, Integer.parseInt(planId), thisEditor.getTableName());
                    context.getRequest().setAttribute("category", (Object)thisCategory);
                    break block7;
                }
                string = "PermissionError";
            }
            catch (Exception e) {
                String string2;
                try {
                    context.getRequest().setAttribute("Error", (Object)e);
                    string2 = "SystemError";
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
                return string2;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AdminCategories.getReturn(context, "SavePlanMap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateAssignment(ActionContext context) {
        Connection db;
        block13: {
            String string;
            String moduleId = context.getRequest().getParameter("moduleId");
            String categoryId = context.getRequest().getParameter("categoryId");
            String userGroupId = context.getRequest().getParameter("userGroupId");
            String assignedTo = context.getRequest().getParameter("assignedTo");
            String siteId = context.getRequest().getParameter("siteId");
            if (!AdminCategories.isSiteAccessPermitted(context, siteId)) {
                return "PermissionError";
            }
            boolean isValid = false;
            boolean recordInserted = false;
            int recordCount = -1;
            context.getRequest().setAttribute("siteId", (Object)siteId);
            String departmentId = context.getRequest().getParameter("departmentId");
            TicketCategoryDraft thisCategory = null;
            db = null;
            try {
                int constantId = Integer.parseInt(context.getRequest().getParameter("constantId"));
                db = this.getConnection(context);
                PermissionCategory permCat = new PermissionCategory(db, Integer.parseInt(moduleId));
                context.getRequest().setAttribute("PermissionCategory", (Object)permCat);
                SystemStatus systemStatus = this.getSystemStatus(context);
                CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, constantId);
                thisEditor.setSiteId(siteId);
                thisEditor.build(db);
                if (categoryId != null && !"-1".equals(categoryId)) {
                    thisCategory = thisEditor.getCategory(Integer.parseInt(categoryId));
                    TicketCategoryDraftAssignment assignment = new TicketCategoryDraftAssignment(db, thisCategory.getId(), null);
                    if (userGroupId != null && !"".equals(userGroupId.trim())) {
                        assignment.setUserGroupId(userGroupId);
                    }
                    if (assignedTo != null && !"".equals(assignedTo.trim())) {
                        assignment.setAssignedTo(assignedTo);
                    }
                    if (departmentId != null && !"".equals(departmentId.trim())) {
                        assignment.setDepartmentId(departmentId);
                    }
                    if (assignment.getId() > -1) {
                        isValid = this.validateObject(context, db, (Object)assignment);
                        if (isValid) {
                            recordCount = assignment.update(db);
                        }
                    } else {
                        assignment.setCategoryId(thisCategory.getId());
                        isValid = this.validateObject(context, db, (Object)assignment);
                        if (isValid) {
                            recordInserted = assignment.insert(db);
                        }
                    }
                }
                if (isValid && (recordCount == 1 || recordInserted)) break block13;
                string = AdminCategories.getReturn(context, "UpdateAssignmentError");
            }
            catch (Exception e) {
                String string2;
                try {
                    e.printStackTrace();
                    context.getRequest().setAttribute("Error", (Object)e);
                    string2 = "SystemError";
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
                return string2;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AdminCategories.getReturn(context, "UpdateAssignment");
    }
}

