/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.actions;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.hooks.CustomHook;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Hashtable;
import org.aspcfs.apps.workFlowManager.BusinessProcessImporter;
import org.aspcfs.apps.workFlowManager.BusinessProcessList;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.controller.objectHookManager.ObjectHookList;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.MerchantPaymentGateway;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.service.base.SyncClientList;
import org.aspcfs.utils.XMLUtils;
import org.aspcfs.utils.web.CountrySelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.StateSelect;

public final class AdminConfig
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListGlobalParams(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            Organization myCompany = new Organization(db, 0);
            context.getRequest().setAttribute("myCompany", (Object)myCompany);
            BusinessProcessList processList = new BusinessProcessList();
            processList.setEnabled(1);
            processList.buildList(db);
            MerchantPaymentGateway gateway = new MerchantPaymentGateway(db);
            context.getRequest().setAttribute("merchantPaymentGateway", (Object)gateway);
            ObjectHookList hookList = new ObjectHookList();
            hookList.setEnabled(1);
            hookList.buildList(db);
            SyncClientList syncClientList = new SyncClientList();
            syncClientList.setEnabledOnly(1);
            syncClientList.buildList(db);
            UserList httpUsers = new UserList();
            httpUsers.setEnabled(1);
            httpUsers.setHasHttpApiAccess(1);
            httpUsers.buildList(db);
            UserList webdavUsers = new UserList();
            webdavUsers.setEnabled(1);
            webdavUsers.setHasWebdavAccess(1);
            webdavUsers.buildList(db);
            context.getRequest().setAttribute("processes", (Object)("" + processList.values().size()));
            context.getRequest().setAttribute("hooks", (Object)("" + hookList.getSizeOfActions()));
            context.getRequest().setAttribute("clients", (Object)("" + syncClientList.size()));
            context.getRequest().setAttribute("httpUsers", (Object)("" + httpUsers.size()));
            context.getRequest().setAttribute("webdavUsers", (Object)("" + webdavUsers.size()));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String processList = "SystemError";
            return processList;
        }
        finally {
            this.freeConnection(context, db);
        }
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        int sessionTimeout = ((SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl())).getSessionTimeout();
        context.getRequest().setAttribute("Timeout", (Object)String.valueOf(sessionTimeout / 60));
        this.addModuleBean(context, "Configuration", "Configuration");
        return "GlobalParamsOK";
    }

    public String executeCommandModifyTimeout(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Configuration", "Configuration");
        return "ModifyTimeoutOK";
    }

    public String executeCommandUpdateTimeout(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-view")) {
            return "PermissionError";
        }
        int timeout = Integer.parseInt(context.getRequest().getParameter("timeout"));
        this.addModuleBean(context, "Configuration", "Configuration");
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        SystemStatus thisSystem = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
        thisSystem.setSessionTimeout(timeout * 60);
        return "UpdateOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Configuration", "Configuration");
        String module = context.getRequest().getParameter("param");
        if (module == null) {
            return "ModifyError";
        }
        if ("COMPANYINFO".equals(module)) {
            Connection db = null;
            try {
                db = this.getConnection(context);
                SystemStatus systemStatus = this.getSystemStatus(context);
                Organization myOrg = new Organization(db, 0);
                context.getRequest().setAttribute("OrgDetails", (Object)myOrg);
                LookupList phoneTypeList = systemStatus.getLookupList(db, "lookup_orgphone_types");
                context.getRequest().setAttribute("OrgPhoneTypeList", (Object)phoneTypeList);
                LookupList addrTypeList = systemStatus.getLookupList(db, "lookup_orgaddress_types");
                context.getRequest().setAttribute("OrgAddressTypeList", (Object)addrTypeList);
                LookupList emailTypeList = systemStatus.getLookupList(db, "lookup_orgemail_types");
                context.getRequest().setAttribute("OrgEmailTypeList", (Object)emailTypeList);
                ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
                StateSelect stateSelect = new StateSelect(systemStatus, myOrg.getAddressList().getCountries() + "," + prefs.get("SYSTEM.COUNTRY"));
                stateSelect.setPreviousStates(myOrg.getAddressList().getSelectedStatesHashMap());
                CountrySelect countrySelect = new CountrySelect(systemStatus);
                context.getRequest().setAttribute("StateSelect", (Object)stateSelect);
                context.getRequest().setAttribute("CountrySelect", (Object)countrySelect);
                context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                String string = "SystemError";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
            return "ModifyCompanyInfoOK";
        }
        if ("MAILSERVER".equals(module)) {
            return "ModifyEmailOK";
        }
        if ("WORKFLOW".equals(module)) {
            return "ModifyWorkflowOK";
        }
        if ("EMAILADDRESS".equals(module)) {
            return "ModifyEmailAddressOK";
        }
        if ("ASTERISKSERVER".equals(module)) {
            return "ModifyAsteriskOK";
        }
        if ("XMPPSERVER".equals(module)) {
            return "ModifyXMPPOK";
        }
        if ("LDAPSERVER".equals(module)) {
            return "ModifyLDAPOK";
        }
        if ("FAXSERVER".equals(module)) {
            return "ModifyFaxOK";
        }
        if ("WEBSERVER.URL".equals(module)) {
            return "ModifyUrlOK";
        }
        if ("SYSTEM.TIMEZONE".equals(module)) {
            return "ModifyTimeZoneOK";
        }
        if ("SYSTEM.CURRENCY".equals(module)) {
            return "ModifyCurrencyOK";
        }
        if ("SYSTEM.LANGUAGE".equals(module)) {
            return "ModifyLanguageOK";
        }
        if ("SYSTEM.COUNTRY".equals(module)) {
            return "ModifyCountryOK";
        }
        if ("PAYMENTGATEWAY".equals(module)) {
            return "ModifyPaymentGatewayOK";
        }
        String value = CustomHook.populateAdminConfig((String)module);
        if (value != null) {
            return value;
        }
        return "ModifyError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String executeCommandImportWorkflow(ActionContext context) {
        block11: {
            if (!this.hasPermission(context, "admin-sysconfig-view")) {
                return "PermissionError";
            }
            Connection db = null;
            try {
                HttpMultiPartParser multiPart = new HttpMultiPartParser();
                HashMap parts = multiPart.parseData(context.getRequest(), null);
                SystemStatus systemStatus = this.getSystemStatus(context);
                String delete = null;
                FileInfo fileInfo = (FileInfo)parts.get("file");
                delete = (String)parts.get("delete");
                if (fileInfo.getFileContents().length <= 0) break block11;
                XMLUtils xml = new XMLUtils(new String(fileInfo.getFileContents()));
                BusinessProcessImporter importer = new BusinessProcessImporter();
                db = this.getConnection(context);
                if (delete != null && "true".equals(delete)) {
                    importer.deleteProcesses(db);
                } else {
                    importer.setProcesses(systemStatus.getHookManager().getProcessList());
                    importer.setHooks(systemStatus.getHookManager().getHookList());
                    importer.buildEventList(db);
                }
                int sizeOfProcesses = importer.execute(db, xml.getDocumentElement());
                if (sizeOfProcesses <= 0) break block11;
                SystemStatus systemStatus2 = systemStatus;
                synchronized (systemStatus2) {
                    systemStatus.loadWorkflows(db);
                }
            }
            catch (Exception e) {
                context.getRequest().setAttribute("actionError", (Object)e.getMessage());
                e.printStackTrace(System.out);
                String string = "ImportERROR";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        return "UpdateOK";
    }

    public String executeCommandUpdate(ActionContext context) {
        String country;
        String language;
        String currency;
        String timeZone;
        String url;
        String ldap;
        String xmpp;
        String asterisk;
        String fax;
        String emailAddress;
        if (!this.hasPermission(context, "admin-sysconfig-view")) {
            return "PermissionError";
        }
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        if (prefs == null) {
            return "ModifyError";
        }
        String email = context.getRequest().getParameter("email");
        if (email != null) {
            prefs.add("MAILSERVER", email);
        }
        if ((emailAddress = context.getRequest().getParameter("emailAddress")) != null) {
            prefs.add("EMAILADDRESS", emailAddress);
        }
        if ((fax = context.getRequest().getParameter("fax")) != null) {
            prefs.add("FAXSERVER", fax);
            if (fax != null && !"".equals(fax.trim())) {
                prefs.add("FAXENABLED", "true");
            } else {
                prefs.add("FAXENABLED", "false");
            }
        }
        if ((asterisk = context.getRequest().getParameter("asteriskUrl")) != null) {
            prefs.add("ASTERISK.URL", asterisk);
            prefs.add("ASTERISK.USERNAME", context.getRequest().getParameter("asteriskUsername"));
            prefs.add("ASTERISK.PASSWORD", context.getRequest().getParameter("asteriskPassword"));
            prefs.add("ASTERISK.CONTEXT", context.getRequest().getParameter("asteriskContext"));
            prefs.add("ASTERISK.INBOUND.ENABLED", "true".equals(context.getRequest().getParameter("asteriskInbound")) ? "true" : "false");
            prefs.add("ASTERISK.OUTBOUND.ENABLED", "true".equals(context.getRequest().getParameter("asteriskOutbound")) ? "true" : "false");
            this.getSystemStatus(context).startServers(context.getServletContext());
        }
        if ((xmpp = context.getRequest().getParameter("xmppUrl")) != null) {
            prefs.add("XMPP.CONNECTION.URL", xmpp);
            prefs.add("XMPP.CONNECTION.PORT", context.getRequest().getParameter("xmppPort"));
            prefs.add("XMPP.MANAGER.USERNAME", context.getRequest().getParameter("xmppUsername"));
            prefs.add("XMPP.MANAGER.PASSWORD", context.getRequest().getParameter("xmppPassword"));
            prefs.add("XMPP.CONNECTION.SSL", "true".equals(context.getRequest().getParameter("xmppSSL")) ? "true" : "false");
            prefs.add("XMPP.ENABLED", "true".equals(context.getRequest().getParameter("xmppEnabled")) ? "true" : "false");
            this.getSystemStatus(context).startServers(context.getServletContext());
        }
        if ((ldap = context.getRequest().getParameter("ldapUrl")) != null) {
            prefs.add("LDAP.SERVER", ldap);
            prefs.add("LDAP.CENTRIC_CRM.FIELD", context.getRequest().getParameter("ldapCentricCRMField"));
            prefs.add("LDAP.FACTORY", context.getRequest().getParameter("ldapFactory"));
            prefs.add("LDAP.SEARCH.USERNAME", context.getRequest().getParameter("ldapSearchUsername"));
            prefs.add("LDAP.SEARCH.PASSWORD", context.getRequest().getParameter("ldapSearchPassword"));
            prefs.add("LDAP.SEARCH.CONTAINER", context.getRequest().getParameter("ldapSearchContainer"));
            prefs.add("LDAP.SEARCH.ORGPERSON", context.getRequest().getParameter("ldapSearchOrgPerson"));
            prefs.add("LDAP.SEARCH.ATTRIBUTE", context.getRequest().getParameter("ldapSearchAttribute"));
            prefs.add("LDAP.SEARCH.PREFIX", context.getRequest().getParameter("ldapSearchPrefix"));
            prefs.add("LDAP.SEARCH.POSTFIX", context.getRequest().getParameter("ldapSearchPostfix"));
            prefs.add("LDAP.SEARCH.BY_ATTRIBUTE", "true".equals(context.getRequest().getParameter("ldapSearchByAttribute")) ? "true" : "false");
            prefs.add("LDAP.SEARCH.SUBTREE", "true".equals(context.getRequest().getParameter("ldapSearchSubtree")) ? "true" : "false");
            prefs.add("LDAP.ENABLED", "true".equals(context.getRequest().getParameter("ldapEnabled")) ? "true" : "false");
        }
        if ((url = context.getRequest().getParameter("url")) != null) {
            prefs.add("WEBSERVER.URL", url);
        }
        if ((timeZone = context.getRequest().getParameter("timeZone")) != null) {
            prefs.add("SYSTEM.TIMEZONE", timeZone);
        }
        if ((currency = context.getRequest().getParameter("currency")) != null) {
            prefs.add("SYSTEM.CURRENCY", currency);
        }
        if ((language = context.getRequest().getParameter("language")) != null) {
            prefs.add("SYSTEM.LANGUAGE", language);
            this.getSystemStatus(context).setLanguage(language);
        }
        if ((country = context.getRequest().getParameter("country")) != null) {
            prefs.add("SYSTEM.COUNTRY", country);
        }
        prefs.save();
        prefs.populateContext(context.getServletContext());
        prefs.loadApplicationDictionary(context.getServletContext());
        return "UpdateOK";
    }

    public String executeCommandUpdateLicense(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-view")) {
            return "PermissionError";
        }
        return CustomHook.populateLicense((ActionContext)context, (SystemStatus)this.getSystemStatus(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateCompanyInfo(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-view")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = -1;
        boolean isValid = false;
        Organization myOrg = (Organization)((Object)context.getFormBean());
        myOrg.setOrgId(0);
        myOrg.setEnteredBy(this.getUserId(context));
        myOrg.setModifiedBy(this.getUserId(context));
        try {
            db = this.getConnection(context);
            isValid = this.validateObject(context, db, (Object)myOrg);
            if (isValid) {
                myOrg.setRequestItems(context);
                resultCount = myOrg.update(db);
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Modify Account");
        if (resultCount == -1 || !isValid) {
            return "ModifyCompanyInfoERROR";
        }
        if (resultCount == 1) {
            return "UpdateOK";
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }
}

