/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.CustomListView;
import org.aspcfs.modules.admin.base.CustomListViewEditor;
import org.aspcfs.modules.admin.base.CustomListViewEditorList;
import org.aspcfs.modules.admin.base.CustomListViewList;
import org.aspcfs.modules.admin.base.PermissionCategory;

public final class AdminCustomListViews
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        String moduleId = context.getRequest().getParameter("moduleId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            PermissionCategory permCat = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permCat);
            CustomListViewEditorList editorList = new CustomListViewEditorList();
            editorList.setModuleId(moduleId);
            editorList.buildList(db);
            context.getRequest().setAttribute("editorList", (Object)editorList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListViews(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Configuration", "Custom List Views");
        Connection db = null;
        String moduleId = context.getRequest().getParameter("moduleId");
        try {
            db = this.getConnection(context);
            PermissionCategory permCat = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permCat);
            String constantId = context.getRequest().getParameter("constantId");
            CustomListViewEditor editor = new CustomListViewEditor(db, Integer.parseInt(constantId));
            context.getRequest().setAttribute("listViewEditor", (Object)editor);
            CustomListViewList customList = new CustomListViewList();
            customList.setEditorId(editor.getId());
            customList.buildList(db);
            context.getRequest().setAttribute("customListViews", (Object)customList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListViewsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-customlistviews-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Configuration", "Custom List Views");
        Connection db = null;
        String moduleId = context.getRequest().getParameter("moduleId");
        try {
            db = this.getConnection(context);
            PermissionCategory permCat = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permCat);
            SystemStatus thisSystem = this.getSystemStatus(context);
            String constantId = context.getRequest().getParameter("constantId");
            CustomListViewEditor editor = thisSystem.getCustomListViewEditor(context, db, Integer.parseInt(constantId));
            context.getRequest().setAttribute("customListViewEditor", (Object)editor);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-customlistviews-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Configuration", "Custom List Views");
        Connection db = null;
        CustomListView newCustomView = null;
        boolean isValid = true;
        boolean recordInserted = false;
        CustomListView customView = (CustomListView)((Object)context.getFormBean());
        String moduleId = context.getRequest().getParameter("moduleId");
        try {
            db = this.getConnection(context);
            PermissionCategory permCat = new PermissionCategory(db, Integer.parseInt(moduleId));
            context.getRequest().setAttribute("permissionCategory", (Object)permCat);
            isValid = this.validateObject(context, db, (Object)customView);
            if (isValid) {
                recordInserted = customView.insert(db);
            }
            if (recordInserted) {
                newCustomView = new CustomListView(db, customView.getId());
                context.getRequest().setAttribute("customListView", (Object)newCustomView);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted && isValid) {
            return "InsertOK";
        }
        return this.executeCommandAdd(context);
    }
}

