/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldCategoryList;
import org.aspcfs.modules.base.CustomFieldGroup;
import org.aspcfs.utils.web.LookupElement;
import org.aspcfs.utils.web.LookupList;

public final class AdminFields
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-view")) {
            return "PermissionError";
        }
        return this.executeCommandListFolders(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListFolders(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.addCategoryList(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            this.addModuleBean(context, "Configuration", "Configuration");
            return "ListFoldersOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddFolder(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        PermissionCategory permCat = null;
        String moduleId = context.getRequest().getParameter("modId");
        int constantId = -1;
        try {
            db = this.getConnection(context);
            constantId = AdminFields.queryConstantId(db, Integer.parseInt(moduleId));
            permCat = new PermissionCategory(db, Integer.parseInt(moduleId));
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            this.addModuleBean(context, "Configuration", "Configuration");
            context.getRequest().setAttribute("ModId", (Object)moduleId);
            context.getRequest().setAttribute("ConstantId", (Object)String.valueOf(constantId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permCat);
            return "AddFolderOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertFolder(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean result = false;
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            CustomFieldCategory thisCategory = (CustomFieldCategory)context.getFormBean();
            isValid = this.validateObject(context, db, thisCategory);
            if (isValid) {
                result = thisCategory.insertCategory(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (result) {
            return "InsertFolderOK";
        }
        return "InsertFolderERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyFolder(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.addCategoryList(context, db);
            this.addCategory(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            this.addModuleBean(context, "Configuration", "Configuration");
            return "ModifyFolderOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateFolder(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean result = false;
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            CustomFieldCategory thisCategory = (CustomFieldCategory)context.getFormBean();
            isValid = this.validateObject(context, db, thisCategory);
            if (isValid) {
                result = thisCategory.updateCategory(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Configuration", "Configuration");
        if (result) {
            return "UpdateFolderOK";
        }
        return "UpdateFolderERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandToggleFolder(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean result = false;
        String moduleId = context.getRequest().getParameter("modId");
        String categoryId = context.getRequest().getParameter("catId");
        try {
            db = this.getConnection(context);
            int constantId = AdminFields.queryConstantId(db, Integer.parseInt(moduleId));
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(categoryId));
            if (constantId == thisCategory.getModuleId()) {
                thisCategory.toggleEnabled(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ToggleOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteFolder(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean result = false;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            CustomFieldCategory thisCategory = (CustomFieldCategory)context.getFormBean();
            result = thisCategory.deleteCategory(db);
            if (!result) {
                this.processErrors(context, thisCategory.getErrors());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("actionError", (Object)this.getSystemStatus(context).getLabel("object.validation.categoryDeletion"));
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Configuration", "Configuration");
        if (result) {
            return "DeleteFolderOK";
        }
        return "DeleteFolderERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListGroups(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.addCategoryList(context, db);
            this.addCategory(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Configuration", "Configuration");
        return "ListGroupsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddGroup(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.addCategoryList(context, db);
            this.addCategory(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "AddGroupOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertGroup(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean result = false;
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            CustomFieldGroup thisGroup = (CustomFieldGroup)context.getFormBean();
            isValid = this.validateObject(context, db, thisGroup);
            if (isValid) {
                result = thisGroup.insertGroup(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (result) {
            return "InsertGroupOK";
        }
        return "InsertGroupERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyGroup(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.addCategoryList(context, db);
            this.addCategory(context, db);
            this.addGroup(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            this.addModuleBean(context, "Configuration", "Configuration");
            return "ModifyGroupOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateGroup(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean result = false;
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            CustomFieldGroup thisGroup = (CustomFieldGroup)context.getFormBean();
            isValid = this.validateObject(context, db, thisGroup);
            if (isValid) {
                result = thisGroup.updateGroup(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Configuration", "Configuration");
        if (result) {
            return "UpdateGroupOK";
        }
        return "UpdateGroupERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteGroup(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean result = false;
        try {
            db = this.getConnection(context);
            CustomFieldGroup thisGroup = (CustomFieldGroup)context.getFormBean();
            result = thisGroup.deleteGroup(db);
            if (!result) {
                this.processErrors(context, thisGroup.getErrors());
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (result) {
            return "DeleteGroupOK";
        }
        return "DeleteGroupERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddField(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.addCategoryList(context, db);
            this.addCategory(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "AddFieldOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertField(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean result = false;
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            CustomField thisField = (CustomField)context.getFormBean();
            isValid = this.validateObject(context, db, thisField);
            if (isValid) {
                result = thisField.insertField(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (result) {
            return "InsertFieldOK";
        }
        return "InsertFieldERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteField(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean result = false;
        try {
            db = this.getConnection(context);
            CustomField thisField = (CustomField)context.getFormBean();
            result = thisField.deleteField(db);
            if (!result) {
                SystemStatus systemStatus = this.getSystemStatus(context);
                thisField.getErrors().put("actionError", systemStatus.getLabel("object.validation.formDataError"));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (result) {
            return "DeleteFieldOK";
        }
        return "DeleteFieldERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyField(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.addCategoryList(context, db);
            this.addCategory(context, db);
            this.addGroup(context, db);
            this.addField(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Configuration", "Configuration");
        return "ModifyFieldOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateField(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean result = false;
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            CustomField thisField = (CustomField)context.getFormBean();
            thisField.buildElementData(db);
            if (thisField.getLookupListRequired()) {
                String[] params = context.getRequest().getParameterValues("selectedList");
                String[] names = new String[params.length];
                int j = 0;
                StringTokenizer st = new StringTokenizer(context.getRequest().getParameter("selectNames"), "^");
                while (st.hasMoreTokens()) {
                    names[j] = st.nextToken();
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println(names[j]);
                    }
                    ++j;
                }
                LookupList compareList = (LookupList)thisField.getElementData();
                LookupList newList = new LookupList(params, names);
                if (System.getProperty("DEBUG") != null) {
                    newList.printVals();
                }
                for (LookupElement thisElement : compareList) {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Here: " + thisElement.getCode() + " " + newList.getSelectedValue(thisElement.getCode()));
                    }
                    if (!newList.getSelectedValue(thisElement.getCode()).equals("") && newList.getSelectedValue(thisElement.getCode()) != null) continue;
                    thisElement.disableElement(db, "custom_field_lookup");
                }
                for (LookupElement thisElement : newList) {
                    if (thisElement.getCode() == 0) {
                        thisElement.insertElement(db, "custom_field_lookup", thisField.getId());
                        continue;
                    }
                    thisElement.setNewOrder(db, "custom_field_lookup");
                }
            }
            if (isValid = this.validateObject(context, db, thisField)) {
                result = thisField.updateField(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Configuration", "Configuration");
        if (result) {
            return "UpdateFieldOK";
        }
        return "UpdateFieldERROR";
    }

    private void addCategoryList(ActionContext context, Connection db) throws SQLException {
        int moduleId = -1;
        PermissionCategory permCat = null;
        CustomFieldCategoryList categoryList = new CustomFieldCategoryList();
        if (context.getRequest().getParameter("modId") != null) {
            moduleId = Integer.parseInt(context.getRequest().getParameter("modId"));
            int constantId = AdminFields.queryConstantId(db, moduleId);
            permCat = new PermissionCategory(db, moduleId);
            categoryList.setLinkModuleId(constantId);
            categoryList.setBuildResources(false);
            categoryList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)categoryList);
            context.getRequest().setAttribute("ModId", (Object)context.getRequest().getParameter("modId"));
            context.getRequest().setAttribute("ConstantId", (Object)String.valueOf(constantId));
            context.getRequest().setAttribute("PermissionCategory", (Object)permCat);
        }
    }

    private void addCategory(ActionContext context, Connection db) throws SQLException {
        int moduleId = -1;
        if (context.getRequest().getParameter("auto-populate") == null || context.getFormBean() == null || !(context.getFormBean() instanceof CustomFieldCategory)) {
            String categoryId = context.getRequest().getParameter("catId");
            if (categoryId == null) {
                categoryId = (String)context.getRequest().getAttribute("catId");
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("AdminFields-> Adding Category: " + categoryId);
            }
            if (context.getRequest().getParameter("modId") != null) {
                moduleId = Integer.parseInt(context.getRequest().getParameter("modId"));
            }
            if (categoryId != null) {
                context.getRequest().setAttribute("catId", (Object)categoryId);
                int constantId = AdminFields.queryConstantId(db, moduleId);
                LookupList moduleList = (LookupList)context.getRequest().getAttribute("ModuleList");
                CustomFieldCategoryList categoryList = (CustomFieldCategoryList)context.getRequest().getAttribute("CategoryList");
                CustomFieldCategory thisCategory = categoryList.getCategory(Integer.parseInt(categoryId));
                thisCategory.setLinkModuleId(constantId);
                thisCategory.setBuildResources(true);
                thisCategory.buildResources(db);
                context.getRequest().setAttribute("Category", (Object)thisCategory);
            }
        }
    }

    private void addGroup(ActionContext context, Connection db) throws SQLException {
        if (context.getRequest().getParameter("auto-populate") == null || context.getFormBean() == null || !(context.getFormBean() instanceof CustomFieldGroup)) {
            String groupId = context.getRequest().getParameter("grpId");
            if (groupId == null) {
                groupId = (String)context.getRequest().getAttribute("grpId");
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("AdminFields-> Adding Group: " + groupId);
            }
            if (groupId != null) {
                context.getRequest().setAttribute("grpId", (Object)groupId);
                LookupList moduleList = (LookupList)context.getRequest().getAttribute("ModuleList");
                CustomFieldCategoryList categoryList = (CustomFieldCategoryList)context.getRequest().getAttribute("CategoryList");
                CustomFieldCategory thisCategory = (CustomFieldCategory)context.getRequest().getAttribute("Category");
                CustomFieldGroup thisGroup = thisCategory.getGroup(Integer.parseInt(groupId));
                context.getRequest().setAttribute("Group", (Object)thisGroup);
            }
        }
    }

    private void addField(ActionContext context, Connection db) throws SQLException {
        if (context.getRequest().getParameter("auto-populate") == null || context.getFormBean() == null || !(context.getFormBean() instanceof CustomField)) {
            String fieldId = context.getRequest().getParameter("id");
            if (fieldId == null) {
                fieldId = (String)context.getRequest().getAttribute("id");
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("AdminFields-> Adding Field: " + fieldId);
            }
            if (fieldId != null) {
                context.getRequest().setAttribute("id", (Object)fieldId);
                LookupList moduleList = (LookupList)context.getRequest().getAttribute("ModuleList");
                CustomFieldCategoryList categoryList = (CustomFieldCategoryList)context.getRequest().getAttribute("CategoryList");
                CustomFieldCategory thisCategory = (CustomFieldCategory)context.getRequest().getAttribute("Category");
                CustomFieldGroup thisGroup = (CustomFieldGroup)context.getRequest().getAttribute("Group");
                if (thisGroup == null) {
                    System.out.println("AdminFields-> CustomFieldGroup should not be null");
                }
                CustomField thisField = thisGroup.getField(Integer.parseInt(fieldId));
                context.getRequest().setAttribute("CustomField", (Object)thisField);
            }
        } else if (context.getRequest().getParameter("auto-populate") != null && context.getFormBean() != null && context.getFormBean() instanceof CustomField) {
            CustomField thisField = (CustomField)context.getFormBean();
            thisField.buildElementData(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMoveField(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.addCategoryList(context, db);
            this.addCategory(context, db);
            String change = context.getRequest().getParameter("chg");
            if (System.getProperty("DEBUG") != null) {
                System.out.println("AdminFields->MoveField: " + change);
            }
            if (change != null && change.indexOf("|") > -1) {
                StringTokenizer st = new StringTokenizer(change, "|");
                int groupChange = Integer.parseInt(st.nextToken());
                int fieldChange = Integer.parseInt(st.nextToken());
                String direction = st.nextToken();
                CustomFieldCategory thisCategory = (CustomFieldCategory)context.getRequest().getAttribute("Category");
                Iterator groups = thisCategory.iterator();
                int groupCount = 0;
                int previousGroupId = -1;
                int previousGroupSize = -1;
                CustomFieldGroup previousGroup = null;
                boolean hasNewGroup = false;
                int previousFieldId = -1;
                while (groups.hasNext()) {
                    CustomField thisField;
                    CustomFieldGroup thisGroup = (CustomFieldGroup)groups.next();
                    ++groupCount;
                    Iterator fields = thisGroup.iterator();
                    int level = 0;
                    int fieldCount = 0;
                    boolean forceUpdate = false;
                    if (hasNewGroup) {
                        ++fieldCount;
                        thisField = new CustomField();
                        thisField.setId(previousFieldId);
                        thisField.setLevel(++level);
                        thisField.setGroupId(thisGroup.getId());
                        thisField.updateLevel(db);
                        hasNewGroup = false;
                        forceUpdate = true;
                    }
                    while (fields.hasNext()) {
                        thisField = (CustomField)fields.next();
                        if (groupCount > 1 && ++fieldCount == 1 && groupChange == groupCount && fieldChange == 1 && "U".equals(direction)) {
                            thisField.setLevel(previousGroup.size() + 1);
                            thisField.setGroupId(previousGroup.getId());
                        } else if (groups.hasNext() && !fields.hasNext() && groupChange == groupCount && fieldChange == fieldCount && "D".equals(direction)) {
                            hasNewGroup = true;
                            previousFieldId = thisField.getId();
                        } else if (groupCount == groupChange && "U".equals(direction)) {
                            if (fieldCount < fieldChange) {
                                ++level;
                            }
                            if (fieldCount + 1 == fieldChange) {
                                ++level;
                            }
                            if (fieldCount == fieldChange) {
                                --level;
                            }
                            if (fieldCount > fieldChange) {
                                ++level;
                            }
                            thisField.setLevel(new Integer(level));
                            if (fieldCount == fieldChange) {
                                ++level;
                            }
                        } else if (groupCount == groupChange && "D".equals(direction)) {
                            if (fieldCount < fieldChange) {
                                ++level;
                            }
                            if (fieldCount == fieldChange) {
                                level += 2;
                            }
                            if (fieldCount - 1 == fieldChange) {
                                --level;
                            }
                            if (fieldCount - 1 > fieldChange) {
                                ++level;
                            }
                            thisField.setLevel(new Integer(level));
                            if (fieldCount - 1 == fieldChange) {
                                ++level;
                            }
                        } else if (forceUpdate) {
                            thisField.setLevel(new Integer(++level));
                        }
                        if (!hasNewGroup) {
                            thisField.updateLevel(db);
                        }
                        System.out.println("Grp: " + thisField.getGroupId() + " Fld: " + thisField.getLevel());
                    }
                    previousGroup = thisGroup;
                    previousGroupId = thisGroup.getId();
                    previousGroupSize = thisGroup.size();
                }
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            this.addModuleBean(context, "Configuration", "Configuration");
            return "MoveFieldOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMoveGroup(ActionContext context) {
        if (!this.hasPermission(context, "admin-sysconfig-folders-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.addCategoryList(context, db);
            this.addCategory(context, db);
            String change = context.getRequest().getParameter("chg");
            if (System.getProperty("DEBUG") != null) {
                System.out.println("AdminFields->MoveGroup: " + change);
            }
            if (change != null && change.indexOf("|") > -1) {
                StringTokenizer st = new StringTokenizer(change, "|");
                int groupChange = Integer.parseInt(st.nextToken());
                String direction = st.nextToken();
                CustomFieldCategory thisCategory = (CustomFieldCategory)context.getRequest().getAttribute("Category");
                Iterator groups = thisCategory.iterator();
                int groupCount = 0;
                int level = 0;
                while (groups.hasNext()) {
                    CustomFieldGroup thisGroup = (CustomFieldGroup)groups.next();
                    ++groupCount;
                    if ("U".equals(direction)) {
                        if (groupCount < groupChange) {
                            ++level;
                        }
                        if (groupCount + 1 == groupChange) {
                            ++level;
                        }
                        if (groupCount == groupChange) {
                            --level;
                        }
                        if (groupCount > groupChange) {
                            ++level;
                        }
                        thisGroup.setLevel(new Integer(level));
                        if (groupCount == groupChange) {
                            ++level;
                        }
                    } else if ("D".equals(direction)) {
                        if (groupCount < groupChange) {
                            ++level;
                        }
                        if (groupCount == groupChange) {
                            level += 2;
                        }
                        if (groupCount - 1 == groupChange) {
                            --level;
                        }
                        if (groupCount - 1 > groupChange) {
                            ++level;
                        }
                        thisGroup.setLevel(new Integer(level));
                        if (groupCount - 1 == groupChange) {
                            ++level;
                        }
                    }
                    thisGroup.updateLevel(db);
                }
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            this.addModuleBean(context, "Configuration", "Configuration");
            return "MoveGroupOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    private static int queryConstantId(Connection db, int moduleId) throws SQLException {
        int constantId = -1;
        PreparedStatement pst = db.prepareStatement("SELECT category_id FROM module_field_categorylink WHERE module_id = ? ");
        pst.setInt(1, moduleId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            constantId = rs.getInt("category_id");
        }
        rs.close();
        pst.close();
        return constantId;
    }
}

