/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.MerchantPaymentGateway;
import org.aspcfs.utils.web.LookupList;

public class MerchantPaymentGateways
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        Connection db = null;
        MerchantPaymentGateway thisGateway = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            thisGateway = new MerchantPaymentGateway(db);
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("merchantPaymentGateway", (Object)thisGateway);
            return "DetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        Exception errorMessage = null;
        boolean recordDeleted = false;
        MerchantPaymentGateway thisGateway = null;
        Connection db = null;
        String returnUrl = context.getRequest().getParameter("return");
        try {
            db = this.getConnection(context);
            thisGateway = new MerchantPaymentGateway(db);
            if (thisGateway.getId() > -1) {
                recordDeleted = thisGateway.delete(db);
            }
        }
        catch (Exception e) {
            errorMessage = e;
            System.out.println(errorMessage.getMessage());
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                return "DeleteOK";
            }
            this.processErrors(context, thisGateway.getErrors());
            return "SystemError";
        }
        context.getRequest().setAttribute("actionError", (Object)this.getSystemStatus(context).getLabel("object.validation.actionError.gatewayDeletion"));
        context.getRequest().setAttribute("refreshUrl", (Object)returnUrl);
        return "DeleteError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        int recordUpdated;
        block9: {
            Connection db = null;
            recordUpdated = -1;
            MerchantPaymentGateway updatedGateway = null;
            MerchantPaymentGateway gateway = (MerchantPaymentGateway)((Object)context.getFormBean());
            try {
                db = this.getConnection(context);
                if (gateway.getId() > -1) {
                    gateway.setModifiedBy(this.getUserId(context));
                    recordUpdated = gateway.update(db);
                } else {
                    gateway.setEnteredBy(this.getUserId(context));
                    recordUpdated = gateway.insert(db);
                }
                if (recordUpdated > 0) {
                    updatedGateway = new MerchantPaymentGateway(db);
                    context.getRequest().setAttribute("merchantPaymentGateway", (Object)updatedGateway);
                    break block9;
                }
                context.getRequest().setAttribute("merchantPaymentGateway", (Object)gateway);
                String string = this.executeCommandDefault(context);
                return string;
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                e.printStackTrace(System.out);
                String string = "SystemError";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        if (recordUpdated > 0) {
            return this.executeCommandDetails(context);
        }
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDefault(ActionContext context) {
        Connection db = null;
        MerchantPaymentGateway gateway = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            gateway = new MerchantPaymentGateway(db);
            if (gateway.getId() > -1) {
                String string = this.executeCommandDetails(context);
                return string;
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList paymentSelect = systemStatus.getLookupList(db, "lookup_payment_gateway");
            paymentSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("paymentGatewayList", (Object)paymentSelect);
            gateway = new MerchantPaymentGateway(db);
            context.getRequest().setAttribute("merchantPaymentGateway", (Object)gateway);
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "ModifyOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        Connection db = null;
        MerchantPaymentGateway gateway = null;
        Exception errorMessage = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList paymentSelect = systemStatus.getLookupList(db, "lookup_payment_gateway");
            paymentSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("paymentGatewayList", (Object)paymentSelect);
            gateway = new MerchantPaymentGateway(db);
            context.getRequest().setAttribute("merchantPaymentGateway", (Object)gateway);
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "ModifyOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }
}

