/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionList;
import org.aspcfs.modules.admin.base.PopulatePortalRolePermissionList;
import org.aspcfs.modules.admin.base.Role;
import org.aspcfs.modules.admin.base.RoleList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.PagedListInfo;

public class PortalRoleEditor
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "admin-portalroleeditor-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        Connection db = null;
        PagedListInfo roleInfo = this.getPagedListInfo(context, "portalRoleListInfo");
        roleInfo.setLink("PortalRoleEditor.do?command=List");
        RoleList roleList = new RoleList();
        try {
            db = this.getConnection(context);
            roleList.setPagedListInfo(roleInfo);
            roleList.setBuildUsers(false);
            roleList.setBuildUserCount(true);
            roleList.setRoleType(1);
            roleList.setEnabledState(-1);
            roleList.buildList(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Roles", "Role List");
        context.getRequest().setAttribute("roleList", (Object)roleList);
        return "ListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "admin-portalroleeditor-edit")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        String roleId = context.getRequest().getParameter("id");
        Connection db = null;
        try {
            db = this.getConnection(context);
            PopulatePortalRolePermissionList portalRoleList = new PopulatePortalRolePermissionList();
            PermissionList permissionList = portalRoleList.populatePortalPermissions(db);
            context.getRequest().setAttribute("permissionList", (Object)permissionList);
            Role thisRole = new Role(db, Integer.parseInt(roleId));
            context.getRequest().setAttribute("role", (Object)thisRole);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Roles", "Modify Role Details");
        return "ModifyOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "admin-portalroleeditor-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = 0;
        boolean isValid = false;
        Role thisRole = (Role)((Object)context.getFormBean());
        thisRole.setRequestItems(context.getRequest());
        thisRole.setModifiedBy(this.getUserId(context));
        thisRole.setRoleType(1);
        try {
            db = this.getConnection(context);
            isValid = this.validateObject(context, db, (Object)thisRole);
            if (isValid) {
                resultCount = thisRole.update(db);
            }
            if (resultCount == 1) {
                this.updateSystemPermissionCheck(db, context);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Roles", "Update Role");
        if (resultCount == -1 || !isValid) {
            return this.executeCommandModify(context);
        }
        if (resultCount == 1) {
            return "UpdateOK";
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Role thisRole = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        int id = -1;
        if (!this.hasPermission(context, "admin-portalroleeditor-delete")) {
            return "DefaultError";
        }
        if (context.getRequest().getParameter("id") != null) {
            id = Integer.parseInt(context.getRequest().getParameter("id"));
        }
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisRole = new Role(db, id);
            DependencyList dependencies = thisRole.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            if (dependencies.size() == 0) {
                htmlDialog.setShowAndConfirm(false);
                htmlDialog.setDeleteUrl("javascript:window.location.href='PortalRoleEditor.do?command=Delete&id=" + id + "'");
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.roleUserHeader"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "admin-portalroleeditor-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        this.addModuleBean(context, "Roles", "Insert a Role");
        Connection db = null;
        try {
            db = this.getConnection(context);
            PopulatePortalRolePermissionList portalRoleList = new PopulatePortalRolePermissionList();
            PermissionList thisPermissionList = portalRoleList.populatePortalPermissions(db);
            context.getRequest().setAttribute("permissionList", (Object)thisPermissionList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "AddOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "admin-portalroleeditor-add")) {
            return "PermissionError";
        }
        boolean recordInserted = false;
        boolean isValid = false;
        Role thisRole = (Role)((Object)context.getFormBean());
        thisRole.setRequestItems(context.getRequest());
        thisRole.setEnteredBy(this.getUserId(context));
        thisRole.setModifiedBy(this.getUserId(context));
        thisRole.setRoleType(1);
        Connection db = null;
        try {
            db = this.getConnection(context);
            isValid = this.validateObject(context, db, (Object)thisRole);
            if (isValid) {
                recordInserted = thisRole.insert(db);
            }
            if (recordInserted) {
                PermissionList permissionList = new PermissionList(db);
                context.getRequest().setAttribute("permissionList", (Object)permissionList);
                thisRole = new Role(db, thisRole.getId());
                context.getRequest().setAttribute("role", (Object)thisRole);
                this.updateSystemPermissionCheck(db, context);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Roles", "Insert a Role");
        if (recordInserted) {
            return "SaveOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        boolean recordDeleted = false;
        Role thisRole = null;
        String roleId = context.getRequest().getParameter("id");
        Connection db = null;
        try {
            if (Integer.parseInt(roleId) == 1) {
                throw new Exception("Administrator Role cannot be deleted.");
            }
            db = this.getConnection(context);
            thisRole = new Role(db, Integer.parseInt(roleId));
            boolean usersPresent = thisRole.buildUserCount(db, true);
            SystemStatus systemStatus = this.getSystemStatus(context);
            if (usersPresent) {
                thisRole.getErrors().put("actionError", systemStatus.getLabel("object.validation.actionError.activeUsersAssignedToRole"));
            } else {
                recordDeleted = thisRole.delete(db);
                if (!recordDeleted) {
                    thisRole.getErrors().put("actionError", systemStatus.getLabel("object.validation.actionError.roleDeletion"));
                }
            }
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "Roles", "Delete a Role");
        if (recordDeleted) {
            context.getRequest().setAttribute("refreshUrl", (Object)"PortalRoleEditor.do?command=List");
            return "DeleteOK";
        }
        this.processErrors(context, thisRole.getErrors());
        context.getRequest().setAttribute("refreshUrl", (Object)"PortalRoleEditor.do?command=List");
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandActivate(ActionContext context) {
        if (!this.hasPermission(context, "admin-portalroleeditor-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        Role thisRole = null;
        try {
            db = this.getConnection(context);
            User user = this.getUser(context, this.getUserId(context));
            String roleId = context.getRequest().getParameter("id");
            int id = -1;
            if (roleId != null) {
                id = Integer.parseInt(roleId);
                thisRole = new Role(db, id);
                thisRole.setEnabled(true);
                thisRole.setModifiedBy(user.getId());
                thisRole.update(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Roles", "Activate a Role");
        return "ActivateOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeactivate(ActionContext context) {
        if (!this.hasPermission(context, "admin-portalroleeditor-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        Role thisRole = null;
        try {
            db = this.getConnection(context);
            User user = this.getUser(context, this.getUserId(context));
            String roleId = context.getRequest().getParameter("id");
            int id = -1;
            if (roleId != null) {
                id = Integer.parseInt(roleId);
                thisRole = new Role(db, id);
                thisRole.setEnabled(false);
                thisRole.setModifiedBy(user.getId());
                thisRole.update(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Roles", "Deactivate a Role");
        return "DeactivateOK";
    }

    public String executeCommandTrash(ActionContext context) {
        return "";
    }

    public void buildPortalPermissions(ActionContext context, Connection db) throws SQLException {
    }
}

