/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.actions;

import com.darkhorseventures.database.ConnectionPool;
import com.darkhorseventures.framework.actions.ActionContext;
import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.utils.web.RequestUtils;

public final class ProcessSystem
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReloadSystemPrefs(ActionContext context) {
        if (!this.allow(context)) {
            return "PermissionError";
        }
        ConnectionPool sqlDriver = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool");
        Connection db = null;
        Iterator i = this.getSystemIterator(context);
        while (i.hasNext()) {
            SystemStatus systemStatus = (SystemStatus)i.next();
            try {
                db = sqlDriver.getConnection(systemStatus.getConnectionElement());
                systemStatus.buildPreferences(db);
            }
            catch (Exception e) {}
            continue;
            finally {
                sqlDriver.free(db);
            }
        }
        return "ProcessOK";
    }

    public String executeCommandClearSystems(ActionContext context) {
        if (!this.allow(context)) {
            return "PermissionError";
        }
        Iterator i = this.getSystemIterator(context);
        while (i.hasNext()) {
            SystemStatus thisStatus = (SystemStatus)i.next();
            i.remove();
        }
        return "ProcessOK";
    }

    private Iterator getSystemIterator(ActionContext context) {
        Hashtable globalStatus = (Hashtable)context.getServletContext().getAttribute("SystemStatus");
        return globalStatus.values().iterator();
    }

    public String executeCommandPrecompileJSPs(ActionContext context) {
        File baseDir = new File(context.getServletContext().getRealPath("/"));
        this.precompileDirectory(context, baseDir, "/");
        return "ProcessOK";
    }

    private void precompileDirectory(ActionContext context, File thisDirectory, String dir) {
        File[] listing = thisDirectory.listFiles();
        for (int i = 0; i < listing.length; ++i) {
            File thisFile = listing[i];
            if (thisFile.isDirectory()) {
                this.precompileDirectory(context, thisFile, dir + thisFile.getName() + "/");
                continue;
            }
            this.precompileJSP(context, thisFile, dir);
        }
    }

    private void precompileJSP(ActionContext context, File thisFile, String dir) {
        if (thisFile.getName().endsWith(".jsp") && !thisFile.getName().endsWith("_include.jsp") && !thisFile.getName().endsWith("_menu.jsp")) {
            String serverName = "http://" + RequestUtils.getServerUrl(context.getRequest());
            String jsp = serverName + dir + thisFile.getName();
            try {
                URL url = new URL(jsp);
                URLConnection conn = url.openConnection();
                Object result = conn.getContent();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private boolean allow(ActionContext context) {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("IP FROM REQUEST: " + context.getIpAddress());
        }
        try {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Compare to: " + InetAddress.getLocalHost().getHostAddress());
            }
            return "127.0.0.1".equals(context.getIpAddress()) || InetAddress.getLocalHost().getHostAddress().equals(context.getIpAddress());
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized boolean deleteImportedRecords(ActionContext context) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ProcessSystem-> Checking imports for deletion");
        }
        ConnectionPool sqlDriver = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool");
        Connection db = null;
        PreparedStatement pst = null;
        Iterator i = this.getSystemIterator(context);
        while (i.hasNext()) {
            SystemStatus systemStatus = (SystemStatus)i.next();
            try {
                db = sqlDriver.getConnection(systemStatus.getConnectionElement());
                if (db == null) continue;
                db.setAutoCommit(false);
                ResultSet rs = null;
                ArrayList<String> imports = new ArrayList<String>();
                pst = db.prepareStatement("SELECT import_id FROM import WHERE status_id = ? ");
                pst.setInt(1, 8);
                rs = pst.executeQuery();
                while (rs.next()) {
                    imports.add(String.valueOf(rs.getInt("import_id")));
                }
                rs.close();
                pst.close();
                Iterator j = imports.iterator();
                while (j.hasNext()) {
                    int thisImportId = Integer.parseInt((String)j.next());
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("ProcessSystem-> Deleting import " + thisImportId);
                    }
                    pst = db.prepareStatement("DELETE FROM contact_emailaddress WHERE EXISTS (SELECT contact_id from contact c where c.contact_id = contact_emailaddress.contact_id AND import_id = ?) ");
                    pst.setInt(1, thisImportId);
                    pst.executeUpdate();
                    pst.close();
                    pst = db.prepareStatement("DELETE FROM contact_phone WHERE EXISTS (SELECT contact_id from contact c where c.contact_id = contact_phone.contact_id AND import_id = ?) ");
                    pst.setInt(1, thisImportId);
                    pst.executeUpdate();
                    pst.close();
                    pst = db.prepareStatement("DELETE FROM contact_address WHERE EXISTS (SELECT contact_id from contact c where c.contact_id = contact_address.contact_id AND import_id = ?) ");
                    pst.setInt(1, thisImportId);
                    pst.executeUpdate();
                    pst.close();
                    pst = db.prepareStatement("DELETE FROM contact WHERE import_id = ?");
                    pst.setInt(1, thisImportId);
                    pst.executeUpdate();
                    pst.close();
                    pst = db.prepareStatement("DELETE FROM organization WHERE import_id = ?");
                    pst.setInt(1, thisImportId);
                    pst.executeUpdate();
                    pst.close();
                    pst = db.prepareStatement("DELETE FROM import WHERE import_id = ?");
                    pst.setInt(1, thisImportId);
                    pst.executeUpdate();
                    pst.close();
                    db.commit();
                }
            }
            catch (Exception e) {
                if (db != null) {
                    db.rollback();
                }
                throw new SQLException(e.getMessage());
            }
            finally {
                if (db == null) continue;
                db.setAutoCommit(true);
                sqlDriver.free(db);
            }
        }
        return true;
    }
}

