/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionList;
import org.aspcfs.modules.admin.base.Role;
import org.aspcfs.modules.admin.base.RoleList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.PagedListInfo;

public final class Roles
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandListRoles(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListRoles(ActionContext context) {
        if (!this.hasPermission(context, "admin-roles-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        PagedListInfo roleInfo = this.getPagedListInfo(context, "RoleListInfo");
        roleInfo.setLink("Roles.do?command=ListRoles");
        RoleList roleList = new RoleList();
        try {
            db = this.getConnection(context);
            roleList.setPagedListInfo(roleInfo);
            roleList.setBuildUsers(false);
            roleList.setBuildUserCount(true);
            roleList.setRoleType(0);
            roleList.setEnabledState(1);
            roleList.buildList(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Roles", "Role List");
        if (errorMessage == null) {
            context.getRequest().setAttribute("RoleList", (Object)roleList);
            return "ListRolesOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRoleDetails(ActionContext context) {
        if (!this.hasPermission(context, "admin-roles-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String roleId = context.getRequest().getParameter("id");
        String action = context.getRequest().getParameter("action");
        Connection db = null;
        try {
            db = this.getConnection(context);
            PermissionList permissionList = new PermissionList(db);
            context.getRequest().setAttribute("PermissionList", (Object)permissionList);
            Role thisRole = new Role(db, Integer.parseInt(roleId));
            context.getRequest().setAttribute("Role", (Object)thisRole);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (action != null && action.equals("modify")) {
                this.addModuleBean(context, "Roles", "Modify Role Details");
                return "RoleDetailsModifyOK";
            }
            this.addModuleBean(context, "Roles", "View Role Details");
            return "RoleDetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateRole(ActionContext context) {
        if (!this.hasPermission(context, "admin-roles-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = 0;
        boolean isValid = false;
        Role thisRole = (Role)((Object)context.getFormBean());
        thisRole.setRequestItems(context.getRequest());
        thisRole.setModifiedBy(this.getUserId(context));
        thisRole.setRoleType(0);
        try {
            db = this.getConnection(context);
            isValid = this.validateObject(context, db, (Object)thisRole);
            if (isValid) {
                resultCount = thisRole.update(db);
            }
            if (resultCount == 1) {
                this.updateSystemPermissionCheck(db, context);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Roles", "Update Role");
        if (resultCount == -1 || !isValid) {
            return this.executeCommandRoleDetails(context);
        }
        if (resultCount == 1) {
            return "RoleUpdateOK";
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Role thisRole = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        int id = -1;
        if (!this.hasPermission(context, "admin-roles-delete")) {
            return "DefaultError";
        }
        if (context.getRequest().getParameter("id") != null) {
            id = Integer.parseInt(context.getRequest().getParameter("id"));
        }
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisRole = new Role(db, id);
            DependencyList dependencies = thisRole.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            if (dependencies.size() == 0) {
                htmlDialog.setShowAndConfirm(false);
                htmlDialog.setDeleteUrl("javascript:window.location.href='Roles.do?command=DeleteRole&id=" + id + "'");
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.roleUserHeader"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertRoleForm(ActionContext context) {
        if (!this.hasPermission(context, "admin-roles-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        this.addModuleBean(context, "Roles", "Insert a Role");
        Connection db = null;
        try {
            db = this.getConnection(context);
            PermissionList thisPermissionList = new PermissionList(db);
            context.getRequest().setAttribute("PermissionList", (Object)thisPermissionList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "RoleInsertFormOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertRole(ActionContext context) {
        if (!this.hasPermission(context, "admin-roles-add")) {
            return "PermissionError";
        }
        boolean recordInserted = false;
        boolean isValid = false;
        Role thisRole = (Role)((Object)context.getFormBean());
        thisRole.setRequestItems(context.getRequest());
        thisRole.setEnteredBy(this.getUserId(context));
        thisRole.setModifiedBy(this.getUserId(context));
        thisRole.setRoleType(0);
        Connection db = null;
        try {
            db = this.getConnection(context);
            isValid = this.validateObject(context, db, (Object)thisRole);
            if (isValid) {
                recordInserted = thisRole.insert(db);
            }
            if (recordInserted) {
                PermissionList permissionList = new PermissionList(db);
                context.getRequest().setAttribute("PermissionList", (Object)permissionList);
                thisRole = new Role(db, thisRole.getId());
                context.getRequest().setAttribute("Role", (Object)thisRole);
                this.updateSystemPermissionCheck(db, context);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Roles", "Insert a Role");
        if (recordInserted) {
            return "RoleAddOK";
        }
        return this.executeCommandInsertRoleForm(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteRole(ActionContext context) {
        if (!this.hasPermission(context, "admin-roles-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        Role thisRole = null;
        String roleId = context.getRequest().getParameter("id");
        Connection db = null;
        try {
            if (Integer.parseInt(roleId) == 1) {
                throw new Exception("Administrator Role cannot be deleted.");
            }
            db = this.getConnection(context);
            thisRole = new Role(db, Integer.parseInt(roleId));
            boolean usersPresent = thisRole.buildUserCount(db, true);
            SystemStatus systemStatus = this.getSystemStatus(context);
            if (usersPresent) {
                thisRole.getErrors().put("actionError", systemStatus.getLabel("object.validation.actionError.activeUsersAssignedToRole"));
            } else {
                recordDeleted = thisRole.delete(db);
                if (!recordDeleted) {
                    thisRole.getErrors().put("actionError", systemStatus.getLabel("object.validation.actionError.roleDeletion"));
                }
            }
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "Roles", "Delete a Role");
        if (recordDeleted) {
            context.getRequest().setAttribute("refreshUrl", (Object)"Roles.do?command=ListRoles");
            return "DeleteOK";
        }
        this.processErrors(context, thisRole.getErrors());
        context.getRequest().setAttribute("refreshUrl", (Object)"Roles.do?command=ListRoles");
        return "DeleteOK";
    }
}

