/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserGroup;
import org.aspcfs.modules.admin.base.UserGroupList;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupElement;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class UserGroups
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        return this.executeCommandList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        PagedListInfo listInfo = this.getPagedListInfo(context, "userGroupListInfo");
        listInfo.setLink("UserGroups.do?command=List");
        Connection db = null;
        User user = this.getUser(context, this.getUserId(context));
        UserGroupList groups = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            LookupList siteid = new LookupList(db, "lookup_site_id");
            siteid.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteid);
            groups = new UserGroupList();
            groups.setPagedListInfo(listInfo);
            groups.setBuildResources(true);
            if (user.getSiteId() > -1) {
                groups.setSiteId(user.getSiteId());
            } else {
                groups.setIncludeAllSites(true);
            }
            groups.buildList(db);
            context.getRequest().setAttribute("groupList", (Object)groups);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        Connection db = null;
        UserGroup group = (UserGroup)((Object)context.getFormBean());
        if (group == null) {
            group = new UserGroup();
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            context.getRequest().setAttribute("userGroup", (Object)group);
            StringBuffer vectorUserId = new StringBuffer();
            StringBuffer vectorState = new StringBuffer();
            HtmlSelect selCurrentTeam = new HtmlSelect();
            LookupList siteid = new LookupList(db, "lookup_site_id");
            siteid.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteid);
            if (group.getGroupUsers() != null) {
                Iterator iter = group.getGroupUsers().iterator();
                while (iter.hasNext()) {
                    User selUser = (User)((Object)iter.next());
                    if (selUser.getContact().getOrgId() == 0) {
                        selCurrentTeam.addItem(selUser.getId(), selUser.getContact().getNameFirstLast() + (!selUser.getEnabled() ? " (X)" : ""));
                    } else {
                        Organization organization = new Organization(db, selUser.getContact().getOrgId());
                        String userNameForDisplay = selUser.getContact().getNameFirstLast() + " (" + organization.getName() + ")" + (!selUser.getEnabled() || !selUser.getContact().getEnabled() || selUser.getContact().isTrashed() ? " (X)" : "");
                        if (organization.getPrimaryContact() != null && organization.getPrimaryContact().getId() == selUser.getContact().getId()) {
                            userNameForDisplay = selUser.getContact().getNameFirstLast() + (!selUser.getEnabled() || !selUser.getContact().getEnabled() || selUser.getContact().isTrashed() ? " (X)" : "");
                        }
                        selCurrentTeam.addItem(selUser.getId(), userNameForDisplay);
                    }
                    vectorUserId.append(selUser.getId());
                    vectorState.append("user");
                    if (!iter.hasNext()) continue;
                    vectorUserId.append("|");
                    vectorState.append("|");
                }
            }
            context.getRequest().setAttribute("currentTeam", (Object)selCurrentTeam);
            context.getRequest().setAttribute("vectorUserId", (Object)vectorUserId.toString());
            context.getRequest().setAttribute("vectorState", (Object)vectorState.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        Connection db = null;
        UserGroup group = (UserGroup)((Object)context.getFormBean());
        boolean isValid = false;
        boolean recordInserted = false;
        int recordCount = -1;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            group.setModifiedBy(this.getUserId(context));
            if (group.getId() > -1) {
                isValid = this.validateObject(context, db, (Object)group);
                if (isValid) {
                    recordCount = group.update(db);
                    if (group.getInsertMembers() != null || group.getDeleteMembers() != null) {
                        group.updateUserMembership(db);
                    }
                }
            } else {
                isValid = this.validateObject(context, db, (Object)group);
                if (isValid) {
                    recordInserted = group.insert(db);
                    if (group.getInsertMembers() != null || group.getDeleteMembers() != null) {
                        group.updateUserMembership(db);
                    }
                }
            }
            context.getRequest().setAttribute("userGroup", (Object)group);
            if (!isValid || !recordInserted && recordCount == -1) {
                if (group.getId() > -1) {
                    String string = this.executeCommandAdd(context);
                    return string;
                }
                String string = this.executeCommandModify(context);
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SaveOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String groupId = context.getRequest().getParameter("groupId");
        UserGroup group = (UserGroup)((Object)context.getFormBean());
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            if (group.getId() == -1) {
                group = new UserGroup();
                group.setBuildResources(true);
                group.queryRecord(db, Integer.parseInt(groupId));
            }
            LookupList siteid = new LookupList(db, "lookup_site_id");
            siteid.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteid);
            StringBuffer vectorUserId = new StringBuffer();
            StringBuffer vectorState = new StringBuffer();
            HtmlSelect selCurrentTeam = new HtmlSelect();
            if (group.getGroupUsers() != null) {
                Iterator iter = group.getGroupUsers().iterator();
                while (iter.hasNext()) {
                    User selUser = (User)((Object)iter.next());
                    if (selUser.getContact().getOrgId() == 0) {
                        selCurrentTeam.addItem(selUser.getId(), selUser.getContact().getNameFirstLast() + (!selUser.getEnabled() ? " (X)" : ""));
                    } else {
                        Organization organization = new Organization(db, selUser.getContact().getOrgId());
                        String userNameForDisplay = selUser.getContact().getNameFirstLast() + " (" + organization.getName() + ")" + (!selUser.getEnabled() || !selUser.getContact().getEnabled() || selUser.getContact().isTrashed() ? " (X)" : "");
                        if (organization.getPrimaryContact() != null && organization.getPrimaryContact().getId() == selUser.getContact().getId()) {
                            userNameForDisplay = selUser.getContact().getNameFirstLast() + (!selUser.getEnabled() || !selUser.getContact().getEnabled() || selUser.getContact().isTrashed() ? " (X)" : "");
                        }
                        selCurrentTeam.addItem(selUser.getId(), userNameForDisplay);
                    }
                    vectorUserId.append(selUser.getId());
                    vectorState.append("user");
                    if (!iter.hasNext()) continue;
                    vectorUserId.append("|");
                    vectorState.append("|");
                }
            }
            context.getRequest().setAttribute("currentTeam", (Object)selCurrentTeam);
            context.getRequest().setAttribute("vectorUserId", (Object)vectorUserId.toString());
            context.getRequest().setAttribute("vectorState", (Object)vectorState.toString());
            context.getRequest().setAttribute("userGroup", (Object)group);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String groupId = context.getRequest().getParameter("groupId");
        UserGroup group = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            group = new UserGroup();
            group.setBuildResources(true);
            group.queryRecord(db, Integer.parseInt(groupId));
            context.getRequest().setAttribute("userGroup", (Object)group);
            LookupList siteid = new LookupList(db, "lookup_site_id");
            siteid.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteid);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        String groupId = context.getRequest().getParameter("groupId");
        if (groupId == null || "".equals(groupId)) {
            groupId = (String)context.getRequest().getAttribute("groupId");
        }
        Connection db = null;
        UserGroup group = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            group = new UserGroup();
            group.setBuildResources(true);
            group.queryRecord(db, Integer.parseInt(groupId));
            DependencyList dependencies = group.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (dependencies.canDelete()) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("usergroup.dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='UserGroups.do?command=Delete&groupId=" + group.getId() + "';");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.unableHeader"));
                htmlDialog.addButton("OK", "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        String groupId = context.getRequest().getParameter("groupId");
        if (groupId != null && !"".equals(groupId)) {
            context.getRequest().setAttribute("groupId", (Object)groupId);
        }
        UserGroup group = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            group = new UserGroup();
            group.setBuildResources(true);
            group.queryRecord(db, Integer.parseInt(groupId));
            group.delete(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)"UserGroups.do?command=List");
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUsers(ActionContext context) {
        String value = context.getRequest().getParameter("source");
        StringTokenizer st = new StringTokenizer(value, "|");
        String source = st.nextToken();
        String status = st.nextToken();
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            if ("dept".equals(source) && "all".equals(status)) {
                LookupList departmentList = new LookupList(db, "lookup_department");
                departmentList.addItem(0, systemStatus.getLabel("admin.group.withoutADepartment", "Without a department"));
                context.getRequest().setAttribute("departments", (Object)departmentList);
                String string = "MakeDepartmentListOK";
                return string;
            }
            if ("acct".equals(source) && "all".equals(status)) {
                LookupList accountTypeList = new LookupList(db, "lookup_account_types");
                accountTypeList.addItem(0, systemStatus.getLabel("admin.group.withoutAType", "Without a type"));
                context.getRequest().setAttribute("accountTypes", (Object)accountTypeList);
                String string = "MakeAccountTypeListOK";
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandItems(ActionContext context) {
        String value = context.getRequest().getParameter("source");
        String siteId = context.getRequest().getParameter("siteId");
        if (!UserGroups.isSiteAccessPermitted(context, siteId)) {
            return "PermissionError";
        }
        StringTokenizer st = new StringTokenizer(value, "|");
        String source = st.nextToken();
        String status = st.nextToken();
        String id = st.nextToken();
        Connection db = null;
        try {
            db = this.getConnection(context);
            if ("dept".equals(source) && "all".equals(status)) {
                UserList users = new UserList();
                users.setDepartment(Integer.parseInt(id));
                users.setBuildEmployeeUsersOnly(true);
                users.setSiteId(siteId);
                users.setEnabled(1);
                users.setIncludeUsersWithAccessToAllSites(true);
                users.buildList(db);
                context.getRequest().setAttribute("UserList", (Object)users);
                String string = "MakeUserListOK";
                return string;
            }
            if ("acct".equals(source) && "all".equals(status)) {
                UserList allAccountUsers = new UserList();
                allAccountUsers.setBuildAccountUsersOnly(true);
                allAccountUsers.setRoleType(0);
                allAccountUsers.setBuildContactDetails(true);
                allAccountUsers.setSiteId(siteId);
                allAccountUsers.setIncludeUsersWithAccessToAllSites(true);
                allAccountUsers.setEnabled(1);
                allAccountUsers.buildList(db);
                Iterator itr = allAccountUsers.iterator();
                UserList users = new UserList();
                while (itr.hasNext()) {
                    User thisUser = (User)((Object)itr.next());
                    Organization organization = new Organization(db, thisUser.getContact().getOrgId());
                    if (organization.getPrimaryContact() != null) {
                        if (organization.getPrimaryContact().getId() != thisUser.getContact().getId()) {
                            thisUser.getContact().setNameLast(thisUser.getContact().getNameLast() + " (" + organization.getName() + ")");
                        }
                    } else {
                        thisUser.getContact().setNameLast(thisUser.getContact().getNameLast() + " (" + organization.getName() + ")");
                    }
                    Iterator typesIterator = organization.getTypes().iterator();
                    if (organization.getTypes().size() == 0 && Integer.parseInt(id) == 0) {
                        users.add(thisUser);
                        continue;
                    }
                    while (typesIterator.hasNext()) {
                        LookupElement lookupElement = (LookupElement)typesIterator.next();
                        if (lookupElement.getCode() != Integer.parseInt(id)) continue;
                        users.add(thisUser);
                    }
                }
                context.getRequest().setAttribute("UserList", (Object)users);
                String string = "MakeUserListOK";
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandGroupList(ActionContext context) {
        if (!this.hasPermission(context, "admin-view")) {
            return "PermissionError";
        }
        String userId = context.getRequest().getParameter("userId");
        PagedListInfo listInfo = this.getPagedListInfo(context, "groupListInfo");
        listInfo.setLink("UserGroups.do?command=GroupList&userId=" + userId);
        Connection db = null;
        UserGroupList groups = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            User user = this.getUser(context, Integer.parseInt(userId));
            context.getRequest().setAttribute("thisUser", (Object)user);
            UserGroupList completeGroupList = new UserGroupList();
            completeGroupList.setUserId(userId);
            if (user.getSiteId() > -1) {
                completeGroupList.setSiteId(user.getSiteId());
                completeGroupList.setExclusiveToSite(true);
            } else {
                completeGroupList.setIncludeAllSites(true);
            }
            completeGroupList.buildList(db);
            context.getRequest().setAttribute("completeGroupList", (Object)completeGroupList);
            groups = new UserGroupList();
            groups.setUserId(userId);
            if (user.getSiteId() > -1) {
                groups.setSiteId(user.getSiteId());
                groups.setExclusiveToSite(true);
            } else {
                groups.setIncludeAllSites(true);
            }
            groups.setBuildUserCount(true);
            groups.setPagedListInfo(listInfo);
            groups.buildList(db);
            context.getRequest().setAttribute("groupList", (Object)groups);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "GroupListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeCommandPopupSelector(ActionContext context) {
        UserGroupList selectList;
        Connection db;
        block36: {
            String string;
            block35: {
                block34: {
                    block33: {
                        db = null;
                        User user = null;
                        String userId = context.getRequest().getParameter("userId");
                        String campaignId = context.getRequest().getParameter("campaignId");
                        if (campaignId == null || "".equals(campaignId.trim())) {
                            campaignId = (String)context.getRequest().getAttribute("campaignId");
                        }
                        selectList = new UserGroupList();
                        boolean listDone = false;
                        String displayFieldId = null;
                        String type = context.getRequest().getParameter("type");
                        if (type != null && !"".equals(type)) {
                            context.getRequest().setAttribute("type", (Object)type);
                        }
                        PagedListInfo userGroupSelectorInfo = this.getPagedListInfo(context, "UserGroupSelectorInfo");
                        String tableName = context.getRequest().getParameter("table");
                        HashMap selectedList = new HashMap();
                        try {
                            HashMap finalElementList = (HashMap)context.getSession().getAttribute("finalElements");
                            if (context.getRequest().getParameter("previousSelection") != null) {
                                int j = 0;
                                StringTokenizer st = new StringTokenizer(context.getRequest().getParameter("previousSelection"), "|");
                                StringTokenizer st1 = new StringTokenizer(context.getRequest().getParameter("previousSelectionDisplay"), "|");
                                while (st.hasMoreTokens()) {
                                    selectedList.put(new Integer(st.nextToken()), st1.nextToken());
                                    ++j;
                                }
                            } else {
                                selectedList = (HashMap)context.getSession().getAttribute("selectedElements");
                            }
                            if (context.getRequest().getParameter("displayFieldId") != null) {
                                displayFieldId = context.getRequest().getParameter("displayFieldId");
                            }
                            if (context.getRequest().getParameter("flushtemplist") != null && context.getRequest().getParameter("flushtemplist").equalsIgnoreCase("true") && context.getSession().getAttribute("finalElements") != null && context.getRequest().getParameter("previousSelection") == null) {
                                selectedList = (HashMap)((HashMap)context.getSession().getAttribute("finalElements")).clone();
                            }
                            int rowCount = 1;
                            while (context.getRequest().getParameter("hiddenelementid" + rowCount) != null) {
                                int elementId = 0;
                                String elementValue = "";
                                elementId = Integer.parseInt(context.getRequest().getParameter("hiddenelementid" + rowCount));
                                if (context.getRequest().getParameter("checkelement" + rowCount) != null) {
                                    if (context.getRequest().getParameter("elementvalue" + rowCount) != null) {
                                        elementValue = context.getRequest().getParameter("elementvalue" + rowCount);
                                    }
                                    if (selectedList.get(new Integer(elementId)) == null) {
                                        selectedList.put(new Integer(elementId), elementValue);
                                    } else {
                                        selectedList.remove(new Integer(elementId));
                                        selectedList.put(new Integer(elementId), elementValue);
                                    }
                                } else {
                                    selectedList.remove(new Integer(elementId));
                                }
                                ++rowCount;
                            }
                            context.getSession().setAttribute("selectedElements", (Object)selectedList);
                            context.getRequest().setAttribute("DisplayFieldId", (Object)displayFieldId);
                            context.getRequest().setAttribute("Table", (Object)tableName);
                            db = this.getConnection(context);
                            if (userId != null && !"".equals(userId.trim()) && !"-1".equals(userId.trim())) {
                                user = this.getUser(context, Integer.parseInt(userId));
                                if (user.getSiteId() > -1) {
                                    selectList.setExclusiveToSite(true);
                                    selectList.setSiteId(user.getSiteId());
                                } else {
                                    selectList.setIncludeAllSites(true);
                                }
                                context.getRequest().setAttribute("thisUser", (Object)user);
                            }
                            if (context.getRequest().getParameter("finalsubmit") != null && context.getRequest().getParameter("finalsubmit").equalsIgnoreCase("true")) {
                                context.getSession().removeAttribute("selectedElements");
                                context.getSession().removeAttribute("finalElements");
                                if (displayFieldId != null && !"".equals(displayFieldId)) {
                                    if (displayFieldId.equals("groups")) {
                                        string = this.saveUserGroups(context, db, selectedList, userId);
                                        context.getRequest().setAttribute("baseList", (Object)selectList);
                                        break block33;
                                    }
                                    if (displayFieldId.equals("campaign")) {
                                        context.getRequest().setAttribute("selectedList", (Object)selectedList);
                                        if (type != null && !"".equals(type) && "active".equals(type)) {
                                            string = "ReturnSaveCampaignUserGroupsOK";
                                            context.getRequest().setAttribute("baseList", (Object)selectList);
                                            break block34;
                                        }
                                        string = "SaveCampaignUserGroupsOK";
                                        context.getRequest().setAttribute("baseList", (Object)selectList);
                                        break block35;
                                    }
                                }
                            }
                            selectList.setPagedListInfo(userGroupSelectorInfo);
                            if (userId != null && !"".equals(userId.trim()) && !"-1".equals(userId.trim())) {
                                selectList.setGetEnabledForUser(1, Integer.parseInt(userId));
                            }
                            if (campaignId != null && !"".equals(campaignId.trim()) && !"-1".equals(campaignId.trim())) {
                                context.getRequest().setAttribute("campaignId", (Object)campaignId);
                                selectList.setGetEnabledForCampaign(1, Integer.parseInt(campaignId));
                            }
                            if (campaignId != null && !"".equals(campaignId.trim())) {
                                user = this.getUser(context, this.getUserId(context));
                                selectList.setIncludeAllSites(false);
                                selectList.setExclusiveToSite(false);
                                selectList.setSiteId(user.getSiteId());
                                selectList.setEnabled(1);
                            }
                            selectList.buildList(db);
                            context.getRequest().setAttribute("baseList", (Object)selectList);
                            break block36;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            context.getRequest().setAttribute("Error", (Object)e);
                            String string2 = "SystemError";
                            return string2;
                        }
                    }
                    this.freeConnection(context, db);
                    return string;
                }
                this.freeConnection(context, db);
                return string;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return "PopLookupOK";
        finally {
            context.getRequest().setAttribute("baseList", (Object)selectList);
            this.freeConnection(context, db);
        }
    }

    public String saveUserGroups(ActionContext context, Connection db, HashMap finalSelections, String userId) throws SQLException {
        try {
            UserGroupList oldGroupList = new UserGroupList();
            oldGroupList.setUserId(userId);
            oldGroupList.setIncludeAllSites(true);
            oldGroupList.buildList(db);
            oldGroupList.addUsersForGroups(db, finalSelections, Integer.parseInt(userId));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        return "SaveUserGroupsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPopupSingleSelector(ActionContext context) {
        Connection db = null;
        UserGroupList groupList = null;
        try {
            db = this.getConnection(context);
            String nonSiteSpecific = context.getRequest().getParameter("nonSiteSpecific");
            String userId = context.getRequest().getParameter("userId");
            String displayFieldId = context.getRequest().getParameter("displayFieldId");
            String hiddenFieldId = context.getRequest().getParameter("hiddenFieldId");
            String siteId = context.getRequest().getParameter("siteId");
            String includeAllSites = context.getRequest().getParameter("includeAllSites");
            User user = null;
            user = userId != null && !"".equals(userId.trim()) ? this.getUser(context, Integer.parseInt(userId)) : this.getUser(context, this.getUserId(context));
            if (!UserGroups.isSiteAccessPermitted(context, siteId)) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("thisUser", (Object)user);
            PagedListInfo oppPagedInfo = this.getPagedListInfo(context, "groupUsersListInfo");
            oppPagedInfo.setLink("UserGroups.do?command=PopupSingleSelector&userId=" + (userId != null ? userId : "") + "&siteId=" + (siteId != null ? siteId : "") + "&hiddenFieldId=" + hiddenFieldId + "&displayFieldId=" + displayFieldId);
            groupList = new UserGroupList();
            groupList.setPagedListInfo(oppPagedInfo);
            if (siteId != null && !"".equals(siteId.trim())) {
                groupList.setSiteId(siteId);
            }
            if (includeAllSites != null && !"".equals(includeAllSites.trim())) {
                groupList.setIncludeAllSites(includeAllSites);
            }
            groupList.setEnabled(1);
            groupList.setBuildResources(true);
            groupList.buildList(db);
            context.getRequest().setAttribute("displayFieldId", (Object)displayFieldId);
            context.getRequest().setAttribute("hiddenFieldId", (Object)hiddenFieldId);
            context.getRequest().setAttribute("userId", (Object)userId);
            LookupList siteid = new LookupList(db, "lookup_site_id");
            siteid.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteid);
            context.getRequest().setAttribute("groupList", (Object)groupList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListSingleOK";
    }
}

