/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.hooks.CustomHook;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessLogList;
import org.aspcfs.modules.admin.base.RoleList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserEmail;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.BatchInfo;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class Users
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandListUsers(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListUsers(ActionContext context) {
        if (!this.hasPermission(context, "admin-users-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        UserList list = new UserList();
        RoleList roleList = new RoleList();
        PagedListInfo listInfo = this.getPagedListInfo(context, "UserListInfo");
        listInfo.setLink("Users.do?command=ListUsers");
        BatchInfo batchInfo = new BatchInfo("batchUsers");
        batchInfo.setAction("Users.do?command=ProcessBatch");
        try {
            db = this.getConnection(context);
            if ("disabled".equals(listInfo.getListView())) {
                list.setEnabled(0);
                list.setIncludeAliases(-1);
            } else if ("aliases".equals(listInfo.getListView())) {
                list.setEnabled(1);
                list.setIncludeAliases(1);
            } else {
                list.setEnabled(1);
                list.setIncludeAliases(-1);
            }
            list.setPagedListInfo(listInfo);
            list.setBuildContact(false);
            list.setBuildContactDetails(false);
            list.setBuildHierarchy(false);
            list.setRoleType(0);
            list.setRoleId(listInfo.getFilterKey("listFilter1"));
            list.setSiteId(this.getUserSiteId(context));
            list.buildList(db);
            roleList.setBuildUsers(false);
            roleList.setRoleType(0);
            roleList.setEnabledState(1);
            roleList.setEmptyHtmlSelectRecord(this.getSystemStatus(context).getLabel("accounts.any"));
            roleList.setJsEvent("onChange=\"javascript:document.userForm.submit();\"");
            roleList.buildList(db);
            context.getRequest().setAttribute("roleList", (Object)roleList);
            batchInfo.setSize(list.size());
            context.getRequest().setAttribute("userListBatchInfo", (Object)batchInfo);
            context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Users", "User List");
        if (errorMessage == null) {
            context.getRequest().setAttribute("UserList", (Object)list);
            return "ListUsersOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewLog(ActionContext context) {
        if (!this.hasPermission(context, "admin-users-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        PagedListInfo listInfo = this.getPagedListInfo(context, "AccessLogInfo");
        listInfo.setLink("Users.do?command=ViewLog&id=" + context.getRequest().getParameter("id"));
        Connection db = null;
        AccessLogList list = new AccessLogList();
        int userId = -1;
        User newUser = null;
        if (context.getRequest().getParameter("id") != null) {
            userId = Integer.parseInt(context.getRequest().getParameter("id"));
        }
        try {
            db = this.getConnection(context);
            newUser = new User();
            newUser.setBuildContact(true);
            newUser.buildRecord(db, userId);
            list.setUserId(userId);
            list.setPagedListInfo(listInfo);
            list.buildList(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Users", "View User Details");
        if (errorMessage == null) {
            context.getRequest().setAttribute("UserRecord", (Object)newUser);
            context.getRequest().setAttribute("AccessLog", (Object)list);
            return "ViewLogOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUserDetails(ActionContext context) {
        if (!this.hasPermission(context, "admin-users-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String id = context.getRequest().getParameter("id");
        String action = context.getRequest().getParameter("action");
        Connection db = null;
        User thisUser = new User();
        try {
            db = this.getConnection(context);
            thisUser.setBuildContact(true);
            thisUser.buildRecord(db, Integer.parseInt(id));
            context.getRequest().setAttribute("UserRecord", (Object)thisUser);
            this.addRecentItem(context, (Object)thisUser);
            if (action != null && action.equals("modify")) {
                // empty if block
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (action != null && action.equals("modify")) {
                this.addModuleBean(context, "Users", "Modify User Details");
                return "UserDetailsModifyOK";
            }
            this.addModuleBean(context, "Users", "View User Details");
            return "UserDetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertUserForm(ActionContext context) {
        if (!this.hasPermission(context, "admin-users-add")) {
            return "PermissionError";
        }
        Connection db = null;
        this.addModuleBean(context, "Add User", "Add New User");
        try {
            db = this.getConnection(context);
            String value = CustomHook.populateUser((Connection)db, (String)Users.getPref(context, "FILELIBRARY"));
            if (value != null) {
                String string = value;
                return string;
            }
            User user = (User)((Object)context.getFormBean());
            if (user.getUsername() == null) {
                user.setHasHttpApiAccess(true);
                user.setHasWebdavAccess(true);
            }
            RoleList roleList = new RoleList();
            roleList.setBuildUsers(false);
            roleList.setEmptyHtmlSelectRecord(this.getSystemStatus(context).getLabel("admin.users.pleaseSelect"));
            roleList.setRoleType(0);
            roleList.setEnabledState(1);
            roleList.buildList(db);
            context.getRequest().setAttribute("RoleList", (Object)roleList);
            UserList userList = new UserList();
            userList.setEmptyHtmlSelectRecord(this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            userList.setBuildContact(false);
            userList.setExcludeDisabledIfUnselected(true);
            userList.setExcludeExpiredIfUnselected(true);
            userList.setBuildContactDetails(false);
            userList.setRoleType(0);
            userList.setSiteId(this.getUserSiteId(context));
            userList.setIncludeUsersWithAccessToAllSites(true);
            userList.buildList(db);
            context.getRequest().setAttribute("UserList", (Object)userList);
            LookupList siteid = new LookupList(db, "lookup_site_id");
            siteid.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteid);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "UserInsertFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String executeCommandAddUser(ActionContext context) {
        block35: {
            if (!this.hasPermission(context, "admin-users-add")) {
                return "PermissionError";
            }
            prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
            db = null;
            generatePassword = context.getRequest().getParameter("generatePassword");
            recordInserted = false;
            hasEmailAddress = false;
            insertedUser = null;
            var8_8 = this;
            synchronized (var8_8) {
                db = this.getConnection(context);
                value = CustomHook.populateUser((Connection)db, (String)Users.getPref(context, "FILELIBRARY"));
                if (value == null) ** break block30
                var10_11 = value;
            }
            this.freeConnection(context, db);
            return var10_11;
            {
                thisUser = (User)context.getFormBean();
                if (context.getRequest().getParameter("typeId") != null) {
                    thisUser.getContact().addType(context.getRequest().getParameter("typeId"));
                }
                systemStatus = this.getSystemStatus(context);
                errors = new HashMap<String, String>();
                if (thisUser.getManagerId() == -1) ** break block31
                manager = this.getUser(context, thisUser.getManagerId());
                if (manager.getEnabled()) ** break block32
                errors.put("actionError", systemStatus.getLabel("object.validation.genericActionError"));
                errors.put("managerIdError", systemStatus.getLabel("admin.disabledManager.text"));
                errors.putAll(thisUser.getErrors());
                if (thisUser.getContactId() != -1) {
                    thisUser.setContact(new Contact(db, thisUser.getContactId()));
                }
                context.getRequest().setAttribute("UserRecord", (Object)thisUser);
                this.processErrors(context, errors);
                if (generatePassword != null && "true".equals(generatePassword)) {
                    context.getRequest().setAttribute("generatePassword", (Object)generatePassword);
                }
                var14_16 = this.executeCommandInsertUserForm(context);
            }
            this.freeConnection(context, db);
            return var14_16;
            {
                if (manager.getSiteId() == -1 || manager.getSiteId() == thisUser.getSiteId() && thisUser.getSiteId() != -1) ** break block31
                errors.put("actionError", systemStatus.getLabel("admin.notTheSameSiteAsManager.text"));
                errors.putAll(thisUser.getErrors());
                if (thisUser.getContactId() != -1) {
                    thisUser.setContact(new Contact(db, thisUser.getContactId()));
                }
                context.getRequest().setAttribute("UserRecord", (Object)thisUser);
                this.processErrors(context, errors);
                if (generatePassword != null && "true".equals(generatePassword)) {
                    context.getRequest().setAttribute("generatePassword", (Object)generatePassword);
                }
                var14_17 = this.executeCommandInsertUserForm(context);
            }
            this.freeConnection(context, db);
            return var14_17;
            {
                contactForUser = new Contact(db, thisUser.getContactId());
                if (contactForUser.getPrimaryEmailAddress() != null && !"".equals(contactForUser.getPrimaryEmailAddress())) {
                    hasEmailAddress = true;
                }
                if (generatePassword == null || !"true".equals(generatePassword)) ** GOTO lbl81
                if (hasEmailAddress) ** break block33
                errors.put("password1Error", systemStatus.getLabel("admin.generatePasswordError.text"));
                errors.putAll(thisUser.getErrors());
                this.processErrors(context, errors);
                if (thisUser.getContactId() != -1) {
                    thisUser.setContact(contactForUser);
                }
                context.getRequest().setAttribute("UserRecord", (Object)thisUser);
                var14_18 = this.executeCommandInsertUserForm(context);
            }
            this.freeConnection(context, db);
            return var14_18;
            {
                password = null;
                password = String.valueOf(StringUtils.rand(100000, 999999));
                thisUser.setPassword1(password);
                thisUser.setPassword2(password);
lbl81:
                // 2 sources

                if (contactForUser.getSiteId() == thisUser.getSiteId()) ** break block34
                errors.put("actionError", systemStatus.getLabel("admin.notTheSameSiteAsContact.text"));
                errors.putAll(thisUser.getErrors());
                this.processErrors(context, errors);
                if (thisUser.getContactId() != -1) {
                    thisUser.setContact(contactForUser);
                }
                context.getRequest().setAttribute("UserRecord", (Object)thisUser);
                if (generatePassword != null && "true".equals(generatePassword)) {
                    context.getRequest().setAttribute("generatePassword", (Object)generatePassword);
                }
                password = this.executeCommandInsertUserForm(context);
            }
            this.freeConnection(context, db);
            return password;
            {
                try {
                    thisUser.setEnteredBy(this.getUserId(context));
                    thisUser.setModifiedBy(this.getUserId(context));
                    thisUser.setTimeZone(prefs.get("SYSTEM.TIMEZONE"));
                    thisUser.setCurrency(prefs.get("SYSTEM.CURRENCY"));
                    thisUser.setLanguage(systemStatus.getLanguage());
                    recordInserted = thisUser.insert(db, context);
                    if (recordInserted) {
                        insertedUser = new User();
                        insertedUser.setBuildContact(true);
                        insertedUser.setBuildContactDetails(true);
                        insertedUser.buildRecord(db, thisUser.getId());
                        this.addRecentItem(context, (Object)insertedUser);
                        context.getRequest().setAttribute("UserRecord", (Object)insertedUser);
                        this.updateSystemHierarchyCheck(db, context);
                        if (generatePassword != null && "true".equals(generatePassword)) {
                            templateFile = Users.getDbNamePath(context) + "templates_" + this.getUserLanguage(context) + ".xml";
                            if (!FileUtils.fileExists(templateFile)) {
                                templateFile = Users.getDbNamePath(context) + "templates_en_US.xml";
                            }
                            modifiedByUser = new User();
                            modifiedByUser.setBuildContact(true);
                            modifiedByUser.setBuildContactDetails(true);
                            modifiedByUser.buildRecord(db, this.getUserId(context));
                            this.sendEmail(context, insertedUser, modifiedByUser, templateFile, thisUser.getPassword1());
                        }
                    } else {
                        if (generatePassword != null && "true".equals(generatePassword)) {
                            context.getRequest().setAttribute("generatePassword", (Object)generatePassword);
                        }
                        if (thisUser.getContactId() != -1) {
                            thisUser.setContact(new Contact(db, thisUser.getContactId()));
                        }
                        context.getRequest().setAttribute("UserRecord", (Object)thisUser);
                        this.processErrors(context, thisUser.getErrors());
                    }
                    break block35;
                    {
                        catch (Throwable var16_21) {
                            throw var16_21;
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        context.getRequest().setAttribute("Error", (Object)e);
                        var9_10 = "SystemError";
                    }
                    catch (Throwable var17_22) {
                        this.freeConnection(context, db);
                        throw var17_22;
                    }
                    this.freeConnection(context, db);
                    return var9_10;
                }
            }
        }
        this.freeConnection(context, db);
        if (recordInserted) {
            return "UserDetailsOK";
        }
        return this.executeCommandInsertUserForm(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteUser(ActionContext context) {
        if (!this.hasPermission(context, "admin-users-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        User thisUser = null;
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            thisUser = new User(db, context.getRequest().getParameter("id"));
            recordDeleted = thisUser.disable(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Users", "Delete User");
        if (recordDeleted) {
            return "UserDeleteOK";
        }
        thisUser.getErrors().put("actionError", systemStatus.getLabel("object.validation.actionError.userDeletion"));
        this.processErrors(context, thisUser.getErrors());
        return this.executeCommandListUsers(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDisableUser(ActionContext context) {
        if (!this.hasPermission(context, "admin-users-delete")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        boolean recordDisabled = false;
        User thisUser = null;
        Ticket thisTicket = null;
        User thisRec = ((UserBean)((Object)context.getSession().getAttribute("User"))).getUserRecord();
        User managerUser = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisUser = new User(db, context.getRequest().getParameter("id"));
            if (context.getRequest().getParameter("disablecontact") != null) {
                Contact thisContact = new Contact(db, thisUser.getContactId());
                thisContact.disable(db);
            }
            if (recordDisabled = thisUser.disable(db)) {
                thisTicket = new Ticket();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("${thisUser.username}", thisUser.getUsername());
                map.put("${thisRec.username}", thisRec.getUsername());
                Template template = new Template(systemStatus.getLabel("ticket.problem.userDisabled"));
                template.setParseElements(map);
                thisTicket.setProblem(template.getParsedText());
                thisTicket.setEnteredBy(thisRec.getId());
                thisTicket.setModifiedBy(thisRec.getId());
                thisTicket.setOrgId(0);
                thisTicket.setContactId(thisUser.getContactId());
                thisTicket.setSeverityCode(3);
                thisTicket.setPriorityCode(3);
                if (thisUser.getManagerId() > -1) {
                    managerUser = new User();
                    managerUser.setBuildContact(true);
                    managerUser.buildRecord(db, thisUser.getManagerId());
                    this.updateSystemHierarchyCheck(db, context);
                    thisTicket.setAssignedTo(thisUser.getManagerId());
                    thisTicket.setDepartmentCode(managerUser.getContact().getDepartment());
                } else {
                    thisTicket.setDepartmentCode(thisUser.getContact().getDepartment());
                }
                thisTicket.insert(db);
            } else {
                thisUser.getErrors().put("actionError", systemStatus.getLabel("object.validation.actionError.userNotDisabled"));
                this.processErrors(context, thisUser.getErrors());
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Users", "Delete User");
        if (recordDisabled) {
            return "UserDeleteOK";
        }
        this.processErrors(context, thisUser.getErrors());
        return this.executeCommandListUsers(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String executeCommandEnableUser(ActionContext context) {
        Connection db;
        User thisUser;
        boolean recordEnabled;
        SystemStatus systemStatus;
        block13: {
            String string;
            block12: {
                if (!this.hasPermission(context, "admin-users-edit")) {
                    return "PermissionError";
                }
                systemStatus = this.getSystemStatus(context);
                recordEnabled = false;
                thisUser = null;
                db = null;
                Users users = this;
                // MONITORENTER : users
                db = this.getConnection(context);
                String value = CustomHook.populateUser((Connection)db, (String)Users.getPref(context, "FILELIBRARY"));
                if (value == null) break block12;
                String string2 = value;
                // MONITOREXIT : users
                this.freeConnection(context, db);
                return string2;
            }
            try {
                thisUser = new User(db, context.getRequest().getParameter("id"));
                Contact thisContact = new Contact(db, thisUser.getContactId());
                if (thisContact.getEnabled() && !thisContact.isTrashed()) break block13;
                string = "PermissionError";
                // MONITOREXIT : users
            }
            catch (Exception e) {
                String string3;
                try {
                    context.getRequest().setAttribute("Error", (Object)e);
                    string3 = "SystemError";
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
                return string3;
            }
            this.freeConnection(context, db);
            return string;
        }
        recordEnabled = thisUser.enable(db);
        if (recordEnabled) {
            this.updateSystemHierarchyCheck(db, context);
        } else {
            thisUser.getErrors().put("actionError", systemStatus.getLabel("object.validation.actionError.userNotEnabled"));
            this.processErrors(context, thisUser.getErrors());
        }
        // MONITOREXIT : users
        this.freeConnection(context, db);
        this.addModuleBean(context, "View Users", "Enable User");
        if (recordEnabled) return this.executeCommandListUsers(context);
        this.processErrors(context, thisUser.getErrors());
        return this.executeCommandListUsers(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDisableUserConfirm(ActionContext context) {
        if (!this.hasPermission(context, "admin-users-delete")) {
            return "PermissionError";
        }
        User thisUser = null;
        User managerUser = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisUser = new User();
            thisUser.setBuildContact(true);
            thisUser.buildRecord(db, Integer.parseInt(context.getRequest().getParameter("id")));
            if (thisUser.getManagerId() > -1) {
                managerUser = new User();
                managerUser.setBuildContact(true);
                managerUser.buildRecord(db, thisUser.getManagerId());
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Users", "Disable User");
        context.getRequest().setAttribute("User", (Object)thisUser);
        context.getRequest().setAttribute("ManagerUser", (Object)managerUser);
        return "UserDisableConfirmOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyUser(ActionContext context) {
        if (!this.hasPermission(context, "admin-users-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Users", "Modify User");
        Connection db = null;
        User newUser = null;
        String userId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            newUser = new User();
            newUser.setBuildContact(true);
            newUser.setBuildContactDetails(true);
            newUser.buildRecord(db, Integer.parseInt(userId));
            UserList userList = new UserList();
            userList.setEmptyHtmlSelectRecord(this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            userList.setBuildContact(false);
            userList.setBuildContactDetails(false);
            userList.setExcludeDisabledIfUnselected(true);
            userList.setExcludeExpiredIfUnselected(true);
            userList.setRoleType(0);
            userList.setSiteId(newUser.getSiteId());
            userList.setIncludeUsersWithAccessToAllSites(true);
            userList.buildList(db);
            context.getRequest().setAttribute("UserList", (Object)userList);
            RoleList roleList = new RoleList();
            roleList.setBuildUsers(false);
            roleList.setEmptyHtmlSelectRecord(this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            roleList.setEnabledState(1);
            roleList.setRoleType(0);
            roleList.buildList(db);
            context.getRequest().setAttribute("RoleList", (Object)roleList);
            LookupList siteid = new LookupList(db, "lookup_site_id");
            siteid.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteid);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("UserRecord", (Object)newUser);
        return "UserModifyOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateUser(ActionContext context) {
        if (!this.hasPermission(context, "admin-users-edit")) {
            return "PermissionError";
        }
        User newUser = (User)((Object)context.getFormBean());
        User manager = null;
        Connection db = null;
        int resultCount = -1;
        boolean isValid = true;
        boolean siteChangeAllowed = false;
        try {
            db = this.getConnection(context);
            newUser.setModifiedBy(this.getUserId(context));
            SystemStatus systemStatus = this.getSystemStatus(context);
            if (newUser.getManagerId() != -1) {
                manager = this.getUser(context, newUser.getManagerId());
                if (!manager.getEnabled()) {
                    newUser.getErrors().put("actionError", systemStatus.getLabel("object.validation.genericActionError"));
                    newUser.getErrors().put("managerIdError", systemStatus.getLabel("admin.disabledManager.text"));
                    isValid = false;
                } else if (manager.getSiteId() != -1 && (manager.getSiteId() != newUser.getSiteId() || newUser.getSiteId() == -1)) {
                    newUser.getErrors().put("actionError", systemStatus.getLabel("admin.notTheSameSiteAsManager.text"));
                    if (newUser.getContactId() != -1) {
                        newUser.setContact(new Contact(db, newUser.getContactId()));
                    }
                    isValid = false;
                }
            }
            User thisUser = this.getUser(context, this.getUserId(context));
            User oldUser = this.getUser(context, newUser.getId());
            if (newUser.getSiteId() != oldUser.getSiteId() && isValid) {
                if (thisUser.getSiteId() == -1) {
                    Contact contactForUser = new Contact(db, newUser.getContactId());
                    if (newUser.getSiteId() != -1) {
                        if (thisUser.getId() == oldUser.getId()) {
                            UserList nullSiteUserList = new UserList();
                            nullSiteUserList.setIncludeUsersWithAccessToAllSites(true);
                            nullSiteUserList.buildList(db);
                            if (nullSiteUserList.size() == 0) {
                                isValid = false;
                                newUser.getErrors().put("siteIdError", systemStatus.getLabel("object.validation.noOtherUserWithAccessToAllSitesExist.text"));
                            }
                        }
                        if (!contactForUser.getEmployee() || contactForUser.getOrgId() > 0) {
                            isValid = false;
                            newUser.getErrors().put("siteIdError", systemStatus.getLabel("object.validation.siteChangeNotAllowed"));
                        }
                        boolean bl = isValid = this.validateObject(context, db, (Object)newUser) && isValid;
                        if (isValid) {
                            siteChangeAllowed = true;
                        }
                    } else {
                        isValid = true;
                        siteChangeAllowed = true;
                        if (!contactForUser.getEmployee()) {
                            isValid = false;
                            newUser.getErrors().put("siteIdError", systemStatus.getLabel("object.validation.siteChangeNotAllowed"));
                            isValid = this.validateObject(context, db, (Object)newUser) && isValid;
                        }
                    }
                } else {
                    isValid = false;
                    newUser.getErrors().put("actionError", systemStatus.getLabel("object.validation.siteChangeNotAllowed"));
                }
            }
            if (isValid) {
                resultCount = newUser.update(db, context);
            }
            if (resultCount == -1) {
                this.processErrors(context, newUser.getErrors());
                newUser.setBuildContact(true);
                newUser.buildResources(db);
                context.getRequest().setAttribute("UserRecord", (Object)newUser);
                UserList userList = new UserList();
                userList.setEmptyHtmlSelectRecord(this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
                userList.setBuildContact(false);
                userList.setBuildContactDetails(false);
                userList.setExcludeDisabledIfUnselected(true);
                userList.setExcludeExpiredIfUnselected(true);
                userList.setRoleType(0);
                userList.setSiteId(newUser.getSiteId());
                userList.setIncludeUsersWithAccessToAllSites(true);
                userList.buildList(db);
                context.getRequest().setAttribute("UserList", (Object)userList);
                RoleList roleList = new RoleList();
                roleList.setBuildUsers(false);
                roleList.setEmptyHtmlSelectRecord(this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
                roleList.setEnabledState(1);
                roleList.setRoleType(0);
                roleList.buildList(db);
                context.getRequest().setAttribute("RoleList", (Object)roleList);
                LookupList siteid = new LookupList(db, "lookup_site_id");
                siteid.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
                context.getRequest().setAttribute("SiteIdList", (Object)siteid);
            } else if (resultCount == 1) {
                if (context.getRequest().getParameter("generatePass") != null) {
                    String password = newUser.generateRandomPassword(db);
                    newUser.setBuildContact(true);
                    newUser.setBuildContactDetails(true);
                    newUser.buildRecord(db, newUser.getId());
                    String templateFile = Users.getDbNamePath(context) + "templates_" + this.getUserLanguage(context) + ".xml";
                    if (!FileUtils.fileExists(templateFile)) {
                        templateFile = Users.getDbNamePath(context) + "templates_en_US.xml";
                    }
                    User modifiedByUser = new User();
                    modifiedByUser.setBuildContact(true);
                    modifiedByUser.setBuildContactDetails(true);
                    modifiedByUser.buildRecord(db, this.getUserId(context));
                    this.sendEmail(context, newUser, modifiedByUser, templateFile, password);
                }
                if (siteChangeAllowed) {
                    Contact linkContact = new Contact(db, newUser.getContactId());
                    linkContact.setSiteId(newUser.getSiteId());
                    linkContact.update(db);
                }
                this.updateSystemHierarchyCheck(db, context);
            }
        }
        catch (Exception errorMessage) {
            errorMessage.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == -1) {
            if (isValid) {
                this.processErrors(context, newUser.getErrors());
            }
            return "UserModifyOK";
        }
        if (resultCount == 1) {
            context.getRequest().setAttribute("id", (Object)context.getRequest().getParameter("id"));
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                return this.executeCommandListUsers(context);
            }
            return "UserUpdateOK";
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReportsToJSList(ActionContext context) {
        String siteIdString = context.getRequest().getParameter("siteId");
        int siteId = -1;
        if (siteIdString != null || !"".equals(siteIdString)) {
            siteId = Integer.parseInt(siteIdString);
        }
        if (!Users.isSiteAccessPermitted(context, String.valueOf(siteId))) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            UserList userList = new UserList();
            userList.setEmptyHtmlSelectRecord(this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            userList.setBuildContact(false);
            userList.setBuildContactDetails(false);
            userList.setExcludeDisabledIfUnselected(true);
            userList.setExcludeExpiredIfUnselected(true);
            userList.setRoleType(0);
            userList.setSiteId(siteId);
            userList.setIncludeUsersWithAccessToAllSites(true);
            userList.buildList(db);
            HtmlSelect userListSelect = userList.getHtmlSelectObj("userId", this.getUserId(context));
            context.getRequest().setAttribute("UserListSelect", (Object)userListSelect);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SiteJSUserListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandProcessBatch(ActionContext context) {
        if (!this.hasPermission(context, "admin-users-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String batchName = context.getRequest().getParameter("batchId");
            String batchSize = context.getRequest().getParameter("batchSize");
            String action = context.getRequest().getParameter("action");
            String status = context.getRequest().getParameter("status");
            ArrayList<String> selection = new ArrayList<String>();
            for (int rowCount = 1; rowCount <= Integer.parseInt(batchSize); ++rowCount) {
                String id;
                if (context.getRequest().getParameter(batchName + rowCount) == null || selection.contains(String.valueOf(id = context.getRequest().getParameter(batchName + rowCount)))) continue;
                selection.add(String.valueOf(id));
            }
            for (int i = 0; i < selection.size(); ++i) {
                int id = Integer.parseInt((String)selection.get(i));
                User thisUser = new User(db, id);
                if (action == null || status == null) continue;
                if ("webdav".equals(action.toLowerCase())) {
                    thisUser.updateWebdavAccess(db, "enable".equals(status.toLowerCase()));
                    continue;
                }
                if ("httpapi".equals(action.toLowerCase())) {
                    thisUser.updateHttpApiAccess(db, "enable".equals(status.toLowerCase()));
                    continue;
                }
                if (!"userlogin".equals(action.toLowerCase())) continue;
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandListUsers(context);
    }

    private boolean sendEmail(ActionContext context, User thisUser, User modifiedByUser, String template, String password) throws Exception {
        int result;
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        SystemStatus systemStatus = this.getSystemStatus(context);
        String modifiedByUserName = modifiedByUser.getContact() != null && modifiedByUser.getContact().getNameFull() != null ? modifiedByUser.getContact().getNameFull() : systemStatus.getLabel("campaign.superUser", "Super User");
        UserEmail userEmail = new UserEmail(context, thisUser, modifiedByUserName, password, systemStatus.getUrl(), template);
        SMTPMessage mail = new SMTPMessage();
        mail.setHost(prefs.get("MAILSERVER"));
        mail.setFrom(prefs.get("EMAILADDRESS"));
        mail.addReplyTo(prefs.get("EMAILADDRESS"));
        mail.setType("text/html");
        mail.setSubject(userEmail.getSubject());
        mail.setBody(userEmail.getBody());
        if (thisUser.getContact().getPrimaryEmailAddress() != null && !"".equals(thisUser.getContact().getPrimaryEmailAddress())) {
            mail.addTo(thisUser.getContact().getPrimaryEmailAddress());
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ADDING: " + thisUser.getContact().getPrimaryEmailAddress());
            }
        }
        if ((result = mail.send()) == 2) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Users-> Send error: " + mail.getErrorMsg() + "\n");
            }
        } else if (System.getProperty("DEBUG") != null) {
            System.out.println("Users-> Sending message...");
        }
        return true;
    }
}

