/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.Viewpoint;
import org.aspcfs.modules.admin.base.ViewpointList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.PagedListInfo;

public final class Viewpoints
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandListViewpoints(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListViewpoints(ActionContext context) {
        if (!this.hasPermission(context, "admin-roles-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        PagedListInfo viewpointInfo = this.getPagedListInfo(context, "ViewpointListInfo");
        String userId = context.getRequest().getParameter("userId");
        viewpointInfo.setLink("Viewpoints.do?command=ListViewpoints&userId=" + userId);
        Connection db = null;
        ViewpointList viewpointList = new ViewpointList();
        try {
            db = this.getConnection(context);
            viewpointList.setPagedListInfo(viewpointInfo);
            viewpointList.setUserId(Integer.parseInt(userId));
            viewpointList.setBuildResources(true);
            viewpointList.buildList(db);
            User thisUser = new User();
            thisUser.setBuildContact(true);
            thisUser.buildRecord(db, Integer.parseInt(userId));
            context.getRequest().setAttribute("UserRecord", (Object)thisUser);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Users", "Viewpoint List");
        if (errorMessage == null) {
            context.getRequest().setAttribute("ViewpointList", (Object)viewpointList);
            return "ListViewpointsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewpointDetails(ActionContext context) {
        if (!this.hasPermission(context, "admin-roles-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String viewpointId = context.getRequest().getParameter("id");
        String action = context.getRequest().getParameter("action");
        String userId = context.getRequest().getParameter("userId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            PermissionList permissionList = new PermissionList();
            permissionList.setViewpointsOnly(true);
            permissionList.buildList(db);
            context.getRequest().setAttribute("PermissionList", (Object)permissionList);
            Viewpoint thisViewpoint = new Viewpoint(db, Integer.parseInt(viewpointId));
            context.getRequest().setAttribute("Viewpoint", (Object)thisViewpoint);
            User thisUser = new User();
            thisUser.setBuildContact(true);
            thisUser.buildRecord(db, Integer.parseInt(userId));
            context.getRequest().setAttribute("UserRecord", (Object)thisUser);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (action != null && action.equals("modify")) {
                this.addModuleBean(context, "Users", "Modify Viewpoint Details");
                return "ViewpointDetailsModifyOK";
            }
            this.addModuleBean(context, "Users", "View Viewpoint Details");
            return "ViewpointDetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateViewpoint(ActionContext context) {
        if (!this.hasPermission(context, "admin-roles-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = 0;
        boolean isValid = false;
        String userId = context.getRequest().getParameter("userId");
        Viewpoint thisViewpoint = (Viewpoint)((Object)context.getFormBean());
        thisViewpoint.setRequestItems(context.getRequest());
        thisViewpoint.setModifiedBy(this.getUserId(context));
        try {
            db = this.getConnection(context);
            isValid = this.validateObject(context, db, (Object)thisViewpoint);
            if (isValid) {
                resultCount = thisViewpoint.update(db);
            }
            if (resultCount == 1) {
                this.invalidateViewpoints(context);
            }
            User thisUser = new User();
            thisUser.setBuildContact(true);
            thisUser.buildRecord(db, Integer.parseInt(userId));
            context.getRequest().setAttribute("UserRecord", (Object)thisUser);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Users", "Update Viewpoint");
        if (resultCount == -1 || !isValid) {
            this.processErrors(context, thisViewpoint.getErrors());
            return this.executeCommandViewpointDetails(context);
        }
        if (resultCount == 1) {
            return "ViewpointUpdateOK";
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Viewpoint thisViewpoint = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        int id = -1;
        String userId = context.getRequest().getParameter("userId");
        if (!this.hasPermission(context, "admin-roles-delete")) {
            return "DefaultError";
        }
        if (context.getRequest().getParameter("id") != null) {
            id = Integer.parseInt(context.getRequest().getParameter("id"));
        }
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisViewpoint = new Viewpoint(db, id);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            htmlDialog.setShowAndConfirm(false);
            htmlDialog.setDeleteUrl("javascript:window.location.href='Viewpoints.do?command=DeleteViewpoint&id=" + id + "&userId=" + userId + "'");
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertViewpointForm(ActionContext context) {
        if (!this.hasPermission(context, "admin-roles-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Users", "Add a Viewpoint");
        Connection db = null;
        String userId = context.getRequest().getParameter("userId");
        try {
            db = this.getConnection(context);
            PermissionList permissionList = new PermissionList();
            permissionList.setViewpointsOnly(true);
            permissionList.buildList(db);
            context.getRequest().setAttribute("PermissionList", (Object)permissionList);
            User thisUser = new User();
            thisUser.setBuildContact(true);
            thisUser.buildRecord(db, Integer.parseInt(userId));
            context.getRequest().setAttribute("UserRecord", (Object)thisUser);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewpointInsertFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertViewpoint(ActionContext context) {
        if (!this.hasPermission(context, "admin-roles-add")) {
            return "PermissionError";
        }
        boolean recordInserted = false;
        boolean isValid = false;
        String userId = context.getRequest().getParameter("userId");
        Viewpoint thisViewpoint = (Viewpoint)((Object)context.getFormBean());
        thisViewpoint.setRequestItems(context.getRequest());
        thisViewpoint.setEnteredBy(this.getUserId(context));
        thisViewpoint.setModifiedBy(this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            isValid = this.validateObject(context, db, (Object)thisViewpoint);
            ViewpointList viewpoints = new ViewpointList();
            viewpoints.setUserId(thisViewpoint.getUserId());
            viewpoints.buildList(db);
            HashMap<String, String> errors = new HashMap<String, String>();
            SystemStatus systemStatus = this.getSystemStatus(context);
            if (isValid) {
                User tmpUser = this.getUser(context, thisViewpoint.getUserId());
                User tmpViewPointUser = this.getUser(context, thisViewpoint.getVpUserId());
                if (tmpUser.getSiteId() != -1 && tmpUser.getSiteId() != tmpViewPointUser.getSiteId()) {
                    errors.put("actionError", systemStatus.getLabel("object.validation.theSelectedUserHasIncompatibleSite"));
                    isValid = false;
                }
                if (viewpoints.checkForDuplicates(thisViewpoint.getVpUserId()) != 0) {
                    errors.put("actionError", systemStatus.getLabel("object.validation.duplicateViewpointUserCanNotBeInserted"));
                    isValid = false;
                }
                if (isValid) {
                    recordInserted = thisViewpoint.insert(db);
                } else {
                    this.processErrors(context, errors);
                }
            }
            if (recordInserted) {
                PermissionList permissionList = new PermissionList(db);
                context.getRequest().setAttribute("PermissionList", (Object)permissionList);
                thisViewpoint = new Viewpoint(db, thisViewpoint.getId());
                context.getRequest().setAttribute("Viewpoint", (Object)thisViewpoint);
                this.invalidateViewpoints(context);
                User thisUser = new User();
                thisUser.setBuildContact(true);
                thisUser.buildRecord(db, Integer.parseInt(userId));
                context.getRequest().setAttribute("UserRecord", (Object)thisUser);
            } else {
                context.getRequest().setAttribute("vpUserId", (Object)("" + thisViewpoint.getVpUserId()));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Users", "Insert a Viewpoint");
        if (recordInserted) {
            return "ViewpointAddOK";
        }
        return this.executeCommandInsertViewpointForm(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteViewpoint(ActionContext context) {
        if (!this.hasPermission(context, "admin-roles-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordDeleted = false;
        Viewpoint thisViewpoint = null;
        String viewpointId = context.getRequest().getParameter("id");
        String userId = context.getRequest().getParameter("userId");
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisViewpoint = new Viewpoint(db, Integer.parseInt(viewpointId));
            recordDeleted = thisViewpoint.delete(db);
            if (recordDeleted) {
                this.invalidateViewpoints(context);
            } else {
                thisViewpoint.getErrors().put("actionError", systemStatus.getLabel("object.validation.actionError.viewPointDeletion"));
                this.processErrors(context, thisViewpoint.getErrors());
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Users", "Delete a Viewpoint");
        if (errorMessage == null) {
            if (recordDeleted) {
                context.getRequest().setAttribute("refreshUrl", (Object)("Viewpoints.do?command=ListViewpoints&userId=" + userId));
                return "DeleteOK";
            }
            this.processErrors(context, thisViewpoint.getErrors());
            context.getRequest().setAttribute("refreshUrl", (Object)("Viewpoints.do?command=ListViewpoints&userId=" + userId));
            return "DeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }
}

