/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class AccessLog
extends GenericBean {
    private int id = -1;
    private int userId = -1;
    private String username = "";
    private String ip = "";
    private String browser = "";
    private Timestamp entered = null;

    public AccessLog() {
    }

    public AccessLog(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public AccessLog(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public AccessLog(Connection db, String id) throws SQLException {
        this.queryRecord(db, Integer.parseInt(id));
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Access Log ID");
        }
        PreparedStatement pst = db.prepareStatement("SELECT a.* FROM access_log a WHERE a.id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Access Log not found");
        }
    }

    public int getId() {
        return this.id;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getIp() {
        return this.ip;
    }

    public String getBrowser() {
        return this.browser;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public void setUsername(String tmp) {
        this.username = tmp;
    }

    public void setIp(String tmp) {
        this.ip = tmp;
    }

    public void setBrowser(String tmp) {
        this.browser = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public void insert(Connection db) throws SQLException {
        if (this.userId == -1) {
            throw new SQLException("Log Entry must be associated to a Centric CRM user");
        }
        StringBuffer sql = new StringBuffer();
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "access_log_id_seq");
            sql.append("INSERT INTO access_log (user_id, username, ip, ");
            if (this.id > -1) {
                sql.append("id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            sql.append("browser ) ");
            sql.append("VALUES (?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setInt(++i, this.getUserId());
            pst.setString(++i, this.getUsername());
            pst.setString(++i, this.getIp());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            pst.setString(++i, this.getBrowser());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "access_log_id_seq", this.id);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Access Log ID not specified.");
        }
        PreparedStatement pst = db.prepareStatement("DELETE FROM access_log WHERE id = ? ");
        pst.setInt(1, this.getId());
        pst.executeUpdate();
        pst.close();
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("id"));
        this.userId = rs.getInt("user_id");
        this.username = rs.getString("username");
        this.ip = rs.getString("ip");
        this.browser = rs.getString("browser");
        this.entered = rs.getTimestamp("entered");
    }
}

