/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.admin.base.AccessLog;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class AccessLogList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int userId = -1;
    public static final String tableName = "access_log";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private Timestamp enteredRangeStart = null;
    private Timestamp enteredRangeEnd = null;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setUserId(String userId) {
        this.userId = Integer.parseInt(userId);
    }

    public void setEnteredRangeStart(Timestamp tmp) {
        this.enteredRangeStart = tmp;
    }

    public void setEnteredRangeEnd(Timestamp tmp) {
        this.enteredRangeEnd = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM access_log a WHERE a.id > 0 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(a.username) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("a.entered", "desc");
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY a.entered desc ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("a.* FROM access_log a WHERE a.id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        int count = 0;
        while (rs.next()) {
            ++count;
            AccessLog thisAccessLog = new AccessLog(rs);
            this.add(thisAccessLog);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (this.userId > -1) {
            sqlFilter.append("AND a.user_id = ? ");
        }
        if (this.enteredRangeStart != null) {
            sqlFilter.append("AND entered >= ? ");
        }
        if (this.enteredRangeEnd != null) {
            sqlFilter.append("AND entered <= ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.userId > -1) {
            pst.setInt(++i, this.userId);
        }
        if (this.enteredRangeStart != null) {
            pst.setTimestamp(++i, this.enteredRangeStart);
        }
        if (this.enteredRangeEnd != null) {
            pst.setTimestamp(++i, this.enteredRangeEnd);
        }
        return i;
    }

    public int queryRecordCount(Connection db) throws SQLException {
        int recordCount = 0;
        StringBuffer sqlFilter = new StringBuffer();
        String sqlCount = "SELECT COUNT(*) AS recordcount FROM access_log a WHERE a.id > 0 ";
        this.createFilter(sqlFilter);
        PreparedStatement pst = db.prepareStatement(sqlCount + sqlFilter.toString());
        int items = this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            recordCount = DatabaseUtils.getInt(rs, "recordcount", 0);
        }
        pst.close();
        rs.close();
        return recordCount;
    }

    public boolean delete(Connection db) throws SQLException {
        for (AccessLog tmpAccessLog : this) {
            tmpAccessLog.delete(db);
        }
        return true;
    }
}

