/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.communications.base.Message;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.LookupElement;

public class AccessType
extends LookupElement {
    public static final int GENERAL_CONTACTS = 626030330;
    public static final int ACCOUNT_CONTACTS = 626030331;
    public static final int EMPLOYEES = 626030332;
    public static final int COMMUNICATION_MESSAGES = 707031028;
    public static final int OPPORTUNITIES = 804051057;
    public static final int PERSONAL = 626030333;
    public static final int PUBLIC = 626030334;
    public static final int CONTROLLED_HIERARCHY = 626030335;
    int linkModuleId = -1;
    int ruleId = -1;
    int code = -1;

    public AccessType() {
    }

    public AccessType(Connection db, int code) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("AccessType-> Retrieving ID: " + code + " from lookup_access_types ");
        }
        this.setCode(code);
        PreparedStatement pst = db.prepareStatement("SELECT code, link_module_id, description, default_item, " + DatabaseUtils.addQuotes(db, "level") + ", enabled, rule_id " + "FROM lookup_access_types " + "WHERE code = ? ");
        pst.setInt(1, code);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.build(rs);
        }
        rs.close();
        pst.close();
        if (code < 0) {
            throw new SQLException("ID not found");
        }
    }

    public AccessType(ResultSet rs) throws SQLException {
        this.build(rs);
    }

    public void setRuleId(int ruleId) {
        this.ruleId = ruleId;
    }

    public void setLinkModuleId(int linkModuleId) {
        this.linkModuleId = linkModuleId;
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public static int getLinkModuleId(Object obj) {
        if (obj instanceof Contact) {
            Contact thisContact = (Contact)((Object)obj);
            if (thisContact.getOrgId() > 0) {
                return 626030331;
            }
            return 626030330;
        }
        if (obj instanceof Message) {
            return 707031028;
        }
        return -1;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int tmp) {
        this.code = tmp;
    }

    public void setCode(String tmp) {
        this.code = Integer.parseInt(tmp);
    }

    public void build(ResultSet rs) throws SQLException {
        this.code = rs.getInt("code");
        this.linkModuleId = rs.getInt("link_module_id");
        this.description = rs.getString("description");
        this.defaultItem = rs.getBoolean("default_item");
        this.level = rs.getInt("level");
        this.enabled = rs.getBoolean("enabled");
        if (!this.getEnabled()) {
            this.description = this.description + " (X)";
        }
        this.ruleId = rs.getInt("rule_id");
    }

    public boolean insert(Connection db) throws SQLException {
        int id = DatabaseUtils.getNextSeq(db, "lookup_access_types_code_seq");
        int i = 0;
        PreparedStatement pst = db.prepareStatement("INSERT INTO lookup_access_types (" + (id > -1 ? "code, " : "") + "link_module_id, description, default_item, " + DatabaseUtils.addQuotes(db, "level") + ", enabled, rule_id) " + "VALUES (" + (id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?) ");
        if (id > -1) {
            pst.setInt(++i, id);
        }
        pst.setInt(++i, this.linkModuleId);
        pst.setString(++i, this.getDescription());
        pst.setBoolean(++i, this.defaultItem);
        pst.setInt(++i, this.level);
        pst.setBoolean(++i, this.enabled);
        pst.setInt(++i, this.ruleId);
        pst.execute();
        pst.close();
        this.code = DatabaseUtils.getCurrVal(db, "lookup_access_types_code_seq", id);
        return true;
    }
}

