/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.admin.base.AccessType;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.LookupList;

public class AccessTypeList
extends LookupList {
    int linkModuleId = -1;

    public AccessTypeList() {
    }

    public AccessTypeList(Connection db, int linkModuleId) throws SQLException {
        this.queryRecord(db, linkModuleId);
    }

    public void queryRecord(Connection db, int linkModuleId) throws SQLException {
        this.linkModuleId = linkModuleId;
        this.buildList(db);
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlSelect = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM lookup_access_types WHERE code > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(description) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("description ", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY " + DatabaseUtils.addQuotes(db, "level") + ",description ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("lat.* FROM lookup_access_types lat WHERE code > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            AccessType thisType = new AccessType(rs);
            this.add(thisType);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.linkModuleId > -1) {
            sqlFilter.append("AND link_module_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND entered > ? ");
            }
            sqlFilter.append("AND entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND modified > ? ");
            sqlFilter.append("AND entered < ? ");
            sqlFilter.append("AND modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.linkModuleId > -1) {
            pst.setInt(++i, this.linkModuleId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public int getDefaultItem() {
        for (AccessType thisType : this) {
            if (!thisType.getDefaultItem()) continue;
            return thisType.getCode();
        }
        return -1;
    }

    public int getCode(int ruleId) {
        for (AccessType thisType : this) {
            if (thisType.getRuleId() != ruleId) continue;
            return thisType.getCode();
        }
        return -1;
    }

    public int getRuleId(int code) {
        for (AccessType thisType : this) {
            if (thisType.getCode() != code) continue;
            return thisType.getRuleId();
        }
        return -1;
    }

    public String getDescriptionFromRuleId(int ruleId) {
        for (AccessType thisType : this) {
            if (thisType.getRuleId() != ruleId) continue;
            return thisType.getDescription();
        }
        return null;
    }

    public static boolean exists(Connection db, int linkModuleId, int ruleId) throws SQLException {
        boolean result = false;
        PreparedStatement pst = db.prepareStatement("SELECT code FROM lookup_access_types WHERE link_module_id = ? AND rule_id = ? ");
        pst.setInt(1, linkModuleId);
        pst.setInt(2, ruleId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            result = true;
        }
        rs.close();
        pst.close();
        return result;
    }
}

