/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.base.Category;
import org.aspcfs.modules.base.CategoryList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryAssignment;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraft;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftAssignment;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftPlanMapList;
import org.aspcfs.modules.troubletickets.base.TicketCategoryPlanMapList;
import org.aspcfs.utils.DatabaseUtils;

public class CategoryEditor {
    private int id = -1;
    private int moduleId = -1;
    private int categoryId = -1;
    private int constantId = -1;
    private String tableName = null;
    private int level = -1;
    private String description = null;
    private Timestamp entered = null;
    private int maxLevels = -1;
    private HashMap categoryList = new HashMap();
    private TicketCategoryDraftList topCategoryList = new TicketCategoryDraftList();
    private Date hierarchyCheck = new Date();
    private boolean hierarchyUpdating = false;
    private SystemStatus systemStatus = null;
    private int siteId = -1;

    public CategoryEditor() {
    }

    public CategoryEditor(Connection db, int constantId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM category_editor_lookup WHERE constant_id = ? ");
        pst.setInt(1, constantId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public CategoryEditor(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.moduleId = rs.getInt("module_id");
        this.constantId = rs.getInt("constant_id");
        this.tableName = rs.getString("table_name");
        this.level = rs.getInt("level");
        this.description = rs.getString("description");
        this.entered = rs.getTimestamp("entered");
        this.categoryId = rs.getInt("category_id");
        this.maxLevels = rs.getInt("max_levels");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id =" + this.id + "\n");
        sb.append("moduleId =" + this.moduleId + "\n");
        sb.append("constantId =" + this.constantId + "\n");
        sb.append("tableName =" + this.tableName + "\n");
        sb.append("level =" + this.level + "\n");
        sb.append("description =" + this.description + "\n");
        sb.append("entered =" + this.entered + "\n");
        sb.append("categoryId =" + this.categoryId + "\n");
        sb.append("maxLevels =" + this.maxLevels + "\n");
        return sb.toString().trim();
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModuleId(int tmp) {
        this.moduleId = tmp;
    }

    public void setModuleId(String tmp) {
        this.moduleId = Integer.parseInt(tmp);
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public void setConstantId(int tmp) {
        this.constantId = tmp;
    }

    public void setConstantId(String tmp) {
        this.constantId = Integer.parseInt(tmp);
    }

    public void setTableName(String tmp) {
        this.tableName = tmp;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setMaxLevels(int tmp) {
        this.maxLevels = tmp;
    }

    public void setMaxLevels(String tmp) {
        this.maxLevels = Integer.parseInt(tmp);
    }

    public void setSystemStatus(SystemStatus tmp) {
        this.systemStatus = tmp;
    }

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public int getId() {
        return this.id;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public int getConstantId() {
        return this.constantId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getLevel() {
        return this.level;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public void setCategoryList(HashMap categoryList) {
        this.categoryList = categoryList;
    }

    public void setHierarchyCheck(Date hierarchyCheck) {
        this.hierarchyCheck = hierarchyCheck;
    }

    public void setHierarchyUpdating(boolean hierarchyUpdating) {
        this.hierarchyUpdating = hierarchyUpdating;
    }

    public void setTopCategoryList(TicketCategoryDraftList topCategoryList) {
        this.topCategoryList = topCategoryList;
    }

    public TicketCategoryDraftList getTopCategoryList() {
        return this.topCategoryList;
    }

    public Date getHierarchyCheck() {
        return this.hierarchyCheck;
    }

    public boolean getHierarchyUpdating() {
        return this.hierarchyUpdating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TicketCategoryDraft getCategory(int categoryId) {
        boolean flag = false;
        CategoryEditor categoryEditor = this;
        synchronized (categoryEditor) {
            flag = this.hierarchyUpdating;
        }
        while (flag) {
            categoryEditor = this;
            synchronized (categoryEditor) {
                flag = this.hierarchyUpdating;
            }
        }
        return (TicketCategoryDraft)((Object)this.categoryList.get(new Integer(categoryId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getCategoryList() {
        boolean flag = false;
        CategoryEditor categoryEditor = this;
        synchronized (categoryEditor) {
            flag = this.hierarchyUpdating;
        }
        while (flag) {
            categoryEditor = this;
            synchronized (categoryEditor) {
                flag = this.hierarchyUpdating;
            }
        }
        return this.categoryList;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public void build(Connection db) throws SQLException {
        this.categoryList.clear();
        this.topCategoryList.clear();
        this.topCategoryList.setBuildHierarchy(false);
        this.topCategoryList.setTopLevelOnly(true);
        this.topCategoryList.setSiteId(this.getSiteId());
        this.topCategoryList.setExclusiveToSite(true);
        this.topCategoryList.buildList(db, this.tableName);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CategoryEditor -> buildList: Top Level Size " + this.topCategoryList.size());
        }
        TicketCategoryDraftList fullCategoryList = new TicketCategoryDraftList();
        fullCategoryList.setBuildHierarchy(false);
        fullCategoryList.setSiteId(this.getSiteId());
        fullCategoryList.setExclusiveToSite(true);
        fullCategoryList.setTopLevelOnly(false);
        fullCategoryList.buildList(db, this.tableName);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("SystemStatus-> buildList: Full List " + fullCategoryList.size());
        }
        for (TicketCategoryDraft thisCategory : this.topCategoryList) {
            if (thisCategory == null) continue;
            this.categoryList.put(new Integer(thisCategory.getId()), thisCategory);
            this.addSubCategories(thisCategory, fullCategoryList);
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("SystemStatus-> Total categories added : " + this.categoryList.size());
        }
    }

    private void addSubCategories(TicketCategoryDraft parentCategory, TicketCategoryDraftList fullList) {
        if (parentCategory.getShortChildList() == null) {
            parentCategory.setShortChildList(new TicketCategoryDraftList());
        }
        for (TicketCategoryDraft tmpCategory : fullList) {
            if (tmpCategory.getParentCode() != parentCategory.getId()) continue;
            this.categoryList.put(new Integer(tmpCategory.getId()), tmpCategory);
            parentCategory.getShortChildList().add(tmpCategory);
            this.addSubCategories(tmpCategory, fullList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Connection db) throws SQLException {
        Date checkDate = new Date();
        if (checkDate.after(this.getHierarchyCheck())) {
            CategoryEditor categoryEditor = this;
            synchronized (categoryEditor) {
                try {
                    this.hierarchyUpdating = true;
                    if (checkDate.after(this.hierarchyCheck)) {
                        this.build(db);
                        this.setHierarchyCheck(new Date());
                    }
                }
                catch (SQLException e) {
                    throw e;
                }
                finally {
                    this.hierarchyUpdating = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCategory(Connection db, String catList, int parentCode) throws SQLException {
        Date checkDate = new Date();
        if (checkDate.after(this.getHierarchyCheck())) {
            CategoryEditor categoryEditor = this;
            synchronized (categoryEditor) {
                try {
                    this.hierarchyUpdating = true;
                    if (checkDate.after(this.hierarchyCheck)) {
                        TicketCategoryDraft parentCategory = null;
                        if (this.categoryList.containsKey(new Integer(parentCode))) {
                            parentCategory = (TicketCategoryDraft)((Object)this.categoryList.get(new Integer(parentCode)));
                        }
                        StringTokenizer st1 = new StringTokenizer(catList, "|");
                        while (st1.hasMoreTokens()) {
                            int catId = Integer.parseInt(st1.nextToken());
                            String description = st1.nextToken();
                            boolean enabled = "true".equals(st1.nextToken());
                            TicketCategoryDraft thisCat = null;
                            if (this.categoryList.containsKey(new Integer(catId))) {
                                thisCat = (TicketCategoryDraft)((Object)this.categoryList.get(new Integer(catId)));
                                thisCat.setDescription(description);
                                if (thisCat.getEnabled() && !enabled || !thisCat.getEnabled() && enabled) {
                                    this.toggleSubCategories(db, thisCat, enabled);
                                    continue;
                                }
                                thisCat.setEnabled(enabled);
                                thisCat.update(db, this.tableName);
                                continue;
                            }
                            thisCat = new TicketCategoryDraft();
                            thisCat.setDescription(description);
                            if (parentCategory != null) {
                                thisCat.setParentCode(parentCategory.getId());
                                thisCat.setCategoryLevel(parentCategory.getCategoryLevel() + 1);
                                parentCategory.getShortChildList().add(thisCat);
                            } else {
                                thisCat.setParentCode(0);
                                thisCat.setCategoryLevel(0);
                                this.topCategoryList.add(thisCat);
                            }
                            thisCat.setSiteId(this.getSiteId());
                            thisCat.insert(db, this.tableName);
                            this.categoryList.put(new Integer(thisCat.getId()), thisCat);
                        }
                        this.setHierarchyCheck(new Date());
                    }
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
                finally {
                    this.hierarchyUpdating = false;
                }
            }
        }
        return true;
    }

    public void toggleSubCategories(Connection db, TicketCategoryDraft thisCategory, boolean enabled) throws SQLException {
        boolean recordDeleted = false;
        if (thisCategory.getActualCatId() == -1) {
            this.categoryList.remove(new Integer(thisCategory.getId()));
            if (thisCategory.getParentCode() > 0) {
                TicketCategoryDraft parentCategory = (TicketCategoryDraft)((Object)this.categoryList.get(new Integer(thisCategory.getParentCode())));
                parentCategory.removeChild(thisCategory.getId());
            }
            if (thisCategory.getParentCode() == 0) {
                this.topCategoryList.remove((Object)thisCategory);
            }
            if (!(recordDeleted = thisCategory.delete(db, this.tableName))) {
                thisCategory.getErrors().put("actionError", this.systemStatus.getLabel("object.validation.actionError.ticketCategoryDeletion"));
            }
        } else {
            thisCategory.setEnabled(enabled);
            thisCategory.update(db, this.tableName);
        }
        if (thisCategory.getShortChildList() != null) {
            for (TicketCategoryDraft tmpCategory : thisCategory.getShortChildList()) {
                this.toggleSubCategories(db, tmpCategory, enabled);
            }
        }
    }

    public void reset(Connection db) throws SQLException {
        CategoryList activeTopCategoryList = new CategoryList(this.tableName);
        activeTopCategoryList.setParentCode(0);
        activeTopCategoryList.setSiteId(this.getSiteId());
        activeTopCategoryList.setExclusiveToSite(true);
        activeTopCategoryList.buildList(db);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CategoryEditor -> buildList: Top Level Size " + activeTopCategoryList.size());
        }
        CategoryList fullCategoryList = new CategoryList(this.tableName);
        fullCategoryList.setSiteId(this.getSiteId());
        fullCategoryList.setExclusiveToSite(true);
        fullCategoryList.buildList(db);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("SystemStatus-> buildList: Full List " + fullCategoryList.size());
        }
        for (Category thisCategory : activeTopCategoryList) {
            thisCategory.setSiteId(this.getSiteId());
            if (thisCategory == null) continue;
            this.addActiveSubCategories(thisCategory, fullCategoryList);
        }
        boolean draftDeleted = TicketCategoryDraftList.deleteDraft(db, this.tableName, this.getSiteId());
        if (draftDeleted) {
            for (Category thisCategory : activeTopCategoryList) {
                thisCategory.setSiteId(this.getSiteId());
                this.copyCategory(db, thisCategory, 0);
            }
            this.update(db);
        }
    }

    private void copyCategory(Connection db, Category activeCategory, int parentCode) throws SQLException {
        TicketCategoryDraft draftCategory = new TicketCategoryDraft();
        draftCategory.setDescription(activeCategory.getDescription());
        draftCategory.setActualCatId(activeCategory.getId());
        draftCategory.setLevel(activeCategory.getLevel());
        draftCategory.setCategoryLevel(activeCategory.getCategoryLevel());
        draftCategory.setEnabled(activeCategory.getEnabled());
        draftCategory.setParentCode(parentCode);
        draftCategory.setSiteId(activeCategory.getSiteId());
        draftCategory.insert(db, this.tableName);
        if (this.tableName.equals("ticket_category")) {
            TicketCategoryPlanMapList planMapList = new TicketCategoryPlanMapList();
            planMapList.setCategoryId(activeCategory.getId());
            planMapList.buildList(db);
            TicketCategoryDraftPlanMapList draftMapList = new TicketCategoryDraftPlanMapList();
            draftMapList.setCategoryId(draftCategory.getId());
            draftMapList.buildList(db);
            draftMapList.parseDraftPlans(db, planMapList);
            TicketCategoryAssignment assignment = new TicketCategoryAssignment(db, activeCategory.getId(), null);
            if (assignment.getId() > -1) {
                TicketCategoryDraftAssignment draftAssignment = new TicketCategoryDraftAssignment();
                draftAssignment.setCategoryId(draftCategory.getId());
                draftAssignment.copyAssignment(assignment);
                draftAssignment.insert(db);
            }
        }
        for (Category tmpCategory : activeCategory.getShortChildList()) {
            tmpCategory.setSiteId(this.getSiteId());
            this.copyCategory(db, tmpCategory, draftCategory.getId());
        }
    }

    private void addActiveSubCategories(Category parentCategory, CategoryList fullList) {
        if (parentCategory.getShortChildList() == null) {
            parentCategory.setShortChildList(new TicketCategoryDraftList());
        }
        for (Category tmpCategory : fullList) {
            if (tmpCategory.getParentCode() != parentCategory.getId()) continue;
            parentCategory.getShortChildList().add(tmpCategory);
            this.addActiveSubCategories(tmpCategory, fullList);
        }
    }

    public boolean activate(Connection db) throws SQLException {
        for (TicketCategoryDraft thisCategory : this.topCategoryList) {
            this.activateCategory(db, thisCategory, 0);
        }
        return true;
    }

    private void activateCategory(Connection db, TicketCategoryDraft draftCategory, int parentCode) throws SQLException {
        TicketCategoryDraftAssignment draftAssignment;
        TicketCategoryAssignment assignment;
        TicketCategoryPlanMapList planMapList;
        Category activeCategory = null;
        TicketCategoryDraftPlanMapList draftMapList = new TicketCategoryDraftPlanMapList();
        if (this.constantId == 202041401) {
            draftMapList.setCategoryId(draftCategory.getId());
            draftMapList.buildList(db);
        }
        if (draftCategory.getActualCatId() > 0) {
            activeCategory = new Category(db, draftCategory.getActualCatId(), this.tableName);
            activeCategory.setDescription(draftCategory.getDescription());
            activeCategory.setLevel(draftCategory.getLevel());
            activeCategory.setCategoryLevel(draftCategory.getCategoryLevel());
            activeCategory.setEnabled(draftCategory.getEnabled());
            activeCategory.setParentCode(parentCode);
            activeCategory.update(db);
            if (draftMapList.size() > 0) {
                planMapList = new TicketCategoryPlanMapList();
                planMapList.setCategoryId(activeCategory.getId());
                planMapList.buildList(db);
                planMapList.parsePlans(db, draftMapList);
            }
            if (this.constantId == 202041401) {
                assignment = new TicketCategoryAssignment(db, activeCategory.getId(), null);
                draftAssignment = new TicketCategoryDraftAssignment(db, draftCategory.getId(), null);
                if (assignment != null && assignment.getId() > -1) {
                    if (draftAssignment != null && draftAssignment.getId() > -1) {
                        assignment.copyAssignment(draftAssignment);
                        assignment.update(db);
                    } else {
                        assignment.delete(db);
                    }
                } else if (draftAssignment != null && draftAssignment.getId() > -1) {
                    assignment.copyAssignment(draftAssignment);
                    assignment.setCategoryId(activeCategory.getId());
                    assignment.insert(db);
                }
            }
        } else {
            activeCategory = new Category(this.tableName);
            activeCategory.setDescription(draftCategory.getDescription());
            activeCategory.setLevel(draftCategory.getLevel());
            activeCategory.setCategoryLevel(draftCategory.getCategoryLevel());
            activeCategory.setEnabled(draftCategory.getEnabled());
            activeCategory.setParentCode(parentCode);
            activeCategory.setSiteId(draftCategory.getSiteId());
            activeCategory.insert(db);
            if (draftMapList.size() > 0) {
                planMapList = new TicketCategoryPlanMapList();
                planMapList.setCategoryId(activeCategory.getId());
                planMapList.buildList(db);
                planMapList.parsePlans(db, draftMapList);
            }
            if (this.constantId == 202041401) {
                assignment = new TicketCategoryAssignment();
                draftAssignment = new TicketCategoryDraftAssignment(db, draftCategory.getId(), null);
                if (draftAssignment != null && draftAssignment.getId() > -1) {
                    assignment.copyAssignment(draftAssignment);
                    assignment.setCategoryId(activeCategory.getId());
                    assignment.insert(db);
                }
            }
        }
        draftCategory.setActualCatId(activeCategory.getId());
        draftCategory.update(db, this.tableName);
        for (TicketCategoryDraft tmpCategory : draftCategory.getShortChildList()) {
            this.activateCategory(db, tmpCategory, activeCategory.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getHierarchyAsList(int categoryId) {
        TicketCategoryDraft tmpCategory;
        int parentCode = categoryId;
        HashMap<Integer, Integer> thisHierarchy = new HashMap<Integer, Integer>();
        boolean flag = false;
        CategoryEditor categoryEditor = this;
        synchronized (categoryEditor) {
            flag = this.hierarchyUpdating;
        }
        while (flag) {
            categoryEditor = this;
            synchronized (categoryEditor) {
                flag = this.hierarchyUpdating;
            }
        }
        do {
            tmpCategory = (TicketCategoryDraft)((Object)this.categoryList.get(new Integer(parentCode)));
            thisHierarchy.put(new Integer(tmpCategory.getCategoryLevel()), new Integer(parentCode));
        } while ((parentCode = tmpCategory.getParentCode()) != 0);
        return thisHierarchy;
    }

    public DependencyList processDependencies(String catList) {
        DependencyList dependencyList = new DependencyList();
        StringTokenizer st1 = new StringTokenizer(catList, "|");
        while (st1.hasMoreTokens()) {
            int catId = Integer.parseInt(st1.nextToken());
            st1.nextToken();
            boolean enabled = "true".equals(st1.nextToken());
            TicketCategoryDraft thisCat = null;
            if (!this.categoryList.containsKey(new Integer(catId)) || enabled || !(thisCat = (TicketCategoryDraft)((Object)this.categoryList.get(new Integer(catId)))).getEnabled() || thisCat.getShortChildList().size() <= 0) continue;
            Dependency thisDependency = new Dependency();
            thisDependency.setName(thisCat.getDescription());
            thisDependency.setCount(thisCat.getShortChildList().size());
            thisDependency.setCanDelete(true);
            dependencyList.add(thisDependency);
        }
        return dependencyList;
    }

    public void insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "category_editor_lookup_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO category_editor_lookup (" + (this.id > -1 ? "id, " : "") + "module_id, constant_id, table_name, " + DatabaseUtils.addQuotes(db, "level") + ", description, category_id, max_levels) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.moduleId);
        pst.setInt(++i, this.constantId);
        pst.setString(++i, this.tableName);
        pst.setInt(++i, this.level);
        pst.setString(++i, this.description);
        pst.setInt(++i, this.categoryId);
        pst.setInt(++i, this.maxLevels);
        pst.executeUpdate();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "category_editor_lookup_id_seq", this.id);
    }
}

