/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.admin.base.CustomListViewFieldList;
import org.aspcfs.utils.DatabaseUtils;

public class CustomListView
extends GenericBean {
    private int id = -1;
    private int editorId = -1;
    private String name = null;
    private String description = null;
    private boolean isDefault = false;
    private Timestamp entered = null;
    private boolean buildFields = false;
    private CustomListViewFieldList fieldList = null;

    public boolean getBuildFields() {
        return this.buildFields;
    }

    public void setBuildFields(boolean tmp) {
        this.buildFields = tmp;
    }

    public void setBuildFields(String tmp) {
        this.buildFields = DatabaseUtils.parseBoolean(tmp);
    }

    public CustomListViewFieldList getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(CustomListViewFieldList tmp) {
        this.fieldList = tmp;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getEditorId() {
        return this.editorId;
    }

    public void setEditorId(int tmp) {
        this.editorId = tmp;
    }

    public void setEditorId(String tmp) {
        this.editorId = Integer.parseInt(tmp);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(boolean tmp) {
        this.isDefault = tmp;
    }

    public void setIsDefault(String tmp) {
        this.isDefault = DatabaseUtils.parseBoolean(tmp);
    }

    public CustomListView() {
    }

    public CustomListView(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public CustomListView(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Custom List View ID");
        }
        PreparedStatement pst = db.prepareStatement("SELECT clv.* FROM custom_list_view clv WHERE clv.view_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        if (this.buildFields) {
            this.buildFields(db);
        }
    }

    public void buildFields(Connection db) throws SQLException {
        this.fieldList = new CustomListViewFieldList();
        this.fieldList.setViewId(this.id);
        this.fieldList.buildList(db);
    }

    public int getFieldCount() {
        if (this.fieldList != null) {
            return this.fieldList.size();
        }
        return 0;
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("view_id");
        this.editorId = rs.getInt("editor_id");
        this.name = rs.getString("name");
        this.description = rs.getString("description");
        this.isDefault = rs.getBoolean("is_default");
        this.entered = rs.getTimestamp("entered");
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "custom_list_view_view_id_seq");
        sql.append("INSERT INTO custom_list_view (editor_id, name, description, ");
        if (this.entered != null) {
            sql.append("entered, ");
        }
        sql.append("is_default ) ");
        sql.append("VALUES (?, ?, ?, ");
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("? ) ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.editorId);
        pst.setString(++i, this.name);
        pst.setString(++i, this.description);
        if (this.entered != null) {
            pst.setTimestamp(++i, this.entered);
        }
        pst.setBoolean(++i, this.isDefault);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "custom_list_view_view_id_seq", this.id);
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = db.prepareStatement("UPDATE custom_list_view SET name = ? , description = ?, is_default = ? WHERE view_id = ? ");
        int i = 0;
        pst.setString(++i, this.name);
        pst.setString(++i, this.description);
        pst.setBoolean(++i, this.isDefault);
        pst.setInt(++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }
}

