/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.aspcfs.modules.admin.base.CustomListViewField;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CustomListViewEditor {
    private int id = -1;
    private int moduleId = -1;
    private int constantId = -1;
    private String description = null;
    private int categoryId = -1;
    private LinkedHashMap fields = new LinkedHashMap();
    public static final String fs = System.getProperty("file.separator");

    public LinkedHashMap getFields() {
        return this.fields;
    }

    public void setFields(LinkedHashMap tmp) {
        this.fields = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(int tmp) {
        this.moduleId = tmp;
    }

    public void setModuleId(String tmp) {
        this.moduleId = Integer.parseInt(tmp);
    }

    public int getConstantId() {
        return this.constantId;
    }

    public void setConstantId(int tmp) {
        this.constantId = tmp;
    }

    public void setConstantId(String tmp) {
        this.constantId = Integer.parseInt(tmp);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public CustomListViewEditor() {
    }

    public CustomListViewEditor(Connection db, int constantId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM custom_list_view_editor WHERE constant_id = ? ");
        pst.setInt(1, constantId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public CustomListViewEditor(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("editor_id");
        this.moduleId = rs.getInt("module_id");
        this.constantId = rs.getInt("constant_id");
        this.description = rs.getString("description");
        this.categoryId = rs.getInt("category_id");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("-------------------------------\r\n");
        sb.append("Editor Id: " + this.id + "\r\n");
        sb.append("Module Id: " + this.moduleId + "\r\n");
        sb.append("Constant Id: " + this.constantId + "\r\n");
        sb.append("Description: " + this.description + "\r\n");
        sb.append("Category Id: " + this.categoryId + "\r\n");
        sb.append("-------------------------------\r\n");
        return sb.toString();
    }

    public void insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "custom_list_view_editor_editor_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO custom_list_view_editor (" + (this.id > -1 ? "editor_id, " : "") + "module_id, constant_id, description, category_id) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.moduleId);
        pst.setInt(++i, this.constantId);
        pst.setString(++i, this.description);
        pst.setInt(++i, this.categoryId);
        pst.executeUpdate();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "custom_list_view_editor_editor_id_seq", this.id);
    }

    public void build(Connection db, String webinfPath) throws SQLException {
        block5: {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("CustomListViewEditor-> Loading editor(" + this.getDescription() + ") fields: " + webinfPath + fs + "cfs-customlistview-fields.xml");
            }
            this.fields.clear();
            try {
                File prefsFile;
                if (webinfPath == null || !(prefsFile = new File(webinfPath + fs + "cfs-customlistview-fields.xml")).exists()) break block5;
                XMLUtils xml = new XMLUtils(prefsFile);
                ArrayList viewElements = new ArrayList();
                XMLUtils.getAllChildren(xml.getFirstChild("views"), "view", viewElements);
                for (Element view : viewElements) {
                    if (!view.getAttribute("constantId").equals(String.valueOf(this.constantId))) continue;
                    NodeList nl = view.getChildNodes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        CustomListViewField thisField;
                        Node n = nl.item(i);
                        if (n.getNodeType() != 1 || !((Element)n).getTagName().equals("field") || !(thisField = new CustomListViewField(n)).isValid()) continue;
                        this.addField(thisField);
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public boolean addField(CustomListViewField thisField) {
        if (this.fields.containsKey(thisField.getName())) {
            return false;
        }
        this.fields.put(thisField.getName(), thisField);
        return true;
    }
}

