/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CustomListViewField
extends GenericBean {
    private int id = -1;
    private int viewId = -1;
    private String name = null;

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getViewId() {
        return this.viewId;
    }

    public void setViewId(int tmp) {
        this.viewId = tmp;
    }

    public void setViewId(String tmp) {
        this.viewId = Integer.parseInt(tmp);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public CustomListViewField() {
    }

    public CustomListViewField(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public CustomListViewField(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public CustomListViewField(Node n) {
        String name = ((Element)n).getAttribute("name");
        if (!"".equals(StringUtils.toString(name))) {
            this.setName(name);
        }
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Custom List View Field ID");
        }
        PreparedStatement pst = db.prepareStatement("SELECT clvf.* FROM custom_list_view_field clvf WHERE clvf.field_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("field_id");
        this.viewId = rs.getInt("view_id");
        this.name = rs.getString("name");
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "custom_list_view_field_field_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO custom_list_view_field (" + (this.id > -1 ? "field_id, " : "") + "view_id, name) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.viewId);
        pst.setString(++i, this.name);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "custom_list_view_field_field_id_seq", this.id);
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = db.prepareStatement("UPDATE custom_list_view_field SET name = ? WHERE field_id = ? ");
        int i = 0;
        pst.setString(++i, this.name);
        pst.setInt(++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean isValid() {
        return true;
    }
}

