/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.admin.base.CustomListViewField;
import org.aspcfs.utils.web.PagedListInfo;

public class CustomListViewFieldList
extends ArrayList {
    private int viewId = -1;
    public static final String tableName = "custom_list_view_field";
    public static final String uniqueField = "field_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public int getViewId() {
        return this.viewId;
    }

    public void setViewId(int tmp) {
        this.viewId = tmp;
    }

    public void setViewId(String tmp) {
        this.viewId = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer("");
        StringBuffer sqlCount = new StringBuffer("");
        StringBuffer sqlFilter = new StringBuffer("");
        StringBuffer sqlOrder = new StringBuffer("");
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM custom_list_view_field clvf  WHERE clvf.field_id > 0 ");
        this.createFilter(sqlFilter, db);
        sqlOrder.append("ORDER BY name ");
        sqlSelect.append("SELECT ");
        sqlSelect.append("clvf.* FROM custom_list_view_field clvf WHERE clvf.field_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            CustomListViewField thisField = new CustomListViewField(rs);
            this.add(thisField);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (this.viewId > -1) {
            sqlFilter.append("AND clvf.view_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.viewId > -1) {
            pst.setInt(++i, this.viewId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }
}

