/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.admin.base.CustomListView;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class CustomListViewList
extends ArrayList {
    private int editorId = -1;
    private boolean buildFields = false;
    public static final String tableName = "custom_list_view";
    public static final String uniqueField = "view_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public boolean getBuildFields() {
        return this.buildFields;
    }

    public void setBuildFields(boolean tmp) {
        this.buildFields = tmp;
    }

    public void setBuildFields(String tmp) {
        this.buildFields = DatabaseUtils.parseBoolean(tmp);
    }

    public int getEditorId() {
        return this.editorId;
    }

    public void setEditorId(int tmp) {
        this.editorId = tmp;
    }

    public void setEditorId(String tmp) {
        this.editorId = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer("");
        StringBuffer sqlCount = new StringBuffer("");
        StringBuffer sqlFilter = new StringBuffer("");
        StringBuffer sqlOrder = new StringBuffer("");
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM custom_list_view clv WHERE clv.view_id > 0 ");
        this.createFilter(sqlFilter, db);
        sqlOrder.append("ORDER BY name ");
        sqlSelect.append("SELECT ");
        sqlSelect.append("clv.* FROM custom_list_view clv WHERE clv.view_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            CustomListView customListView = new CustomListView(rs);
            this.add(customListView);
        }
        rs.close();
        pst.close();
        for (CustomListView thisView : this) {
            thisView.buildFields(db);
        }
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (this.editorId > -1) {
            sqlFilter.append("AND clv.editor_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.editorId > -1) {
            pst.setInt(++i, this.editorId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }
}

