/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class MerchantPaymentGateway
extends GenericBean {
    private int id = -1;
    private int gatewayId = -1;
    private String gatewayName = null;
    private String merchantId = null;
    private String merchantCode = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp entered) {
        this.entered = entered;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int enteredBy) {
        this.enteredBy = enteredBy;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setModified(Timestamp modified) {
        this.modified = modified;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public int getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(int gatewayId) {
        this.gatewayId = gatewayId;
    }

    public void setGatewayId(String tmp) {
        this.gatewayId = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public String getMerchantCode() {
        return this.merchantCode;
    }

    public void setMerchantCode(String merchantCode) {
        this.merchantCode = merchantCode;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public MerchantPaymentGateway() {
    }

    public MerchantPaymentGateway(Connection db) throws SQLException {
        this.queryRecord(db);
    }

    private void queryRecord(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT mpg.merchant_payment_gateway_id, lpg.description, mpg.gateway_id, mpg.merchant_id, mpg.merchant_code, mpg.entered, mpg.enteredby, mpg.modified, mpg.modifiedby FROM merchant_payment_gateway mpg LEFT JOIN lookup_payment_gateway lpg on (mpg.gateway_id=lpg.code)");
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public MerchantPaymentGateway(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("merchant_payment_gateway_id"));
        this.gatewayId = DatabaseUtils.getInt(rs, "gateway_id");
        this.gatewayName = rs.getString("description");
        this.merchantId = rs.getString("merchant_id");
        this.merchantCode = rs.getString("merchant_code");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }

    public int insert(Connection db) throws SQLException {
        int result = 0;
        this.id = DatabaseUtils.getNextSeq(db, "merchant_payment_gateway_merchant_payment_gateway_id_seq");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO merchant_payment_gateway(gateway_id, merchant_id, merchant_code,");
        if (this.id > -1) {
            sql.append("merchant_payment_gateway_id, ");
        }
        if (this.entered != null) {
            sql.append("entered, ");
        }
        sql.append("enteredby, ");
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("modifiedby )");
        sql.append("VALUES( ?, ?, ?, ");
        if (this.id > -1) {
            sql.append("?, ");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("?, ");
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("? )");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getGatewayId());
        pst.setString(++i, this.getMerchantId());
        pst.setString(++i, this.getMerchantCode());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        pst.setInt(++i, this.getEnteredBy());
        if (this.modified != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "merchant_payment_gateway_merchant_payment_gateway_id_seq", this.id);
        result = 1;
        return result;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Merchant Payment Gateway ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("DELETE FROM merchant_payment_gateway WHERE merchant_payment_gateway_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE merchant_payment_gateway SET  gateway_id = ?,      merchant_id = ?,      merchant_code = ?,      modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "     modifiedby = ? " + "WHERE merchant_payment_gateway_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getGatewayId());
        pst.setString(++i, this.getMerchantId());
        pst.setString(++i, this.getMerchantCode());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }
}

