/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class PaymentGateway {
    private int code = -1;
    private String description = "";
    private boolean defaultItem = false;
    private int level = 0;
    private boolean enabled = true;
    private int constantId = -1;

    public PaymentGateway() {
    }

    public PaymentGateway(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public PaymentGateway(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setCode(String code) {
        this.code = Integer.parseInt(code);
    }

    public int getConstantId() {
        return this.constantId;
    }

    public void setConstantId(int constantId) {
        this.constantId = constantId;
    }

    public void setConstantId(String constantId) {
        this.constantId = Integer.parseInt(constantId);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = DatabaseUtils.parseBoolean(enabled);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean getDefaultItem() {
        return this.defaultItem;
    }

    public void setDefaultItem(boolean defaultItem) {
        this.defaultItem = defaultItem;
    }

    public void setDefaultItem(String defaultItem) {
        this.defaultItem = DatabaseUtils.parseBoolean(defaultItem);
    }

    private void queryRecord(Connection db, int code) throws SQLException {
        if (code == -1) {
            throw new SQLException("Invalid ID");
        }
        String sql = "SELECT code, description, default_item, " + DatabaseUtils.addQuotes(db, "level") + ", enabled, constant_id " + "FROM lookup_payment_gateway  " + "WHERE code = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, code);
        ResultSet rs = pst.executeQuery();
        if (!rs.next()) {
            throw new SQLException("ID not found");
        }
        this.buildRecord(rs);
        rs.close();
        pst.close();
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.code = rs.getInt("code");
        this.description = rs.getString("description");
        this.defaultItem = rs.getBoolean("default_item");
        this.level = rs.getInt("level");
        this.enabled = rs.getBoolean("enabled");
        this.constantId = rs.getInt("constant_id");
        if (!this.getEnabled()) {
            this.description = this.description + " (X)";
        }
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.code = DatabaseUtils.getNextSeq(db, "lookup_payment_gateway_code_seq");
        sql.append("INSERT INTO lookup_payment_gateway (");
        if (this.code > -1) {
            sql.append("code, ");
        }
        sql.append(" description, " + DatabaseUtils.addQuotes(db, "level") + ", enabled, " + " constant_id) " + "VALUES (");
        if (this.code > -1) {
            sql.append("?, ");
        }
        sql.append("?, ?, ?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.code > -1) {
            pst.setInt(++i, this.getCode());
        }
        pst.setString(++i, this.getDescription());
        pst.setInt(++i, this.getLevel());
        pst.setBoolean(++i, true);
        pst.setInt(++i, this.getConstantId());
        pst.execute();
        pst.close();
        this.code = DatabaseUtils.getCurrVal(db, "lookup_payment_gateway_code_seq", this.code);
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getCode() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE lookup_payment_gateway SET description = ?,  " + DatabaseUtils.addQuotes(db, "level") + " = ?, enabled = ?, constant_id = ? " + "WHERE code = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getDescription());
        pst.setInt(++i, this.getLevel());
        pst.setBoolean(++i, this.getEnabled());
        pst.setInt(++i, this.getConstantId());
        pst.setInt(++i, this.getCode());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public void delete(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM lookup_payment_gateway WHERE code = ? ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.code);
        pst.execute();
        pst.close();
    }
}

