/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.utils.DatabaseUtils;

public class Permission
extends GenericBean {
    protected int id = -1;
    protected int categoryId = -1;
    protected String categoryName = null;
    protected int permissionLevel = -1;
    protected String name = null;
    protected boolean add = false;
    protected boolean view = false;
    protected boolean edit = false;
    protected boolean delete = false;
    protected String description = null;
    protected boolean enabled = false;
    protected boolean active = true;
    protected boolean viewpoints = false;

    public Permission() {
    }

    public Permission(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Permission(Connection db, int permissionId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT p.*, c.category FROM permission p, permission_category c WHERE p.category_id = c.category_id AND p.permission_id = ? ");
        pst.setInt(1, permissionId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Permission record not found.");
        }
    }

    public Permission(Connection db, String permissionName) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT p.*, c.category FROM permission p, permission_category c WHERE p.category_id = c.category_id AND p.permission = ? ");
        pst.setString(1, permissionName);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Permission record not found.");
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public void setCategoryName(String tmp) {
        this.categoryName = tmp;
    }

    public void setPermissionLevel(int tmp) {
        this.permissionLevel = tmp;
    }

    public void setPermissionLevel(String tmp) {
        this.permissionLevel = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setAdd(boolean tmp) {
        this.add = tmp;
    }

    public void setAdd(String tmp) {
        this.add = DatabaseUtils.parseBoolean(tmp);
    }

    public void setView(boolean tmp) {
        this.view = tmp;
    }

    public void setView(String tmp) {
        this.view = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEdit(boolean tmp) {
        this.edit = tmp;
    }

    public void setEdit(String tmp) {
        this.edit = DatabaseUtils.parseBoolean(tmp);
    }

    public void setDelete(boolean tmp) {
        this.delete = tmp;
    }

    public void setDelete(String tmp) {
        this.delete = DatabaseUtils.parseBoolean(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setActive(boolean tmp) {
        this.active = tmp;
    }

    public void setActive(String tmp) {
        this.active = DatabaseUtils.parseBoolean(tmp);
    }

    public void setViewpoints(boolean tmp) {
        this.viewpoints = tmp;
    }

    public void setViewpoints(String tmp) {
        this.viewpoints = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public String getName() {
        return this.name;
    }

    public boolean getAdd() {
        if (this.enabled) {
            return this.add;
        }
        return false;
    }

    public boolean getView() {
        if (this.enabled) {
            return this.view;
        }
        return false;
    }

    public boolean getEdit() {
        if (this.enabled) {
            return this.edit;
        }
        return false;
    }

    public boolean getDelete() {
        if (this.enabled) {
            return this.delete;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getActive() {
        return this.active;
    }

    public boolean getViewpoints() {
        return this.viewpoints;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("permission_id");
        this.categoryId = rs.getInt("category_id");
        this.name = rs.getString("permission");
        this.view = rs.getBoolean("permission_view");
        this.add = rs.getBoolean("permission_add");
        this.edit = rs.getBoolean("permission_edit");
        this.delete = rs.getBoolean("permission_delete");
        this.description = rs.getString("description");
        this.enabled = rs.getBoolean("enabled");
        this.active = rs.getBoolean("active");
        this.viewpoints = rs.getBoolean("viewpoints");
        this.categoryName = rs.getString("category");
        this.permissionLevel = rs.getInt("level");
    }

    protected void buildRecord(HttpServletRequest request, int parseItem) {
        String action;
        if (request.getParameter("permission" + parseItem + "id") != null) {
            this.setId(request.getParameter("permission" + parseItem + "id"));
        }
        if (request.getParameter("permission" + parseItem + "enabled") != null) {
            action = request.getParameter("permission" + parseItem + "enabled").toLowerCase();
            this.setEnabled(action.equals("on"));
        }
        if (request.getParameter("permission" + parseItem + "add") != null) {
            action = request.getParameter("permission" + parseItem + "add").toLowerCase();
            this.setAdd(DatabaseUtils.parseBoolean(action));
            this.setEnabled(true);
        }
        if (request.getParameter("permission" + parseItem + "view") != null) {
            action = request.getParameter("permission" + parseItem + "view").toLowerCase();
            this.setView(DatabaseUtils.parseBoolean(action));
            this.setEnabled(true);
        }
        if (request.getParameter("permission" + parseItem + "edit") != null) {
            action = request.getParameter("permission" + parseItem + "edit").toLowerCase();
            this.setEdit(DatabaseUtils.parseBoolean(action));
            this.setEnabled(true);
        }
        if (request.getParameter("permission" + parseItem + "delete") != null) {
            action = request.getParameter("permission" + parseItem + "delete").toLowerCase();
            this.setDelete(DatabaseUtils.parseBoolean(action));
            this.setEnabled(true);
        }
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "permission_permission_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO permission (" + (this.id > -1 ? "permission_id, " : "") + "category_id, permission, permission_view, " + "permission_add, permission_edit, permission_delete, " + "description, " + DatabaseUtils.addQuotes(db, "level") + ", enabled, " + DatabaseUtils.addQuotes(db, "active") + ", viewpoints) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.categoryId);
        pst.setString(++i, this.name);
        pst.setBoolean(++i, this.view);
        pst.setBoolean(++i, this.add);
        pst.setBoolean(++i, this.edit);
        pst.setBoolean(++i, this.delete);
        pst.setString(++i, this.description);
        pst.setInt(++i, this.permissionLevel);
        pst.setBoolean(++i, this.enabled);
        pst.setBoolean(++i, this.active);
        pst.setBoolean(++i, this.viewpoints);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "permission_permission_id_seq", this.id);
        return true;
    }

    public static int lookupId(Connection db, String name) throws SQLException {
        if (name == null) {
            throw new SQLException("Invalid Permission Name");
        }
        int i = -1;
        PreparedStatement pst = db.prepareStatement("SELECT permission_id FROM permission WHERE permission = ? ");
        pst.setString(1, name);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            i = rs.getInt("permission_id");
        }
        rs.close();
        pst.close();
        if (i == -1) {
            throw new SQLException("Permission not found in database: " + name);
        }
        return i;
    }
}

