/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class PermissionCategory
extends GenericBean {
    private int id = -1;
    private String category = null;
    private String description = null;
    private int level = -1;
    private boolean enabled = false;
    private boolean active = false;
    private boolean lookups = false;
    private boolean folders = false;
    private boolean viewpoints = false;
    private boolean categories = false;
    private boolean scheduledEvents = false;
    private boolean objectEvents = false;
    private boolean reports = false;
    private boolean webdav = false;
    private boolean logos = false;
    private boolean actionPlans = false;
    private boolean customListViews = false;
    private int constant = -1;
    public static final int NONE = -1;
    public static final int VIEW = 1;
    public static final int ADD = 2;
    public static final int EDIT = 3;
    public static final int DELETE = 4;
    public static final int PERMISSION_CAT_LEADS = 4;
    public static final int LOOKUP_LEADS_STAGE = 1;
    public static final int LOOKUP_LEADS_TYPE = 2;
    public static final int LOOKUP_OPPORTUNITY_ENVIRONMENT = 707050229;
    public static final int LOOKUP_OPPORTUNITY_COMPETITORS = 707050230;
    public static final int LOOKUP_OPPORTUNITY_COMPELLING_EVENT = 707050231;
    public static final int LOOKUP_OPPORTUNITY_BUDGET = 707050232;
    public static final int LOOKUP_CALL_TYPES = 206061500;
    public static final int PERMISSION_CAT_ACCOUNTS = 1;
    public static final int LOOKUP_ACCOUNTS_TYPE = 1;
    public static final int LOOKUP_ACCOUNTS_REVENUE_TYPE = 2;
    public static final int LOOKUP_ACCOUNTS_CONTACTS_TYPE = 3;
    public static final int LOOKUP_ACCOUNTS_EMAIL = 819041648;
    public static final int LOOKUP_ACCOUNTS_ADDRESS = 819041649;
    public static final int LOOKUP_ACCOUNTS_PHONE = 819041650;
    public static final int LOOKUP_ACCOUNTS_INDUSTRY = 302051030;
    public static final int LOOKUP_ACCOUNTS_SEGMENT = 128051430;
    public static final int LOOKUP_ACCOUNTS_SUBSEGMENT = 128051431;
    public static final int LOOKUP_ACCOUNTS_SITE = 128051432;
    public static final int LOOKUP_ACCOUNTS_SIZE = 158051538;
    public static final int LOOKUP_SITE_ID = 813200314;
    public static final int LOOKUP_ACCOUNT_SIZE = 819200310;
    public static final int LOOKUP_TITLE = 904200315;
    public static final int LOOKUP_CONTACT_SOURCE = 904200316;
    public static final int LOOKUP_SEGMENTS = 722031447;
    public static final int LOOKUP_SUB_SEGMENT = 909200314;
    public static final int LOOKUP_ACCOUNTS_STAGE = 181206161;
    public static final int PERMISSION_CAT_SERVICE_CONTRACTS = 130041100;
    public static final int LOOKUP_SERVICECONTRACT_CATEGORY = 130041305;
    public static final int LOOKUP_SERVICECONTRACT_TYPE = 130041306;
    public static final int LOOKUP_RESPONSE_TIME_MODEL = 116041409;
    public static final int LOOKUP_PHONE_RESPONSE_MODEL = 116041410;
    public static final int LOOKUP_ONSITE_RESPONSE_TIME_MODEL = 116041411;
    public static final int LOOKUP_EMAIL_RESPONSE_TIME_MODEL = 116041412;
    public static final int LOOKUP_HOURS_REASON = 308041546;
    public static final int PERMISSION_CAT_ASSETS = 130041000;
    public static final int LOOKUP_ASSET_STATUS = 130041304;
    public static final int LOOKUP_ASSET_MATERIALS = 928051135;
    public static final int MULTIPLE_CATEGORY_ASSET = 202041400;
    public static final int LOOKUP_ASSET_VENDOR = 910040914;
    public static final int LOOKUP_ASSET_MANUFACTURER = 910040915;
    public static final int PERMISSION_CAT_CONTACTS = 2;
    public static final int LOOKUP_CONTACTS_TYPE = 1;
    public static final int LOOKUP_CONTACTS_EMAIL = 2;
    public static final int LOOKUP_CONTACTS_ADDRESS = 3;
    public static final int LOOKUP_CONTACTS_PHONE = 4;
    public static final int LOOKUP_CONTACTS_IMTYPES = 111051308;
    public static final int LOOKUP_CONTACTS_IMSERVICES = 111051352;
    public static final int LOOKUP_CONTACTS_TEXT = 111051354;
    public static final int LOOKUP_ACCOUNTS_TITLE = 128051433;
    public static final int PERMISSION_CAT_EMPLOYEES = 1111031131;
    public static final int LOOKUP_CONTACTS_DEPT = 1111031132;
    public static final int PERMISSION_CAT_TICKETS = 8;
    public static final int LOOKUP_TICKETS_SOURCE = 1;
    public static final int LOOKUP_TICKETS_SEVERITY = 2;
    public static final int LOOKUP_TICKETS_PRIORITY = 3;
    public static final int LOOKUP_TICKET_FORM = 127041246;
    public static final int LOOKUP_TICKET_CAUSE = 922051718;
    public static final int LOOKUP_TICKET_RESOLUTION = 922051719;
    public static final int LOOKUP_TICKET_TASK_CATEGORY = 101705190;
    public static final int MULTIPLE_CATEGORY_TICKET = 202041401;
    public static final int LOOKUP_TICKET_ESCALATION = 910040913;
    public static final int LOOKUP_TICKET_STATE = 112205113;
    public static final int CUSTOM_LIST_VIEWS_TICKET = 113051436;
    public static final int PERMISSION_CAT_PRODUCT_CATALOG = 330041409;
    public static final int LOOKUP_PRODUCT_TYPE = 1017040901;
    public static final int LOOKUP_PRODUCT_FORMAT = 1017040902;
    public static final int LOOKUP_PRODUCT_SHIPPING = 1017040903;
    public static final int LOOKUP_PRODUCT_SHIP_TIME = 1017040904;
    public static final int LOOKUP_PRODUCT_CATEGORY_TYPE = 1017040905;
    public static final int LOOKUP_PRODUCT_TAX = 1017040906;
    public static final int LOOKUP_CURRENCY = 1017040907;
    public static final int LOOKUP_RECURRING_TYPE = 1017040908;
    public static final int LOOKUP_MANUFACTURER_TYPE = 1017040909;
    public static final int PERMISSION_CAT_QUOTES = 420041017;
    public static final int LOOKUP_QUOTE_STATUS = 1123041000;
    public static final int LOOKUP_QUOTE_TYPES = 1123041001;
    public static final int LOOKUP_QUOTE_TERMS = 1123041002;
    public static final int LOOKUP_QUOTE_SOURCE = 1123041003;
    public static final int LOOKUP_QUOTE_DELIVERY = 1123041004;
    public static final int LOOKUP_QUOTE_CONDITION = 1123041005;
    public static final int LOOKUP_QUOTE_REMARKS = 1123041006;
    public static final int PERMISSION_CAT_DOCUMENTS = 1202041528;
    public static final int PERMISSION_CAT_SALES = 228051100;
    public static final int LOOKUP_SALES_STATUS = 228051101;
    public static final int LOOKUP_CONTACTS_RATING = 228051102;
    public static final int LOOKUP_CONTACTS_SOURCE = 228051103;
    public static final int PERMISSION_CAT_WEBSITE = 223061200;
    public static final int PERMISSION_NET_APP = 1021051129;
    public static final int PERMISSION_CAT_ADMIN = 9;
    public static final int MULTIPLE_CATEGORY_ACTIONPLAN = 907051127;
    public static final int PERMISSION_CAT_COMMUNICATIONS = 6;
    public static final int PERMISSION_CAT_PROJECTS = 714200712;

    public PermissionCategory() {
    }

    public PermissionCategory(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public PermissionCategory(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    private void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Permission Category ID");
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM permission_category WHERE category_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Permission category not found");
        }
    }

    public static int lookupId(Connection db, String name) throws SQLException {
        if (name == null) {
            throw new SQLException("Invalid Permission Category Name");
        }
        int i = -1;
        PreparedStatement pst = db.prepareStatement("SELECT category_id FROM permission_category WHERE category = ? ");
        pst.setString(1, name);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            i = rs.getInt("category_id");
        }
        rs.close();
        pst.close();
        return i;
    }

    public static int lookupId(Connection db, int constantId) throws SQLException {
        if (constantId == -1) {
            throw new SQLException("Invalid Permission Category Name");
        }
        int i = -1;
        PreparedStatement pst = db.prepareStatement("SELECT category_id FROM permission_category WHERE constant = ? ");
        pst.setInt(1, constantId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            i = rs.getInt("category_id");
        }
        rs.close();
        pst.close();
        return i;
    }

    public boolean getCustomListViews() {
        return this.customListViews;
    }

    public void setCustomListViews(boolean tmp) {
        this.customListViews = tmp;
    }

    public void setCustomListViews(String tmp) {
        this.customListViews = DatabaseUtils.parseBoolean(tmp);
    }

    public void setWebdav(boolean tmp) {
        this.webdav = tmp;
    }

    public void setWebdav(String tmp) {
        this.webdav = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getWebdav() {
        return this.webdav;
    }

    public void setLogos(boolean tmp) {
        this.logos = tmp;
    }

    public void setLogos(String tmp) {
        this.logos = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getLogos() {
        return this.logos;
    }

    public void setConstant(int tmp) {
        this.constant = tmp;
    }

    public void setConstant(String tmp) {
        this.constant = Integer.parseInt(tmp);
    }

    public int getConstant() {
        return this.constant;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCategory(String tmp) {
        this.category = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setActive(boolean tmp) {
        this.active = tmp;
    }

    public void setActive(String tmp) {
        this.active = DatabaseUtils.parseBoolean(tmp);
    }

    public void setCategories(boolean categories) {
        this.categories = categories;
    }

    public void setCategories(String categories) {
        this.categories = DatabaseUtils.parseBoolean(categories);
    }

    public boolean getCategories() {
        return this.categories;
    }

    public int getId() {
        return this.id;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getActive() {
        return this.active;
    }

    public boolean getLookups() {
        return this.lookups;
    }

    public boolean getFolders() {
        return this.folders;
    }

    public boolean getViewpoints() {
        return this.viewpoints;
    }

    public boolean getReports() {
        return this.reports;
    }

    public boolean getScheduledEvents() {
        return this.scheduledEvents;
    }

    public boolean getObjectEvents() {
        return this.objectEvents;
    }

    public void setLookups(boolean tmp) {
        this.lookups = tmp;
    }

    public void setLookups(String tmp) {
        this.lookups = DatabaseUtils.parseBoolean(tmp);
    }

    public void setFolders(boolean tmp) {
        this.folders = tmp;
    }

    public void setFolders(String tmp) {
        this.folders = DatabaseUtils.parseBoolean(tmp);
    }

    public void setViewpoints(boolean tmp) {
        this.viewpoints = tmp;
    }

    public void setViewpoints(String tmp) {
        this.viewpoints = DatabaseUtils.parseBoolean(tmp);
    }

    public void setReports(boolean tmp) {
        this.reports = tmp;
    }

    public void setReports(String tmp) {
        this.reports = DatabaseUtils.parseBoolean(tmp);
    }

    public void setScheduledEvents(boolean tmp) {
        this.scheduledEvents = tmp;
    }

    public void setScheduledEvents(String tmp) {
        this.scheduledEvents = DatabaseUtils.parseBoolean(tmp);
    }

    public void setObjectEvents(boolean tmp) {
        this.objectEvents = tmp;
    }

    public void setObjectEvents(String tmp) {
        this.objectEvents = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getActionPlans() {
        return this.actionPlans;
    }

    public void setActionPlans(boolean tmp) {
        this.actionPlans = tmp;
    }

    public void setActionPlans(String tmp) {
        this.actionPlans = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean insert(Connection db) throws SQLException {
        if (this.constant == -1) {
            throw new SQLException("PermissionCategory constantId cannot be -1");
        }
        this.id = DatabaseUtils.getNextSeq(db, "permission_cate_category_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO permission_category (" + (this.id > -1 ? "category_id, " : "") + "category, description, " + DatabaseUtils.addQuotes(db, "level") + ", enabled, " + DatabaseUtils.addQuotes(db, "active") + ", lookups, folders, viewpoints, categories, scheduled_events, " + "object_events, reports, webdav, logos, constant, action_plans, custom_list_views) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.category);
        pst.setString(++i, this.description);
        pst.setInt(++i, this.level);
        pst.setBoolean(++i, this.enabled);
        pst.setBoolean(++i, this.active);
        pst.setBoolean(++i, this.lookups);
        pst.setBoolean(++i, this.folders);
        pst.setBoolean(++i, this.viewpoints);
        pst.setBoolean(++i, this.categories);
        pst.setBoolean(++i, this.scheduledEvents);
        pst.setBoolean(++i, this.objectEvents);
        pst.setBoolean(++i, this.reports);
        pst.setBoolean(++i, this.webdav);
        pst.setBoolean(++i, this.logos);
        pst.setInt(++i, this.constant);
        pst.setBoolean(++i, this.actionPlans);
        pst.setBoolean(++i, this.customListViews);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "permission_cate_category_id_seq", this.id);
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("category_id");
        this.category = rs.getString("category");
        this.description = rs.getString("description");
        this.level = rs.getInt("level");
        this.enabled = rs.getBoolean("enabled");
        this.active = rs.getBoolean("active");
        this.folders = rs.getBoolean("folders");
        this.lookups = rs.getBoolean("lookups");
        this.viewpoints = rs.getBoolean("viewpoints");
        this.categories = rs.getBoolean("categories");
        this.scheduledEvents = rs.getBoolean("scheduled_events");
        this.objectEvents = rs.getBoolean("object_events");
        this.reports = rs.getBoolean("reports");
        this.webdav = rs.getBoolean("webdav");
        this.logos = rs.getBoolean("logos");
        this.constant = rs.getInt("constant");
        this.actionPlans = rs.getBoolean("action_plans");
        this.customListViews = rs.getBoolean("custom_list_views");
    }

    public static void updateReportAttribute(Connection db, int categoryId, boolean enabled) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE permission_category SET reports = ? WHERE category_id = ? ");
        pst.setBoolean(1, enabled);
        pst.setInt(2, categoryId);
        pst.execute();
        pst.close();
    }

    public static void updateWebdavAttribute(Connection db, int categoryId, boolean enabled) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE permission_category SET webdav = ? WHERE category_id = ? ");
        pst.setBoolean(1, enabled);
        pst.setInt(2, categoryId);
        pst.execute();
        pst.close();
    }

    public static void updateLogosAttribute(Connection db, int categoryId, boolean enabled) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE permission_category SET logos = ? WHERE category_id = ? ");
        pst.setBoolean(1, enabled);
        pst.setInt(2, categoryId);
        pst.execute();
        pst.close();
    }

    public static void updateFoldersAttribute(Connection db, int categoryId, boolean enabled) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE permission_category SET folders = ? WHERE category_id = ? ");
        pst.setBoolean(1, enabled);
        pst.setInt(2, categoryId);
        pst.execute();
        pst.close();
    }

    public static void updateActionPlansAttribute(Connection db, int categoryId, boolean enabled) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE permission_category SET action_plans = ? WHERE category_id = ? ");
        pst.setBoolean(1, enabled);
        pst.setInt(2, categoryId);
        pst.execute();
        pst.close();
    }

    public static void updateCustomListViewsAttribute(Connection db, int categoryId, boolean enabled) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE permission_category SET custom_list_views = ? WHERE category_id = ? ");
        pst.setBoolean(1, enabled);
        pst.setInt(2, categoryId);
        pst.execute();
        pst.close();
    }
}

