/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class PermissionCategoryList
extends Vector {
    private PagedListInfo pagedListInfo = null;
    private String emptyHtmlSelectRecord = null;
    public static final String tableName = "permission_category";
    public static final String uniqueField = "category_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private boolean customizableModulesOnly = false;
    private boolean modulesWithReportsOnly = false;
    private int enabledState = -1;
    private int activeState = -1;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setEmptyHtmlSelectRecord(String tmp) {
        this.emptyHtmlSelectRecord = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public String getEmptyHtmlSelectRecord() {
        return this.emptyHtmlSelectRecord;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setEnabledState(int tmp) {
        this.enabledState = tmp;
    }

    public void setActiveState(int tmp) {
        this.activeState = tmp;
    }

    public int getEnabledState() {
        return this.enabledState;
    }

    public int getActiveState() {
        return this.activeState;
    }

    public boolean getCustomizableModulesOnly() {
        return this.customizableModulesOnly;
    }

    public void setCustomizableModulesOnly(boolean customizableModulesOnly) {
        this.customizableModulesOnly = customizableModulesOnly;
    }

    public boolean getModulesWithReportsOnly() {
        return this.modulesWithReportsOnly;
    }

    public void setModulesWithReportsOnly(boolean tmp) {
        this.modulesWithReportsOnly = tmp;
    }

    public void setModulesWithReportsOnly(String tmp) {
        this.modulesWithReportsOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM permission_category pc WHERE pc.category_id > 0 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(pc.category) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("pc.category", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY pc.category ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("pc.* FROM permission_category pc WHERE pc.category_id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            PermissionCategory thisCategory = new PermissionCategory(rs);
            this.add(thisCategory);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(Connection db, StringBuffer sqlFilter) {
        if (this.enabledState != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
        if (this.activeState != -1) {
            sqlFilter.append("AND " + DatabaseUtils.addQuotes(db, "active") + " = ? ");
        }
        if (this.customizableModulesOnly) {
            sqlFilter.append("AND (lookups = ? OR folders = ? OR scheduled_events = ? OR object_events = ? OR categories = ?) ");
        }
        if (this.modulesWithReportsOnly) {
            sqlFilter.append("AND reports = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enabledState != -1) {
            pst.setBoolean(++i, this.enabledState == 1);
        }
        if (this.activeState != -1) {
            pst.setBoolean(++i, this.activeState == 1);
        }
        if (this.customizableModulesOnly) {
            pst.setBoolean(++i, true);
            pst.setBoolean(++i, true);
            pst.setBoolean(++i, true);
            pst.setBoolean(++i, true);
            pst.setBoolean(++i, true);
        }
        if (this.modulesWithReportsOnly) {
            pst.setBoolean(++i, true);
        }
        return i;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect categoryListSelect = new HtmlSelect();
        if (this.emptyHtmlSelectRecord != null) {
            categoryListSelect.addItem(-1, this.emptyHtmlSelectRecord);
        }
        for (PermissionCategory thisCategory : this) {
            categoryListSelect.addItem(thisCategory.getId(), thisCategory.getCategory());
        }
        return categoryListSelect.getHtml(selectName, defaultKey);
    }
}

