/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.aspcfs.modules.admin.base.Permission;
import org.aspcfs.utils.DatabaseUtils;

public class PermissionList
extends Vector {
    private String currentCategory = "!new";
    private boolean viewpointsOnly = false;
    private int enabled = 1;

    public int getEnabled(int tmp) {
        return this.enabled;
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public PermissionList() {
    }

    public PermissionList(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void setViewpointsOnly(boolean viewpointsOnly) {
        this.viewpointsOnly = viewpointsOnly;
    }

    public boolean getViewpointsOnly() {
        return this.viewpointsOnly;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT p.*, c.category FROM permission p, permission_category c WHERE p.category_id = c.category_id ");
        this.createFilter(sqlFilter);
        sqlOrder.append("ORDER BY c." + DatabaseUtils.addQuotes(db, "level") + ", c.category, p." + DatabaseUtils.addQuotes(db, "level") + " ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            Permission thisPermission = new Permission(rs);
            this.addElement(thisPermission);
            thisPermission.setEnabled(true);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND p.enabled = ? ");
            sqlFilter.append("AND c.enabled = ? ");
        }
        if (this.viewpointsOnly) {
            sqlFilter.append("AND p.viewpoints = ? ");
            sqlFilter.append("AND c.viewpoints = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
            pst.setBoolean(++i, this.enabled == 1);
        }
        if (this.viewpointsOnly) {
            pst.setBoolean(++i, true);
            pst.setBoolean(++i, true);
        }
        return i;
    }

    public boolean isNewCategory(String thisCategory) {
        if (thisCategory.equals(this.currentCategory)) {
            return false;
        }
        this.currentCategory = thisCategory;
        return true;
    }

    public static int retrieveMaxLevel(Connection db, int tmpCategoryId) throws SQLException {
        int maxLevel = 0;
        PreparedStatement pst = db.prepareStatement("SELECT MAX(" + DatabaseUtils.addQuotes(db, "level") + ") AS max_level " + "FROM permission " + "WHERE category_id = ? ");
        pst.setInt(1, tmpCategoryId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            maxLevel = rs.getInt("max_level");
        }
        rs.close();
        pst.close();
        return maxLevel;
    }
}

