/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.modules.admin.base.Permission;
import org.aspcfs.modules.admin.base.PermissionList;

public class PopulatePortalRolePermissionList {
    private PermissionList permissionList = new PermissionList();

    public PermissionList populatePortalPermissions(Connection db) throws SQLException {
        this.buildAccountPermissions(db);
        this.buildProjectPermissions(db);
        this.buildDocumentPermissions(db);
        return this.permissionList;
    }

    public void buildAccountPermissions(Connection db) throws SQLException {
        this.addPermission(db, "accounts", true);
        this.addPermission(db, "accounts-accounts", true);
        this.addPermission(db, "accounts-accounts-contacts", true);
        this.addPermission(db, "accounts-service-contracts", true);
        this.addPermission(db, "accounts-assets", true);
        this.addPermission(db, "accounts-accounts-tickets", true, true, false, false);
        this.addPermission(db, "accounts-accounts-tickets-maintenance-report", true);
        this.addPermission(db, "accounts-accounts-tickets-activity-log", true);
        this.addPermission(db, "accounts-accounts-documents", true, true, false, false);
        this.addPermission(db, "accounts-accounts-shareddocuments", true);
    }

    public void buildProjectPermissions(Connection db) throws SQLException {
        this.addPermission(db, "projects", true);
        this.addPermission(db, "projects-personal", true);
        this.addPermission(db, "projects-enterprise", true);
        this.addPermission(db, "projects-projects", true);
    }

    public void buildDocumentPermissions(Connection db) throws SQLException {
        this.addPermission(db, "documents", true);
        this.addPermission(db, "documents_documentstore", true);
    }

    public void addPermission(Connection db, String permission, boolean view) throws SQLException {
        this.addPermission(db, permission, view, false, false, false);
    }

    public void addPermission(Connection db, String name, boolean view, boolean add, boolean edit, boolean delete) throws SQLException {
        Permission permission = new Permission(db, name);
        if (permission != null) {
            permission.setView(view);
            permission.setEdit(edit);
            permission.setAdd(add);
            permission.setDelete(delete);
            this.permissionList.add(permission);
        }
    }
}

