/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.admin.base.Permission;
import org.aspcfs.modules.admin.base.RolePermissionList;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.utils.DatabaseUtils;

public class Role
extends GenericBean {
    protected int id = -1;
    protected String role = null;
    protected String description = null;
    protected int roleType = -1;
    protected Timestamp entered = null;
    protected Timestamp modified = null;
    protected int enteredBy = -1;
    protected int modifiedBy = -1;
    protected boolean enabled = true;
    protected int userCount = -1;
    protected RolePermissionList permissionList = new RolePermissionList();
    protected UserList userList = new UserList();
    protected boolean buildHierarchy = false;

    public Role() {
    }

    public Role(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Role(Connection db, int roleId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM " + DatabaseUtils.addQuotes(db, "role") + " " + "WHERE role_id = ? ");
        pst.setInt(1, roleId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Role record not found.");
        }
        this.buildResources(db);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setRole(String tmp) {
        this.role = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setRoleType(int tmp) {
        this.roleType = tmp;
    }

    public void setRoleType(String tmp) {
        this.roleType = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setRequestItems(HttpServletRequest request) {
        this.permissionList = new RolePermissionList(request);
    }

    public void setUserCount(int tmp) {
        this.userCount = tmp;
    }

    public void setUserCount(String tmp) {
        this.userCount = Integer.parseInt(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public String getModifiedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public int getId() {
        return this.id;
    }

    public String getRole() {
        return this.role;
    }

    public String getDescription() {
        return this.description;
    }

    public int getRoleType() {
        return this.roleType;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public RolePermissionList getPermissionList() {
        return this.permissionList;
    }

    public UserList getUserList() {
        return this.userList;
    }

    public int getUserCount() {
        return this.userCount;
    }

    public int update(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID was not specified");
        }
        int resultCount = 0;
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE " + DatabaseUtils.addQuotes(db, "role") + " " + "SET " + DatabaseUtils.addQuotes(db, "role") + " = ?, description = ?, role_type = ?, modified = CURRENT_TIMESTAMP, " + "modifiedby = ?, enabled = ? " + "WHERE modified " + (this.getModified() == null ? "IS NULL " : "= ? ") + "AND role_id = ? ");
            pst = db.prepareStatement(sql.toString());
            int i = 0;
            pst.setString(++i, this.getRole());
            pst.setString(++i, this.getDescription());
            DatabaseUtils.setInt(pst, ++i, this.getRoleType());
            pst.setInt(++i, this.getModifiedBy());
            pst.setBoolean(++i, this.getEnabled());
            if (this.getModified() != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            pst.setInt(++i, this.id);
            resultCount = pst.executeUpdate();
            pst.close();
            this.deletePermissions(db);
            this.insertPermissions(db);
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return resultCount;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        int usercount;
        DependencyList dependencyList = new DependencyList();
        int i = 0;
        PreparedStatement pst = db.prepareStatement("SELECT COUNT(*) AS user_count FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE role_id = ? " + "AND user_id <> 0 " + "AND enabled = ? ");
        pst.setInt(++i, this.getId());
        pst.setBoolean(++i, true);
        ResultSet rs = pst.executeQuery();
        if (rs.next() && (usercount = rs.getInt("user_count")) != 0) {
            Dependency thisDependency = new Dependency();
            thisDependency.setName("activeUsers");
            thisDependency.setCount(usercount);
            thisDependency.setCanDelete(true);
            dependencyList.add(thisDependency);
        }
        rs.close();
        pst.close();
        return dependencyList;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            this.id = DatabaseUtils.getNextSeq(db, "role_role_id_seq");
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO " + DatabaseUtils.addQuotes(db, "role") + " (" + DatabaseUtils.addQuotes(db, "role") + ", description, role_type, ");
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.id > -1) {
                sql.append("role_id, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("enteredby, modifiedby, enabled ) VALUES (?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?, ?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setString(++i, this.getRole());
            pst.setString(++i, this.getDescription());
            DatabaseUtils.setInt(pst, ++i, this.getRoleType());
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.setBoolean(++i, this.enabled);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "role_role_id_seq", this.id);
            this.insertPermissions(db);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        PreparedStatement pst = null;
        if (this.getId() == -1) {
            throw new SQLException("ID was not specified");
        }
        if (this.buildUserCount(db, true)) {
            return false;
        }
        int recordCount = 0;
        try {
            db.setAutoCommit(false);
            if (this.buildUserCount(db, false)) {
                pst = db.prepareStatement("UPDATE " + DatabaseUtils.addQuotes(db, "role") + " " + "SET enabled = ? " + "WHERE role_id = ? ");
                pst.setBoolean(1, false);
                pst.setInt(2, this.id);
                recordCount = pst.executeUpdate();
            } else {
                this.deletePermissions(db);
                pst = db.prepareStatement("DELETE FROM " + DatabaseUtils.addQuotes(db, "role") + " " + "WHERE role_id = ? ");
                pst.setInt(1, this.id);
                recordCount = pst.executeUpdate();
            }
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return recordCount != 0;
    }

    public void addPermission(Connection db, int permissionId, boolean add, boolean view, boolean edit, boolean delete) throws SQLException {
        int i = 0;
        int rolePermissionId = DatabaseUtils.getNextSeq(db, "role_permission_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO role_permission (" + (rolePermissionId > -1 ? "id, " : "") + "role_id, permission_id, role_add, role_view, role_edit, role_delete) " + "VALUES (" + (rolePermissionId > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ? ) ");
        if (rolePermissionId > -1) {
            pst.setInt(++i, rolePermissionId);
        }
        pst.setInt(++i, this.getId());
        pst.setInt(++i, permissionId);
        pst.setBoolean(++i, add);
        pst.setBoolean(++i, view);
        pst.setBoolean(++i, edit);
        pst.setBoolean(++i, delete);
        pst.execute();
        pst.close();
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("role_id");
        this.role = rs.getString("role");
        this.description = rs.getString("description");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enabled = rs.getBoolean("enabled");
        this.roleType = DatabaseUtils.getInt(rs, "role_type");
    }

    protected void buildResources(Connection db) throws SQLException {
        this.permissionList = new RolePermissionList(db, this.id);
        this.buildUserList(db);
    }

    protected void buildUserList(Connection db) throws SQLException {
        this.userList.setRoleId(this.id);
        this.userList.setBuildHierarchy(this.buildHierarchy);
        this.userList.buildList(db);
    }

    public boolean isDuplicate(Connection db) throws SQLException {
        ResultSet rs;
        boolean duplicate = false;
        int i = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM " + DatabaseUtils.addQuotes(db, "role") + " " + "WHERE " + DatabaseUtils.toLowerCase(db) + "(" + DatabaseUtils.addQuotes(db, "role") + ") = ? " + "AND enabled = ? ");
        if (this.id > -1) {
            sql.append("AND role_id <> ? ");
        }
        if (this.roleType > -1) {
            sql.append("AND role_type = ? ");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getRole().toLowerCase());
        pst.setBoolean(++i, true);
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.roleType > -1) {
            pst.setInt(++i, this.roleType);
        }
        if ((rs = pst.executeQuery()).next()) {
            duplicate = true;
        }
        rs.close();
        pst.close();
        return duplicate;
    }

    public boolean buildUserCount(Connection db, boolean activeUsersOnly) throws SQLException {
        ResultSet rs;
        int resultCount = -1;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS thecount FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE role_id = ? " + "AND contact_id > 0 " + "AND (alias = -1 OR alias IS NULL) " + (activeUsersOnly ? "AND enabled = ? " : ""));
        pst.setInt(1, this.id);
        if (activeUsersOnly) {
            pst.setBoolean(2, true);
        }
        if ((rs = pst.executeQuery()).next()) {
            resultCount = rs.getInt("thecount");
        }
        rs.close();
        pst.close();
        this.userCount = resultCount;
        return resultCount > 0;
    }

    private void deletePermissions(Connection db) throws SQLException {
        PreparedStatement pst = null;
        pst = db.prepareStatement("DELETE FROM role_permission WHERE role_id = " + this.id);
        pst.execute();
        pst.close();
    }

    private void insertPermissions(Connection db) throws SQLException {
        Iterator ipermission = this.permissionList.keySet().iterator();
        while (ipermission.hasNext()) {
            Permission thisPermission = (Permission)((Object)this.permissionList.get((String)ipermission.next()));
            if (!thisPermission.getEnabled()) continue;
            this.addPermission(db, thisPermission.getId(), thisPermission.getAdd(), thisPermission.getView(), thisPermission.getEdit(), thisPermission.getDelete());
        }
    }
}

