/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.admin.base.Role;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public class RoleList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private String emptyHtmlSelectRecord = null;
    private int enabledState = 1;
    private boolean buildUsers = false;
    private boolean buildUserCount = false;
    private int roleType = -1;
    private int excludeRoleType = -1;
    private String jsEvent = null;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setEmptyHtmlSelectRecord(String tmp) {
        this.emptyHtmlSelectRecord = tmp;
    }

    public void setEnabledState(int booleanInt) {
        this.enabledState = booleanInt;
    }

    public void setBuildUsers(boolean tmp) {
        this.buildUsers = tmp;
    }

    public void setBuildUserCount(boolean tmp) {
        this.buildUserCount = tmp;
    }

    public void setRoleType(int tmp) {
        this.roleType = tmp;
    }

    public void setRoleType(String tmp) {
        this.roleType = Integer.parseInt(tmp);
    }

    public void setExcludeRoleType(int tmp) {
        this.excludeRoleType = tmp;
    }

    public void setJsEvent(String jsEvent) {
        this.jsEvent = jsEvent;
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect roleListSelect = new HtmlSelect();
        if (this.emptyHtmlSelectRecord != null) {
            roleListSelect.addItem(-1, this.emptyHtmlSelectRecord);
        }
        if (this.jsEvent != null) {
            roleListSelect.setJsEvent(this.jsEvent);
        }
        for (Role thisRole : this) {
            roleListSelect.addItem(thisRole.getId(), thisRole.getRole());
        }
        return roleListSelect.getHtml(selectName, defaultKey);
    }

    public LookupList getLookupList() {
        LookupList thisList = new LookupList();
        for (Role thisRole : this) {
            thisList.addItem(thisRole.getId(), thisRole.getRole());
        }
        return thisList;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM " + DatabaseUtils.addQuotes(db, "role") + " r " + "WHERE r.role_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(" + DatabaseUtils.addQuotes(db, "role") + ") < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("role", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY " + DatabaseUtils.addQuotes(db, "role") + " ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("r.* FROM " + DatabaseUtils.addQuotes(db, "role") + " r " + "WHERE r.role_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Role thisRole = new Role(rs);
            this.add(thisRole);
        }
        rs.close();
        pst.close();
        if (this.buildUsers || this.buildUserCount) {
            for (Role thisRole : this) {
                if (this.buildUsers) {
                    thisRole.buildUserList(db);
                }
                if (!this.buildUserCount) continue;
                thisRole.buildUserCount(db, true);
            }
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.roleType != -1) {
            sqlFilter.append("AND role_type = ? ");
        }
        if (this.excludeRoleType != -1) {
            sqlFilter.append("AND role_type <> ? ");
        }
        if (this.enabledState > -1) {
            sqlFilter.append("AND enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.roleType != -1) {
            pst.setInt(++i, this.roleType);
        }
        if (this.excludeRoleType != -1) {
            pst.setInt(++i, this.excludeRoleType);
        }
        if (this.enabledState > -1) {
            pst.setBoolean(++i, this.enabledState == 1);
        }
        return i;
    }

    public String getRoleNameFromId(int id) {
        String result = null;
        for (Role thisRole : this) {
            if (id != thisRole.getId()) continue;
            result = thisRole.getRole();
            break;
        }
        return result;
    }
}

